/*!
 * FSI QuickZoom
 * Copyright (c) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 *
 * VERSION: 1.1.3
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,version,build){var self=this;this.instance=instance;this.strClassName=strClassName;this.version=version;this.build=build;var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var classDef=new $FSI.ClassDef($FSI,"FSI Core","2016","16.08.4");$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t=="boolean"){ret=value}else{if(t=="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady){if(typeof($FSI.iLoaderCSSSkin)!="object"){if(typeof($FSI.LoaderCSSSkin)!="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create <style> node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		@if (@_jscript_version < 9)
			el.style.setAttribute('cssText', strStyle);
		@else @*/
el.setAttribute("style",strStyle);
/*@end
		@*/
};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!=0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWith=window.innerWidth;$FSI.bElementPosRespectsScroll=true;var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}var uagent=$FSI.userAgent=navigator.userAgent.toLowerCase();var result;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!=-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("safari")>-1&&uagent.search("chrome")<1){$FSI.isSafari=true}else{if(uagent.search("firefox")>-1){$FSI.isFirefox=true}else{if(uagent.search("opera")>-1){$FSI.isOpera=true}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)=="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.getCachedScrollBarWidth=function(el,oReg,w){var cst;var cssOverflowY="";try{cst=top.window.getComputedStyle(el);cssOverflowY=cst["overflow-y"]}catch(e){return 0}if(cssOverflowY=="scroll"||el.scrollHeight>top.window.innerHeight){var orgStyle=el.style.overflowY;var styleID=orgStyle;styleID="S_"+styleID;if(1==1||oReg[styleID]==undefined){el.style.overflowY="hidden";var w2=$FSI.___elementScaleCheck.offsetWidth;if(w2-w>1){oReg[styleID]=w2-w}}}if(!isNaN(oReg[styleID])){ret=oReg[styleID]}else{ret=-1}return ret};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(step){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if(typeof(document.visualViewport)!="undefined"){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return document.visualViewport.pageScale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180==0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=window.outerWidth;return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.document.visualViewport.clientWidth,height:wnd.document.visualViewport.clientHeight}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.push)=="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)=="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])=="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag;if(typeof(document.querySelector)=="function"){var strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector)}else{var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"s*$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var scripts=document.getElementsByTagName("script");var t="/"+strScriptName;var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!="object"){if(typeof($FSI.LoaderJavascript)!="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)=="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!="string"){return false}var t=typeof(parameters);if(t!="object"&&t!="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)=="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!="string"||strClass.length<1){return}if(typeof(strRule)!="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var node=element;var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=scale.x}else{scale.y=targetDimension.height/(sourceDimension.height*range.height);scale.x=scale.y}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)=="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(document.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)=="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)=="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ObjectCollection!=b){return}a.ObjectCollection=function(){var d=this;var f;var h;var c=0;var g;var e;this.reset=function(){c=0;d.empty()};this.empty=function(){f=[];h={};g=0;e=false};this.getCount=function(){return g};this.add=function(j){if(!j){return}c++;h[c]=j;j.__id=c;j.__arrayPos=f.length;f.push(j);g++;return c};this.deleteObject=function(j){if(!j||!j.__id){return}return d.deleteObjectById(j.__id)};this.deleteObjectById=function(j){if(!h[j]){console.error("ObjectCollection deleteObjectById "+j+" failed.");return}g--;delete h[j];e=true;return true};this.replace=function(j,k){if(!j||!k){return}return d.replaceById(j.__id,k)};this.replaceById=function(m,l){if(h[m]==b||l==b){return}var k=h[m];var j=h[m].__arrayPos;delete h[m];c++;l.__id=c;l.__arrayPos=j;f[j]=l;h[c]=l;return true};var i=function(){if(!e){return}f=new Array(g);var l=0;for(var k in h){var j=h[k];j.__arrayPos=l;f[l]=j;l++}e=false};this.getById=function(j){return h[j]};this.getArray=function(){if(e){i()}return f};this.getObjects=function(){return h};d.empty()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!=b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(m,n,p,r){var l=i(m);if(!l){return}if(p&&l.overrideMimeType){l.overrideMimeType(p)}l._url=m;var o=d;c[d]=l;d++;var k=-1;if(g){l.onerror=function(){delete c[o];if(n==b||this.FSIaborted){return}n(this,this.responseText,r,400)};l.onload=function(){delete c[o];if(n==b||this.FSIaborted){return}var s=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var t=new ActiveXObject("Microsoft.XMLDOM");t.async=false;t.loadXML(s);s=this.responseXML=t}catch(u){}break}n(this,s,r,200)}}else{l.onreadystatechange=function(e){if(l.readyState!=4){return}delete c[o];if(n==b||this.FSIaborted){return}var s=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;n(this,s,r,l.status)}}try{l.open("GET",m,true);l.send(null)}catch(q){n(this,"",r,500)}return l};this.stopPendingRequests=function(){for(var k in c){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ObjectCollection!=b){return}a.ObjectCollection=function(){var d=this;var f;var h;var c=0;var g;var e;this.reset=function(){c=0;d.empty()};this.empty=function(){f=[];h={};g=0;e=false};this.getCount=function(){return g};this.add=function(j){if(!j){return}c++;h[c]=j;j.__id=c;j.__arrayPos=f.length;f.push(j);g++;return c};this.deleteObject=function(j){if(!j||!j.__id){return}return d.deleteObjectById(j.__id)};this.deleteObjectById=function(j){if(!h[j]){console.error("ObjectCollection deleteObjectById "+j+" failed.");return}g--;delete h[j];e=true;return true};this.replace=function(j,k){if(!j||!k){return}return d.replaceById(j.__id,k)};this.replaceById=function(m,l){if(h[m]==b||l==b){return}var k=h[m];var j=h[m].__arrayPos;delete h[m];c++;l.__id=c;l.__arrayPos=j;f[j]=l;h[c]=l;return true};var i=function(){if(!e){return}f=new Array(g);var l=0;for(var k in h){var j=h[k];j.__arrayPos=l;f[l]=j;l++}e=false};this.getById=function(j){return h[j]};this.getArray=function(){if(e){i()}return f};this.getObjects=function(){return h};d.empty()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageTagCollection!=b){return}a.ImageTagCollection=function(c,m){a.ObjectCollection.prototype.constructor.apply(this,arguments);var o=this;var n=false;var i=false;var l=false;var p;var d,f;this.init=function(){if(typeof(c.NameID)=="string"){p=c.NameID}else{p="$FSI_ImageTagID"}if(typeof(m.fnFilterImageSource)=="function"){i=m.fnFilterImageSource}if(typeof(m.addCSSClass)=="string"){l=m.addCSSClass}if(typeof(m.enableByCSSClass)=="string"&&m.enableByCSSClass.length>0){f={};var r=m.enableByCSSClass.split(",");for(var q=0;q<r.length;q++){f[r[q]]=true}}if(typeof(m.disableByCSSClass)=="string"&&m.disableByCSSClass.length>0){d={};var r=m.disableByCSSClass.split(",");for(var q=0;q<r.length;q++){d[r[q]]=true}}n=(d!=b||f!=b)};var k=this.isValidFSIImageServerImageSource=function(q){if(typeof(q)!="string"){return false}if(q.length<1||q.search(/[?,&]type=image|directoryimage/i)==-1||q.search(/[?,&]source=/i)==-1){return false}return true};var h=this.createObjectForImageTag=function(r,u){var q=false;var s=r.src;if(u==b){s=u=r.src;if(i!=false){q=true;u=i(u,r)}}if(!k(u)){return}if(!e(r)){return}if(l){a.addClass(r,l)}var t={};t.img=r;t.src=u;t.orgSrc=s;if(q){t.bIgnoreSourceChange=true}return t};this.addBaseMethod=this.add;this.add=function(q,s){if(q[p]!=b){return}var r=h(q,s);if(r){this.addBaseMethod(r);q[p]=r.__id}return r};this.replaceBaseMethod=this.replace;this.replace=function(q,r){if(o.replaceBaseMethod(q,r)){r.img[p]=r.__id}};var j=this.releaseImage=function(r){if(!r||!r.img){return false}var q=r.img;if(!q[p]==b||q[p]!=r.__id){return}if(l){a.removeClass(q,l)}return true};var g=this.remove=function(q){if(!this.deleteObject(q)){return false}j(q);return true};var e=this.isImageEnabledByCSSClass=function(q){if(!n){return true}var r=false;var t=q.className;if(typeof(t)!="string"){t=[]}else{t=t.split(" ")}if(d){r=true;for(var s=0;s<t.length;s++){if(d[t[s]]){r=false;break}}}if(f){for(var s=0;s<t.length;s++){if(f[t[s]]){r=true;break}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(k){var m=this;var d=[];var g={};var h={};var i=0;m._strClassName="$FSI.CustomEventListener";var l=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};var j=this.destroy=function(){for(var n=0;n<d.length;n++){var o=d[n];f(o.element,o.fn)}d=[];g={};h={};m.onDestroy()};this.fireEvent=function(n,o){if(!n||!n.enabled){return false}if(typeof(o)!="object"){o={}}if(n.paused){o.FSI_paused=true}o.FSI_custom_event=true;o.FSI_type=k;o.FSI_target=n.element;n.fn.call(n.element,o);return true};this.fireEvents=function(o){if(typeof(o)!="object"){o={}}o.FSI_custom_event=true;o.FSI_type=k;for(var p=0;p<d.length;p++){var n=d[p];if(n.enabled){if(n.paused){o.FSI_paused=true}else{if(o.FSI_paused){delete o.FSI_paused}}o.FSI_target=n.element;n.fn.call(n.element,o)}}};var c=this.addListener=function(r,q){if(typeof(r)!="object"||typeof(q)!="function"){a.console.error(m._strClassName+": Invalid parameters for addListener");return}if(r.__FSI==b){r.__FSI={}}if(r.__FSI.eventElementID==b){r.__FSI.eventElementListenerCount=1;r.__FSI.eventElementID=a.eventElementID++}else{r.__FSI.eventElementListenerCount++}if(q.__FSIEventFunctionID==b){q.__FSIEventFunctionListenerCount=1;q.__FSIEventFunctionID=a.eventFunctionID++}else{q.__FSIEventFunctionListenerCount++}var o=r.__FSI.eventElementID;var p=q.__FSIEventFunctionID;if(g[o]==b){var n=g[o]={};n.nFunction=0;n.oFunctions={}}if(g[o].oFunctions[p]==b){g[o].nFunction++;g[o].oFunctions[p]=[]}else{a.console.warn(m._strClassName+": There is already a listener for this exact element and function");a.console.log(r);a.console.log(q)}var s={};s.element=r;s.elementID=o;s.fn=q;s.fnID=p;s.instanceListener=m;s.enabled=true;s.paused=false;s.uniqueID=i++;g[o].oFunctions[p].push(s);d.push(s);h[s.uniqueID]=s;m._onListenerAdd(s);m._onListenerCountChange(d.length);return s};this.setListenerProps=function(q,o,p){var n=h[q];if(!n){return false}if(n.props==b){n.props={}}n.props[o]=p;return true};this.enableListener=function(p,o){var n=h[p];if(n==b||n.enabled==o){return}n.enabled=o};this.pauseListener=function(p,o){var n=h[p];if(n==b||n.paused==o){return}n.paused=o};var f=this.removeListener=function(r,q){if(typeof(r)!="object"||typeof(q)!="function"){a.console.error(m._strClassName+": Invalid parameters for removeListener");return}if(r.__FSI==b||r.__FSI.eventElementID==b||q.__FSIEventFunctionID==b){if(q.__FSIEventFunctionID==b){a.console.error(m._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(m._strClassName+": Element not registered for listener in removeListener")}return}var n=r.__FSI.eventElementID;var p=q.__FSIEventFunctionID;if(!g[n]){a.console.error(m._strClassName+": No registered listener for this element in removeListener");return}var o=g[n].oFunctions[p];if(o==b||typeof(o.pop)!="function"){a.console.error(m._strClassName+": No registered listener for this function in removeListener");return}var s=o.pop();s.fn.__FSIEventFunctionListenerCount--;s.element.__FSI.eventElementListenerCount--;if(s.element.__FSI.eventElementListenerCount==0){delete s.element.__FSI.eventElementListenerCount;delete s.element.__FSI.eventElementID}if(s.fn.__FSIEventFunctionListenerCount==0){delete s.fn.__FSIEventFunctionListenerCount;delete s.fn.__FSIEventFunctionID}if(o.length==0){delete g[n].oFunctions[p];g[n].nFunction--;if(g[n].nFunction==0){delete g[n]}}delete h[s.uniqueID];e();m._onListenerRemove(s);m._onListenerCountChange(d.length);return s};this.getEventListenerByID=function(n){return h[n]};this.getListenerObjectByID=function(n){return h[n]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var o in g){var q=g[o].oFunctions;for(var p in q){var n=q[p];d=d.concat(n)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(n){};this._onListenerAdd=function(o,n){};this._onListenerRemove=function(o,n){};this.triggerEvent=function(n){};this.triggerEvents=function(){};this.setListenerProps=function(p,n,o){};this.onDestroy=function(){};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerDocumentZoom!=b){return}a.CustomEventListenerDocumentZoom=a.oCustomEventListenerClasses.FSIDocumentZoomChange=function(){var p=this;var c=false;var g;var h;var o=0;var l=0;var f=false;var e;var n;a.CustomEventListener.prototype.constructor.call(p,"FSIDocumentZoomChange");p._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(document,"visualviewportchanged",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(document,"visualviewportchanged",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(q){var r=(q>0);if(r!=c){if(r){j()}else{i()}}};var m=function(){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=r;k(r);q=true}else{q=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return q};this.triggerEvent=function(s){var q=p.getEventListenerByID(s);if(!q){return}var r={};r.FSI_scale=a.getDocumentScale();r.FSI_scale_with_pixel_ratio=a.getDocumentScaleWithPixelRatio();p.fireEvent(q,r)};this.triggerEvents=function(){k(a.getDocumentScaleWithPixelRatio())};var k=function(r){var q={};q.FSI_scale=a.getDocumentScale();q.FSI_scale_with_pixel_ratio=r;p.fireEvents(q)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.dir=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c="FSI";this.on=true;this.doNothing=function(){};this.log=this.doNothing;this.error=this.doNothing;this.dir=this.doNothing;try{if(console&&console.log){this.log=function(e){console.log(c+e)}}if(console&&console.error){this.error=function(e){console.error(c+e)}}if(console&&console.dir){this.dir=function(e){console.dir(e)}}}catch(d){}this.setPrefix=function(e){c=e+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.QuickZoom!=b){return}a.QuickZoom=function(S){var ab=new a.ClassDef(this,"FSI QuickZoom","2016","16.08.4");var m=ab.instance;a.guessFSIViewerLocation("fsiquickzoom.js",3);var q=a.getViewerInstanceID();var Z=(S)?a.cloneParameters(S):{};var G;var D;var ac;var u=false;var l=/((\?)|&)(width|height)=[^&]*/ig;var h;var t={};var ad={};var aa=3;var V;var B=false;var N={x:0,y:0};var n={x:10000000,y:10000000};var H;var y;var i;var U,F;var w;var p=1;var T=false;var A;var J;var f=true;var e=true;var O=a.makeBool(Z.useDevicePixelRatio,true);var W=a.makeBool(Z.debug,false);if(W){G=new a.Debugger();G.setPrefix(ab.strClassName)}else{G=new a.EmptyDebugger()}G.log(m.getVersion());this.init=function(){if(u){return}u=true;if(typeof(Z.fnPositionAndSizeCallback)=="function"){A=Z.fnPositionAndSizeCallback;if(Z.fnPositionAndSizeCallbackScope){J=Z.fnPositionAndSizeCallbackScope}else{J=window}}if(a.isMobileDevice&&a.BrowserSupports.documentZoom()){return false}ac=new a.CORSLoader();if(a.getDocumentScroll==b||!ac.getSupported()){G.error("Unsupported browser. "+ac.getSupported()+" => "+navigator.userAgent);return}if(m.bAutoInitialized){G.log("Init (auto initialized)")}else{G.log("Init")}if(a.BrowserSupports.documentZoom()){w=a.addCustomEvent(m,"FSIDocumentZoomChange",g);T=(a.getDocumentScale()>1)}if(!D){var ai={NameID:"$FSIQuickZoom_TagID"};D=new a.ImageTagCollection(ai,Z);D.init()}a._FSIQuickZoomInstance=this;if(Z.headers==b){Z.headers="cors"}if(Z.headers.length>0){h="&headers="+Z.headers}else{h=""}aa=E("magnification",2);aa=Math.max(1,aa);n.x=E("maxZoomWindowWidth",n.x);n.y=E("maxZoomWindowHeight",n.y);U=E("minZoomWindowWidth",100);F=E("minZoomWindowHeight",100);N.x=E("skipImageWidth",0);N.y=E("skipImageHeight",0);H=E("pageMargin",18);y=E("zoomImageBorderWidth",-1);i=E("zoomImageOffset",0);if(y<0){try{var ah=document.createElement("div");ah.style.display="none";a.addClass(ah,"FSIQuickZoom");document.body.appendChild(ah);var ag=window.getComputedStyle(ah,null);var ak=0;ak=Math.max(ak,parseFloat(ag.borderLeftWidth));ak=Math.max(ak,parseFloat(ag.borderRightWidth));ak=Math.max(ak,parseFloat(ag.borderTopWidth));ak=Math.max(ak,parseFloat(ag.borderBottomWidth));y=ak;a.removeChild(document.body,ah)}catch(aj){}}var ae=document.getElementsByTagName("img");if(W){G.log("Parameters: ");G.log("magnification: "+aa);G.log("enableByCSSClass: "+Z.enableByCSSClass);G.log("disableByCSSClass: "+Z.disableByCSSClass);G.log("Preparing images (total images: "+ae.length+")")}for(var af=0;af<ae.length;af++){Y(ae[af])}G.log(D.getCount()+" images have been prepared for FSI QuickZoom");return true};this.destroy=function(){if(w!=b){a.removeCustomEvent(m,"FSIDocumentZoomChange",g);w=b}K();clearTimeout(V);var ae=D.getArray();for(var af=0;af<ae-length;af++){j(img)}D.empty();u=false};var g=function(ae){var af=(ae.FSI_scale>1);if(T==af){return}T=af;if(af){K()}};var E=function(af,ag){var ae=parseFloat(Z[af]);if(isNaN(ae)){ae=ag}return ae};this.removeImages=function(ae){if(ae==b){return}if(ae.join==b){ae=[ae]}var af=D.getCount();for(var ah=0;ah<ae.length;ah++){j(ae[ah])}var ag=D.getCount();var ai=af-ag;G.log("removeImages: "+ai+" images have been removed, total zoom images now: "+ag+" images.");return ai};var s=function(ae){if(!ae){return}var af=D.getById(ae.$FSIQuickZoom_TagID);a.removeEvent(ae,"load",x,false);a.removeEvent(ae,"error",P,false);a.removeEvent(ae,"mouseover",C,false);if(typeof(ad)=="object"&&ad.id==af.__id){K()}return af};var j=function(ae){var af=s(ae);D.remove(af);af.img.$FSIQuickZoom_TagID=b;delete af.img.$FSIQuickZoom_TagID};this.addImage=function(ae,ah,af){if(!ae||ae.$FSIQuickZoom_TagID!=b){return}var ag=Y(ae,ah);return(ag!=b)};var Y=function(ae,ag){var af=D.add(ae,ag);if(!af){return}af.srcCurrent=af.src;af.tag=ae;a.addEvent(ae,"load",x,false);a.addEvent(ae,"error",P,false);a.addEvent(ae,"mouseover",C,false);return af};var R=function(af){if(!af||!af.img||af.bPrepared==true){return}var ae=af.img;af.src=Q(af.src);if(ae.width!=b&&ae.width>0){af.width=ae.width}if(ae.height!=b&&ae.height>0){af.height=ae.height}if(af.width>0&&af.height>0){o(af)}else{af.bFinishOnLoad=true}af.bPrepared=true;return af};var o=function(ae){ae.ready=true;ae.wOrg=ae.width;ae.hOrg=ae.height};var Q=function(ae){return ae.replace(l,"$2")};var P=function(){var ae=(!a.isInternetExplorer)?this:window.event.srcElement;var af=D.getById(ae.$FSIQuickZoom_TagID);if(af.bLoading){af.ready=false;af.bLoading=false}};var x=function(){var ae=(!a.isInternetExplorer)?this:window.event.srcElement;var ag=D.getById(ae.$FSIQuickZoom_TagID);if(!ag.bLoading&&ag.orgSrc!=ae.src){var af=false;if(typeof(ad)=="object"&&ad.idVisible==ag.__id){af=true}if(af){K()}ag.bPrepared=ag.ready=false;ag.bInfo=b;Q(ag.src);ag.srcCurrent=ag.orgSrc=ae.src;ag.sourceWidth=ag.sourceHeight=b;ag.src=Q(ag.orgSrc);R(ag);X(ag);if(af){ad.id=ag.__id}}if(ag.bFinishOnLoad){delete ag.bFinishOnLoad;ag.width=ae.width;ag.height=ae.height;o(ag)}else{if(ag.bLoading){ag.bLoading=false}}};var z=function(ae){t.x=ae.clientX;t.y=ae.clientY};var K=function(){var af=ad.elDiv;if(!af){return}var ae=ad.el;ad.src=b;ad.id=ad.idVisible=b;if(B){a.removeEvent(af,"mouseover",k,false);a.removeEvent(af,"mouseout",d,false);a.removeEvent(af,"mousemove",c,false)}a.removeEvent(ad.elImageFinalZoom,"load",r,false);a.removeEvent(ae,"mousemove",c,false);a.removeEvent(ae,"mouseout",d,false);a.removeChild(af.parentNode,af);ad.elDiv=ad.idVisible=b;a.removeClass(ae,"FSIQuickZoom")};var v=function(am,aG){if(!am.bInfo||T){return}if(O){p=Math.max(1,a.getDevicePixelRatio())}else{p=1}var ah=y;var aM=i;var ao=am.img;if(typeof(ad)=="object"&&ad.idVisible==am.__id){return}f=e=false;var aq=a.getViewportSize(window);var aY=H;var ax=aq.width-H-2*ah;var av=H;var aU=aq.height-H-2*ah;var aw=a.getDocumentScroll(window);var ai=a.getElementPosition(ao);var aO=I(ao);var a0=Math.max(n.x,am.wOrg);var aj=Math.max(n.y,am.hOrg);var af;var aN;var ay=aq.width-2*H-2*ah;var aK=aq.height-2*H-2*ah;var aW,aV;if(ay-a0>aK-aj){aN=aK;var aI=ai.left-H-aO.left-aM-2*ah;var aH=aq.width-ai.right-H-aO.right-aM-2*ah;aV=0;if(aH>aI){af=aH;aW=1}else{af=aI;aW=-1}}else{af=ay;var aF=ai.top-H-aO.top-aM-2*ah;var aE=aq.height-ai.bottom-H-aO.bottom-aM-2*ah;aW=0;if(aE>aF){aN=aE;aV=1}else{aN=aF;aV=-1}}a0=Math.min(af,a0);aj=Math.min(aN,aj);var aB=false;if(typeof(am.tag.getAttribute)=="function"){var aR=am.tag.getAttribute("FSIQuickZoomMagnification");if(typeof(aR)=="string"){aR=parseFloat(aR);if(!isNaN(aR)&&aR>1){aB=aR}}}if(!aB){aB=aa}var aA=Math.round(am.sourceWidth/p);var aS=Math.min(aA,Math.round(aB*am.wOrg));aA=Math.round(am.sourceHeight/p);var aL=Math.min(aA,Math.round(aB*am.hOrg));var al=a.getFSIServerImageDim(am.sourceWidth,am.sourceHeight,aS,aL,b,true);aS=al.width;aL=al.height;var au=Math.min(am.sourceWidth,Math.round(aS*p));var aQ=Math.min(am.sourceHeight,Math.round(aL*p));var aD=aS/au;f=(aS<=a0);e=(aL<=aj);if(f){a0=aS}if(e){aj=aL}var ap=am.src+"&width="+au+"&height="+aQ;if(ad.src==ap){return}var ak,an;if(aW==0){ak=(ai.right-ai.left)/2-a0/2-ah}else{if(aW>0){ak=ai.right-ai.left+aO.right+aM}else{ak=-aO.left-a0-2*ah-aM}}var at=ai.left+ak;var ar=at+a0;if(at<aY){ak+=aY-at}if(ar>ax){ak-=ar-ax}if(aV==0){an=(ai.bottom-ai.top)/2-aj/2-ah}else{if(aV>0){an=ai.bottom-ai.top+aO.bottom+aM}else{an=-aO.top-aj-2*ah-aM}}var a2=ai.top+an;var a1=a2+aj;if(a2<av){an+=av-a2}if(a1>aU){an-=a1-aU}if(A){var aT={};var aZ={};aZ.left=ak;aZ.top=an;aZ.width=a0;aZ.height=aj;aZ.srcZoomImage=ap;aT.sourceElement=ao;aT.imageWidth=aS;aT.imageHeight=aL;aT.imageWidthDPR=au;aT.imageHeightDPR=aQ;aT.sourceImageWidth=am.sourceWidth;aT.sourceImageHeight=am.sourceHeight;aT.borderWidth=ah;aT.imageMargin=aM;aT.minZoomWidth=U;aT.minZoomHeight=F;aT.maxZoomWidth=n.x;aT.maxZoomHeight=n.y;aT.elementPosition=a.cloneObject(ai);aT.imgPaddings=a.cloneObject(aO);aT.scrollPos=a.cloneObject(aw);aT.event=aG;A.call(J,aZ,aT);ak=aZ.left;an=aZ.top;a0=aZ.width;aj=aZ.height;ap=aZ.srcZoomImage;f=(aS<=a0);e=(aL<=aj)}if(a0<U||aj<F){return}a.addClass(ao,"FSIQuickZoom");if(ad.elDiv!=b){K()}ad.id=ad.idVisible=am.__id;ad.el=ao;ad.width=ao.offsetWidth;ad.height=ao.offsetHeight;ad.oImage=am;ad.elOffsetX=-ai.left-aw.x;ad.elOffsetY=-ai.top-aw.y;var ae=ad.elImageZoom=document.createElement("img");ae.setAttribute("width",au);ae.setAttribute("height",aQ);var aJ="position:relative;border:0px none; padding:0px; margin:0px;";aJ+="max-width:none;max-height:none;min-width:none;min-height:none;";aJ+="width:"+au+"px;height:"+aQ+"px";a.setStyleAttr(ae,aJ);if(aD!=1){ae.style.width=aS+"px";ae.style.height=aL+"px"}var aX=document.createElement("div");aX.setAttribute("class","FSIQuickZoom");aX.style.position="absolute";aX.style.boxSizing="content-box";aX.style.width=a0+"px";aX.style.height=aj+"px";aX.style.overflow="hidden";aX.style.padding="0px";aX.style.zIndex="10000";aX.style.left=Math.round(aw.x+ai.left+ak)+"px";aX.style.top=Math.round(aw.y+ai.top+an)+"px";ad.src=ap;ad.elDiv=aX;ad.elImageFinalZoom=ae;ad.elImageZoom=ad.elImagePreviewZoom=ae.cloneNode();ad.elImagePreviewZoom.src=ao.src;a.addEvent(ad.elImageFinalZoom,"load",r,false);ae.src=ap;ad.scaleX=aS/am.wOrg;ad.scaleY=aL/am.hOrg;ad.centerX=ad.elOffsetX-am.wOrg/2;ad.centerY=ad.elOffsetY-am.hOrg/2;ad.moveFactorX=aS/am.wOrg;ad.moveFactorY=aL/am.hOrg;ad.moveOffsetX=Math.round(a0/2);ad.moveOffsetY=Math.round(aj/2);aX.appendChild(ad.elImagePreviewZoom);document.body.appendChild(aX);var aC=new a.Rect();var az=new a.Rect();var ag=a.getElementClientPos(ao);aC.copyRect(ag);var aP=a.getElementClientPos(aX);az.copyRect(aP);az.interSectRectValidate(aC);B=(az.width()>0&&az.height()>0);if(B){a.addEvent(aX,"mouseover",k,false);a.addEvent(aX,"mouseout",d,false);a.addEvent(aX,"mousemove",c,false)}a.addEvent(ao,"mouseout",d,false);a.addEvent(ao,"mousemove",c,false);c()};var r=function(){var ae=this;a.removeEvent(ae,"load",r,false);var af=ad.elImagePreviewZoom;af.src=ae.src};var k=function(){clearTimeout(V)};var C=function(ae){clearTimeout(V);z(ae);var af=(!a.isInternetExplorer)?this:window.event.srcElement;var ag=D.getById(af.$FSIQuickZoom_TagID);if(!ag){return}ad.id=ag.__id;ad.evt=ae;R(ag);X(ag);if(ag.bInfo){v(ag,ae)}};var I=function(af){var ae={left:0,top:0,right:0,bottom:0};try{var ag=window.getComputedStyle(af,null);ae.left+=parseFloat(ag.paddingLeft);ae.right+=parseFloat(ag.paddingRight);ae.top+=parseFloat(ag.paddingTop);ae.bottom+=parseFloat(ag.paddingBottom);ae.left+=parseFloat(ag.borderLeftWidth);ae.right+=parseFloat(ag.borderRightWidth);ae.top+=parseFloat(ag.borderTopWidth);ae.bottom+=parseFloat(ag.borderBottomWidth)}catch(ah){}return ae};var c=function(af){if(af){z(af)}if(!ad.bInfo){ad.evt=af}var ai=a.getDocumentScroll(window);var ae,ah;if(f){t.x=-ad.centerX-ai.x}if(e){t.y=-ad.centerY-ai.y}ae=t.x+ad.elOffsetX+ai.x;ah=t.y+ad.elOffsetY+ai.y;ae=ae*ad.moveFactorX-ad.moveOffsetX;ah=ah*ad.moveFactorY-ad.moveOffsetY;var ag=ad.elImageZoom;ag.style.left=-Math.round(ae*p)/p+"px";ag.style.top=-Math.round(ah*p)/p+"px"};var d=function(ae){clearTimeout(V);if(B){V=setTimeout(K,50)}else{K()}};this.scanForNewImages=function(){var ae=document.getElementsByTagName("img");var af=0;G.log("...scanning for new images: "+ae.length+" image(s) in total");for(var ag=0;ag<ae.length;ag++){if(ae[ag].$FSIQuickZoom_ID==b){if(Y(ae[ag])){af++}}}G.log(af+" new QuickZoom image(s) added")};var X=function(ah){if(!ah||ah.bInfo!=b){return}ah.bInfo=false;var ae=ah.src;var af=ae.match(/.*[?]/);var ag=ae.match(/[?&]source=[^&]*/);ae=af+"type=info&tpl=info.json"+h+ag;ac.load(ae,L,b,ah)};var L=function(af,ah,aj){var ag;try{ag=a.JSON.parse(ah)}catch(ai){G.error("Failed to get image info for "+aj.src);ag=a.getFSIServerImageDim(aj.wOrg,aj.hOrg,4000,4000,b,true)}aj.sourceWidth=ag.width;aj.sourceHeight=ag.height;M(aj);var ae=false;if(N.x>0&&aj.wOrg<N.x){ae=true}if(N.y>0&&aj.hOrg<N.y){ae=true}if(ae){j(aj.img)}else{if(ad.id==aj.__id){v(aj,ad.evt)}}};var M=function(ae){if(!ae.sourceWidth||!ae.sourceHeight){ae.ready=false;return}if(ae.rectWidth){ae.maxWidth=Math.round(ae.rectWidth*ae.sourceWidth);ae.maxHeight=Math.round(ae.rectHeight*ae.sourceHeight)}else{ae.maxWidth=ae.sourceWidth;ae.maxHeight=ae.sourceHeight}ae.bInfo=true}};a.addEvent(window,"DOMContentLoaded",function(){if(typeof(a.quickZoomParameters)!="object"||a.makeBool(a.quickZoomParameters.autoInit,true)){if(typeof(a.quickZoom)=="object"&&typeof(a.quickZoom.destroy)=="function"){a.quickZoom.destroy()}var c;if(typeof(a.quickZoomParameters)=="object"){c=a.quickZoomParameters}a.quickZoom=new a.QuickZoom(c);a.quickZoom.bAutoInitialized=true;a.quickZoom.init()}})}(window.$FSI=window.$FSI||{}));