/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.segments.AppnSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class App2Segment
extends AppnSegment
implements Comparable<App2Segment> {
    public final byte[] icc_bytes;
    public final int cur_marker;
    public final int num_markers;

    public App2Segment(int marker, byte[] segmentData) throws ImageReadException, IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public App2Segment(int marker, int marker_length, InputStream is2) throws ImageReadException, IOException {
        super(marker, marker_length, is2);
        if (BinaryFileParser.startsWith(this.bytes, JpegImageParser.icc_profile_label)) {
            ByteArrayInputStream is = new ByteArrayInputStream(this.bytes);
            this.readAndVerifyBytes((InputStream)is, JpegImageParser.icc_profile_label, "Not a Valid App2 Segment: missing ICC Profile label");
            this.cur_marker = this.readByte("cur_marker", is, "Not a valid App2 Marker");
            this.num_markers = this.readByte("num_markers", is, "Not a valid App2 Marker");
            marker_length -= JpegImageParser.icc_profile_label.size();
            this.icc_bytes = this.readBytes("App2 Data", is, marker_length -= 2, "Invalid App2 Segment: insufficient data");
        } else {
            this.cur_marker = -1;
            this.num_markers = -1;
            this.icc_bytes = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof App2Segment) {
            App2Segment other = (App2Segment)obj;
            return this.cur_marker == other.cur_marker;
        }
        return false;
    }

    public int hashCode() {
        return this.cur_marker;
    }

    @Override
    public int compareTo(App2Segment other) {
        return this.cur_marker - other.cur_marker;
    }
}

