/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.rgbe;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.rgbe.RgbeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RgbeImageParser
extends ImageParser {
    public RgbeImageParser() {
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public String getName() {
        return "Radiance HDR";
    }

    @Override
    public String getDefaultExtension() {
        return ".hdr";
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return new String[]{".hdr", ".pic"};
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_RGBE};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        RgbeInfo info = new RgbeInfo(byteSource);
        try {
            IImageMetadata iImageMetadata = info.getMetadata();
            return iImageMetadata;
        }
        finally {
            info.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        RgbeInfo info = new RgbeInfo(byteSource);
        try {
            ImageInfo imageInfo = new ImageInfo(this.getName(), 32, new ArrayList<String>(), ImageFormat.IMAGE_FORMAT_RGBE, this.getName(), info.getHeight(), "image/vnd.radiance", 1, -1, -1.0f, -1, -1.0f, info.getWidth(), false, false, false, 2, "Adaptive RLE");
            return imageInfo;
        }
        finally {
            info.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        RgbeInfo info = new RgbeInfo(byteSource);
        try {
            DataBufferFloat buffer = new DataBufferFloat(info.getPixelData(), info.getWidth() * info.getHeight());
            BufferedImage bufferedImage = new BufferedImage(new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, buffer.getDataType()), Raster.createWritableRaster(new BandedSampleModel(buffer.getDataType(), info.getWidth(), info.getHeight(), 3), buffer, new Point()), false, null);
            return bufferedImage;
        }
        finally {
            info.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getImageSize(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        RgbeInfo info = new RgbeInfo(byteSource);
        try {
            Dimension dimension = new Dimension(info.getWidth(), info.getHeight());
            return dimension;
        }
        finally {
            info.close();
        }
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }
}

