/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.palette;

import java.util.List;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.palette.ColorCount;
import org.apache.commons.imaging.palette.ColorGroupCut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColorGroup {
    public ColorGroupCut cut = null;
    public int palette_index = -1;
    public final List<ColorCount> color_counts;
    public final boolean ignoreAlpha;
    public int min_red = Integer.MAX_VALUE;
    public int max_red = Integer.MIN_VALUE;
    public int min_green = Integer.MAX_VALUE;
    public int max_green = Integer.MIN_VALUE;
    public int min_blue = Integer.MAX_VALUE;
    public int max_blue = Integer.MIN_VALUE;
    public int min_alpha = Integer.MAX_VALUE;
    public int max_alpha = Integer.MIN_VALUE;
    public final int alpha_diff;
    public final int red_diff;
    public final int green_diff;
    public final int blue_diff;
    public final int max_diff;
    public final int diff_total;
    public final int totalPoints;

    public ColorGroup(List<ColorCount> color_counts, boolean ignoreAlpha) throws ImageWriteException {
        this.color_counts = color_counts;
        this.ignoreAlpha = ignoreAlpha;
        if (color_counts.size() < 1) {
            throw new ImageWriteException("empty color_group");
        }
        int totalPoints = 0;
        for (int i = 0; i < color_counts.size(); ++i) {
            ColorCount color = color_counts.get(i);
            totalPoints += color.count;
            this.min_alpha = Math.min(this.min_alpha, color.alpha);
            this.max_alpha = Math.max(this.max_alpha, color.alpha);
            this.min_red = Math.min(this.min_red, color.red);
            this.max_red = Math.max(this.max_red, color.red);
            this.min_green = Math.min(this.min_green, color.green);
            this.max_green = Math.max(this.max_green, color.green);
            this.min_blue = Math.min(this.min_blue, color.blue);
            this.max_blue = Math.max(this.max_blue, color.blue);
        }
        this.totalPoints = totalPoints;
        this.alpha_diff = this.max_alpha - this.min_alpha;
        this.red_diff = this.max_red - this.min_red;
        this.green_diff = this.max_green - this.min_green;
        this.blue_diff = this.max_blue - this.min_blue;
        this.max_diff = Math.max(ignoreAlpha ? this.red_diff : Math.max(this.alpha_diff, this.red_diff), Math.max(this.green_diff, this.blue_diff));
        this.diff_total = (ignoreAlpha ? 0 : this.alpha_diff) + this.red_diff + this.green_diff + this.blue_diff;
    }

    public boolean contains(int argb) {
        int alpha = 0xFF & argb >> 24;
        int red = 0xFF & argb >> 16;
        int green = 0xFF & argb >> 8;
        int blue = 0xFF & argb >> 0;
        if (!(this.ignoreAlpha || alpha >= this.min_alpha && alpha <= this.max_alpha)) {
            return false;
        }
        if (red < this.min_red || red > this.max_red) {
            return false;
        }
        if (green < this.min_green || green > this.max_green) {
            return false;
        }
        return blue >= this.min_blue && blue <= this.max_blue;
    }

    public int getMedianValue() {
        long count_total = 0L;
        long alpha_total = 0L;
        long red_total = 0L;
        long green_total = 0L;
        long blue_total = 0L;
        for (int i = 0; i < this.color_counts.size(); ++i) {
            ColorCount color = this.color_counts.get(i);
            count_total += (long)color.count;
            alpha_total += (long)(color.count * color.alpha);
            red_total += (long)(color.count * color.red);
            green_total += (long)(color.count * color.green);
            blue_total += (long)(color.count * color.blue);
        }
        int alpha = this.ignoreAlpha ? 255 : (int)Math.round((double)alpha_total / (double)count_total);
        int red = (int)Math.round((double)red_total / (double)count_total);
        int green = (int)Math.round((double)green_total / (double)count_total);
        int blue = (int)Math.round((double)blue_total / (double)count_total);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public String toString() {
        return "{ColorGroup. min_red: " + Integer.toHexString(this.min_red) + ", max_red: " + Integer.toHexString(this.max_red) + ", min_green: " + Integer.toHexString(this.min_green) + ", max_green: " + Integer.toHexString(this.max_green) + ", min_blue: " + Integer.toHexString(this.min_blue) + ", max_blue: " + Integer.toHexString(this.max_blue) + ", min_alpha: " + Integer.toHexString(this.min_alpha) + ", max_alpha: " + Integer.toHexString(this.max_alpha) + ", max_diff: " + Integer.toHexString(this.max_diff) + ", diff_total: " + this.diff_total + "}";
    }
}

