/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.opimage.MosaicOpImage;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

final class MlibMosaicOpImage
extends MosaicOpImage {
    private int[] glow;
    private int[] ghigh;
    private int shift;

    public MlibMosaicOpImage(Vector vector, ImageLayout imageLayout, Map map, MosaicType mosaicType, PlanarImage[] planarImageArray, ROI[] rOIArray, double[][] dArray, double[] dArray2) {
        super(vector, imageLayout, map, mosaicType, planarImageArray, rOIArray, dArray, dArray2);
        int n;
        int n2;
        int n3 = vector.size();
        int n4 = this.sampleModel.getDataType();
        if (n4 == 4 || n4 == 5) {
            throw new UnsupportedOperationException(JaiI18N.getString("MlibMosaicOpImage0"));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = 0;
            while (n < this.numBands) {
                int[] nArray = this.threshold[n2];
                int n5 = n++;
                nArray[n5] = nArray[n5] - 1;
            }
        }
        n2 = -2147483647;
        n = Integer.MAX_VALUE;
        switch (n4) {
            case 0: {
                n2 = 0;
                n = 255;
                this.shift = 8;
                break;
            }
            case 1: {
                n2 = 0;
                n = 65535;
                this.shift = 16;
                break;
            }
            case 2: {
                n2 = Short.MIN_VALUE;
                n = Short.MAX_VALUE;
                this.shift = 16;
                break;
            }
            case 3: {
                n2 = Integer.MIN_VALUE;
                n = Integer.MAX_VALUE;
                this.shift = 32;
                break;
            }
        }
        this.glow = new int[this.numBands];
        Arrays.fill(this.glow, n2);
        this.ghigh = new int[this.numBands];
        Arrays.fill(this.ghigh, n);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle, Raster[] rasterArray2, Raster[] rasterArray3) {
        int n;
        int n2 = rasterArray.length;
        ArrayList<Raster> arrayList = new ArrayList<Raster>(n2);
        for (n = 0; n < n2; ++n) {
            if (rasterArray[n] == null) continue;
            arrayList.add(rasterArray[n]);
        }
        n = arrayList.size();
        Raster[] rasterArray4 = null;
        if (n != 0) {
            rasterArray4 = new Raster[n];
            arrayList.toArray(rasterArray4);
        }
        int n3 = MediaLibAccessor.findCompatibleTag(rasterArray4, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster, rectangle, n3);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        int[] nArray = mediaLibAccessor.getIntParameters(0, this.background);
        if (n == 0) {
            Image.Clear((mediaLibImage)mediaLibImageArray[0], (int[])nArray);
            return;
        }
        MediaLibAccessor[] mediaLibAccessorArray = new MediaLibAccessor[n2];
        for (int i = 0; i < n2; ++i) {
            if (rasterArray[i] == null) continue;
            mediaLibAccessorArray[i] = new MediaLibAccessor(rasterArray[i], rectangle, n3);
        }
        int[][] nArrayArray = new int[n2][];
        mediaLibImage[][] mediaLibImageArrayArray = new mediaLibImage[n2][];
        for (int i = 0; i < n2; ++i) {
            if (mediaLibAccessorArray[i] == null) continue;
            mediaLibImageArrayArray[i] = mediaLibAccessorArray[i].getMediaLibImages();
            nArrayArray[i] = mediaLibAccessorArray[i].getIntParameters(0, this.threshold[i]);
        }
        mediaLibImage mediaLibImage2 = null;
        mediaLibImage mediaLibImage3 = null;
        mediaLibImage[] mediaLibImageArray2 = new mediaLibImage[]{mediaLibImage2};
        mediaLibImage[] mediaLibImageArray3 = new mediaLibImage[]{mediaLibImage3};
        if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            Image.Clear((mediaLibImage)mediaLibImageArray[0], (int[])nArray);
            for (int i = n2 - 1; i >= 0; --i) {
                if (mediaLibImageArrayArray[i] == null) continue;
                mediaLibImage mediaLibImage4 = this.getWeightImage(rectangle, n3, mediaLibImageArray[0], mediaLibImageArrayArray[i][0], this.sourceAlpha != null && this.sourceAlpha[i] != null ? rasterArray2[i] : null, this.sourceROI != null && this.sourceROI[i] != null ? rasterArray3[i] : null, nArrayArray[i], mediaLibImageArray2, mediaLibImageArray3);
                Image.Blend2((mediaLibImage)mediaLibImageArray[0], (mediaLibImage)mediaLibImageArrayArray[i][0], (mediaLibImage)mediaLibImage4);
            }
        } else if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_BLEND) {
            mediaLibImage2 = new mediaLibImage(mediaLibImageArray[0].getType(), 1, mediaLibImageArray[0].getWidth(), mediaLibImageArray[0].getHeight());
            mediaLibImage3 = new mediaLibImage(mediaLibImageArray[0].getType(), mediaLibImageArray[0].getChannels(), mediaLibImageArray[0].getWidth(), mediaLibImageArray[0].getHeight());
            mediaLibImage[] mediaLibImageArray4 = new mediaLibImage[n];
            mediaLibImage[] mediaLibImageArray5 = new mediaLibImage[n];
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (mediaLibImageArrayArray[i] == null) continue;
                mediaLibImageArray5[n4] = mediaLibImageArrayArray[i][0];
                mediaLibImageArray4[n4] = this.getWeightImage(rectangle, n3, mediaLibImageArray[0], mediaLibImageArrayArray[i][0], this.sourceAlpha != null && this.sourceAlpha[i] != null ? rasterArray2[i] : null, this.sourceROI != null && this.sourceROI[i] != null ? rasterArray3[i] : null, nArrayArray[i], null, null);
                ++n4;
            }
            if (n4 != n) {
                mediaLibImage[] mediaLibImageArray6 = new mediaLibImage[n4];
                System.arraycopy(mediaLibImageArray5, 0, mediaLibImageArray6, 0, n4);
                mediaLibImageArray5 = mediaLibImageArray6;
                mediaLibImage[] mediaLibImageArray7 = new mediaLibImage[n4];
                System.arraycopy(mediaLibImageArray4, 0, mediaLibImageArray7, 0, n4);
                mediaLibImageArray4 = mediaLibImageArray7;
            }
            Image.BlendMulti((mediaLibImage)mediaLibImageArray[0], (mediaLibImage[])mediaLibImageArray5, (mediaLibImage[])mediaLibImageArray4, (int[])nArray);
        }
        if (mediaLibAccessor.isDataCopy()) {
            mediaLibAccessor.clampDataArrays();
            mediaLibAccessor.copyDataToRaster();
        }
    }

    private mediaLibImage getWeightImage(Rectangle rectangle, int n, mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, Raster raster, Raster raster2, int[] nArray, mediaLibImage[] mediaLibImageArray, mediaLibImage[] mediaLibImageArray2) {
        mediaLibImage mediaLibImage4 = null;
        if (raster != null) {
            MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle, n);
            mediaLibImage[] mediaLibImageArray3 = mediaLibAccessor.getMediaLibImages();
            if (this.isAlphaBitmask) {
                if (mediaLibImageArray == null) {
                    mediaLibImageArray = new mediaLibImage[]{null};
                }
                if (mediaLibImageArray[0] == null) {
                    mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
                }
                Image.Thresh1((mediaLibImage)mediaLibImageArray[0], (mediaLibImage)mediaLibImageArray3[0], (int[])new int[]{0}, (int[])new int[]{this.ghigh[0]}, (int[])new int[]{this.glow[0]});
                mediaLibImage4 = mediaLibImageArray[0];
            } else {
                mediaLibImage4 = mediaLibImageArray3[0];
            }
        } else if (raster2 != null) {
            int n2 = MediaLibAccessor.findCompatibleTag(null, raster2);
            MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster2, rectangle, n2, true);
            mediaLibImage[] mediaLibImageArray4 = mediaLibAccessor.getMediaLibImages();
            if (mediaLibImageArray == null) {
                mediaLibImageArray = new mediaLibImage[]{null};
            }
            if (mediaLibImageArray[0] == null) {
                mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
            }
            if (mediaLibImageArray[0].getType() != mediaLibImageArray4[0].getType()) {
                if (mediaLibImageArray[0] == null) {
                    mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
                }
                Image.DataTypeConvert((mediaLibImage)mediaLibImageArray[0], (mediaLibImage)mediaLibImageArray4[0]);
            } else {
                mediaLibImageArray[0] = mediaLibImageArray4[0];
            }
            Image.Thresh1((mediaLibImage)mediaLibImageArray[0], (int[])new int[]{0}, (int[])new int[]{this.ghigh[0]}, (int[])new int[]{this.glow[0]});
            mediaLibImage4 = mediaLibImageArray[0];
        } else {
            if (mediaLibImageArray2 == null) {
                mediaLibImageArray2 = new mediaLibImage[]{null};
            }
            if (mediaLibImageArray2[0] == null) {
                mediaLibImageArray2[0] = mediaLibImage2.createCompatibleImage();
            }
            mediaLibImage4 = mediaLibImageArray2[0];
            Image.Thresh1((mediaLibImage)mediaLibImage4, (mediaLibImage)mediaLibImage3, (int[])nArray, (int[])this.ghigh, (int[])this.glow);
        }
        return mediaLibImage4;
    }
}

