<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Add Property Set" />

  <#if show_form?? >

    <script type="text/javascript">
    
      function addRow(sectionname) {
        for (var i = 2; i <= 20; i++) {
        	if (document.getElementById(sectionname + "_" + i).style.display == "none") {
        		document.getElementById(sectionname + "_" + i).style.display = "table-row";
        		break;
			}
        }
      }
      
      function clearRow(sectionname, number) {
      		alert(sectionname + "_name_" + number);
        	document.getElementById(sectionname + "_name_" + number).value="";
      }
    
    
    </script>

    <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="addpropertyset">
      <input type="hidden" name="save" value="1">
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
        <td class="pad1" colspan="5">
         <#if message??>
          <span style="color: red">${message}</span>
         <#else>
          Enter the properties in the form below and press the save button at the end of the page. 
          The property sets will then be re-read for the changes to take effect.
         </#if>
        </td>
      </tr>
	  <tr>
	    <td class="sectionheader" colspan="4">Name</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1">Name</td>
        <td class="pad1"><input type="text" class="inwhite" name="name" <#if name?? >value="${name}"</#if> help="<@appID/>:permissionsets_name" /> 
        </td>
      </tr>
      
      <#-- General Properties -->
      
      <tr>
	    <td class="sectionheader" colspan="4">General Properties</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
	  <#list 1..20 as i>
	    <tr id="general_${i}" style="display: <#if i==1>table-row<#else>none</#if>;">
          <td class="pad1"><input type="text" class="inwhite" id="general_name_${i}" name="general_name_${i}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="general_protected_${i}" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="general_inherit_${i}" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="general_value_${i}" itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="generalplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('general', ${i});">X</span></td>
        </tr>
	  </#list>  

      <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="generalplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('general');">+</span></td>
	  </tr>
	  
	  
	  
	  <tr>
	    <td class="sectionheader" colspan="5">Hide Apps</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
	  <tr id="hideapps_1" style="display: hidden;">
          <td class="pad1"><input type="text" class="inwhite" name="hideapps_name_1" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hideapps_protected_1" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hideapps_inherit_1" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="hideapps_value_1" itemlist=valueList helpid="renderer_format" /></td>
      </tr>
	  
	  <#list 2..20 as i>
	    <tr id="hideapps_${i}" style="display: none;">
          <td class="pad1"><input type="text" class="inwhite" name="hideapps_name_${i}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hideapps_protected_${i}" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hideapps_inherit_${i}" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="hideapps_value_${i}" itemlist=valueList helpid="renderer_format" /></td>
        </tr>
	  </#list>  

      <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="hideappsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('hideapps');">+</span></td>
	  </tr>
	  
	  <tr>
	    <td class="sectionheader" colspan="5">Hide Publishing Tabs</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
	  <tr id="hidepublishingtabs_1" style="display: hidden;">
          <td class="pad1"><input type="text" class="inwhite" name="hidepublishingtabs_name_1" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hidepublishingtabs_protected_1" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hidepublishingtabs_inherit_1" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="hidepublishingtabs_value_1" itemlist=valueList helpid="renderer_format" /></td>
      </tr>
	  
	  <#list 2..20 as i>
	    <tr id="hidepublishingtabs_${i}" style="display: none;">
          <td class="pad1"><input type="text" class="inwhite" name="hidepublishingtabs_name_${i}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hidepublishingtabs_protected_${i}" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hidepublishingtabs_inherit_${i}" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="hidepublishingtabs_value_${i}" itemlist=valueList helpid="renderer_format" /></td>
        </tr>
	  </#list>  

      <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="hidepublishingtabsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('hidepublishingtabs');">+</span></td>
	  </tr>
	  
	  <tr>
	    <td class="sectionheader" colspan="5">Custom Metadata Fields</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
	  <tr id="custommetadatafields_1" style="display: hidden;">
          <td class="pad1"><input type="text" class="inwhite" name="custommetadatafields_name_1" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="custommetadatafields_protected_1" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="custommetadatafields_inherit_1" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="custommetadatafields_value_1" itemlist=valueList helpid="renderer_format" /></td>
      </tr>
	  
	  <#list 2..20 as i>
	    <tr id="custommetadatafields_${i}" style="display: none;">
          <td class="pad1"><input type="text" class="inwhite" name="custommetadatafields_name_${i}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="custommetadatafields_protected_${i}" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="custommetadatafields_inherit_${i}" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="custommetadatafields_value_${i}" itemlist=valueList helpid="renderer_format" /></td>
        </tr>
	  </#list>  

      <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="custommetadatafieldsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('custommetadatafields');">+</span></td>
	  </tr>
	  
	  
	  
	  <tr>
	    <td class="sectionheader" colspan="5">Publishing Sets</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
	  <tr id="publishingsets_1" style="display: hidden;">
          <td class="pad1"><input type="text" class="inwhite" name="publishingsets_name_1" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="publishingsets_protected_1" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="publishingsets_inherit_1" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="publishingsets_value_1" itemlist=valueList helpid="renderer_format" /></td>
      </tr>
	  
	  <#list 2..20 as i>
	    <tr id="publishingsets_${i}" style="display: none;">
          <td class="pad1"><input type="text" class="inwhite" name="publishingsets_name_${i}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="publishingsets_protected_${i}" helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="publishingsets_inherit_${i}" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="publishingsets_value_${i}" itemlist=valueList helpid="renderer_format" /></td>
        </tr>
	  </#list>  

      <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="publishingsetsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('publishingsets');">+</span></td>
	  </tr>
	  
	  
	  
	  <tr>
        <td class="pad1" style="padding-top: 20px;" colspan="5" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listpermissionsets" />
          <@formsubmit value="Save" helpid="permissionsets_save" />	
        </td>
      </tr>
      
      </table>
    </form>
    


  <#elseif show_confirmation?? >
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
	    <td class="sectionheader">Permission set saved</td>
	  </tr>
	  <tr><td><hr size="1" class="hr1"/></td></tr>
	  <tr>
	   <td class="pad1">
    	Please wait while the permission sets are re-read for the changes to take effect.
       </td>
      </tr>
    </table>
    <#assign timeout="5" />
    <#assign postprogresslocation="action=listpermissionsets">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">