<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

  <@tableHeader Heading="Delete User" />
  
  <#if request_confirmation??>
  
    <form action="pt.do" method="POST" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="deleteuser">
    <input type="hidden" name="confirmed" value="1">
    <input type="hidden" name="username" value="${username}">

    <table cellspacing="0" cellpadding="20px" border="0px">
     <tr> 
      <td style="vertical-align: top" colspan="2">Are you sure you want to delete the user "${username}"?</td>
     </tr>
     <#if (stale_groups?size > 0) || (stale_sourceconnectors?size > 0) > 
      <tr>
       <td>Also delete the following group(s) and source connector(s)? <br />
           <#if (stale_groups?size > 0) >
           Groups: <#list stale_groups as group>${group} </#list> <br />
           </#if>
           <#if (stale_sourceconnectors?size > 0) >
           Source Connectors: <#list stale_sourceconnectors as ssc>${ssc} </#list>
           </#if>
       </td>   
       <td><@formcheckbox objid="deletegroupsandconnectors" preselect="true" helpid="deleteuser_deletegroupsconnectors" /></td>
     </tr>
     </#if>
     <tr>
      <td class="pad1" align="right" style="padding-top: 30px;" colspan="2">
       <span class="btnwhite" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
       <@formsubmit value="Delete" />
      </td>
     </tr>
    </table>
    </form>
      
  <#elseif show_error?? >
  
  	<#if message??><span style="color: red">${message}</span><br /><br /></#if>
  	
  <#elseif show_confirmation?? > 
  
    <#if restart_required?? >
  
     The user "${username}" was successfully deleted. Please wait while the FSI Server is restarted for the changes to take effect.<br /><br />
	 <#assign timeout="5" />
     <#assign postprogresslocation="action=listusers">
     <#include "/sub/progressbar.ftl">
    
    <#else>
    
     The user "${username}" was successfully deleted. 
    
    </#if>
    
  </#if>
  
  <@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">