<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

  <#if show_summary?? >

    <@tableHeader Heading="Licences" />

    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
    
     <#if licences?size == 0>
       
      <tr>  
       <td class="sectionheader firstsection" colspan="3">No licences</td>
      </tr>
      <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
      <tr>  
       <td class="pad1" colspan="3">
        There are currently no licences installed. The FSI Server is running in evaluation mode. Use the "Install Licence"
        button below to install a licence. 
       </td>
      </tr>
       
     <#else>
     
      <#list licences as licence>
      <tr>
	    <td class="sectionheader firstsection" colspan="3">${licence.appname} - Version ${licence.version}</td>
	  </tr>
	  <tr>
	    <td colspan="3"><hr size="1" class="hr1"/></td>
	  </tr>
	   <#if (licence.properties?size > 0) >
	    <#list licence.properties?keys as key>
	     <tr>
          <td class="pad1" valign="top">${key}</td> 
          <td class="pad1" colspan="2">
            <#list licence.properties[key] as value>
             ${value}<br />
            </#list>
          </td>
         </tr>
        </#list>
       <#else>
        <tr>
          <td class="pad1" colspan="3">No details for this licence available.</td>
        </tr>
       </#if>
       <tr>
        <td class="pad1" style="text-align: right;" colspan="3">
            <form action="pt.do" method="post" onsubmit="this.submit();">    
       		<@printRequiredParams method="post" />
          	<input type="hidden" name="action" value="licence">
          	<input type="hidden" name="deletelicence" value="true">
          	<input type="hidden" name="appid" value="${licence.appid}">
          	<input type="hidden" name="version" value="${licence.version}">
          	<img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" onclick="spansubmit(this);" class="btnwhite" title="Delete Licence" alt="Delete Licence" src="images/apps/app22/delete_profile.png" id="app1iconic" help="<@appID />:licence_delete" />
	   		</form>
        </td>
       </tr>
      </#list>
      <tr>
	    <td style="padding-top: 20px;" colspan="3"><hr size="1" class="hr1"/></td>
	  </tr>
     </#if>
	  <tr>
       <td class="pad1" style="text-align: right; padding-top: 20px;" colspan="3">
       <form action="pt.do" method="post" onsubmit="this.submit();">    
          <@printRequiredParams method="post" />
          <input type="hidden" name="action" value="licence">
          <input type="hidden" name="licenceform" value="1">
          <@formsubmit value="Install/Replace Licence" helpid="licence_install_replace"/> 
	   </form>
	  </td>
	 </tr>
    </table>
    <@tableFooter/>
	
  <#elseif show_licence_form?? >
    
    <@tableHeader Heading="Install New Licence" />
    
    <form action="pt.do" method="post" enctype="multipart/form-data" onsubmit="this.submit();">    
     <@printRequiredParams method="post" />
     <input type="hidden" name="action" value="licence">
     <input type="hidden" name="installlicence" value="true">

     <script type="text/javascript">
       function activateSubmit() {
         document.getElementById("submitbutton").className = "btnwhite";
       }
     </script>
     
     <table cellspacing=0 cellpadding=0 style="border: 0px; width:500px;">
      <tr>
       <td class="pad1">
       Please select the licence file to upload and click the "Install Licence" button.<br /> 
       If the licence file contains keys matching already installed keys, these will be replaced.
       </td>
      </tr> 
      <tr>
        <td class="sectionheader">Upload Licence</td>
      </tr>
      <tr><td><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="pad1">
          <input class="btnwhite" type="file" name="licencefile" accept="application/xml" onkeyup="activateSubmit();" onmouseup="activateSubmit();" help="<@appID />:licence_select_file">
        </td>
      </tr>
      <tr>
     	<td class="pad1" align="right">
     	  <span class="btnwhite" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();" >Cancel</span>
     	  <@formsubmit disabled="true" value="Install Selected Licences" helpid="licence_upload" />
        </td>
      </tr>
     </table>
    </form>
	<@tableFooter/>
     
  <#elseif show_install_confirmation?? >
     
     <@tableHeader Heading="Install Licence" />
     
     <table cellspacing=0 cellpadding=0 style="border: 0px; width: 500px;">
      <tr>
        <td class="sectionheader">Licence uploaded</td>
      </tr>
      <tr><td><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1">The new licence has been installed. Please wait while the server is restarted for the licence 
       changes to take effect.</td>
      </tr>
      <tr>
       <td class="pad1" style="padding-top: 10px">
      <#assign timeout="5" />
      <#assign postprogresslocation="action=licence">
      <#include "/sub/progressbar.ftl">
       </td>
      </tr>
     </table>
	 <@tableFooter/>
	 
     
  <#elseif show_invalid_file_format?? >
  
     <@tableHeader Heading="Install Licence" /> 
     
     <table cellspacing=0 cellpadding=0 style="border: 0px; width: 500px;">
      <tr>
        <td class="sectionheader">Invalid File Format</td>
      </tr>
      <tr><td><hr size="1" class="hr1"/></td></tr>   
      <tr>
       <td class="pad1">
         An error occured reading the uploaded licence file: <br />
         ${message?xml}
       </td>
      </tr>
      <tr>
       <td class="pad1" style="padding-top: 10px" align="right">
        <form action="pt.do" method="post" onsubmit="this.submit();">    
        <@printRequiredParams method="post" />
        <input type="hidden" name="action" value="licence">
     	<@formsubmit value="Ok" />
        </form> 
       </td>
      </tr>
     </table>    
	 <@tableFooter/>
     
  <#elseif show_confirm_remove_request?? >
     
     <@tableHeader Heading="Delete Licence" />
     
     <table cellspacing=0 cellpadding=0 style="border: 0px; width: 500px;">
      <tr>
        <td class="sectionheader">Delete licence?</td>
      </tr>
      <tr><td><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1">Are you sure you want to delete the selected licence?</td>
      </tr>
      <tr>
       <td class="pad1" style="padding-top: 10px; min-width: 0px;" align="right">
        <form action="pt.do" method="post" onsubmit="this.submit();">    
        <@printRequiredParams method="post" />
        <input type="hidden" name="action" value="licence">
        <input type="hidden" name="deletelicence" value="true">
        <input type="hidden" name="confirmed" value="true">
        <input type="hidden" name="appid" value="${appid}">
        <input type="hidden" name="version" value="${version}">
        <span class="btnwhite" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
        <@formsubmit value="Delete" />
        </form> 
       </td>
      </tr>
     </table>
	 <@tableFooter/>
     
  <#elseif show_remove_confirmation?? >
  	
  	<@tableHeader Heading="Licence removed" />

  	<table cellspacing=0 cellpadding=0 style="border: 0px; width: 500px;">
      <tr>
        <td class="sectionheader">Licence deleted</td>
      </tr>
      <tr><td><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1">The selected licence has been removed. Please wait while the server is restarted for the new licence to take effect.</td>
      </tr>
      <tr>
       <td class="pad1" style="padding-top: 10px">
       <#assign timeout="5" />
       <#assign postprogresslocation="action=licence">
       <#include "/sub/progressbar.ftl">
       </td>
      </tr>
    </table>
	<@tableFooter/>
  
  <#elseif show_invalid_error?? >
  	
    Error
  
  </#if>

<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">