<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

   <#if show_chooser??>

    <@tableHeader Heading="Preferences" />
   
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
       <tr>
         <td class="pad1" colspan="2">Preferences are environment variables used by the FSI Server web interface or any 
         client application accessing data on the FSI Server. Some preferences are set by the server itself, 
         others can be freely configured here. Preferences can be set to either apply to all users or only to specific users.
         </td>
       </tr>
	   <tr>
	      <td class="sectionheader" colspan="2">Default Preferences</td>
	   </tr>
	   <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	   <tr>
	    <td class="pad1" valign="top">
     		Edit the default preferences that apply to all users.
     	</td>
     	<td class="pad1" valign="bottom" align="right">  
          <form action="pt.do" method="post" onsubmit="this.submit();">    
     	  <@printRequiredParams method="post" />
       	  <input type="hidden" name="action" value="userprefs">
       	  <input type="hidden" name="defaultprefs" value="true">
          <@formsubmit value="Edit" helpid="edit_default_prefs" />
   	 	  </form>
   	 	</td>
   	   </tr>
   	   
   	   <tr>
	      <td class="sectionheader" colspan="2">User Preferences</td>
	   </tr>
	   <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	   <tr>
	    <td class="pad1" valign="top">
	     Select a user and edit his/her preferences.
        </td>
     	<td class="pad1" valign="bottom" align="right">  
         <form action="pt.do" method="post" onsubmit="this.submit();">    
         <@printRequiredParams method="post" />
         <input type="hidden" name="action" value="userprefs">
         <@formgfxselect objid="user" itemlist=all_users preselect=all_users?first.value helpid="" /><br />
   	     <@formsubmit value="Edit" helpid="edit_user_prefs" />
         </form>
   	    </td>
   	   </tr>
   	 </table>
    <@tableFooter/>
   <#else>

     <#if user??><@tableHeader Heading="Preferences for user '<i>${user}</i>'" />
     <#else><@tableHeader Heading="Default preferences for all users" /></#if>
      
     <table cellspacing="0" cellpadding="0" border="0" width="600px">
       <tr>
        <td class="pad1" colspan="3">
        
          <#if message?? ><div style="width: 100%; text-align: center; color: green">${message}</div><br /><br /></#if>
        
          <#if user??>
          The table shows the preferences that apply to the <b>user ${user}</b>. Grayed out preferences are 
          default preferences that also apply to this user and cannot be deleted here. Adding a preference value 
          at the end of this page will add the preference for this user only, overriding any default preferences 
          of the same name.
          <#else>
          The table shows the preferences that will apply to all users unless they have been overridden by any 
          user specific preferences. The form at the bottom allows adding new default preferences. 
          </#if>
        </td>
	   <tr>
	      <td class="sectionheader" style="font-weight: bold;">Name</td>
	      <td class="sectionheader" style="font-weight: bold;">Value(s)</td>
	      <td class="sectionheader" style="font-weight: bold;">&nbsp;</td>
	   </tr>
	   <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
	   <#if prefs?size == 0 >
	     <tr><td colspan="3" align="center"><i>No preferences defined.</i></td></tr>
	   </#if>
	   <#list prefs as pref>
	    <#list pref.values as value>
	     <tr>
	      <#if pref.disabled>
           <td class="pad1"><font color="lightgrey">${pref.name}</font></td> 
           <td class="pad1"><font color="lightgrey">${value}</font></td>
           <td class="pad1" style="min-width: 0px;"></td>
          <#else>
           <td class="pad1">${pref.name}</td> 
           <td class="pad1">${value}</td>
           <td class="pad1" style="min-width: 0px;" align="right">
           <form action="pt.do" method="post" onsubmit="this.submit();">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="userprefs">
            <#if user??><input type="hidden" name="user" value="${user}"></#if>
            <#if defaultprefs??><input type="hidden" name="defaultprefs" value="true"></#if>
            <input type="hidden" name="remove" value="1">
            <input type="hidden" name="name" value="${pref.name}">
            <input type="hidden" name="value" value="${value}">
            <@formsubmit value="Delete" helpid="del_pref" />
           </form>
          </td>
          </#if>
         </tr>
        </#list>
       </#list>
       
       <tr>
	      <td class="sectionheader" colspan="3">Add new preference</td>
	   </tr>
       <tr>
	     <td colspan="3"><hr size="1" class="hr1"/></td>
	   </tr>
	 </table>
	 <form action="pt.do" method="post" onsubmit="this.submit();">    
        <@printRequiredParams method="post" />
        <input type="hidden" name="action" value="userprefs">
        <input type="hidden" name="add" value="1">
        <#if user??><input type="hidden" name="user" value="${user}"></#if>
        <#if defaultprefs??><input type="hidden" name="defaultprefs" value="true"></#if>
	   <table cellspacing="0" cellpadding="0" style="border: 0px; width: 600px;">
	   <tr>
	    <td class="pad1" colspan="3">
	     <#if user??>
	      Currently configurable per-user preferences used in the FSIServer webinterface.<br /><br />
	      <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='viewerPath';">"viewerPath"</span> 
          defines the relative location of the FSI Viewer (this is also set when installing or removing a user's viewer).<br />
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='proxyURL';">"proxyURL" (*)</span> 
          defines the absolute URL to an installed FSI Cache, proxy or an alternative URL to the FSI Server.<br />
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='proxyServerPattern';">"proxyServerPattern" (*)</span> 
          defines the FSICache profile (or path prefix on the proxy) to access images and meta data.<br />
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='proxyJSPath';">"proxyJSPath" (*)</span> 
          defines the FSICache profile (or path prefix on the proxy) to access the JavaScript helper files like fsiwriter.js.<br />
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='demoMode';document.getElementById('value').value='true'">"demoMode"</span> 
          Switches the webinterface to demo mode for this user. This prohibits changing the password and saving the current interface state.<br /><br />
          Some of these preferences will modify the HTML codesnips generated by FSI Server's "publish to web" interfaces. 
          Please consider setting the prefs marked with a (*) in the default prefs instead of on a per-user base as 
          they most likely apply to all users. Setting preferences here will override default preferences with the same name. To unset a default preference enter "null" as value.  
	     <#else>
	      Currently configurable default preferences used in the FSI Server webinterface.<br /><br/>
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='proxyURL';">"proxyURL"</span> 
          defines the absolute URL to an installed FSI Cache, proxy or an alternative URL to the FSI Server.<br />
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='proxyServerPattern';">"proxyServerPattern"</span> 
          defines the FSICache profile (or path prefix on the proxy) to access images and meta data.<br />
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='proxyViewerPath';">"proxyViewerPath"</span> 
          defines the FSICache profile (or path prefix on the proxy) used to access the default FSI Viewer.<br /> 
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='proxyUserViewerBase';">"proxyUserViewerBase"</span> 
          defines the FSICache profile (or path prefix on the proxy) used to access the default FSI Viewer.<br />
          <span style="font-weight: bold; cursor: pointer; cursor: hand;" onclick="document.getElementById('name').value='proxyJSPath';">"proxyJSPath"</span> 
          defines the relative location of the directory containing the JavaScript helper files like fsiwriter.js.<br /><br />
          Some of these preferences will modify the HTML codesnips generated by FSI Server's "publish to web" interfaces.
         </#if> 
        </td>
       </tr>
	   <tr>
	      <td class="sectionheader" style="font-weight: bold;">Name</td>
	      <td class="sectionheader" style="font-weight: bold;">Value(s)</td>
	      <td class="sectionheader" style="font-weight: bold;">&nbsp;</td>
	   </tr>
	   <tr>
        <td class="pad1">
          <input type="text" class="inwhite" maxlength="30" id="name" name="name" help="<@appID/>:add_pref_name">
        </td>
        <td class="pad1">
          <input type="text" class="inwhite" id="value" name="value" help="<@appID/>:add_pref_value">
        </td>
        <td class="pad1" style="min-width: 40px;" align="right">
            <@formsubmit value="Add" helpid="add_pref_submit" />
        </td>
       </tr>
       </table>
     </form>
	 <@tableFooter/>
  </#if>

<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">