<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Edit Property Set '${propertyset.name}'" />

  <#if show_form?? >

    <script type="text/javascript">
    
      function addRow(sectionname) {
        for (var i = 2; i <= 10; i++) {
        	if (document.getElementById(sectionname + "_" + i).style.display == "none") {
        		document.getElementById(sectionname + "_" + i).style.display = "table-row";
        		break;
			}
        }
      }
      
      function clearRow(sectionname, number) {
      		document.getElementById(sectionname + "_name_" + number).value="";
        	document.getElementById(sectionname + "_" + number).style.display = "none";
      }
    
    </script>

    <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="editpropertyset">
      <input type="hidden" name="name" value="${propertyset.name}">
      <input type="hidden" name="save" value="1">
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
        <td class="pad1" colspan="5">
         <#if message??>
          <span style="color: red">${message}</span>
         <#else>
          Enter the properties in the form below and press the save button at the end of the page. 
          The property sets will then be re-read for the changes to take effect.
         </#if>
        </td>
      </tr>
	  
      <#-- General Properties -->
      
      <tr>
	    <td class="sectionheader" colspan="4">General Properties</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
      
	  <#assign i = 1 />
	  <#list propertyset.general?keys as key>
	    <tr id="general_${i}" style="display: table-row;">
	      <td class="pad1"><input type="text" class="inwhite" id="general_name_${i}" name="general_name_${i}" value="${propertyset.general[key].name}" help="<@appID/>:permissionsets_name" /></td>
	      <td class="pad1" align="center"><@formcheckbox objid="general_protected_${i}" preselect=propertyset.general[key].protected?string helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="general_inherit_${i}" preselect=propertyset.general[key].inherit?string helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="general_value_${i}" preselect=propertyset.general[key].value?string itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="generalplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('general', ${i});">X</span></td>
	    </tr>
	    <#assign i = i + 1 />
	  </#list>  
	  
	  <#list i..10 as j>
	    <tr id="general_${j}" style="display: <#if j==i>table-row<#else>none</#if>;">
          <td class="pad1"><input type="text" class="inwhite" id="general_name_${j}" name="general_name_${j}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="general_protected_${j}" preselect="general_protected_${i}"?eval helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="general_inherit_${j}" helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="general_value_${j}" itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="generalplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('general', ${j});">X</span></td>
        </tr>
	  </#list>  

      <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="generalplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('general');">+</span></td>
	  </tr>
	  
	  <tr>
	    <td class="sectionheader" colspan="5">Hide Apps</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
	  <#assign i = 1 />
	  <#list propertyset.hideapps?keys as key>
	    <tr id="hideapps_${i}" style="display: table-row;">
	      <td class="pad1"><input type="text" class="inwhite" id="hideapps_name_${i}" name="hideapps_name_${i}" value="${propertyset.hideapps[key].name}" help="<@appID/>:permissionsets_name" /></td>
	      <td class="pad1" align="center"><@formcheckbox objid="hideapps_protected_${i}" preselect=propertyset.hideapps[key].protected?string helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hideapps_inherit_${i}" preselect=propertyset.hideapps[key].inherit?string helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="hideapps_value_${i}" preselect=propertyset.hideapps[key].value?string itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="hideappsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('hideapps', ${i});">X</span></td>
	    </tr>
	    <#assign i = i + 1 />
	  </#list>  
	  
	  <#list i..10 as j>
	    <tr id="hideapps_${j}" style="display: <#if j==i>table-row<#else>none</#if>;">
          <td class="pad1"><input type="text" class="inwhite" id="hideapps_name_${j}" name="hideapps_name_${j}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hideapps_protected_${j}" preselect="hideapps_protected_${i}"?eval helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hideapps_inherit_${j}" helpid="hideapps_format" /></td>
          <td class="pad1"><@formgfxselect objid="hideapps_value_${j}" itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="hideappsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('hideapps', ${j});">X</span></td>
        </tr>
	  </#list>  
	  
	  <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="hideappsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('hideapps');">+</span></td>
	  </tr>
	  
	  
	  
	  
	  
	  <tr>
	    <td class="sectionheader" colspan="5">Hide Publishing Tabs</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
	  <#assign i = 1 />
	  <#list propertyset.hidepublishingtabs?keys as key>
	    <tr id="hidepublishingtabs_${i}" style="display: table-row;">
	      <td class="pad1"><input type="text" class="inwhite" id="hidepublishingtabs_name_${i}" name="hidepublishingtabs_name_${i}" value="${propertyset.hidepublishingtabs[key].name}" help="<@appID/>:permissionsets_name" /></td>
	      <td class="pad1" align="center"><@formcheckbox objid="hidepublishingtabs_protected_${i}" preselect=propertyset.hidepublishingtabs[key].protected?string helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hidepublishingtabs_inherit_${i}" preselect=propertyset.hidepublishingtabs[key].inherit?string helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="hidepublishingtabs_value_${i}" preselect=propertyset.hidepublishingtabs[key].value?string itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="hidepublishingtabsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('hidepublishingtabs', ${i});">X</span></td>
	    </tr>
	    <#assign i = i + 1 />
	  </#list>  
	  
	  <#list i..10 as j>
	    <tr id="hidepublishingtabs_${j}" style="display: <#if j==i>table-row<#else>none</#if>;">
          <td class="pad1"><input type="text" class="inwhite" id="hidepublishingtabs_name_${j}" name="hidepublishingtabs_name_${j}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hidepublishingtabs_protected_${j}" preselect="hidepublishingtabs_protected_${i}"?eval helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="hidepublishingtabs_inherit_${j}" helpid="hidepublishingtabs_format" /></td>
          <td class="pad1"><@formgfxselect objid="hidepublishingtabs_value_${j}" itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="hidepublishingtabsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('hidepublishingtabs', ${j});">X</span></td>
        </tr>
	  </#list>  
	  
	  <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="hidepublishingtabsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('hidepublishingtabs');">+</span></td>
	  </tr>
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  <tr>
	    <td class="sectionheader" colspan="5">Custom Metadata Fields</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
	  <#assign i = 1 />
	  <#list propertyset.custommetadatafields?keys as key>
	    <tr id="custommetadatafields_${i}" style="display: table-row;">
	      <td class="pad1"><input type="text" class="inwhite" id="custommetadatafields_name_${i}" name="custommetadatafields_name_${i}" value="${propertyset.custommetadatafields[key].name}" help="<@appID/>:permissionsets_name" /></td>
	      <td class="pad1" align="center"><@formcheckbox objid="custommetadatafields_protected_${i}" preselect=propertyset.custommetadatafields[key].protected?string helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="custommetadatafields_inherit_${i}" preselect=propertyset.custommetadatafields[key].inherit?string helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="custommetadatafields_value_${i}" preselect=propertyset.custommetadatafields[key].value?string itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="custommetadatafieldsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('custommetadatafields', ${i});">X</span></td>
	    </tr>
	    <#assign i = i + 1 />
	  </#list>  
	  
	  <#list i..10 as j>
	    <tr id="general_${j}" style="display: <#if j==i>table-row<#else>none</#if>;">
          <td class="pad1"><input type="text" class="inwhite" id="custommetadatafields_name_${j}" name="custommetadatafields_name_${j}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="custommetadatafields_protected_${j}" preselect="custommetadatafields_protected_${i}"?eval helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="custommetadatafields_inherit_${j}" helpid="custommetadatafields_format" /></td>
          <td class="pad1"><@formgfxselect objid="custommetadatafields_value_${j}" itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="custommetadatafieldsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('custommetadatafields', ${j});">X</span></td>
        </tr>
	  </#list>
	  
      <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="custommetadatafieldsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('custommetadatafields');">+</span></td>
	  </tr>
	  
	  <tr>
	    <td class="sectionheader" colspan="5">Publishing Sets</td>
	  </tr>
	  <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	  
	  <tr>
          <td class="pad1" style="font-weight: bold;">Name</td>
          <td class="pad1" style="font-weight: bold;" align="center">Protected</td>
          <td class="pad1" style="font-weight: bold;" align="center">Inherit</td>
          <td class="pad1" style="font-weight: bold;">Value</td>
      </tr>
	  
      <#assign i = 1 />
	  <#list propertyset.publishingsets?keys as key>
	    <tr id="publishingsets_${i}" style="display: table-row;">
	      <td class="pad1"><input type="text" class="inwhite" id="publishingsets_name_${i}" name="publishingsets_name_${i}" value="${propertyset.publishingsets[key].name}" help="<@appID/>:permissionsets_name" /></td>
	      <td class="pad1" align="center"><@formcheckbox objid="publishingsets_protected_${i}" preselect=propertyset.publishingsets[key].protected?string helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="publishingsets_inherit_${i}" preselect=propertyset.publishingsets[key].inherit?string helpid="renderer_format" /></td>
          <td class="pad1"><@formgfxselect objid="publishingsets_value_${i}" preselect=propertyset.publishingsets[key].value?string itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="publishingsetsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('publishingsets', ${i});">X</span></td>
	    </tr>
	    <#assign i = i + 1 />
	  </#list>  
	  
	  <#list i..10 as j>
	    <tr id="general_${j}" style="display: <#if j==i>table-row<#else>none</#if>;">
          <td class="pad1"><input type="text" class="inwhite" id="publishingsets_name_${j}" name="publishingsets_name_${j}" help="<@appID/>:permissionsets_name" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="publishingsets_protected_${j}" preselect="publishingsets_protected_${i}"?eval helpid="renderer_format" /></td>
          <td class="pad1" align="center"><@formcheckbox objid="publishingsets_inherit_${j}" helpid="publishingsets_format" /></td>
          <td class="pad1"><@formgfxselect objid="publishingsets_value_${j}" itemlist=valueList helpid="renderer_format" /></td>
          <td class="pad1"><span class="btnwhite" id="publishingsetsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="clearRow('publishingsets', ${j});">X</span></td>
        </tr>
	  </#list>

      <tr>
        <td class="pad1" colspan="5" align="right"><span class="btnwhite" id="publishingsetsplusbutton" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="addRow('publishingsets');">+</span></td>
	  </tr>
	  
	  <tr>
        <td class="pad1" style="padding-top: 20px;" colspan="5" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listpropertysets" />
          <@formsubmit value="Save" helpid="permissionsets_save" />	
        </td>
      </tr>
      
      </table>
    </form>
    
  <#elseif show_confirmation?? >
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
	    <td class="sectionheader">Property set saved</td>
	  </tr>
	  <tr><td><hr size="1" class="hr1"/></td></tr>
	  <tr>
	   <td class="pad1">
    	Please wait while the property sets are re-read for the changes to take effect.
       </td>
      </tr>
    </table>
    <#assign timeout="5" />
    <#assign postprogresslocation="action=listpropertysets">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">