/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 3.0.0
 */
;function MetaDataFieldNames(interfaceControl){var ic=interfaceControl;var strCustomFieldNamesCurrent="";var custom_fieldnames={};var oComparative={"file.size":1,"file.width":1,"file.height":1,"file.lastmodified":1,"iptc.release_date":1,"iptc.date_created":1};var oSpecialSearch={"file.status'ok'":"file.status:1","file.status'broken'":"file.status:3","file.status'importing'":"file.status:2","file.type'directory'":"file.type:directory","file.type'file'":"file.type:file"};var search_globals={Name:"filename",Suffix:"filename",Path:"file.path",FullPath:"file.fullpath",Size:"filesize","Last Modified":"lmdate",Width:"dimwidth",Height:"dimheight","Status 'ok'":"filebroken","Status 'broken'":"filebroken","Status 'importing'":"fileimporting",status:"status","type 'directory'":"file.type:directory","type 'file'":"file.type:file"};var fieldTypes={"FSI Extra":"textarea","FSI Search Data":"textarea",Keywords:"textarea",Caption:"textarea","User comments":"textarea"};var iptc_fieldnames={"By-line Title":"TAG_BY_LINE_TITLE","By-line":"TAG_BY_LINE",Caption:"TAG_CAPTION",Category:"TAG_CATEGORY",City:"TAG_CITY","Copyright Notice":"TAG_COPYRIGHT_NOTICE","Country Code":"TAG_COUNTRY_CODE","Country/Primary Location":"TAG_COUNTRY_OR_PRIMARY_LOCATION",Credit:"TAG_CREDIT","Date Created":"TAG_DATE_CREATED","Directory Version":"TAG_RECORD_VERSION","FSI Encoding":"TAG_FSI_ENCODING","FSI Extra":"TAG_FSI_XMLDATA","FSI SceneSets":"TAG_FSI_SCENESETS","FSI Search Data":"TAG_FSI_SEARCHDATA","FSI Tiles X":"TAG_FSI_TILESX","FSI Tiles Y":"TAG_FSI_TILESY",Headline:"TAG_HEADLINE",Keywords:"TAG_KEYWORDS","Object Name":"TAG_OBJECT_NAME","Original Transmission Reference":"TAG_ORIGINAL_TRANSMISSION_REFERENCE","Originating Program":"TAG_ORIGINATING_PROGRAM","Province/State":"TAG_PROVINCE_OR_STATE","Release Date":"TAG_RELEASE_DATE","Release Time":"TAG_RELEASE_TIME",Source:"TAG_SOURCE","Special Instructions":"TAG_SPECIAL_INSTRUCTIONS","Supplemental Category(s)":"TAG_SUPPLEMENTAL_CATEGORIES","Time Created":"TAG_TIME_CREATED",Urgency:"TAG_URGENCY",Writer:"TAG_WRITER"};var exif_fieldnames={Aperture:"ApertureValue","Bits per Sample":"BitsPerSample",Brightness:"BrightnessValue","CFA pattern":"CFAPattern","Color components":"ComponentsConfiguration","Color space information":"ColorSpace","Compressed Bits per Pixel":"CompressedBitsPerPixel",Compression:"Compression",Contrast:"Contrast","Copyright holder":"Copyright","Custom image processing":"CustomRendered","Date and time of digital data generation":"DateTimeDigitized","Date and time of original data generation":"DateTimeOriginal","Device setting description":"DeviceSettingDescription","Digital zoom ratio":"DigitalZoomRatio","Exif IFD Pointer":"ExifIDFPointer","Exif Image Height":"ExifImageHeight","Exif Image Width":"ExifImageWidth","Exif version":"ExifVersion","Exposure bias":"ExposureBiasValue","Exposure index":"ExposureIndex","Exposure mode":"ExposureMode","Exposure program":"ExposureProgram","Exposure time":"ExposureTime","F number":"FNumber","File change date and time":"DateTime","File source":"FileSource","Flash energy":"FlashEnergy",Flash:"Flash","Flashpix Version":"FlashpixVersion","Focal length in 35 mm film":"FocalLengthIn35mmFilm","Focal length in mm":"FocalLength","Gain control":"GainControl","GPS Altitude Reference":"GPSAltitudeRef","GPS Altitude":"GPSAltitude","GPS Date Stamp":"GPSDateStamp","GPS Differential":"GPSDifferential","GPS Dilution of Precision":"GPSDOP","GPS Image Direction Reference":"GPSImgDirectionRef","GPS Image Direction":"GPSImgDirection","GPS Latitude Reference":"GPSLatitudeRef","GPS Latitude":"GPSLatitude","GPS Longitude Reference":"GPSLongitudeRef","GPS Longitude":"GPSLongitude","GPS Map Datum":"GPSMapDatum","GPS Measure Mode":"GPSMeasureMode","GPS Satellites":"GPSSatellites","GPS Speed Reference":"GPSSpeedRef","GPS Speed":"GPSSpeed","GPS Status":"GPSStatus","GPS Time Stamp":"GPSTimeStamp","GPS Track Reference":"GPSTrackRef","GPS Track":"GPSTrack","GPSInfo IFD Pointer":"GPSInfoIDFPointer","Image Height":"ImageHeight","Image title":"ImageDescription","Image Width":"ImageWidth","Interop IFD Pointer":"InteropIDFPointer","Interoperability Index":"InteroperabilityIndex","Interoperability Version":"InteroperabilityVersion","ISO speed rating":"ISOSpeedRatings","Light source":"LightSource","Manufacturer notes":"MakerNote","Manufacturer of image input equipment":"Make","MarkerNote IFD Pointer":"MarkerNoteIDFPointer","Maximum lens aperture":"MaxApertureValue","Metering mode":"MeteringMode","Model of image input equipment":"Model","Optoelectric conversion factor":"OECF","Person who created the image":"Artist","Photometric Interpretation":"PhotometricInterpretation","Pixels (height) per focal unit":"FocalPlaneYResolution","Pixels (width) per focal unit":"FocalPlaneXResolution","Planar Configuration":"PlanarConfiguration","Primary Chromaticities":"PrimaryChromaticities",PrintIM:"PrintIM","Processing Software":"ProcessingSoftware","Rating Percent":"RatingPercent",Rating:"Rating","Reference Black White":"ReferenceBlackWhite","Related Image File Format":"RelatedImageFileFormat","Related Image Length":"RelatedImageLength","Related Image Width":"RelatedImageWidth","Related Sound File":"RelatedSoundFile","Resolution Unit":"ResolutionUnit","Samples per Pixel":"SamplesPerPixel",Saturation:"Saturation","Scene capture type":"SceneCaptureType","Scene type":"SceneType","Sensing method":"SensingMethod",Sharpness:"Sharpness","Shutter speed":"ShutterSpeedValue","Software used":"Software","Spatial frequency response":"SpatialFrequencyResponse","Spectral sensitivity":"SpectralSensitivity","Sub Sec Time Digitized":"SubSecTimeDigitized","Sub Sec Time Original":"SubSecTimeOriginal","Sub Sec Time":"SubSecTime","Subject distance range":"SubjectDistanceRange","Subject distance":"SubjectDistance","Subject location":"SubjectLocation","The orientation of the image":"Orientation","Unique image ID":"ImageUniqueID","Unit for focal plane resolution":"FocalPlaneResolutionUnit","User comments":"UserComment","White balance":"WhiteBalance","White Point":"WhitePoint","X Resolution":"XResolution","Y Cb Cr Coefficients":"YCbCrCoefficients","Y Cb Cr Positioning":"YCbCrPositioning","Y Resolution":"YResolution"};var init=function(){};var updateCustomMetaDataFields=this.updateCustomMetaDataFields=function(oConnectorInfo){if(!oConnectorInfo){oConnectorInfo=ic.getCurrentConnectorInfo()}var fields;var str="";if(oConnectorInfo&&oConnectorInfo.properties&&oConnectorInfo.properties.customMetadataFields&&typeof(oConnectorInfo.properties.customMetadataFields.join)=="function"){fields=oConnectorInfo.properties.customMetadataFields;str=fields.join("|")}if(str!=strCustomFieldNamesCurrent){strCustomFieldNamesCurrent=str;custom_fieldnames={};for(var i=0;i<fields.length;i++){custom_fieldnames[fields[i]]=fields[i]}}};this.getIPTC=function(){return iptc_fieldnames};this.getEXIF=function(){return exif_fieldnames};this.getCustom=function(){return custom_fieldnames};this.getIPTC_Options=function(oMetaData){var fields=iptc_fieldnames;var iptcExist=oMetaData.iptc;if(iptcExist==undefined){iptcExist={}}var ret="";for(var o in iptc){if(iptcExist[o]==undefined){ret+='<option value="'+fields[o]+'">'+o+"</option>\n"}}return ret};this.getEXIF_Options=function(oMetaData){var fields=exif_fieldnames;var exifExist=oMetaData.exif;if(exifExist==undefined){exifExist={}}var ret="";for(var o in exif){if(exifExist[o]==undefined){ret+='<option value="'+fields[o]+'">'+o+"</option>\n"}}return ret};this.getCustom_Options=function(oMetaData){var fields=custom_fieldnames;var customExist=oMetaData.fsi;if(customExist==undefined){customExist={}}var ret="";for(var o in exif){if(customExist[o]==undefined){ret+='<option value="'+fields[o]+'">'+o+"</option>\n"}}return ret};var getHeadRow=function(title,bForSearching){if(bForSearching){return""}return'<tr><td colspan="2" class="metaFieldHead">'+title+"</td></tr>"};var getFieldRow=function(group,value,bForSearching){var ret;var str;var label;if(group.length>0){str=group+"."+value}else{str=value}if(bForSearching){if(group=="file"||group==""){var t=value.toLowerCase();t=t.replace(/\s/g,"");label=str;ret='<option value="'+str+'">'+label+"</option>"}else{ret='<option value="'+str+'">'+str+"</option>"}}else{ret='<tr FSIFieldName="'+str+'"><td class="metaDataFieldCheck"><input type="checkbox"/></td><td class="metaDataFieldValue">'+value+"</td></tr>"}return ret};this.getSearchInfo=function(strName){var ret={};if(!strName){return ret}var name=strName.toLowerCase();if(name.indexOf(" ")!=-1){if(name.indexOf("iptc")==0){name=name.split(" ").join("_");name=name.split("-").join("_")}else{name=name.split(" ").join("")}}ret.name=name;if(oSpecialSearch[name]!=undefined){ret.bSpecial=true;ret.query=oSpecialSearch[name]}else{ret.bSpecial=false}ret.bComparative=!ret.bSpecial;ret.fnValueProcessor=searchValueProcessors[name];return ret};this.getFieldRows=function(oMetaData,bForSearching){var iptc=iptc_fieldnames;var exif=exif_fieldnames;var custom=custom_fieldnames;var iptcExist=oMetaData.iptc;if(iptcExist==undefined){iptcExist={}}var exifExist=oMetaData.exif;if(exifExist==undefined){exifExist={}}var customExist=oMetaData.fsi;if(customExist==undefined){customExist={}}var htmlBlocks=[];var html;var o;if(bForSearching){html="";html+=getFieldRow("","All Fields",bForSearching);for(o in search_globals){html+=getFieldRow("file",o,bForSearching)}if(html.length>0){html=getHeadRow("File",bForSearching)+html}htmlBlocks.push(html)}html="";for(o in custom){if(customExist[o]==undefined){html+=getFieldRow("fsi",o,bForSearching)}}if(html.length>0){html=getHeadRow("Custom",bForSearching)+html}htmlBlocks.push(html);html="";for(o in iptc){if(iptcExist[o]==undefined){html+=getFieldRow("iptc",o,bForSearching)}}if(html.length>0){html=getHeadRow("IPTC",bForSearching)+html}htmlBlocks.push(html);html="";for(o in exif){if(exifExist[o]==undefined){html+=getFieldRow("exif",o,bForSearching)}}if(html.length>0){html=getHeadRow("EXIF",bForSearching)+html}htmlBlocks.push(html);return htmlBlocks.join("")};this.getType=function(itm){return fieldTypes[itm]};var fsUnitMultipliers={kb:1024,mb:1048576,gb:1073741824,tb:1099511627776,pb:1125899906842624};var getInt=function(str){var t=parseInt(str);if(isNaN(t)){return""}return""+t};var parseSize=function(str){if(str==undefined){return""}str=str.replace(/,/g,".");var num=parseFloat(str);if(isNaN(num)){return str}str=str.toLowerCase();var unit=str.match(/[a-z]{2}/i);var t=fsUnitMultipliers[unit];if(t!=undefined&&!isNaN(t)){num*=t}return""+Math.round(num)};var searchValueProcessors={"file.size":parseSize,"file.height":getInt,"file.width":getInt};init()};