/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import java.io.IOException;
import javax.imageio.IIOException;

public class TIFFLZWDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    private static final int[] andTable = new int[]{511, 1023, 2047, 4095};
    int predictor;
    byte[] srcData;
    byte[] dstData;
    int srcIndex;
    int dstIndex;
    byte[][] stringTable;
    int tableIndex;
    int bitsToGet = 9;
    int nextData = 0;
    int nextBits = 0;

    public TIFFLZWDecompressor(int n) throws IIOException {
        if (n != 1 && n != 2 && n != 3) {
            throw new IIOException("Illegal value (" + n + ") for Predictor in TIFF file");
        }
        this.predictor = n;
    }

    @Override
    public void decodeRaw(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray2;
        int n5;
        if (this.predictor == 2) {
            int n6 = this.bitsPerSample.length;
            for (n5 = 0; n5 < n6; ++n5) {
                if (this.bitsPerSample[n5] == 8 || this.bitsPerSample[n5] == 16 || this.bitsPerSample[n5] == 24 || this.bitsPerSample[n5] == 32) continue;
                throw new IIOException(this.bitsPerSample[n5] + "-bit samples are not supported for Horizontal differencing Predictor (LZW)");
            }
        }
        this.stream.seek(this.offset);
        byte[] byArray3 = new byte[this.byteCount];
        this.stream.readFully(byArray3);
        n5 = (this.srcWidth * n2 + 7) / 8;
        if (n5 == n3) {
            byArray2 = byArray;
            n4 = n;
        } else {
            byArray2 = new byte[n5 * this.srcHeight];
            n4 = 0;
        }
        this.decode(byArray3, 0, byArray2, n4, this.bitsPerSample[0]);
        if (n5 != n3) {
            int n7 = 0;
            for (int i = 0; i < this.srcHeight; ++i) {
                System.arraycopy(byArray2, n7, byArray, n, n5);
                n7 += n5;
                n += n3;
            }
        }
    }

    public int decode(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws IOException {
        int n4;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new IIOException("TIFF 5.0-style LZW compression is not supported!");
        }
        this.srcData = byArray;
        this.dstData = byArray2;
        this.srcIndex = n;
        this.dstIndex = n2;
        this.nextData = 0;
        this.nextBits = 0;
        this.initializeStringTable();
        int n5 = 0;
        while ((n4 = this.getNextCode()) != 257) {
            byte[] byArray3;
            if (n4 == 256) {
                this.initializeStringTable();
                n4 = this.getNextCode();
                if (n4 == 257) break;
                this.writeString(this.stringTable[n4]);
                n5 = n4;
                continue;
            }
            if (n4 < this.tableIndex) {
                byArray3 = this.stringTable[n4];
                this.writeString(byArray3);
                this.addStringToTable(this.stringTable[n5], byArray3[0]);
                n5 = n4;
                continue;
            }
            byArray3 = this.stringTable[n5];
            byArray3 = this.composeString(byArray3, byArray3[0]);
            this.writeString(byArray3);
            this.addStringToTable(byArray3);
            n5 = n4;
        }
        this.decodeSpecial(this.dstData, n2, n3, this.predictor);
        return this.dstIndex - n2;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] byArray) {
        if (this.dstIndex < this.dstData.length) {
            int n = Math.min(byArray.length, this.dstData.length - this.dstIndex);
            for (int i = 0; i < n; ++i) {
                this.dstData[this.dstIndex++] = byArray[i];
            }
        }
    }

    public void addStringToTable(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
                this.nextBits += 8;
            }
            int n = this.nextData >> this.nextBits - this.bitsToGet & andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

