/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.ImageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageInfo {
    private final String formatDetails;
    private final int bitsPerPixel;
    private final List<String> comments;
    private final ImageFormat format;
    private final String formatName;
    private final int height;
    private final String mimeType;
    private final int numberOfImages;
    private final int physicalHeightDpi;
    private final float physicalHeightInch;
    private final int physicalWidthDpi;
    private final float physicalWidthInch;
    private final int width;
    private final boolean isProgressive;
    private final boolean isTransparent;
    private final boolean usesPalette;
    public static final int COLOR_TYPE_BW = 0;
    public static final int COLOR_TYPE_GRAYSCALE = 1;
    public static final int COLOR_TYPE_RGB = 2;
    public static final int COLOR_TYPE_CMYK = 3;
    public static final int COLOR_TYPE_YCbCr = 4;
    public static final int COLOR_TYPE_YCCK = 5;
    public static final int COLOR_TYPE_YCC = 6;
    public static final int COLOR_TYPE_OTHER = -1;
    public static final int COLOR_TYPE_UNKNOWN = -2;
    private final int colorType;
    public static final String COMPRESSION_ALGORITHM_UNKNOWN = "Unknown";
    public static final String COMPRESSION_ALGORITHM_NONE = "None";
    public static final String COMPRESSION_ALGORITHM_LZW = "LZW";
    public static final String COMPRESSION_ALGORITHM_PACKBITS = "PackBits";
    public static final String COMPRESSION_ALGORITHM_JPEG = "JPEG";
    public static final String COMPRESSION_ALGORITHM_RLE = "RLE: Run-Length Encoding";
    public static final String COMPRESSION_ALGORITHM_PSD = "Photoshop";
    public static final String COMPRESSION_ALGORITHM_PNG_FILTER = "PNG Filter";
    public static final String COMPRESSION_ALGORITHM_CCITT_GROUP_3 = "CCITT Group 3 1-Dimensional Modified Huffman run-length encoding.";
    public static final String COMPRESSION_ALGORITHM_CCITT_GROUP_4 = "CCITT Group 4";
    public static final String COMPRESSION_ALGORITHM_CCITT_1D = "CCITT 1D";
    private final String compressionAlgorithm;

    public ImageInfo(String formatDetails, int bitsPerPixel, List<String> comments, ImageFormat format, String formatName, int height, String mimeType, int numberOfImages, int physicalHeightDpi, float physicalHeightInch, int physicalWidthDpi, float physicalWidthInch, int width, boolean isProgressive, boolean isTransparent, boolean usesPalette, int colorType, String compressionAlgorithm) {
        this.formatDetails = formatDetails;
        this.bitsPerPixel = bitsPerPixel;
        this.comments = comments;
        this.format = format;
        this.formatName = formatName;
        this.height = height;
        this.mimeType = mimeType;
        this.numberOfImages = numberOfImages;
        this.physicalHeightDpi = physicalHeightDpi;
        this.physicalHeightInch = physicalHeightInch;
        this.physicalWidthDpi = physicalWidthDpi;
        this.physicalWidthInch = physicalWidthInch;
        this.width = width;
        this.isProgressive = isProgressive;
        this.isTransparent = isTransparent;
        this.usesPalette = usesPalette;
        this.colorType = colorType;
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public List<String> getComments() {
        return new ArrayList<String>(this.comments);
    }

    public ImageFormat getFormat() {
        return this.format;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public int getHeight() {
        return this.height;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getNumberOfImages() {
        return this.numberOfImages;
    }

    public int getPhysicalHeightDpi() {
        return this.physicalHeightDpi;
    }

    public float getPhysicalHeightInch() {
        return this.physicalHeightInch;
    }

    public int getPhysicalWidthDpi() {
        return this.physicalWidthDpi;
    }

    public float getPhysicalWidthInch() {
        return this.physicalWidthInch;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isProgressive() {
        return this.isProgressive;
    }

    public int getColorType() {
        return this.colorType;
    }

    public String getColorTypeDescription() {
        switch (this.colorType) {
            case 0: {
                return "Black and White";
            }
            case 1: {
                return "Grayscale";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "CMYK";
            }
            case 4: {
                return "YCbCr";
            }
            case 5: {
                return "YCCK";
            }
            case 6: {
                return "YCC";
            }
            case -1: {
                return "Other";
            }
            case -2: {
                return COMPRESSION_ALGORITHM_UNKNOWN;
            }
        }
        return COMPRESSION_ALGORITHM_UNKNOWN;
    }

    public void dump() {
        System.out.print(this.toString());
    }

    public String toString() {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.toString(pw, "");
            pw.flush();
            return sw.toString();
        }
        catch (Exception e) {
            return "Image Data: Error";
        }
    }

    public void toString(PrintWriter pw, String prefix) {
        pw.println("Format Details: " + this.formatDetails);
        pw.println("Bits Per Pixel: " + this.bitsPerPixel);
        pw.println("Comments: " + this.comments.size());
        for (int i = 0; i < this.comments.size(); ++i) {
            String s = this.comments.get(i);
            pw.println("\t" + i + ": '" + s + "'");
        }
        pw.println("Format: " + this.format.getName());
        pw.println("Format Name: " + this.formatName);
        pw.println("Compression Algorithm: " + this.compressionAlgorithm);
        pw.println("Height: " + this.height);
        pw.println("MimeType: " + this.mimeType);
        pw.println("Number Of Images: " + this.numberOfImages);
        pw.println("Physical Height Dpi: " + this.physicalHeightDpi);
        pw.println("Physical Height Inch: " + this.physicalHeightInch);
        pw.println("Physical Width Dpi: " + this.physicalWidthDpi);
        pw.println("Physical Width Inch: " + this.physicalWidthInch);
        pw.println("Width: " + this.width);
        pw.println("Is Progressive: " + this.isProgressive);
        pw.println("Is Transparent: " + this.isTransparent);
        pw.println("Color Type: " + this.getColorTypeDescription());
        pw.println("Uses Palette: " + this.usesPalette);
        pw.flush();
    }

    public String getFormatDetails() {
        return this.formatDetails;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public boolean usesPalette() {
        return this.usesPalette;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }
}

