/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common.mylzw;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.mylzw.MyBitOutputStream;

public class MyLzwCompressor {
    private int codeSize;
    private final int initialCodeSize;
    private int codes = -1;
    private final ByteOrder byteOrder;
    private final boolean earlyLimit;
    private final int clearCode;
    private final int eoiCode;
    private final Listener listener;
    private final Map<ByteArray, Integer> map = new HashMap<ByteArray, Integer>();

    public MyLzwCompressor(int initialCodeSize, ByteOrder byteOrder, boolean earlyLimit) {
        this(initialCodeSize, byteOrder, earlyLimit, null);
    }

    public MyLzwCompressor(int initialCodeSize, ByteOrder byteOrder, boolean earlyLimit, Listener listener) {
        this.listener = listener;
        this.byteOrder = byteOrder;
        this.earlyLimit = earlyLimit;
        this.initialCodeSize = initialCodeSize;
        this.clearCode = 1 << initialCodeSize;
        this.eoiCode = this.clearCode + 1;
        if (null != listener) {
            listener.init(this.clearCode, this.eoiCode);
        }
        this.InitializeStringTable();
    }

    private final void InitializeStringTable() {
        this.codeSize = this.initialCodeSize;
        int intial_entries_count = (1 << this.codeSize) + 2;
        this.map.clear();
        this.codes = 0;
        while (this.codes < intial_entries_count) {
            if (this.codes != this.clearCode && this.codes != this.eoiCode) {
                ByteArray key = this.arrayToKey((byte)this.codes);
                this.map.put(key, this.codes);
            }
            ++this.codes;
        }
    }

    private final void clearTable() {
        this.InitializeStringTable();
        this.incrementCodeSize();
    }

    private final void incrementCodeSize() {
        if (this.codeSize != 12) {
            ++this.codeSize;
        }
    }

    private final ByteArray arrayToKey(byte b) {
        return this.arrayToKey(new byte[]{b}, 0, 1);
    }

    private final ByteArray arrayToKey(byte[] bytes, int start, int length) {
        return new ByteArray(bytes, start, length);
    }

    private final void writeDataCode(MyBitOutputStream bos, int code) throws IOException {
        if (null != this.listener) {
            this.listener.dataCode(code);
        }
        this.writeCode(bos, code);
    }

    private final void writeClearCode(MyBitOutputStream bos) throws IOException {
        if (null != this.listener) {
            this.listener.dataCode(this.clearCode);
        }
        this.writeCode(bos, this.clearCode);
    }

    private final void writeEoiCode(MyBitOutputStream bos) throws IOException {
        if (null != this.listener) {
            this.listener.eoiCode(this.eoiCode);
        }
        this.writeCode(bos, this.eoiCode);
    }

    private final void writeCode(MyBitOutputStream bos, int code) throws IOException {
        bos.writeBits(code, this.codeSize);
    }

    private final boolean isInTable(byte[] bytes, int start, int length) {
        ByteArray key = this.arrayToKey(bytes, start, length);
        return this.map.containsKey(key);
    }

    private final int codeFromString(byte[] bytes, int start, int length) throws IOException {
        ByteArray key = this.arrayToKey(bytes, start, length);
        Integer code = this.map.get(key);
        if (code == null) {
            throw new IOException("CodeFromString");
        }
        return code;
    }

    private final boolean addTableEntry(MyBitOutputStream bos, byte[] bytes, int start, int length) throws IOException {
        ByteArray key = this.arrayToKey(bytes, start, length);
        return this.addTableEntry(bos, key);
    }

    private final boolean addTableEntry(MyBitOutputStream bos, ByteArray key) throws IOException {
        boolean cleared = false;
        int limit = 1 << this.codeSize;
        if (this.earlyLimit) {
            --limit;
        }
        if (this.codes == limit) {
            if (this.codeSize < 12) {
                this.incrementCodeSize();
            } else {
                this.writeClearCode(bos);
                this.clearTable();
                cleared = true;
            }
        }
        if (!cleared) {
            this.map.put(key, this.codes);
            ++this.codes;
        }
        return cleared;
    }

    public byte[] compress(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        MyBitOutputStream bos = new MyBitOutputStream(baos, this.byteOrder);
        this.InitializeStringTable();
        this.clearTable();
        this.writeClearCode(bos);
        int w_start = 0;
        int w_length = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (this.isInTable(bytes, w_start, w_length + 1)) {
                ++w_length;
                continue;
            }
            int code = this.codeFromString(bytes, w_start, w_length);
            this.writeDataCode(bos, code);
            this.addTableEntry(bos, bytes, w_start, w_length + 1);
            w_start = i;
            w_length = 1;
        }
        int code = this.codeFromString(bytes, w_start, w_length);
        this.writeDataCode(bos, code);
        this.writeEoiCode(bos);
        bos.flushCache();
        return baos.toByteArray();
    }

    public static interface Listener {
        public void dataCode(int var1);

        public void eoiCode(int var1);

        public void clearCode(int var1);

        public void init(int var1, int var2);
    }

    private static final class ByteArray {
        private final byte[] bytes;
        private final int start;
        private final int length;
        private final int hash;

        public ByteArray(byte[] bytes, int start, int length) {
            this.bytes = bytes;
            this.start = start;
            this.length = length;
            int tempHash = length;
            for (int i = 0; i < length; ++i) {
                int b = 0xFF & bytes[i + start];
                tempHash = tempHash + (tempHash << 8) ^ b ^ i;
            }
            this.hash = tempHash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o instanceof ByteArray) {
                ByteArray other = (ByteArray)o;
                if (other.hash != this.hash) {
                    return false;
                }
                if (other.length != this.length) {
                    return false;
                }
                for (int i = 0; i < this.length; ++i) {
                    if (other.bytes[i + other.start] == this.bytes[i + this.start]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

