/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryInputStream;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcBlock;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcConstants;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcType;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypeLookup;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypes;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.util.Debug;
import org.apache.commons.imaging.util.ParamMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IptcParser
extends BinaryFileParser
implements IptcConstants {
    private static final ByteOrder APP13_BYTE_ORDER = ByteOrder.NETWORK;

    public IptcParser() {
        this.setByteOrder(ByteOrder.NETWORK);
    }

    public boolean isPhotoshopJpegSegment(byte[] segmentData) {
        if (!BinaryFileParser.startsWith(segmentData, PHOTOSHOP_IDENTIFICATION_STRING)) {
            return false;
        }
        int index = PHOTOSHOP_IDENTIFICATION_STRING.size();
        return index + 4 <= segmentData.length && ByteConversions.toInt(segmentData, index, APP13_BYTE_ORDER) == CONST_8BIM;
    }

    public PhotoshopApp13Data parsePhotoshopSegment(byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        boolean strict = ParamMap.getParamBoolean(params, "STRICT", false);
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        return this.parsePhotoshopSegment(bytes, verbose, strict);
    }

    public PhotoshopApp13Data parsePhotoshopSegment(byte[] bytes, boolean verbose, boolean strict) throws ImageReadException, IOException {
        ArrayList<IptcRecord> records = new ArrayList<IptcRecord>();
        List<IptcBlock> allBlocks = this.parseAllBlocks(bytes, verbose, strict);
        for (int i = 0; i < allBlocks.size(); ++i) {
            IptcBlock block = allBlocks.get(i);
            if (!block.isIPTCBlock()) continue;
            records.addAll(this.parseIPTCBlock(block.blockData, verbose));
        }
        return new PhotoshopApp13Data(records, allBlocks);
    }

    protected List<IptcRecord> parseIPTCBlock(byte[] bytes, boolean verbose) throws ImageReadException, IOException {
        ArrayList<IptcRecord> elements = new ArrayList<IptcRecord>();
        int index = 0;
        while (index + 1 < bytes.length) {
            int tagMarker = 0xFF & bytes[index++];
            if (verbose) {
                Debug.debug("tagMarker", tagMarker + " (0x" + Integer.toHexString(tagMarker) + ")");
            }
            if (tagMarker != 28) {
                if (verbose) {
                    System.out.println("Unexpected record tag marker in IPTC data.");
                }
                return elements;
            }
            int recordNumber = 0xFF & bytes[index++];
            if (verbose) {
                Debug.debug("recordNumber", recordNumber + " (0x" + Integer.toHexString(recordNumber) + ")");
            }
            int recordType = 0xFF & bytes[index];
            if (verbose) {
                Debug.debug("recordType", recordType + " (0x" + Integer.toHexString(recordType) + ")");
            }
            int recordSize = this.toUInt16(bytes, ++index);
            index += 2;
            boolean extendedDataset = recordSize > Short.MAX_VALUE;
            int dataFieldCountLength = recordSize & Short.MAX_VALUE;
            if (extendedDataset && verbose) {
                Debug.debug("extendedDataset. dataFieldCountLength: " + dataFieldCountLength);
            }
            if (extendedDataset) {
                return elements;
            }
            byte[] recordData = this.slice(bytes, index, recordSize);
            index += recordSize;
            if (recordNumber != 2) continue;
            if (recordType == 0) {
                if (!verbose) continue;
                System.out.println("ignore record version record! " + elements.size());
                continue;
            }
            String value = new String(recordData, "ISO-8859-1");
            IptcType iptcType = IptcTypeLookup.getIptcType(recordType);
            IptcRecord element = new IptcRecord(iptcType, recordData, value);
            elements.add(element);
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IptcBlock> parseAllBlocks(byte[] bytes, boolean verbose, boolean strict) throws ImageReadException, IOException {
        ArrayList<IptcBlock> blocks = new ArrayList<IptcBlock>();
        BinaryInputStream bis = null;
        try {
            bis = new BinaryInputStream(bytes, APP13_BYTE_ORDER);
            byte[] idString = bis.readBytes(PHOTOSHOP_IDENTIFICATION_STRING.size(), "App13 Segment missing identification string");
            if (!PHOTOSHOP_IDENTIFICATION_STRING.equals(idString)) {
                throw new ImageReadException("Not a Photoshop App13 Segment");
            }
            while (true) {
                byte[] blockData;
                byte[] blockNameBytes;
                int imageResourceBlockSignature;
                try {
                    imageResourceBlockSignature = bis.read4Bytes("Image Resource Block missing identification string");
                }
                catch (IOException ioEx) {
                    break;
                }
                if (imageResourceBlockSignature != CONST_8BIM) {
                    throw new ImageReadException("Invalid Image Resource Block Signature");
                }
                int blockType = bis.read2Bytes("Image Resource Block missing type");
                if (verbose) {
                    Debug.debug("blockType", blockType + " (0x" + Integer.toHexString(blockType) + ")");
                }
                byte blockNameLength = bis.readByte("Name length", "Image Resource Block missing name length");
                if (verbose && blockNameLength > 0) {
                    Debug.debug("blockNameLength", blockNameLength + " (0x" + Integer.toHexString(blockNameLength) + ")");
                }
                if (blockNameLength == 0) {
                    bis.readByte("Block name bytes", "Image Resource Block has invalid name");
                    blockNameBytes = new byte[]{};
                } else {
                    try {
                        blockNameBytes = bis.readBytes(blockNameLength, "Invalid Image Resource Block name");
                    }
                    catch (IOException ioEx) {
                        if (!strict) break;
                        throw ioEx;
                    }
                    if (blockNameLength % 2 == 0) {
                        bis.readByte("Padding byte", "Image Resource Block missing padding byte");
                    }
                }
                int blockSize = bis.read4Bytes("Image Resource Block missing size");
                if (verbose) {
                    Debug.debug("blockSize", blockSize + " (0x" + Integer.toHexString(blockSize) + ")");
                }
                if (blockSize > bytes.length) {
                    throw new ImageReadException("Invalid Block Size : " + blockSize + " > " + bytes.length);
                }
                try {
                    blockData = bis.readBytes(blockSize, "Invalid Image Resource Block data");
                }
                catch (IOException ioEx) {
                    if (!strict) break;
                    throw ioEx;
                }
                blocks.add(new IptcBlock(blockType, blockNameBytes, blockData));
                if (blockSize % 2 == 0) continue;
                bis.readByte("Padding byte", "Image Resource Block missing padding byte");
            }
            ArrayList<IptcBlock> arrayList = blocks;
            return arrayList;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public byte[] writePhotoshopApp13Segment(PhotoshopApp13Data data) throws IOException, ImageWriteException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream(os);
        PHOTOSHOP_IDENTIFICATION_STRING.writeTo(bos);
        List<IptcBlock> blocks = data.getRawBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            IptcBlock block = blocks.get(i);
            bos.write4Bytes(CONST_8BIM);
            if (block.blockType < 0 || block.blockType > 65535) {
                throw new ImageWriteException("Invalid IPTC block type.");
            }
            bos.write2Bytes(block.blockType);
            if (block.blockNameBytes.length > 255) {
                throw new ImageWriteException("IPTC block name is too long: " + block.blockNameBytes.length);
            }
            bos.write(block.blockNameBytes.length);
            bos.write(block.blockNameBytes);
            if (block.blockNameBytes.length % 2 == 0) {
                bos.write(0);
            }
            if (block.blockData.length > Short.MAX_VALUE) {
                throw new ImageWriteException("IPTC block data is too long: " + block.blockData.length);
            }
            bos.write4Bytes(block.blockData.length);
            bos.write(block.blockData);
            if (block.blockData.length % 2 != 1) continue;
            bos.write(0);
        }
        bos.flush();
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeIPTCBlock(List<IptcRecord> elements) throws ImageWriteException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputStream bos = null;
        try {
            bos = new BinaryOutputStream(baos, this.getByteOrder());
            bos.write(28);
            bos.write(2);
            bos.write(IptcTypes.RECORD_VERSION.type);
            bos.write2Bytes(2);
            bos.write2Bytes(2);
            elements = new ArrayList<IptcRecord>(elements);
            Comparator<IptcRecord> comparator = new Comparator<IptcRecord>(){

                @Override
                public int compare(IptcRecord e1, IptcRecord e2) {
                    return e2.iptcType.getType() - e1.iptcType.getType();
                }
            };
            Collections.sort(elements, comparator);
            for (int i = 0; i < elements.size(); ++i) {
                IptcRecord element = elements.get(i);
                if (element.iptcType == IptcTypes.RECORD_VERSION) continue;
                bos.write(28);
                bos.write(2);
                if (element.iptcType.getType() < 0 || element.iptcType.getType() > 255) {
                    throw new ImageWriteException("Invalid record type: " + element.iptcType.getType());
                }
                bos.write(element.iptcType.getType());
                byte[] recordData = element.value.getBytes("ISO-8859-1");
                if (!new String(recordData, "ISO-8859-1").equals(element.value)) {
                    throw new ImageWriteException("Invalid record value, not ISO-8859-1");
                }
                bos.write2Bytes(recordData.length);
                bos.write(recordData);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
        byte[] blockData = baos.toByteArray();
        return blockData;
    }
}

