/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.ColorTools;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.PngConstants;
import org.apache.commons.imaging.formats.png.PngImageInfo;
import org.apache.commons.imaging.formats.png.PngText;
import org.apache.commons.imaging.formats.png.PngWriter;
import org.apache.commons.imaging.formats.png.ScanExpediter;
import org.apache.commons.imaging.formats.png.ScanExpediterInterlaced;
import org.apache.commons.imaging.formats.png.ScanExpediterSimple;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;
import org.apache.commons.imaging.formats.png.chunks.PngChunkGama;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIccp;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIdat;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIhdr;
import org.apache.commons.imaging.formats.png.chunks.PngChunkItxt;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPhys;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.chunks.PngChunkText;
import org.apache.commons.imaging.formats.png.chunks.PngChunkZtxt;
import org.apache.commons.imaging.formats.png.chunks.PngTextChunk;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilter;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilterGrayscale;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilterIndexedColor;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilterTrueColor;
import org.apache.commons.imaging.icc.IccProfileParser;
import org.apache.commons.imaging.util.Debug;
import org.apache.commons.imaging.util.ParamMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngImageParser
extends ImageParser
implements PngConstants {
    private static final String DEFAULT_EXTENSION = ".png";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".png"};

    @Override
    public String getName() {
        return "Png-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_PNG};
    }

    public static final String getChunkTypeName(int chunkType) {
        StringBuilder result = new StringBuilder();
        result.append((char)(0xFF & chunkType >> 24));
        result.append((char)(0xFF & chunkType >> 16));
        result.append((char)(0xFF & chunkType >> 8));
        result.append((char)(0xFF & chunkType >> 0));
        return result.toString();
    }

    public List<String> getChuckTypes(InputStream is) throws ImageReadException, IOException {
        List<PngChunk> chunks = this.readChunks(is, null, false);
        ArrayList<String> chunkTypes = new ArrayList<String>();
        for (int i = 0; i < chunks.size(); ++i) {
            PngChunk chunk = chunks.get(i);
            chunkTypes.add(PngImageParser.getChunkTypeName(chunk.chunkType));
        }
        return chunkTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChuckType(ByteSource byteSource, int chunkType) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            List<PngChunk> chunks = null;
            this.readSignature(is);
            chunks = this.readChunks(is, new int[]{chunkType}, true);
            boolean bl = chunks.size() > 0;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    private boolean keepChunk(int ChunkType, int[] chunkTypes) {
        if (chunkTypes == null) {
            return true;
        }
        for (int chunkType2 : chunkTypes) {
            if (chunkType2 != ChunkType) continue;
            return true;
        }
        return false;
    }

    private List<PngChunk> readChunks(InputStream is, int[] chunkTypes, boolean returnAfterFirst) throws ImageReadException, IOException {
        int chunkType;
        ArrayList<PngChunk> result = new ArrayList<PngChunk>();
        do {
            if (this.debug) {
                System.out.println("");
            }
            int length = this.read4Bytes("Length", is, "Not a Valid PNG File");
            chunkType = this.read4Bytes("ChunkType", is, "Not a Valid PNG File");
            if (this.debug) {
                this.printCharQuad("ChunkType", chunkType);
                this.debugNumber("Length", length, 4);
            }
            boolean keep = this.keepChunk(chunkType, chunkTypes);
            byte[] bytes = null;
            if (keep) {
                bytes = this.readBytes("Chunk Data", is, length, "Not a Valid PNG File: Couldn't read Chunk Data.");
            } else {
                this.skipBytes(is, length, "Not a Valid PNG File");
            }
            if (this.debug && bytes != null) {
                this.debugNumber("bytes", bytes.length, 4);
            }
            int CRC = this.read4Bytes("CRC", is, "Not a Valid PNG File");
            if (!keep) continue;
            if (chunkType == iCCP) {
                result.add(new PngChunkIccp(length, chunkType, CRC, bytes));
            } else if (chunkType == tEXt) {
                result.add(new PngChunkText(length, chunkType, CRC, bytes));
            } else if (chunkType == zTXt) {
                result.add(new PngChunkZtxt(length, chunkType, CRC, bytes));
            } else if (chunkType == IHDR) {
                result.add(new PngChunkIhdr(length, chunkType, CRC, bytes));
            } else if (chunkType == PLTE) {
                result.add(new PngChunkPlte(length, chunkType, CRC, bytes));
            } else if (chunkType == pHYs) {
                result.add(new PngChunkPhys(length, chunkType, CRC, bytes));
            } else if (chunkType == IDAT) {
                result.add(new PngChunkIdat(length, chunkType, CRC, bytes));
            } else if (chunkType == gAMA) {
                result.add(new PngChunkGama(length, chunkType, CRC, bytes));
            } else if (chunkType == iTXt) {
                result.add(new PngChunkItxt(length, chunkType, CRC, bytes));
            } else {
                result.add(new PngChunk(length, chunkType, CRC, bytes));
            }
            if (!returnAfterFirst) continue;
            return result;
        } while (chunkType != IEND);
        return result;
    }

    public void readSignature(InputStream is) throws ImageReadException, IOException {
        this.readAndVerifyBytes(is, PNG_Signature, "Not a Valid PNG Segment: Incorrect Signature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PngChunk> readChunks(ByteSource byteSource, int[] chunkTypes, boolean returnAfterFirst) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            this.readSignature(is);
            List<PngChunk> list = this.readChunks(is, chunkTypes, returnAfterFirst);
            return list;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<PngChunk> chunks = this.readChunks(byteSource, new int[]{iCCP}, true);
        if (chunks == null || chunks.size() < 1) {
            return null;
        }
        if (chunks.size() > 1) {
            throw new ImageReadException("PNG contains more than one ICC Profile ");
        }
        PngChunkIccp pngChunkiCCP = (PngChunkIccp)chunks.get(0);
        byte[] bytes = pngChunkiCCP.UncompressedProfile;
        return bytes;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<PngChunk> chunks = this.readChunks(byteSource, new int[]{IHDR}, true);
        if (chunks == null || chunks.size() < 1) {
            throw new ImageReadException("Png: No chunks");
        }
        if (chunks.size() > 1) {
            throw new ImageReadException("PNG contains more than one Header");
        }
        PngChunkIhdr pngChunkIHDR = (PngChunkIhdr)chunks.get(0);
        return new Dimension(pngChunkIHDR.width, pngChunkIHDR.height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<PngChunk> chunks = this.readChunks(byteSource, new int[]{tEXt, zTXt}, true);
        if (chunks == null || chunks.size() < 1) {
            return null;
        }
        ImageMetadata result = new ImageMetadata();
        for (int i = 0; i < chunks.size(); ++i) {
            PngTextChunk chunk = (PngTextChunk)chunks.get(i);
            result.add(chunk.getKeyword(), chunk.getText());
        }
        return result;
    }

    private boolean isGrayscale(int colorType) throws ImageReadException {
        switch (colorType) {
            case 0: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 6: {
                return false;
            }
        }
        throw new ImageReadException("PNG: unknown color type: " + colorType);
    }

    private int samplesPerPixel(int colorType) throws ImageReadException {
        switch (colorType) {
            case 0: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 6: {
                return 4;
            }
        }
        throw new ImageReadException("PNG: unknown color type: " + colorType);
    }

    private List<PngChunk> filterChunks(List<PngChunk> v, int type) {
        ArrayList<PngChunk> result = new ArrayList<PngChunk>();
        for (int i = 0; i < v.size(); ++i) {
            PngChunk chunk = v.get(i);
            if (chunk.chunkType != type) continue;
            result.add(chunk);
        }
        return result;
    }

    private boolean hasAlphaChannel(int ColorType) throws ImageReadException {
        switch (ColorType) {
            case 0: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: 
            case 6: {
                return true;
            }
        }
        throw new ImageReadException("PNG: unknown color type: " + ColorType);
    }

    private String getColorTypeDescription(int ColorType) {
        switch (ColorType) {
            case 0: {
                return "grayscale";
            }
            case 2: {
                return "rgb";
            }
            case 3: {
                return "indexed rgb";
            }
            case 4: {
                return "grayscale w/ alpha";
            }
            case 6: {
                return "RGB w/ alpha";
            }
        }
        return "Unknown Color Type";
    }

    private TransparencyFilter getTransparencyFilter(int ColorType, PngChunk pngChunktRNS) throws ImageReadException, IOException {
        switch (ColorType) {
            case 0: {
                return new TransparencyFilterGrayscale(pngChunktRNS.bytes);
            }
            case 2: {
                return new TransparencyFilterTrueColor(pngChunktRNS.bytes);
            }
            case 3: {
                return new TransparencyFilterIndexedColor(pngChunktRNS.bytes);
            }
        }
        throw new ImageReadException("Simple Transparency not compatible with ColorType: " + ColorType);
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        int ColorType;
        int i;
        List<PngChunk> chunks = this.readChunks(byteSource, new int[]{IHDR, pHYs, tEXt, zTXt, tRNS, PLTE, iTXt}, false);
        if (chunks == null || chunks.size() < 1) {
            throw new ImageReadException("PNG: no chunks");
        }
        List<PngChunk> IHDRs = this.filterChunks(chunks, IHDR);
        if (IHDRs.size() != 1) {
            throw new ImageReadException("PNG contains more than one Header");
        }
        PngChunkIhdr pngChunkIHDR = (PngChunkIhdr)IHDRs.get(0);
        boolean isTransparent = false;
        List<PngChunk> tRNSs = this.filterChunks(chunks, tRNS);
        isTransparent = tRNSs.size() > 0 ? true : this.hasAlphaChannel(pngChunkIHDR.colorType);
        PngChunkPhys pngChunkpHYs = null;
        List<PngChunk> pHYss = this.filterChunks(chunks, pHYs);
        if (pHYss.size() > 1) {
            throw new ImageReadException("PNG contains more than one pHYs: " + pHYss.size());
        }
        if (pHYss.size() == 1) {
            pngChunkpHYs = (PngChunkPhys)pHYss.get(0);
        }
        List<PngChunk> tEXts = this.filterChunks(chunks, tEXt);
        List<PngChunk> zTXts = this.filterChunks(chunks, zTXt);
        List<PngChunk> iTXts = this.filterChunks(chunks, iTXt);
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<PngText> textChunks = new ArrayList<PngText>();
        for (i = 0; i < tEXts.size(); ++i) {
            PngChunkText pngChunktEXt = (PngChunkText)tEXts.get(i);
            comments.add(pngChunktEXt.keyword + ": " + pngChunktEXt.text);
            textChunks.add(pngChunktEXt.getContents());
        }
        for (i = 0; i < zTXts.size(); ++i) {
            PngChunkZtxt pngChunkzTXt = (PngChunkZtxt)zTXts.get(i);
            comments.add(pngChunkzTXt.keyword + ": " + pngChunkzTXt.text);
            textChunks.add(pngChunkzTXt.getContents());
        }
        for (i = 0; i < iTXts.size(); ++i) {
            PngChunkItxt pngChunkiTXt = (PngChunkItxt)iTXts.get(i);
            comments.add(pngChunkiTXt.keyword + ": " + pngChunkiTXt.text);
            textChunks.add(pngChunkiTXt.getContents());
        }
        int BitsPerPixel = pngChunkIHDR.bitDepth * this.samplesPerPixel(pngChunkIHDR.colorType);
        ImageFormat Format2 = ImageFormat.IMAGE_FORMAT_PNG;
        String FormatName = "PNG Portable Network Graphics";
        int Height = pngChunkIHDR.height;
        String MimeType = "image/png";
        boolean NumberOfImages = true;
        int Width = pngChunkIHDR.width;
        boolean isProgressive = pngChunkIHDR.interlaceMethod != 0;
        int PhysicalHeightDpi = -1;
        float PhysicalHeightInch = -1.0f;
        int PhysicalWidthDpi = -1;
        float PhysicalWidthInch = -1.0f;
        if (pngChunkpHYs != null && pngChunkpHYs.UnitSpecifier == 1) {
            double meters_per_inch = 0.0254;
            PhysicalWidthDpi = (int)Math.round((double)pngChunkpHYs.PixelsPerUnitXAxis * 0.0254);
            PhysicalWidthInch = (float)((double)Width / ((double)pngChunkpHYs.PixelsPerUnitXAxis * 0.0254));
            PhysicalHeightDpi = (int)Math.round((double)pngChunkpHYs.PixelsPerUnitYAxis * 0.0254);
            PhysicalHeightInch = (float)((double)Height / ((double)pngChunkpHYs.PixelsPerUnitYAxis * 0.0254));
        }
        String FormatDetails = "Png";
        boolean usesPalette = false;
        List<PngChunk> PLTEs = this.filterChunks(chunks, PLTE);
        if (PLTEs.size() > 1) {
            usesPalette = true;
        }
        switch (pngChunkIHDR.colorType) {
            case 0: 
            case 4: {
                ColorType = 1;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                ColorType = 2;
                break;
            }
            default: {
                throw new ImageReadException("Png: Unknown ColorType: " + pngChunkIHDR.colorType);
            }
        }
        String compressionAlgorithm = "PNG Filter";
        return new PngImageInfo("Png", BitsPerPixel, comments, Format2, "PNG Portable Network Graphics", Height, "image/png", 1, PhysicalHeightDpi, PhysicalHeightInch, PhysicalWidthDpi, PhysicalWidthInch, Width, isProgressive, isTransparent, usesPalette, ColorType, "PNG Filter", textChunks);
    }

    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        Boolean is_srgb;
        ScanExpediter scanExpediter;
        int bitDepth;
        List<PngChunk> IDATs;
        List<PngChunk> chunks;
        ParamMap.getParamBoolean(params, "VERBOSE", false);
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        if ((chunks = this.readChunks(byteSource, new int[]{IHDR, PLTE, IDAT, tRNS, iCCP, gAMA, sRGB}, false)) == null || chunks.size() < 1) {
            throw new ImageReadException("PNG: no chunks");
        }
        List<PngChunk> IHDRs = this.filterChunks(chunks, IHDR);
        if (IHDRs.size() != 1) {
            throw new ImageReadException("PNG contains more than one Header");
        }
        PngChunkIhdr pngChunkIHDR = (PngChunkIhdr)IHDRs.get(0);
        List<PngChunk> PLTEs = this.filterChunks(chunks, PLTE);
        if (PLTEs.size() > 1) {
            throw new ImageReadException("PNG contains more than one Palette");
        }
        PngChunkPlte pngChunkPLTE = null;
        if (PLTEs.size() == 1) {
            pngChunkPLTE = (PngChunkPlte)PLTEs.get(0);
        }
        if ((IDATs = this.filterChunks(chunks, IDAT)).size() < 1) {
            throw new ImageReadException("PNG missing image data");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < IDATs.size(); ++i) {
            PngChunkIdat pngChunkIDAT = (PngChunkIdat)IDATs.get(i);
            byte[] bytes = pngChunkIDAT.bytes;
            baos.write(bytes);
        }
        byte[] compressed = baos.toByteArray();
        baos = null;
        TransparencyFilter transparencyFilter = null;
        List<PngChunk> tRNSs = this.filterChunks(chunks, tRNS);
        if (tRNSs.size() > 0) {
            PngChunk pngChunktRNS = tRNSs.get(0);
            transparencyFilter = this.getTransparencyFilter(pngChunkIHDR.colorType, pngChunktRNS);
        }
        ICC_Profile icc_profile = null;
        GammaCorrection gammaCorrection = null;
        List<PngChunk> sRGBs = this.filterChunks(chunks, sRGB);
        List<PngChunk> gAMAs = this.filterChunks(chunks, gAMA);
        List<PngChunk> iCCPs = this.filterChunks(chunks, iCCP);
        if (sRGBs.size() > 1) {
            throw new ImageReadException("PNG: unexpected sRGB chunk");
        }
        if (gAMAs.size() > 1) {
            throw new ImageReadException("PNG: unexpected gAMA chunk");
        }
        if (iCCPs.size() > 1) {
            throw new ImageReadException("PNG: unexpected iCCP chunk");
        }
        if (sRGBs.size() == 1) {
            if (this.debug) {
                System.out.println("sRGB, no color management neccesary.");
            }
        } else if (iCCPs.size() == 1) {
            if (this.debug) {
                System.out.println("iCCP.");
            }
            PngChunkIccp pngChunkiCCP = (PngChunkIccp)iCCPs.get(0);
            byte[] bytes = pngChunkiCCP.UncompressedProfile;
            icc_profile = ICC_Profile.getInstance(bytes);
        } else if (gAMAs.size() == 1) {
            PngChunkGama pngChunkgAMA = (PngChunkGama)gAMAs.get(0);
            double gamma = pngChunkgAMA.getGamma();
            double targetGamma = 1.0;
            double diff = Math.abs(1.0 - gamma);
            if (diff >= 0.5) {
                gammaCorrection = new GammaCorrection(gamma, 1.0);
            }
            if (gammaCorrection != null && pngChunkPLTE != null) {
                pngChunkPLTE.correct(gammaCorrection);
            }
        }
        int width = pngChunkIHDR.width;
        int height = pngChunkIHDR.height;
        int colorType = pngChunkIHDR.colorType;
        int bitsPerSample = bitDepth = pngChunkIHDR.bitDepth;
        if (pngChunkIHDR.filterMethod != 0) {
            throw new ImageReadException("PNG: unknown FilterMethod: " + pngChunkIHDR.filterMethod);
        }
        int samplesPerPixel = this.samplesPerPixel(pngChunkIHDR.colorType);
        boolean isGrayscale = this.isGrayscale(pngChunkIHDR.colorType);
        int bitsPerPixel = bitsPerSample * samplesPerPixel;
        boolean hasAlpha = colorType == 4 || colorType == 6 || transparencyFilter != null;
        BufferedImage result = isGrayscale ? this.getBufferedImageFactory(params).getGrayscaleBufferedImage(width, height, hasAlpha) : this.getBufferedImageFactory(params).getColorBufferedImage(width, height, hasAlpha);
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        InflaterInputStream iis = new InflaterInputStream(bais);
        if (pngChunkIHDR.interlaceMethod == 0) {
            scanExpediter = new ScanExpediterSimple(width, height, iis, result, colorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, transparencyFilter);
        } else if (pngChunkIHDR.interlaceMethod == 1) {
            scanExpediter = new ScanExpediterInterlaced(width, height, iis, result, colorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, transparencyFilter);
        } else {
            throw new ImageReadException("Unknown InterlaceMethod: " + pngChunkIHDR.interlaceMethod);
        }
        ((ScanExpediter)scanExpediter).drive();
        if (!(icc_profile == null || (is_srgb = new IccProfileParser().issRGB(icc_profile)) != null && is_srgb.booleanValue())) {
            ICC_ColorSpace cs = new ICC_ColorSpace(icc_profile);
            ColorModel srgbCM = ColorModel.getRGBdefault();
            ColorSpace cs_sRGB = srgbCM.getColorSpace();
            result = new ColorTools().convertBetweenColorSpaces(result, cs, cs_sRGB);
        }
        return result;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        ImageInfo imageInfo = this.getImageInfo(byteSource);
        if (imageInfo == null) {
            return false;
        }
        imageInfo.toString(pw, "");
        List<PngChunk> chunks = this.readChunks(byteSource, null, false);
        List<PngChunk> IHDRs = this.filterChunks(chunks, IHDR);
        if (IHDRs.size() != 1) {
            if (this.debug) {
                System.out.println("PNG contains more than one Header");
            }
            return false;
        }
        PngChunkIhdr pngChunkIHDR = (PngChunkIhdr)IHDRs.get(0);
        pw.println("Color: " + this.getColorTypeDescription(pngChunkIHDR.colorType));
        pw.println("chunks: " + chunks.size());
        if (chunks.size() < 1) {
            return false;
        }
        for (int i = 0; i < chunks.size(); ++i) {
            PngChunk chunk = chunks.get(i);
            this.printCharQuad(pw, "\t" + i + ": ", chunk.chunkType);
        }
        pw.println("");
        pw.flush();
        return true;
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map<String, Object> params) throws ImageWriteException, IOException {
        new PngWriter(params).writeImage(src, os, params);
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<PngChunk> chunks = this.readChunks(byteSource, new int[]{iTXt}, false);
        if (chunks == null || chunks.size() < 1) {
            return null;
        }
        ArrayList<PngChunkItxt> xmpChunks = new ArrayList<PngChunkItxt>();
        for (int i = 0; i < chunks.size(); ++i) {
            PngChunkItxt chunk = (PngChunkItxt)chunks.get(i);
            if (!chunk.getKeyword().equals("XML:com.adobe.xmp")) continue;
            xmpChunks.add(chunk);
        }
        if (xmpChunks.size() < 1) {
            return null;
        }
        if (xmpChunks.size() > 1) {
            throw new ImageReadException("PNG contains more than one XMP chunk.");
        }
        PngChunkItxt chunk = (PngChunkItxt)xmpChunks.get(0);
        return chunk.getText();
    }
}

