/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ZLibUtils;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;

public class PngChunkIccp
extends PngChunk {
    public final String ProfileName;
    public final int CompressionMethod;
    public final byte[] CompressedProfile;
    public final byte[] UncompressedProfile;

    public PngChunkIccp(int Length, int ChunkType, int CRC, byte[] bytes) throws ImageReadException, IOException {
        super(Length, ChunkType, CRC, bytes);
        int index = this.findNull(bytes);
        if (index < 0) {
            throw new ImageReadException("PngChunkIccp: No Profile Name");
        }
        byte[] name_bytes = new byte[index];
        System.arraycopy(bytes, 0, name_bytes, 0, index);
        this.ProfileName = new String(name_bytes, "ISO-8859-1");
        this.CompressionMethod = bytes[index + 1];
        int CompressedProfileLength = bytes.length - (index + 1 + 1);
        this.CompressedProfile = new byte[CompressedProfileLength];
        System.arraycopy(bytes, index + 1 + 1, this.CompressedProfile, 0, CompressedProfileLength);
        if (this.getDebug()) {
            System.out.println("ProfileName: " + this.ProfileName);
            System.out.println("ProfileName.length(): " + this.ProfileName.length());
            System.out.println("CompressionMethod: " + this.CompressionMethod);
            System.out.println("CompressedProfileLength: " + CompressedProfileLength);
            System.out.println("bytes.length: " + bytes.length);
        }
        this.UncompressedProfile = new ZLibUtils().inflate(this.CompressedProfile);
        if (this.getDebug()) {
            System.out.println("UncompressedProfile: " + (this.UncompressedProfile == null ? "null" : "" + bytes.length));
        }
    }
}

