/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

public abstract class FileInfo {
    protected final int width;
    protected final int height;
    protected final boolean RAWBITS;

    public FileInfo(int width, int height, boolean RAWBITS) {
        this.width = width;
        this.height = height;
        this.RAWBITS = RAWBITS;
    }

    public abstract boolean hasAlpha();

    public abstract int getNumComponents();

    public abstract int getBitDepth();

    public abstract ImageFormat getImageType();

    public abstract String getImageTypeDescription();

    public abstract String getMIMEType();

    public abstract int getColorType();

    public abstract int getRGB(WhiteSpaceReader var1) throws IOException;

    public abstract int getRGB(InputStream var1) throws IOException;

    protected void newline() {
    }

    protected static int readSample(InputStream is, int bytesPerSample) throws IOException {
        int sample = 0;
        for (int i = 0; i < bytesPerSample; ++i) {
            int nextByte = is.read();
            if (nextByte < 0) {
                throw new IOException("PNM: Unexpected EOF");
            }
            sample <<= 8;
            sample |= nextByte;
        }
        return sample;
    }

    protected static int scaleSample(int sample, float scale, int max) throws IOException {
        if (sample < 0) {
            throw new IOException("Negative pixel values are invalid in PNM files");
        }
        if (sample > max) {
            sample = 0;
        }
        return (int)((float)sample * scale / (float)max + 0.5f);
    }

    public void readImage(ImageBuilder imageBuilder, InputStream is) throws IOException {
        if (!this.RAWBITS) {
            WhiteSpaceReader wsr = new WhiteSpaceReader(is);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int rgb = this.getRGB(wsr);
                    imageBuilder.setRGB(x, y, rgb);
                }
                this.newline();
            }
        } else {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int rgb = this.getRGB(is);
                    imageBuilder.setRGB(x, y, rgb);
                }
                this.newline();
            }
        }
    }

    public void dump() {
    }
}

