/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.pnm.FileInfo;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

public class PgmFileInfo
extends FileInfo {
    private final int max;
    private final float scale;
    private final int bytesPerSample;

    public PgmFileInfo(int width, int height, boolean RAWBITS, int max) throws ImageReadException {
        super(width, height, RAWBITS);
        if (max <= 0) {
            throw new ImageReadException("PGM maxVal " + max + " is out of range [1;65535]");
        }
        if (max <= 255) {
            this.scale = 255.0f;
            this.bytesPerSample = 1;
        } else if (max <= 65535) {
            this.scale = 65535.0f;
            this.bytesPerSample = 2;
        } else {
            throw new ImageReadException("PGM maxVal " + max + " is out of range [1;65535]");
        }
        this.max = max;
    }

    public boolean hasAlpha() {
        return false;
    }

    public int getNumComponents() {
        return 1;
    }

    public int getBitDepth() {
        return this.max;
    }

    public ImageFormat getImageType() {
        return ImageFormat.IMAGE_FORMAT_PGM;
    }

    public String getImageTypeDescription() {
        return "PGM: portable graymap file format";
    }

    public String getMIMEType() {
        return "image/x-portable-graymap";
    }

    public int getColorType() {
        return 1;
    }

    public int getRGB(InputStream is) throws IOException {
        int sample = PgmFileInfo.readSample(is, this.bytesPerSample);
        sample = PgmFileInfo.scaleSample(sample, this.scale, this.max);
        int alpha = 255;
        int rgb = 0xFF000000 | (0xFF & sample) << 16 | (0xFF & sample) << 8 | (0xFF & sample) << 0;
        return rgb;
    }

    public int getRGB(WhiteSpaceReader wsr) throws IOException {
        int sample = Integer.parseInt(wsr.readtoWhiteSpace());
        sample = PgmFileInfo.scaleSample(sample, this.scale, this.max);
        int alpha = 255;
        int rgb = 0xFF000000 | (0xFF & sample) << 16 | (0xFF & sample) << 8 | (0xFF & sample) << 0;
        return rgb;
    }
}

