/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.pnm.FileInfo;
import org.apache.commons.imaging.formats.pnm.PamFileInfo;
import org.apache.commons.imaging.formats.pnm.PamWriter;
import org.apache.commons.imaging.formats.pnm.PbmFileInfo;
import org.apache.commons.imaging.formats.pnm.PbmWriter;
import org.apache.commons.imaging.formats.pnm.PgmFileInfo;
import org.apache.commons.imaging.formats.pnm.PgmWriter;
import org.apache.commons.imaging.formats.pnm.PnmConstants;
import org.apache.commons.imaging.formats.pnm.PnmWriter;
import org.apache.commons.imaging.formats.pnm.PpmFileInfo;
import org.apache.commons.imaging.formats.pnm.PpmWriter;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;
import org.apache.commons.imaging.palette.PaletteFactory;
import org.apache.commons.imaging.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PnmImageParser
extends ImageParser
implements PnmConstants {
    private static final String DEFAULT_EXTENSION = ".pnm";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".pbm", ".pgm", ".ppm", ".pnm", ".pam"};
    public static final String PARAM_KEY_PNM_RAWBITS = "PNM_RAWBITS";
    public static final String PARAM_VALUE_PNM_RAWBITS_YES = "YES";
    public static final String PARAM_VALUE_PNM_RAWBITS_NO = "NO";

    public PnmImageParser() {
        super.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public String getName() {
        return "Pbm-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_PBM, ImageFormat.IMAGE_FORMAT_PGM, ImageFormat.IMAGE_FORMAT_PPM, ImageFormat.IMAGE_FORMAT_PNM, ImageFormat.IMAGE_FORMAT_PAM};
    }

    private FileInfo readHeader(InputStream is) throws ImageReadException, IOException {
        byte identifier1 = this.readByte("Identifier1", is, "Not a Valid PNM File");
        byte identifier2 = this.readByte("Identifier2", is, "Not a Valid PNM File");
        if (identifier1 != 80) {
            throw new ImageReadException("PNM file has invalid prefix byte 1");
        }
        WhiteSpaceReader wsr = new WhiteSpaceReader(is);
        if (identifier2 == 49 || identifier2 == 52 || identifier2 == 50 || identifier2 == 53 || identifier2 == 51 || identifier2 == 54) {
            int width = Integer.parseInt(wsr.readtoWhiteSpace());
            int height = Integer.parseInt(wsr.readtoWhiteSpace());
            if (identifier2 == 49) {
                return new PbmFileInfo(width, height, false);
            }
            if (identifier2 == 52) {
                return new PbmFileInfo(width, height, true);
            }
            if (identifier2 == 50) {
                int maxgray = Integer.parseInt(wsr.readtoWhiteSpace());
                return new PgmFileInfo(width, height, false, maxgray);
            }
            if (identifier2 == 53) {
                int maxgray = Integer.parseInt(wsr.readtoWhiteSpace());
                return new PgmFileInfo(width, height, true, maxgray);
            }
            if (identifier2 == 51) {
                int max = Integer.parseInt(wsr.readtoWhiteSpace());
                return new PpmFileInfo(width, height, false, max);
            }
            if (identifier2 == 54) {
                int max = Integer.parseInt(wsr.readtoWhiteSpace());
                return new PpmFileInfo(width, height, true, max);
            }
            throw new ImageReadException("PNM file has invalid header.");
        }
        if (identifier2 == 55) {
            String line;
            int width = -1;
            boolean seenWidth = false;
            int height = -1;
            boolean seenHeight = false;
            int depth = -1;
            boolean seenDepth = false;
            int maxVal = -1;
            boolean seenMaxVal = false;
            String tupleType = "";
            boolean seenTupleType = false;
            wsr.readLine();
            while ((line = wsr.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, " ", false);
                String type = tokenizer.nextToken();
                if (type.equals("WIDTH")) {
                    seenWidth = true;
                    width = Integer.parseInt(tokenizer.nextToken());
                    continue;
                }
                if (type.equals("HEIGHT")) {
                    seenHeight = true;
                    height = Integer.parseInt(tokenizer.nextToken());
                    continue;
                }
                if (type.equals("DEPTH")) {
                    seenDepth = true;
                    depth = Integer.parseInt(tokenizer.nextToken());
                    continue;
                }
                if (type.equals("MAXVAL")) {
                    seenMaxVal = true;
                    maxVal = Integer.parseInt(tokenizer.nextToken());
                    continue;
                }
                if (type.equals("TUPLTYPE")) {
                    seenTupleType = true;
                    tupleType = tupleType + tokenizer.nextToken();
                    continue;
                }
                if (type.equals("ENDHDR")) break;
                throw new ImageReadException("Invalid PAM file header type " + type);
            }
            if (!seenWidth) {
                throw new ImageReadException("PAM header has no WIDTH");
            }
            if (!seenHeight) {
                throw new ImageReadException("PAM header has no HEIGHT");
            }
            if (!seenDepth) {
                throw new ImageReadException("PAM header has no DEPTH");
            }
            if (!seenMaxVal) {
                throw new ImageReadException("PAM header has no MAXVAL");
            }
            if (!seenTupleType) {
                throw new ImageReadException("PAM header has no TUPLTYPE");
            }
            return new PamFileInfo(width, height, depth, maxVal, tupleType);
        }
        throw new ImageReadException("PNM file has invalid prefix byte 2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo readHeader(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            FileInfo fileInfo = this.readHeader(is);
            return fileInfo;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        FileInfo info = this.readHeader(byteSource);
        if (info == null) {
            throw new ImageReadException("PNM: Couldn't read Header");
        }
        return new Dimension(info.width, info.height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        FileInfo info = this.readHeader(byteSource);
        if (info == null) {
            throw new ImageReadException("PNM: Couldn't read Header");
        }
        ArrayList<String> Comments = new ArrayList<String>();
        int BitsPerPixel = info.getBitDepth() * info.getNumComponents();
        ImageFormat Format2 = info.getImageType();
        String FormatName = info.getImageTypeDescription();
        String MimeType = info.getMIMEType();
        boolean NumberOfImages = true;
        boolean isProgressive = false;
        int PhysicalWidthDpi = 72;
        float PhysicalWidthInch = (float)((double)info.width / 72.0);
        int PhysicalHeightDpi = 72;
        float PhysicalHeightInch = (float)((double)info.height / 72.0);
        String FormatDetails = info.getImageTypeDescription();
        boolean isTransparent = info.hasAlpha();
        boolean usesPalette = false;
        int ColorType = info.getColorType();
        String compressionAlgorithm = "None";
        ImageInfo result = new ImageInfo(FormatDetails, BitsPerPixel, Comments, Format2, FormatName, info.height, MimeType, 1, 72, PhysicalHeightInch, 72, PhysicalWidthInch, info.width, false, isTransparent, false, ColorType, "None");
        return result;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("pnm.dumpImageFile");
        ImageInfo imageData = this.getImageInfo(byteSource);
        if (imageData == null) {
            return false;
        }
        imageData.toString(pw, "");
        pw.println("");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            FileInfo info = this.readHeader(is);
            int width = info.width;
            int height = info.height;
            boolean hasAlpha = info.hasAlpha();
            ImageBuilder imageBuilder = new ImageBuilder(width, height, hasAlpha);
            info.readImage(imageBuilder, is);
            BufferedImage bufferedImage = imageBuilder.getBufferedImage();
            return bufferedImage;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map<String, Object> params) throws ImageWriteException, IOException {
        PnmWriter writer = null;
        boolean useRawbits = true;
        boolean hasAlpha = new PaletteFactory().hasTransparency(src);
        if (params != null) {
            Object subtype;
            Object useRawbitsParam = params.get(PARAM_KEY_PNM_RAWBITS);
            if (useRawbitsParam != null && useRawbitsParam.equals(PARAM_VALUE_PNM_RAWBITS_NO)) {
                useRawbits = false;
            }
            if ((subtype = params.get("FORMAT")) != null) {
                if (subtype.equals(ImageFormat.IMAGE_FORMAT_PBM)) {
                    writer = new PbmWriter(useRawbits);
                } else if (subtype.equals(ImageFormat.IMAGE_FORMAT_PGM)) {
                    writer = new PgmWriter(useRawbits);
                } else if (subtype.equals(ImageFormat.IMAGE_FORMAT_PPM)) {
                    writer = new PpmWriter(useRawbits);
                } else if (subtype.equals(ImageFormat.IMAGE_FORMAT_PAM)) {
                    writer = new PamWriter();
                }
            }
        }
        if (writer == null) {
            writer = hasAlpha ? new PamWriter() : new PpmWriter(useRawbits);
        }
        if ((params = params != null ? new HashMap<String, Object>(params) : new HashMap<String, Object>()).containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.size() > 0) {
            String firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        writer.writeImage(src, os, params);
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }
}

