/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.psd.ImageContents;
import org.apache.commons.imaging.formats.psd.ImageResourceBlock;
import org.apache.commons.imaging.formats.psd.PsdConstants;
import org.apache.commons.imaging.formats.psd.PsdHeaderInfo;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParser;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserBitmap;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserCmyk;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserGrayscale;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserIndexed;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserLab;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserRgb;
import org.apache.commons.imaging.formats.psd.datareaders.CompressedDataReader;
import org.apache.commons.imaging.formats.psd.datareaders.DataReader;
import org.apache.commons.imaging.formats.psd.datareaders.UncompressedDataReader;
import org.apache.commons.imaging.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsdImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".psd";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".psd"};
    private static final int PSD_SECTION_HEADER = 0;
    private static final int PSD_SECTION_COLOR_MODE = 1;
    private static final int PSD_SECTION_IMAGE_RESOURCES = 2;
    private static final int PSD_SECTION_LAYER_AND_MASK_DATA = 3;
    private static final int PSD_SECTION_IMAGE_DATA = 4;
    private static final int PSD_HEADER_LENGTH = 26;
    public static final int IMAGE_RESOURCE_ID_ICC_PROFILE = 1039;
    private static final int COLOR_MODE_INDEXED = 2;
    public static final int IMAGE_RESOURCE_ID_XMP = 1060;
    public static final String BLOCK_NAME_XMP = "XMP";

    public PsdImageParser() {
        super.setByteOrder(ByteOrder.MOTOROLA);
    }

    @Override
    public String getName() {
        return "PSD-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_PSD};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsdHeaderInfo readHeader(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            PsdHeaderInfo psdHeaderInfo = this.readHeader(is);
            return psdHeaderInfo;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    private PsdHeaderInfo readHeader(InputStream is) throws ImageReadException, IOException {
        this.readAndVerifyBytes(is, new byte[]{56, 66, 80, 83}, "Not a Valid PSD File");
        int Version = this.read2Bytes("Version", is, "Not a Valid PSD File");
        byte[] Reserved = this.readBytes("Reserved", is, 6, "Not a Valid PSD File");
        int Channels = this.read2Bytes("Channels", is, "Not a Valid PSD File");
        int Rows = this.read4Bytes("Rows", is, "Not a Valid PSD File");
        int Columns = this.read4Bytes("Columns", is, "Not a Valid PSD File");
        int Depth = this.read2Bytes("Depth", is, "Not a Valid PSD File");
        int Mode = this.read2Bytes("Mode", is, "Not a Valid PSD File");
        PsdHeaderInfo result = new PsdHeaderInfo(Version, Reserved, Channels, Rows, Columns, Depth, Mode);
        return result;
    }

    private ImageContents readImageContents(InputStream is) throws ImageReadException, IOException {
        PsdHeaderInfo header = this.readHeader(is);
        int ColorModeDataLength = this.read4Bytes("ColorModeDataLength", is, "Not a Valid PSD File");
        this.skipBytes(is, ColorModeDataLength);
        int ImageResourcesLength = this.read4Bytes("ImageResourcesLength", is, "Not a Valid PSD File");
        this.skipBytes(is, ImageResourcesLength);
        int LayerAndMaskDataLength = this.read4Bytes("LayerAndMaskDataLength", is, "Not a Valid PSD File");
        this.skipBytes(is, LayerAndMaskDataLength);
        int Compression2 = this.read2Bytes("Compression", is, "Not a Valid PSD File");
        ImageContents result = new ImageContents(header, ColorModeDataLength, ImageResourcesLength, LayerAndMaskDataLength, Compression2);
        return result;
    }

    private List<ImageResourceBlock> readImageResourceBlocks(byte[] bytes, int[] imageResourceIDs, int maxBlocksToRead) throws ImageReadException, IOException {
        return this.readImageResourceBlocks(new ByteArrayInputStream(bytes), imageResourceIDs, maxBlocksToRead, bytes.length);
    }

    private boolean keepImageResourceBlock(int ID, int[] imageResourceIDs) {
        if (imageResourceIDs == null) {
            return true;
        }
        for (int imageResourceID : imageResourceIDs) {
            if (ID != imageResourceID) continue;
            return true;
        }
        return false;
    }

    private List<ImageResourceBlock> readImageResourceBlocks(InputStream is, int[] imageResourceIDs, int maxBlocksToRead, int available) throws ImageReadException, IOException {
        ArrayList<ImageResourceBlock> result = new ArrayList<ImageResourceBlock>();
        while (available > 0) {
            this.readAndVerifyBytes(is, new byte[]{56, 66, 73, 77}, "Not a Valid PSD File");
            available -= 4;
            int id = this.read2Bytes("ID", is, "Not a Valid PSD File");
            available -= 2;
            byte nameLength = this.readByte("NameLength", is, "Not a Valid PSD File");
            --available;
            byte[] nameBytes = this.readBytes("NameData", is, nameLength, "Not a Valid PSD File");
            available -= nameLength;
            if ((nameLength + 1) % 2 != 0) {
                this.readByte("NameDiscard", is, "Not a Valid PSD File");
                --available;
            }
            int DataSize = this.read4Bytes("Size", is, "Not a Valid PSD File");
            available -= 4;
            byte[] Data2 = this.readBytes("Data", is, DataSize, "Not a Valid PSD File");
            available -= DataSize;
            if (DataSize % 2 != 0) {
                this.readByte("DataDiscard", is, "Not a Valid PSD File");
                --available;
            }
            if (!this.keepImageResourceBlock(id, imageResourceIDs)) continue;
            result.add(new ImageResourceBlock(id, nameBytes, Data2));
            if (maxBlocksToRead < 0 || result.size() < maxBlocksToRead) continue;
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImageResourceBlock> readImageResourceBlocks(ByteSource byteSource, int[] imageResourceIDs, int maxBlocksToRead) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            ImageContents imageContents = this.readImageContents(is);
            is.close();
            is = this.getInputStream(byteSource, 2);
            byte[] ImageResources = this.readBytes("ImageResources", is, imageContents.ImageResourcesLength, "Not a Valid PSD File");
            List<ImageResourceBlock> list = this.readImageResourceBlocks(ImageResources, imageResourceIDs, maxBlocksToRead);
            return list;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getInputStream(ByteSource byteSource, int section) throws ImageReadException, IOException {
        InputStream is = null;
        boolean notFound = false;
        try {
            is = byteSource.getInputStream();
            if (section == 0) {
                InputStream inputStream = is;
                return inputStream;
            }
            this.skipBytes(is, 26);
            int ColorModeDataLength = this.read4Bytes("ColorModeDataLength", is, "Not a Valid PSD File");
            if (section == 1) {
                InputStream ignore = is;
                return ignore;
            }
            this.skipBytes(is, ColorModeDataLength);
            int ImageResourcesLength = this.read4Bytes("ImageResourcesLength", is, "Not a Valid PSD File");
            if (section == 2) {
                InputStream ignore = is;
                return ignore;
            }
            this.skipBytes(is, ImageResourcesLength);
            int LayerAndMaskDataLength = this.read4Bytes("LayerAndMaskDataLength", is, "Not a Valid PSD File");
            if (section == 3) {
                InputStream inputStream = is;
                return inputStream;
            }
            this.skipBytes(is, LayerAndMaskDataLength);
            this.read2Bytes("Compression", is, "Not a Valid PSD File");
            if (section == 4) {
                InputStream inputStream = is;
                return inputStream;
            }
            notFound = true;
            throw new ImageReadException("getInputStream: Unknown Section: " + section);
        }
        finally {
            if (notFound && is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getData(ByteSource byteSource, int section) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            if (section == 0) {
                byte[] byArray = this.readBytes("Header", is, 26, "Not a Valid PSD File");
                return byArray;
            }
            this.skipBytes(is, 26);
            int ColorModeDataLength = this.read4Bytes("ColorModeDataLength", is, "Not a Valid PSD File");
            if (section == 1) {
                byte[] e = this.readBytes("ColorModeData", is, ColorModeDataLength, "Not a Valid PSD File");
                return e;
            }
            this.skipBytes(is, ColorModeDataLength);
            int ImageResourcesLength = this.read4Bytes("ImageResourcesLength", is, "Not a Valid PSD File");
            if (section == 2) {
                byte[] e = this.readBytes("ImageResources", is, ImageResourcesLength, "Not a Valid PSD File");
                return e;
            }
            this.skipBytes(is, ImageResourcesLength);
            int LayerAndMaskDataLength = this.read4Bytes("LayerAndMaskDataLength", is, "Not a Valid PSD File");
            if (section == 3) {
                byte[] byArray = this.readBytes("LayerAndMaskData", is, LayerAndMaskDataLength, "Not a Valid PSD File");
                return byArray;
            }
            this.skipBytes(is, LayerAndMaskDataLength);
            this.read2Bytes("Compression", is, "Not a Valid PSD File");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
        throw new ImageReadException("getInputStream: Unknown Section: " + section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageContents readImageContents(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            ImageContents imageContents;
            is = byteSource.getInputStream();
            ImageContents imageContents2 = imageContents = this.readImageContents(is);
            return imageContents2;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<ImageResourceBlock> blocks = this.readImageResourceBlocks(byteSource, new int[]{1039}, 1);
        if (blocks == null || blocks.size() < 1) {
            return null;
        }
        ImageResourceBlock irb = blocks.get(0);
        byte[] bytes = irb.data;
        if (bytes == null || bytes.length < 1) {
            return null;
        }
        return bytes;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        PsdHeaderInfo bhi = this.readHeader(byteSource);
        if (bhi == null) {
            throw new ImageReadException("PSD: couldn't read header");
        }
        return new Dimension(bhi.Columns, bhi.Rows);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }

    private int getChannelsPerMode(int mode) {
        switch (mode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return -1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return -1;
            }
            case 8: {
                return -1;
            }
            case 9: {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        String compressionAlgorithm;
        ImageContents imageContents = this.readImageContents(byteSource);
        if (imageContents == null) {
            throw new ImageReadException("PSD: Couldn't read blocks");
        }
        PsdHeaderInfo header = imageContents.header;
        if (header == null) {
            throw new ImageReadException("PSD: Couldn't read Header");
        }
        int Width = header.Columns;
        int Height = header.Rows;
        ArrayList<String> Comments = new ArrayList<String>();
        int BitsPerPixel = header.Depth * this.getChannelsPerMode(header.Mode);
        if (BitsPerPixel < 0) {
            BitsPerPixel = 0;
        }
        ImageFormat Format2 = ImageFormat.IMAGE_FORMAT_PSD;
        String FormatName = "Photoshop";
        String MimeType = "image/x-photoshop";
        int NumberOfImages = -1;
        boolean isProgressive = false;
        int PhysicalWidthDpi = 72;
        float PhysicalWidthInch = (float)((double)Width / 72.0);
        int PhysicalHeightDpi = 72;
        float PhysicalHeightInch = (float)((double)Height / 72.0);
        String FormatDetails = "Psd";
        boolean isTransparent = false;
        boolean usesPalette = header.Mode == 2;
        int ColorType = -2;
        switch (imageContents.Compression) {
            case 0: {
                compressionAlgorithm = "None";
                break;
            }
            case 1: {
                compressionAlgorithm = "Photoshop";
                break;
            }
            default: {
                compressionAlgorithm = "Unknown";
            }
        }
        ImageInfo result = new ImageInfo("Psd", BitsPerPixel, Comments, Format2, "Photoshop", Height, "image/x-photoshop", -1, 72, PhysicalHeightInch, 72, PhysicalWidthInch, Width, false, false, usesPalette, -2, compressionAlgorithm);
        return result;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("gif.dumpImageFile");
        ImageInfo fImageData = this.getImageInfo(byteSource);
        if (fImageData == null) {
            return false;
        }
        fImageData.toString(pw, "");
        ImageContents imageContents = this.readImageContents(byteSource);
        imageContents.dump(pw);
        imageContents.header.dump(pw);
        List<ImageResourceBlock> blocks = this.readImageResourceBlocks(byteSource, null, -1);
        pw.println("blocks.size(): " + blocks.size());
        for (int i = 0; i < blocks.size(); ++i) {
            ImageResourceBlock block = blocks.get(i);
            pw.println("\t" + i + " (" + Integer.toHexString(block.id) + ", " + "'" + new String(block.nameData, "ISO-8859-1") + "' (" + block.nameData.length + "), " + " data: " + block.data.length + " type: '" + new PsdConstants().getDescription(block.id) + "' " + ")");
        }
        pw.println("");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        DataReader fDataReader;
        DataParser dataParser;
        ImageContents imageContents = this.readImageContents(byteSource);
        if (imageContents == null) {
            throw new ImageReadException("PSD: Couldn't read blocks");
        }
        PsdHeaderInfo header = imageContents.header;
        if (header == null) {
            throw new ImageReadException("PSD: Couldn't read Header");
        }
        this.readImageResourceBlocks(byteSource, null, -1);
        int width = header.Columns;
        int height = header.Rows;
        boolean hasAlpha = false;
        BufferedImage result = this.getBufferedImageFactory(params).getColorBufferedImage(width, height, false);
        switch (imageContents.header.Mode) {
            case 0: {
                dataParser = new DataParserBitmap();
                break;
            }
            case 1: 
            case 8: {
                dataParser = new DataParserGrayscale();
                break;
            }
            case 3: {
                dataParser = new DataParserRgb();
                break;
            }
            case 4: {
                dataParser = new DataParserCmyk();
                break;
            }
            case 9: {
                dataParser = new DataParserLab();
                break;
            }
            case 2: {
                byte[] ColorModeData = this.getData(byteSource, 1);
                dataParser = new DataParserIndexed(ColorModeData);
                break;
            }
            default: {
                throw new ImageReadException("Unknown Mode: " + imageContents.header.Mode);
            }
        }
        switch (imageContents.Compression) {
            case 0: {
                fDataReader = new UncompressedDataReader(dataParser);
                break;
            }
            case 1: {
                fDataReader = new CompressedDataReader(dataParser);
                break;
            }
            default: {
                throw new ImageReadException("Unknown Compression: " + imageContents.Compression);
            }
        }
        InputStream is = null;
        try {
            is = this.getInputStream(byteSource, 4);
            fDataReader.readData(is, result, imageContents, this);
            fDataReader.dump();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
        return result;
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        ImageContents imageContents = this.readImageContents(byteSource);
        if (imageContents == null) {
            throw new ImageReadException("PSD: Couldn't read blocks");
        }
        PsdHeaderInfo header = imageContents.header;
        if (header == null) {
            throw new ImageReadException("PSD: Couldn't read Header");
        }
        List<ImageResourceBlock> blocks = this.readImageResourceBlocks(byteSource, new int[]{1060}, -1);
        if (blocks == null || blocks.size() < 1) {
            return null;
        }
        ArrayList<ImageResourceBlock> xmpBlocks = new ArrayList<ImageResourceBlock>();
        xmpBlocks.addAll(blocks);
        if (xmpBlocks.size() < 1) {
            return null;
        }
        if (xmpBlocks.size() > 1) {
            throw new ImageReadException("PSD contains more than one XMP block.");
        }
        ImageResourceBlock block = (ImageResourceBlock)xmpBlocks.get(0);
        try {
            String xml = new String(block.data, 0, block.data.length, "utf-8");
            return xml;
        }
        catch (UnsupportedEncodingException e) {
            throw new ImageReadException("Invalid JPEG XMP Segment.");
        }
    }
}

