/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.formats.tiff.TiffElement;
import org.apache.commons.imaging.formats.tiff.constants.AllTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiffField {
    private final TagInfo tagInfo;
    private final int tag;
    private final int directoryType;
    private final FieldType fieldType;
    private final long count;
    private final long offset;
    private final byte[] value;
    private final ByteOrder byteOrder;
    private final int sortHint;
    public static final String Attribute_Tag = "Tag";
    private static final Map<Object, List<TagInfo>> ALL_TAG_MAP = TiffField.makeTagMap(AllTagConstants.ALL_TAGS, true, "All");

    public TiffField(int tag, int directoryType, FieldType fieldType, long count, long offset, byte[] value, ByteOrder byteOrder, int sortHint) throws ImageReadException {
        this.tag = tag;
        this.directoryType = directoryType;
        this.fieldType = fieldType;
        this.count = count;
        this.offset = offset;
        this.value = value;
        this.byteOrder = byteOrder;
        this.sortHint = sortHint;
        this.tagInfo = TiffField.getTag(directoryType, tag);
    }

    public int getDirectoryType() {
        return this.directoryType;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public int getTag() {
        return this.tag;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public long getCount() {
        return this.count;
    }

    public int getOffset() {
        return (int)this.offset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getSortHint() {
        return this.sortHint;
    }

    public boolean isLocalValue() {
        return this.count * (long)this.fieldType.getSize() <= 4L;
    }

    public int getBytesLength() {
        return (int)this.count * this.fieldType.getSize();
    }

    public byte[] getByteArrayValue() {
        return BinaryFunctions.head(this.value, this.getBytesLength());
    }

    public TiffElement getOversizeValueElement() {
        if (this.isLocalValue()) {
            return null;
        }
        return new OversizeValueElement(this.getOffset(), this.value.length);
    }

    private static TagInfo getTag(int directoryType, int tag, List<TagInfo> possibleMatches) {
        TagInfo tagInfo;
        int i;
        if (possibleMatches.size() < 1) {
            return null;
        }
        for (i = 0; i < possibleMatches.size(); ++i) {
            tagInfo = possibleMatches.get(i);
            if (tagInfo.directoryType == TiffDirectoryType.EXIF_DIRECTORY_UNKNOWN || directoryType != tagInfo.directoryType.directoryType) continue;
            return tagInfo;
        }
        for (i = 0; i < possibleMatches.size(); ++i) {
            tagInfo = possibleMatches.get(i);
            if (tagInfo.directoryType == TiffDirectoryType.EXIF_DIRECTORY_UNKNOWN) continue;
            if (directoryType >= 0 && tagInfo.directoryType.isImageDirectory()) {
                return tagInfo;
            }
            if (directoryType >= 0 || tagInfo.directoryType.isImageDirectory()) continue;
            return tagInfo;
        }
        for (i = 0; i < possibleMatches.size(); ++i) {
            tagInfo = possibleMatches.get(i);
            if (tagInfo.directoryType != TiffDirectoryType.EXIF_DIRECTORY_UNKNOWN) continue;
            return tagInfo;
        }
        return TiffTagConstants.TIFF_TAG_UNKNOWN;
    }

    private static TagInfo getTag(int directoryType, int tag) {
        List<TagInfo> possibleMatches = ALL_TAG_MAP.get(tag);
        if (null == possibleMatches) {
            return TiffTagConstants.TIFF_TAG_UNKNOWN;
        }
        TagInfo result = TiffField.getTag(directoryType, tag, possibleMatches);
        return result;
    }

    public String getValueDescription() {
        try {
            return this.getValueDescription(this.getValue());
        }
        catch (ImageReadException e) {
            return "Invalid value: " + e.getMessage();
        }
    }

    private String getValueDescription(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof String) {
            return "'" + o.toString().trim() + "'";
        }
        if (o instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return df.format((Date)o);
        }
        if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                if (i > 50) {
                    result.append("... (" + objects.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + object);
            }
            return result.toString();
        }
        if (o instanceof short[]) {
            short[] values = (short[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                short value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof int[]) {
            int[] values = (int[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                int value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof long[]) {
            long[] values = (long[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                long value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof double[]) {
            double[] values = (double[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                double value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof byte[]) {
            byte[] values = (byte[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                byte value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof char[]) {
            char[] values = (char[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                char value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof float[]) {
            float[] values = (float[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                float value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        return "Unknown: " + o.getClass().getName();
    }

    public void dump() {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.dump(pw);
        pw.flush();
    }

    public void dump(PrintWriter pw) {
        this.dump(pw, null);
    }

    public void dump(PrintWriter pw, String prefix) {
        if (prefix != null) {
            pw.print(prefix + ": ");
        }
        pw.println(this.toString());
        pw.flush();
    }

    public String getDescriptionWithoutValue() {
        return this.getTag() + " (0x" + Integer.toHexString(this.getTag()) + ": " + this.getTagInfo().name + "): ";
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getTag() + " (0x" + Integer.toHexString(this.getTag()) + ": " + this.getTagInfo().name + "): ");
        result.append(this.getValueDescription() + " (" + this.getCount() + " " + this.getFieldType().getName() + ")");
        return result.toString();
    }

    public String getTagName() {
        if (this.getTagInfo() == TiffTagConstants.TIFF_TAG_UNKNOWN) {
            return this.getTagInfo().name + " (0x" + Integer.toHexString(this.getTag()) + ")";
        }
        return this.getTagInfo().name;
    }

    public String getFieldTypeName() {
        return this.getFieldType().getName();
    }

    public Object getValue() throws ImageReadException {
        return this.getTagInfo().getValue(this);
    }

    public String getStringValue() throws ImageReadException {
        Object o = this.getValue();
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            throw new ImageReadException("Expected String value(" + this.getTagInfo().getDescription() + "): " + o);
        }
        return (String)o;
    }

    private static final Map<Object, List<TagInfo>> makeTagMap(List<TagInfo> tags, boolean ignoreDuplicates, String name) {
        Hashtable<Object, List<TagInfo>> map = new Hashtable<Object, List<TagInfo>>();
        for (int i = 0; i < tags.size(); ++i) {
            TagInfo tag = tags.get(i);
            ArrayList<TagInfo> tagList = (ArrayList<TagInfo>)map.get(tag.tag);
            if (tagList == null) {
                tagList = new ArrayList<TagInfo>();
                map.put(tag.tag, tagList);
            }
            tagList.add(tag);
        }
        return map;
    }

    public int[] getIntArrayValue() throws ImageReadException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return new int[]{((Number)o).intValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i].intValue();
            }
            return result;
        }
        if (o instanceof short[]) {
            short[] numbers = (short[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = 0xFFFF & numbers[i];
            }
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        throw new ImageReadException("Unknown value: " + o + " for: " + this.getTagInfo().getDescription());
    }

    public double[] getDoubleArrayValue() throws ImageReadException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return new double[]{((Number)o).doubleValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i].doubleValue();
            }
            return result;
        }
        if (o instanceof short[]) {
            short[] numbers = (short[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        if (o instanceof float[]) {
            float[] numbers = (float[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        if (o instanceof double[]) {
            double[] numbers = (double[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        throw new ImageReadException("Unknown value: " + o + " for: " + this.getTagInfo().getDescription());
    }

    public int getIntValueOrArraySum() throws ImageReadException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int sum = 0;
            for (Number number : numbers) {
                sum += number.intValue();
            }
            return sum;
        }
        if (o instanceof short[]) {
            short[] numbers = (short[])o;
            int sum = 0;
            for (short number : numbers) {
                sum += number;
            }
            return sum;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            int sum = 0;
            for (int number : numbers) {
                sum += number;
            }
            return sum;
        }
        throw new ImageReadException("Unknown value: " + o + " for: " + this.getTagInfo().getDescription());
    }

    public int getIntValue() throws ImageReadException {
        Object o = this.getValue();
        if (o == null) {
            throw new ImageReadException("Missing value: " + this.getTagInfo().getDescription());
        }
        return ((Number)o).intValue();
    }

    public double getDoubleValue() throws ImageReadException {
        Object o = this.getValue();
        if (o == null) {
            throw new ImageReadException("Missing value: " + this.getTagInfo().getDescription());
        }
        return ((Number)o).doubleValue();
    }

    public final class OversizeValueElement
    extends TiffElement {
        public OversizeValueElement(int offset, int length) {
            super(offset, length);
        }

        public String getElementDescription(boolean verbose) {
            if (verbose) {
                return null;
            }
            return "OversizeValueElement, tag: " + TiffField.this.getTagInfo().name + ", fieldType: " + TiffField.this.getFieldType().getName();
        }
    }
}

