/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.constants;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.common.BinaryConstant;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagConstantsUtils
implements TiffDirectoryConstants {
    private static final TiffDirectoryType[] tiffDirectoryTypes = TiffDirectoryType.values();

    public static List<TagInfo> mergeTagLists(List<?> ... tagLists) {
        int count = 0;
        for (List<?> tagList : tagLists) {
            count += tagList.size();
        }
        ArrayList<TagInfo> result = new ArrayList<TagInfo>(count);
        for (List<?> tagList : tagLists) {
            for (int j = 0; j < tagList.size(); ++j) {
                result.add((TagInfo)tagList.get(j));
            }
        }
        return result;
    }

    public static TiffDirectoryType getExifDirectoryType(int type) {
        for (TiffDirectoryType tiffDirectoryType : tiffDirectoryTypes) {
            if (tiffDirectoryType.directoryType != type) continue;
            return tiffDirectoryType;
        }
        return TiffDirectoryType.EXIF_DIRECTORY_UNKNOWN;
    }

    public static BinaryConstant createMicrosoftHdPhotoGuidEndingWith(byte end) {
        return new BinaryConstant(new byte[]{36, -61, -35, 111, 3, 78, -2, 75, -79, -123, 61, 119, 118, -115, -55, end});
    }
}

