/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class PhotometricInterpreterPalette
extends PhotometricInterpreter {
    private final int[] indexColorMap;

    public PhotometricInterpreterPalette(int fSamplesPerPixel, int[] fBitsPerSample, int Predictor, int width, int height, int[] fColorMap) {
        super(fSamplesPerPixel, fBitsPerSample, Predictor, width, height);
        int fBitsPerPixel = this.bitsPerSample[0];
        int colormap_scale = 1 << fBitsPerPixel;
        this.indexColorMap = new int[colormap_scale];
        for (int index = 0; index < colormap_scale; ++index) {
            int red = fColorMap[index] >> 8 & 0xFF;
            int green = fColorMap[index + colormap_scale] >> 8 & 0xFF;
            int blue = fColorMap[index + 2 * colormap_scale] >> 8 & 0xFF;
            this.indexColorMap[index] = 0xFF000000 | red << 16 | green << 8 | blue;
        }
    }

    public void interpretPixel(ImageBuilder imageBuilder, int[] samples, int x, int y) throws ImageReadException, IOException {
        imageBuilder.setRGB(x, y, this.indexColorMap[samples[0]]);
    }
}

