/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.taginfos;

import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class TagInfoFloat
extends TagInfo {
    public TagInfoFloat(String name, int tag, int length, TiffDirectoryType directoryType) {
        super(name, tag, FieldType.FLOAT, length, directoryType);
    }

    public float[] getValue(ByteOrder byteOrder, byte[] bytes) {
        return ByteConversions.toFloats(bytes, byteOrder);
    }

    public byte[] encodeValue(ByteOrder byteOrder, float ... values) throws ImageWriteException {
        return ByteConversions.toBytes(values, byteOrder);
    }
}

