/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.write;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.formats.tiff.constants.TiffConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.write.ImageDataOffsets;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TiffOutputSummary
implements TiffConstants {
    public final ByteOrder byteOrder;
    public final TiffOutputDirectory rootDirectory;
    public final Map<Integer, TiffOutputDirectory> directoryTypeMap;
    private final List<OffsetItem> offsetItems = new ArrayList<OffsetItem>();
    private final List<ImageDataOffsets> imageDataItems = new ArrayList<ImageDataOffsets>();

    public TiffOutputSummary(ByteOrder byteOrder, TiffOutputDirectory rootDirectory, Map<Integer, TiffOutputDirectory> directoryTypeMap) {
        this.byteOrder = byteOrder;
        this.rootDirectory = rootDirectory;
        this.directoryTypeMap = directoryTypeMap;
    }

    public void add(TiffOutputItem item, TiffOutputField itemOffsetField) {
        this.offsetItems.add(new OffsetItem(item, itemOffsetField));
    }

    public void updateOffsets(ByteOrder byteOrder) throws ImageWriteException {
        int i;
        for (i = 0; i < this.offsetItems.size(); ++i) {
            OffsetItem offset = this.offsetItems.get(i);
            byte[] value = FieldType.LONG.writeData((int)offset.item.getOffset(), byteOrder);
            offset.itemOffsetField.setData(value);
        }
        for (i = 0; i < this.imageDataItems.size(); ++i) {
            ImageDataOffsets imageDataInfo = this.imageDataItems.get(i);
            for (int j = 0; j < imageDataInfo.outputItems.length; ++j) {
                TiffOutputItem item = imageDataInfo.outputItems[j];
                imageDataInfo.imageDataOffsets[j] = (int)item.getOffset();
            }
            imageDataInfo.imageDataOffsetsField.setData(FieldType.LONG.writeData(imageDataInfo.imageDataOffsets, byteOrder));
        }
    }

    public void addTiffImageData(ImageDataOffsets imageDataInfo) {
        this.imageDataItems.add(imageDataInfo);
    }

    private static class OffsetItem {
        public final TiffOutputItem item;
        public final TiffOutputField itemOffsetField;

        public OffsetItem(TiffOutputItem item, TiffOutputField itemOffsetField) {
            this.itemOffsetField = itemOffsetField;
            this.item = item;
        }
    }
}

