/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.icc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryInputStream;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.icc.IccTagDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IccTagDataTypes implements IccTagDataType
{
    DESC_TYPE("descType", 1684370275){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            InputStream bis = null;
            try {
                bis = new BinaryInputStream(new ByteArrayInputStream(bytes), ByteOrder.NETWORK);
                ((BinaryInputStream)bis).read4Bytes("type_signature", "ICC: corrupt tag data");
                ((BinaryInputStream)bis).read4Bytes("ignore", "ICC: corrupt tag data");
                int string_length = ((BinaryInputStream)bis).read4Bytes("string_length", "ICC: corrupt tag data");
                String s = new String(bytes, 12, string_length - 1, "US-ASCII");
                System.out.println(prefix + "s: '" + s + "'");
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
    }
    ,
    DATA_TYPE("dataType", 1684108385){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            InputStream bis = null;
            try {
                bis = new BinaryInputStream(new ByteArrayInputStream(bytes), ByteOrder.NETWORK);
                ((BinaryInputStream)bis).read4Bytes("type_signature", "ICC: corrupt tag data");
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
    }
    ,
    MULTI_LOCALIZED_UNICODE_TYPE("multiLocalizedUnicodeType", 1835824483){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            InputStream bis = null;
            try {
                bis = new BinaryInputStream(new ByteArrayInputStream(bytes), ByteOrder.NETWORK);
                ((BinaryInputStream)bis).read4Bytes("type_signature", "ICC: corrupt tag data");
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
    }
    ,
    SIGNATURE_TYPE("signatureType", 1936287520){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            InputStream bis = null;
            try {
                bis = new BinaryInputStream(new ByteArrayInputStream(bytes), ByteOrder.NETWORK);
                ((BinaryInputStream)bis).read4Bytes("type_signature", "ICC: corrupt tag data");
                ((BinaryInputStream)bis).read4Bytes("ignore", "ICC: corrupt tag data");
                int thesignature = ((BinaryInputStream)bis).read4Bytes("thesignature ", "ICC: corrupt tag data");
                System.out.println(prefix + "thesignature: " + Integer.toHexString(thesignature) + " (" + new String(new byte[]{(byte)(0xFF & thesignature >> 24), (byte)(0xFF & thesignature >> 16), (byte)(0xFF & thesignature >> 8), (byte)(0xFF & thesignature >> 0)}, "US-ASCII") + ")");
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
    }
    ,
    TEXT_TYPE("textType", 1952807028){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            InputStream bis = null;
            try {
                bis = new BinaryInputStream(new ByteArrayInputStream(bytes), ByteOrder.NETWORK);
                ((BinaryInputStream)bis).read4Bytes("type_signature", "ICC: corrupt tag data");
                ((BinaryInputStream)bis).read4Bytes("ignore", "ICC: corrupt tag data");
                String s = new String(bytes, 8, bytes.length - 8, "US-ASCII");
                System.out.println(prefix + "s: '" + s + "'");
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
    };

    public final String name;
    public final int signature;

    private IccTagDataTypes(String name, int signature) {
        this.name = name;
        this.signature = signature;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSignature() {
        return this.signature;
    }
}

