/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import java.util.ArrayList;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.handler.WSDoAllHandler;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.HandlerParameterDecoder;
import org.apache.rampart.util.MessageOptimizer;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class WSDoAllSender
extends WSDoAllHandler {
    private static final Log log = LogFactory.getLog(WSDoAllSender.class);
    private static Log mlog = LogFactory.getLog((String)"org.apache.rampart.MESSAGE");
    private static final String SND_SECURITY = "SND_SECURITY";

    public WSDoAllSender() {
        this.inHandler = false;
    }

    public void processMessage(MessageContext msgContext) throws AxisFault {
        String useDoomValue = (String)this.getProperty(msgContext, "useDoom");
        boolean useDoom = useDoomValue != null && "true".equalsIgnoreCase(useDoomValue);
        RequestData reqData = new RequestData();
        try {
            this.processBasic(msgContext, useDoom, reqData);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reqData != null) {
                reqData.clear();
                reqData = null;
            }
        }
        if (mlog.isDebugEnabled()) {
            mlog.debug((Object)("*********************** WSDoAllSender sent out \n" + msgContext.getEnvelope()));
        }
    }

    private void processBasic(MessageContext msgContext, boolean useDoom, RequestData reqData) throws WSSecurityException, AxisFault {
        Integer repeat;
        String username;
        MessageContext inMsgCtx;
        OperationContext opCtx;
        boolean doDebug = log.isDebugEnabled();
        try {
            HandlerParameterDecoder.processParameters(msgContext, false);
        }
        catch (Exception e) {
            throw new AxisFault("Configureation error", (Throwable)e);
        }
        RampartUtil.setEncryptionCrypto(msgContext);
        if (doDebug) {
            log.debug((Object)"WSDoAllSender: enter invoke()");
        }
        if ((opCtx = msgContext.getOperationContext()) != null && (inMsgCtx = opCtx.getMessageContext("In")) != null) {
            msgContext.setProperty("RECV_RESULTS", inMsgCtx.getProperty("RECV_RESULTS"));
        }
        reqData.setNoSerialization(false);
        reqData.setMsgContext((Object)msgContext);
        if (this.getOption("OutflowSecurity") == null && this.getProperty(msgContext, "OutflowSecurity") == null) {
            if (msgContext.isServerSide() && this.getOption("OutflowSecurity-server") == null && this.getProperty(msgContext, "OutflowSecurity-server") == null) {
                return;
            }
            if (this.getOption("OutflowSecurity-client") == null && this.getProperty(msgContext, "OutflowSecurity-client") == null) {
                return;
            }
        }
        ArrayList actions = new ArrayList();
        String action = null;
        action = (String)this.getOption("items");
        if (action == null) {
            action = (String)this.getProperty(msgContext, "items");
        }
        if (action == null) {
            throw new AxisFault("WSDoAllReceiver: No action items defined");
        }
        int doAction = WSSecurityUtil.decodeAction((String)action, actions);
        if (doAction == 0) {
            return;
        }
        reqData.setUsername((String)this.getOption("user"));
        if ((reqData.getUsername() == null || reqData.getUsername().length() == 0) && (username = (String)this.getProperty(reqData.getMsgContext(), "user")) != null) {
            reqData.setUsername(username);
        }
        if ((doAction & 0x43) != 0 && (reqData.getUsername() == null || reqData.getUsername().length() == 0)) {
            throw new AxisFault("WSDoAllSender: Empty username for specified action");
        }
        Document doc = null;
        doc = (Document)((MessageContext)reqData.getMsgContext()).getProperty(SND_SECURITY);
        if (doc == null) {
            try {
                doc = Axis2Util.getDocumentFromSOAPEnvelope(msgContext.getEnvelope(), useDoom);
            }
            catch (WSSecurityException wssEx) {
                throw new AxisFault("WSDoAllReceiver: Error in converting to Document", (Throwable)wssEx);
            }
        }
        this.doSenderAction(doAction, doc, reqData, actions, !msgContext.isServerSide());
        if (reqData.isNoSerialization()) {
            ((MessageContext)reqData.getMsgContext()).setProperty(SND_SECURITY, (Object)doc);
        } else {
            if (useDoom) {
                msgContext.setEnvelope((SOAPEnvelope)doc.getDocumentElement());
            } else {
                msgContext.setEnvelope(Axis2Util.getSOAPEnvelopeFromDOMDocument(doc, useDoom));
            }
            ((MessageContext)reqData.getMsgContext()).setProperty(SND_SECURITY, null);
        }
        String optimizeParts = (String)this.getOption("optimizeParts");
        if (optimizeParts == null) {
            optimizeParts = (String)this.getProperty(reqData.getMsgContext(), "optimizeParts");
        }
        if (optimizeParts != null) {
            MessageOptimizer.optimize(msgContext.getEnvelope(), optimizeParts);
        }
        if ((repeat = (Integer)this.getOption("senderRepeatCount")) == null) {
            repeat = (Integer)this.getProperty(reqData.getMsgContext(), "senderRepeatCount");
        }
        int repeatCount = repeat;
        int repetition = this.getCurrentRepetition(msgContext);
        if (repeatCount > 0 && repetition < repeatCount) {
            reqData.clear();
            reqData = null;
            msgContext.setProperty("currentRepetition", (Object)(++repetition));
            this.invoke(msgContext);
        }
        if (doDebug) {
            log.debug((Object)"WSDoAllSender: exit invoke()");
        }
    }
}

