/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.neptunelabs.fsiframework.D.O;
import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleCMYKColorSpace;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public abstract class TIFFDecompressor {
    private static final boolean DEBUG = false;
    protected ImageReader reader;
    protected IIOMetadata metadata;
    protected int photometricInterpretation;
    protected int compression;
    protected boolean planar;
    protected int samplesPerPixel;
    protected int[] bitsPerSample;
    protected int[] sampleFormat = new int[]{1};
    protected int[] extraSamples;
    protected char[] colorMap;
    protected ImageInputStream stream;
    protected long offset;
    protected int byteCount;
    protected int srcMinX;
    protected int srcMinY;
    protected int srcWidth;
    protected int srcHeight;
    protected int sourceXOffset;
    protected int dstXOffset;
    protected int sourceYOffset;
    protected int dstYOffset;
    protected int subsampleX;
    protected int subsampleY;
    protected int[] sourceBands;
    protected int[] destinationBands;
    protected BufferedImage rawImage;
    protected BufferedImage image;
    protected int dstMinX;
    protected int dstMinY;
    protected int dstWidth;
    protected int dstHeight;
    protected int activeSrcMinX;
    protected int activeSrcMinY;
    protected int activeSrcWidth;
    protected int activeSrcHeight;
    protected TIFFColorConverter colorConverter;
    boolean isBilevel;
    boolean isContiguous;
    boolean isImageSimple;
    protected boolean adjustBitDepths;
    int[][] bitDepthScale;
    private boolean isFirstBitDepthTable = true;
    private boolean planarCache = false;
    private int[] destBitsPerSampleCache = null;
    private int[] sourceBandsCache = null;
    private int[] bitsPerSampleCache = null;
    private int[] destinationBandsCache = null;

    static SampleModel createInterleavedSM(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
        return new PixelInterleavedSampleModel(n, 1, 1, n2, n2, nArray);
    }

    static ColorModel createComponentCM(ColorSpace colorSpace, int n, int n2, boolean bl, boolean bl2) {
        ComponentColorModel componentColorModel;
        int n3;
        int n4 = n3 = bl ? 3 : 1;
        if (n2 == 4 || n2 == 5) {
            componentColorModel = new ComponentColorModel(colorSpace, bl, bl2, n3, n2);
        } else {
            int n5;
            int[] nArray = new int[n];
            if (n2 == 0) {
                n5 = 8;
            } else if (n2 == 2 || n2 == 1) {
                n5 = 16;
            } else if (n2 == 3) {
                n5 = 32;
            } else {
                throw new IllegalArgumentException("dataType = " + n2);
            }
            for (int i = 0; i < n; ++i) {
                nArray[i] = n5;
            }
            componentColorModel = new ComponentColorModel(colorSpace, nArray, bl, bl2, n3, n2);
        }
        return componentColorModel;
    }

    private static int createMask(int[] nArray, int n) {
        int n2 = (1 << nArray[n]) - 1;
        for (int i = n + 1; i < nArray.length; ++i) {
            n2 <<= nArray[i];
        }
        return n2;
    }

    private static int getDataTypeFromNumBits(int n, boolean bl) {
        int n2 = n <= 8 ? 0 : (n <= 16 ? (bl ? 2 : 1) : 3);
        return n2;
    }

    private static boolean areIntArraysEqual(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return nArray == null && nArray2 == null;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int getDataTypeSize(int n) throws IIOException {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 8;
                break;
            }
            case 1: 
            case 2: {
                n2 = 16;
                break;
            }
            case 3: 
            case 4: {
                n2 = 32;
                break;
            }
            case 5: {
                n2 = 64;
                break;
            }
            default: {
                throw new IIOException("Unknown data type " + n);
            }
        }
        return n2;
    }

    private static int getBitsPerPixel(SampleModel sampleModel) {
        int n = 0;
        int[] nArray = sampleModel.getSampleSize();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            n += nArray[i];
        }
        return n;
    }

    private static boolean areSampleSizesEqual(SampleModel sampleModel) {
        boolean bl = true;
        int[] nArray = sampleModel.getSampleSize();
        int n = nArray[0];
        int n2 = nArray.length;
        for (int i = 1; i < n2; ++i) {
            if (nArray[i] == n) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean isDataBufferBitContiguous(SampleModel sampleModel) throws IIOException {
        int n = TIFFDecompressor.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof ComponentSampleModel) {
            int n2 = sampleModel.getNumBands();
            for (int i = 0; i < n2; ++i) {
                if (sampleModel.getSampleSize(i) == n) continue;
                return false;
            }
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            if (n % multiPixelPackedSampleModel.getPixelBitStride() != 0) {
                return false;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            int n3 = sampleModel.getNumBands();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                n4 += sampleModel.getSampleSize(i);
            }
            if (n4 != n) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void reformatData(byte[] byArray, int n, int n2, short[] sArray, int[] nArray, int n3, int n4) throws IIOException {
        if (sArray != null) {
            int n5 = 0;
            int n6 = n / 2;
            int n7 = n % 2;
            for (int i = 0; i < n2; ++i) {
                int n8 = n3;
                for (int j = 0; j < n6; ++j) {
                    sArray[n8++] = (short)((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF);
                }
                if (n7 != 0) {
                    sArray[n8++] = (short)((byArray[n5++] & 0xFF) << 8);
                }
                n3 += n4;
            }
        } else if (nArray != null) {
            int n9 = 0;
            int n10 = n / 4;
            int n11 = n % 4;
            for (int i = 0; i < n2; ++i) {
                int n12;
                int n13 = n3;
                for (n12 = 0; n12 < n10; ++n12) {
                    nArray[n13++] = (byArray[n9++] & 0xFF) << 24 | (byArray[n9++] & 0xFF) << 16 | (byArray[n9++] & 0xFF) << 8 | byArray[n9++] & 0xFF;
                }
                if (n11 != 0) {
                    n12 = 24;
                    int n14 = 0;
                    for (int j = 0; j < n11; ++j) {
                        n14 |= (byArray[n9++] & 0xFF) << n12;
                        n12 -= 8;
                    }
                    nArray[n13++] = n14;
                }
                n3 += n4;
            }
        } else {
            throw new IIOException("shortData == null && intData == null!");
        }
    }

    private static void reformatDiscontiguousData(byte[] byArray, int n, int n2, int n3, WritableRaster writableRaster) throws IOException {
        SampleModel sampleModel = writableRaster.getSampleModel();
        int n4 = sampleModel.getNumBands();
        int[] nArray = sampleModel.getSampleSize();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
        long l = 0L;
        int n5 = writableRaster.getMinY();
        int n6 = 0;
        while (n6 < n3) {
            memoryCacheImageInputStream.seek(l);
            int n7 = writableRaster.getMinX();
            int n8 = 0;
            while (n8 < n2) {
                for (int i = 0; i < n4; ++i) {
                    long l2 = memoryCacheImageInputStream.readBits(nArray[i]);
                    writableRaster.setSample(n7, n5, i, (int)l2);
                }
                ++n8;
                ++n7;
            }
            l += (long)n;
            ++n6;
            ++n5;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ImageTypeSpecifier getRawImageTypeSpecifier(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, char[] cArray) {
        int n4;
        int n5;
        if (!(n3 != 1 || nArray2[0] != 2 && nArray2[0] != 1 && nArray2[0] != 4 || nArray[0] != 1 && nArray[0] != 2 && nArray[0] != 4 && nArray[0] != 8 && nArray[0] != 16)) {
            int n6;
            if (cArray == null) {
                boolean bl;
                boolean bl2 = bl = nArray2[0] == 2;
                int n7 = nArray[0] <= 8 ? 0 : (nArray2[0] == 2 ? 2 : 1);
                return ImageTypeSpecifier.createGrayscale(nArray[0], n7, bl);
            }
            int n8 = 1 << nArray[0];
            byte[] byArray = new byte[n8];
            byte[] byArray2 = new byte[n8];
            byte[] byArray3 = new byte[n8];
            byte[] byArray4 = null;
            for (n6 = 0; n6 < n8; ++n6) {
                byArray[n6] = (byte)(cArray[n6] * 255 / 65535);
                byArray2[n6] = (byte)(cArray[n8 + n6] * 255 / 65535);
                byArray3[n6] = (byte)(cArray[2 * n8 + n6] * 255 / 65535);
            }
            n6 = nArray[0] == 8 ? 0 : 1;
            return ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, nArray[0], n6);
        }
        if (n3 == 2 && nArray[0] == 8 && nArray[1] == 8) {
            boolean bl = false;
            boolean bl3 = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl3 = true;
            }
            return ImageTypeSpecifier.createGrayscale(8, 0, false, bl3);
        }
        if (!(n3 != 2 || nArray[0] != 16 || nArray[1] != 16 || nArray2[0] != 2 && nArray2[0] != 1 || nArray2[1] != 2 && nArray2[1] != 1)) {
            int n9 = nArray2[0] == 2 ? 2 : 1;
            boolean bl = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl = true;
            }
            boolean bl4 = n9 == 2;
            return ImageTypeSpecifier.createGrayscale(16, n9, bl4, bl);
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        if (n3 == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8) {
            int[] nArray4 = new int[]{0, 1, 2};
            boolean bl = false;
            ColorSpace colorSpace2 = n == 6 && n2 != 7 && n2 != 6 || n == 8 ? ColorSpace.getInstance(1004) : colorSpace;
            return ImageTypeSpecifier.createInterleaved(colorSpace2, nArray4, 0, false, false);
        }
        if (n3 == 4 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8 && nArray[3] == 8) {
            boolean bl;
            ColorSpace colorSpace3;
            int[] nArray5 = new int[]{0, 1, 2, 3};
            boolean bl5 = false;
            boolean bl6 = false;
            if (n == 5) {
                colorSpace3 = SimpleCMYKColorSpace.getInstance();
                bl = false;
            } else {
                colorSpace3 = colorSpace;
                bl = true;
                if (nArray3 != null && nArray3[0] == 1) {
                    bl6 = true;
                }
            }
            return ImageTypeSpecifier.createInterleaved(colorSpace3, nArray5, 0, bl, bl6);
        }
        if (n3 == 3 && nArray[0] == 16 && nArray[1] == 16 && nArray[2] == 16 && (nArray2[0] == 2 || nArray2[0] == 1 || nArray2[0] == 4)) {
            int[] nArray6 = new int[]{0, 1, 2};
            int n10 = nArray2[0] == 2 ? 2 : 1;
            ColorSpace colorSpace4 = n == 6 && n2 != 7 && n2 != 6 || n == 8 ? ColorSpace.getInstance(1004) : colorSpace;
            return ImageTypeSpecifier.createInterleaved(colorSpace4, nArray6, n10, false, false);
        }
        if (n3 == 4 && nArray[0] == 16 && nArray[1] == 16 && nArray[2] == 16 && nArray[3] == 16 && (nArray2[0] == 2 || nArray2[0] == 1 || nArray2[0] == 4)) {
            int[] nArray7 = new int[]{0, 1, 2, 3};
            int n11 = nArray2[0] == 2 ? 2 : 1;
            boolean bl = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl = true;
            }
            return ImageTypeSpecifier.createInterleaved(colorSpace, nArray7, n11, true, bl);
        }
        if (n == 5 && (nArray[0] == 1 || nArray[0] == 2 || nArray[0] == 4)) {
            ColorSpace colorSpace5 = null;
            colorSpace5 = n3 == 4 ? SimpleCMYKColorSpace.getInstance() : new BogusColorSpace(n3);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace5, nArray, false, false, 1, 0);
            return new ImageTypeSpecifier(componentColorModel, ((ColorModel)componentColorModel).createCompatibleSampleModel(1, 1));
        }
        int n12 = 0;
        int[] nArray8 = nArray;
        int n13 = nArray8.length;
        for (n5 = 0; n5 < n13; ++n5) {
            n4 = nArray8[n5];
            n12 += n4;
        }
        if (!(n3 != 3 && n3 != 4 || n12 != 8 && n12 != 16)) {
            int n14 = TIFFDecompressor.createMask(nArray, 0);
            n13 = TIFFDecompressor.createMask(nArray, 1);
            n5 = TIFFDecompressor.createMask(nArray, 2);
            n4 = n3 == 4 ? TIFFDecompressor.createMask(nArray, 3) : 0;
            int n15 = n12 == 8 ? 0 : 1;
            boolean bl = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl = true;
            }
            return ImageTypeSpecifier.createPacked(colorSpace, n14, n13, n5, n4, n15, bl);
        }
        if (nArray[0] % 8 == 0) {
            boolean bl = true;
            for (n13 = 1; n13 < nArray.length; ++n13) {
                if (nArray[n13] == nArray[n13 - 1]) continue;
                bl = false;
                break;
            }
            if (bl) {
                n13 = -1;
                n5 = 0;
                switch (nArray[0]) {
                    case 8: {
                        if (nArray2[0] == 3) break;
                        n13 = 0;
                        n5 = 1;
                        break;
                    }
                    case 16: {
                        if (nArray2[0] == 2) {
                            n13 = 2;
                            n5 = 1;
                            break;
                        }
                        if (nArray2[0] == 1) {
                            n13 = 1;
                            n5 = 1;
                            break;
                        }
                        if (nArray2[0] != 3) break;
                        n13 = 4;
                        n5 = 1;
                        break;
                    }
                    case 24: 
                    case 32: {
                        n13 = nArray2[0] == 3 ? 4 : 3;
                        n5 = 1;
                    }
                }
                if (n5 != 0) {
                    void bogusColorSpace;
                    SampleModel sampleModel = TIFFDecompressor.createInterleavedSM(n13, n3);
                    if (n3 >= 1 && n3 <= 4 && (n13 == 3 || n13 == 4)) {
                        ColorSpace colorSpace2 = n3 <= 2 ? ColorSpace.getInstance(1003) : colorSpace;
                        boolean bl3 = n3 % 2 == 0;
                        boolean bl4 = false;
                        if (bl3 && nArray3 != null && nArray3[0] == 1) {
                            bl4 = true;
                        }
                        ColorModel colorModel = TIFFDecompressor.createComponentCM(colorSpace2, n3, n13, bl3, bl4);
                    } else {
                        BogusColorSpace bogusColorSpace2 = new BogusColorSpace(n3);
                        ColorModel bl10 = TIFFDecompressor.createComponentCM(bogusColorSpace2, n3, n13, false, false);
                    }
                    return new ImageTypeSpecifier((ColorModel)bogusColorSpace, sampleModel);
                }
            }
        }
        if (cArray == null && nArray2[0] != 3) {
            boolean bl;
            int bl9 = 0;
            for (int n6 : nArray) {
                if (n6 <= bl9) continue;
                bl9 = n6;
            }
            boolean bl5 = bl = nArray2[0] == 2;
            if (n3 == 1) {
                n5 = TIFFDecompressor.getDataTypeFromNumBits(bl9, bl);
                return ImageTypeSpecifier.createGrayscale(bl9, n5, bl);
            }
            if (n3 == 2) {
                n5 = 0;
                if (nArray3 != null && nArray3[0] == 1) {
                    n5 = 1;
                }
                n4 = TIFFDecompressor.getDataTypeFromNumBits(bl9, bl);
                return ImageTypeSpecifier.createGrayscale(bl9, n4, false, n5 != 0);
            }
            if (n3 == 3 || n3 == 4) {
                if (n12 <= 32 && !bl) {
                    n5 = TIFFDecompressor.createMask(nArray, 0);
                    n4 = TIFFDecompressor.createMask(nArray, 1);
                    int n7 = TIFFDecompressor.createMask(nArray, 2);
                    int n8 = n3 == 4 ? TIFFDecompressor.createMask(nArray, 3) : 0;
                    int n9 = TIFFDecompressor.getDataTypeFromNumBits(n12, false);
                    boolean bl6 = false;
                    if (nArray3 != null && nArray3[0] == 1) {
                        bl6 = true;
                    }
                    return ImageTypeSpecifier.createPacked(colorSpace, n5, n4, n7, n8, n9, bl6);
                }
                if (n3 == 3) {
                    int[] nArray9 = new int[]{0, 1, 2};
                    n4 = TIFFDecompressor.getDataTypeFromNumBits(bl9, bl);
                    return ImageTypeSpecifier.createInterleaved(colorSpace, nArray9, n4, false, false);
                }
                if (n3 == 4) {
                    boolean bl7;
                    int[] nArray10 = new int[]{0, 1, 2, 3};
                    n4 = TIFFDecompressor.getDataTypeFromNumBits(bl9, bl);
                    boolean bl8 = false;
                    if (nArray3 != null && nArray3[0] == 1) {
                        bl7 = true;
                    }
                    return ImageTypeSpecifier.createInterleaved(colorSpace, nArray10, n4, true, bl7);
                }
            } else {
                n5 = TIFFDecompressor.getDataTypeFromNumBits(bl9, bl);
                SampleModel sampleModel = TIFFDecompressor.createInterleavedSM(n5, n3);
                BogusColorSpace bogusColorSpace = new BogusColorSpace(n3);
                ColorModel colorModel = TIFFDecompressor.createComponentCM(bogusColorSpace, n3, n5, false, false);
                return new ImageTypeSpecifier(colorModel, sampleModel);
            }
        }
        return null;
    }

    public void setReader(ImageReader imageReader) {
        this.reader = imageReader;
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        this.metadata = iIOMetadata;
    }

    public void setPhotometricInterpretation(int n) {
        this.photometricInterpretation = n;
    }

    public void setCompression(int n) {
        this.compression = n;
    }

    public void setPlanar(boolean bl) {
        this.planar = bl;
    }

    public void setSamplesPerPixel(int n) {
        this.samplesPerPixel = n;
    }

    public void setBitsPerSample(int[] nArray) {
        this.bitsPerSample = nArray == null ? null : (int[])nArray.clone();
    }

    public void setSampleFormat(int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = 1;
        } else {
            nArray2 = (int[])nArray.clone();
        }
        this.sampleFormat = nArray2;
    }

    public void setExtraSamples(int[] nArray) {
        this.extraSamples = nArray == null ? null : (int[])nArray.clone();
    }

    public void setColorMap(char[] cArray) {
        this.colorMap = cArray == null ? null : (char[])cArray.clone();
    }

    public void setStream(ImageInputStream imageInputStream) {
        this.stream = imageInputStream;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public void setByteCount(int n) {
        this.byteCount = n;
    }

    public void setSrcMinX(int n) {
        this.srcMinX = n;
    }

    public void setSrcMinY(int n) {
        this.srcMinY = n;
    }

    public void setSrcWidth(int n) {
        this.srcWidth = n;
    }

    public void setSrcHeight(int n) {
        this.srcHeight = n;
    }

    public void setSourceXOffset(int n) {
        this.sourceXOffset = n;
    }

    public void setDstXOffset(int n) {
        this.dstXOffset = n;
    }

    public void setSourceYOffset(int n) {
        this.sourceYOffset = n;
    }

    public void setDstYOffset(int n) {
        this.dstYOffset = n;
    }

    public void setSubsampleX(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("subsampleX <= 0!");
        }
        this.subsampleX = n;
    }

    public void setSubsampleY(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("subsampleY <= 0!");
        }
        this.subsampleY = n;
    }

    public void setSourceBands(int[] nArray) {
        this.sourceBands = nArray == null ? null : (int[])nArray.clone();
    }

    public void setDestinationBands(int[] nArray) {
        this.destinationBands = nArray == null ? null : (int[])nArray.clone();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void setDstMinX(int n) {
        this.dstMinX = n;
    }

    public void setDstMinY(int n) {
        this.dstMinY = n;
    }

    public void setDstWidth(int n) {
        this.dstWidth = n;
    }

    public void setDstHeight(int n) {
        this.dstHeight = n;
    }

    public void setActiveSrcMinX(int n) {
        this.activeSrcMinX = n;
    }

    public void setActiveSrcMinY(int n) {
        this.activeSrcMinY = n;
    }

    public void setActiveSrcWidth(int n) {
        this.activeSrcWidth = n;
    }

    public void setActiveSrcHeight(int n) {
        this.activeSrcHeight = n;
    }

    public void setColorConverter(TIFFColorConverter tIFFColorConverter) {
        this.colorConverter = tIFFColorConverter;
    }

    public ImageTypeSpecifier getRawImageType() {
        ImageTypeSpecifier imageTypeSpecifier = TIFFDecompressor.getRawImageTypeSpecifier(this.photometricInterpretation, this.compression, this.samplesPerPixel, this.bitsPerSample, this.sampleFormat, this.extraSamples, this.colorMap);
        return imageTypeSpecifier;
    }

    public BufferedImage createRawImage() {
        if (this.planar) {
            int n = this.bitsPerSample[this.sourceBands[0]];
            int n2 = this.sampleFormat[0] == 3 ? 4 : (n <= 8 ? 0 : (n <= 16 ? (this.sampleFormat[0] == 2 ? 2 : 1) : 3));
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            ImageTypeSpecifier imageTypeSpecifier = null;
            if (n == 1 || n == 2 || n == 4) {
                int n3 = n;
                int n4 = 1 << n3;
                byte[] byArray = new byte[n4];
                byte[] byArray2 = new byte[n4];
                byte[] byArray3 = new byte[n4];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = 0;
                    byArray2[i] = 0;
                    byArray3[i] = 0;
                }
                IndexColorModel indexColorModel = new IndexColorModel(n3, n4, byArray, byArray2, byArray3);
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, 1, 1, n3);
                imageTypeSpecifier = new ImageTypeSpecifier(indexColorModel, multiPixelPackedSampleModel);
            } else {
                imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0}, n2, false, false);
            }
            return imageTypeSpecifier.createBufferedImage(this.srcWidth, this.srcHeight);
        }
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType();
        if (imageTypeSpecifier == null) {
            return null;
        }
        return imageTypeSpecifier.createBufferedImage(this.srcWidth, this.srcHeight);
    }

    public abstract void decodeRaw(byte[] var1, int var2, int var3, int var4) throws IOException;

    public void decodeRaw(short[] sArray, int n, int n2, int n3) throws IOException {
        int n4 = (this.srcWidth * n2 + 7) / 8;
        int n5 = n4 / 2;
        byte[] byArray = new byte[n4 * this.srcHeight];
        this.decodeRaw(byArray, 0, n2, n4);
        int n6 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < this.srcHeight; ++i) {
                for (int j = 0; j < n5; ++j) {
                    short s;
                    short s2 = byArray[n6++];
                    short s3 = byArray[n6++];
                    sArray[n + j] = s = (short)(s2 << 8 | s3 & 0xFF);
                }
                n += n3;
            }
        } else {
            for (int i = 0; i < this.srcHeight; ++i) {
                for (int j = 0; j < n5; ++j) {
                    short s;
                    short s4 = byArray[n6++];
                    short s5 = byArray[n6++];
                    sArray[n + j] = s = (short)(s5 << 8 | s4 & 0xFF);
                }
                n += n3;
            }
        }
    }

    public void decodeRaw(int[] nArray, int n, int n2, int n3) throws IOException {
        int n4 = n2 / 32;
        int n5 = this.srcWidth * n4;
        int n6 = n5 * 4;
        byte[] byArray = new byte[n6 * this.srcHeight];
        this.decodeRaw(byArray, 0, n2, n6);
        int n7 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < this.srcHeight; ++i) {
                for (int j = 0; j < n5; ++j) {
                    int n8;
                    int n9 = byArray[n7++] & 0xFF;
                    int n10 = byArray[n7++] & 0xFF;
                    int n11 = byArray[n7++] & 0xFF;
                    int n12 = byArray[n7++] & 0xFF;
                    nArray[n + j] = n8 = n9 << 24 | n10 << 16 | n11 << 8 | n12;
                }
                n += n3;
            }
        } else {
            for (int i = 0; i < this.srcHeight; ++i) {
                for (int j = 0; j < n5; ++j) {
                    int n13;
                    int n14 = byArray[n7++] & 0xFF;
                    int n15 = byArray[n7++] & 0xFF;
                    int n16 = byArray[n7++] & 0xFF;
                    int n17 = byArray[n7++] & 0xFF;
                    nArray[n + j] = n13 = n17 << 24 | n16 << 16 | n15 << 8 | n14;
                }
                n += n3;
            }
        }
    }

    public void decodeRaw(float[] fArray, int n, int n2, int n3) throws IOException {
        int n4 = n2 / 32;
        int n5 = this.srcWidth * n4;
        int n6 = n5 * 4;
        byte[] byArray = new byte[n6 * this.srcHeight];
        this.decodeRaw(byArray, 0, n2, n6);
        int n7 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < this.srcHeight; ++i) {
                for (int j = 0; j < n5; ++j) {
                    float f;
                    int n8 = byArray[n7++] & 0xFF;
                    int n9 = byArray[n7++] & 0xFF;
                    int n10 = byArray[n7++] & 0xFF;
                    int n11 = byArray[n7++] & 0xFF;
                    int n12 = n8 << 24 | n9 << 16 | n10 << 8 | n11;
                    fArray[n + j] = f = Float.intBitsToFloat(n12);
                }
                n += n3;
            }
        } else {
            for (int i = 0; i < this.srcHeight; ++i) {
                for (int j = 0; j < n5; ++j) {
                    float f;
                    int n13 = byArray[n7++] & 0xFF;
                    int n14 = byArray[n7++] & 0xFF;
                    int n15 = byArray[n7++] & 0xFF;
                    int n16 = byArray[n7++] & 0xFF;
                    int n17 = n16 << 24 | n15 << 16 | n14 << 8 | n13;
                    fArray[n + j] = f = Float.intBitsToFloat(n17);
                }
                n += n3;
            }
        }
    }

    public void beginDecoding() {
        int n;
        int n2;
        int n3;
        this.adjustBitDepths = false;
        int n4 = this.destinationBands.length;
        int[] nArray = null;
        if (this.planar) {
            n3 = this.bitsPerSample.length;
            nArray = new int[n3];
            n2 = this.image.getSampleModel().getSampleSize(0);
            for (n = 0; n < n3; ++n) {
                nArray[n] = n2;
            }
        } else {
            nArray = this.image.getSampleModel().getSampleSize();
        }
        if (this.photometricInterpretation != 5 || this.bitsPerSample[0] != 1 && this.bitsPerSample[0] != 2 && this.bitsPerSample[0] != 4) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (nArray[this.destinationBands[n3]] == this.bitsPerSample[this.sourceBands[n3]]) continue;
                this.adjustBitDepths = true;
                break;
            }
        }
        if (this.adjustBitDepths) {
            if (!(!this.isFirstBitDepthTable && this.planar == this.planarCache && TIFFDecompressor.areIntArraysEqual(nArray, this.destBitsPerSampleCache) && TIFFDecompressor.areIntArraysEqual(this.sourceBands, this.sourceBandsCache) && TIFFDecompressor.areIntArraysEqual(this.bitsPerSample, this.bitsPerSampleCache) && TIFFDecompressor.areIntArraysEqual(this.destinationBands, this.destinationBandsCache))) {
                this.isFirstBitDepthTable = false;
                this.planarCache = this.planar;
                this.destBitsPerSampleCache = (int[])nArray.clone();
                this.sourceBandsCache = this.sourceBands == null ? null : (int[])this.sourceBands.clone();
                this.bitsPerSampleCache = this.bitsPerSample == null ? null : (int[])this.bitsPerSample.clone();
                this.destinationBandsCache = this.destinationBands == null ? null : (int[])this.destinationBands.clone();
                this.bitDepthScale = new int[n4][];
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = (1 << this.bitsPerSample[this.sourceBands[n3]]) - 1;
                    n = n2 / 2;
                    int n5 = (1 << nArray[this.destinationBands[n3]]) - 1;
                    this.bitDepthScale[n3] = new int[n2 + 1];
                    for (int i = 0; i <= n2; ++i) {
                        this.bitDepthScale[n3][i] = (i * n5 + n) / n2;
                    }
                }
            }
        } else {
            this.bitDepthScale = null;
        }
        n3 = 0;
        n2 = 0;
        if (n4 == this.samplesPerPixel) {
            n3 = 1;
            n2 = 1;
            for (n = 0; n < n4; ++n) {
                if (this.sourceBands[n] != n) {
                    n3 = 0;
                }
                if (this.destinationBands[n] == n) continue;
                n2 = 0;
            }
        }
        this.isBilevel = ImageUtil.isBinary(this.image.getRaster().getSampleModel());
        this.isContiguous = this.isBilevel ? true : ImageUtil.imageIsContiguous(this.image);
        this.isImageSimple = this.colorConverter == null && this.subsampleX == 1 && this.subsampleY == 1 && this.srcWidth == this.dstWidth && this.srcHeight == this.dstHeight && this.dstMinX + this.dstWidth <= this.image.getWidth() && this.dstMinY + this.dstHeight <= this.image.getHeight() && n3 != 0 && n2 != 0 && !this.adjustBitDepths;
    }

    public void decode() throws IOException {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        boolean bl;
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        this.rawImage = null;
        if (this.isImageSimple) {
            if (this.isBilevel) {
                this.rawImage = this.image;
            } else if (this.isContiguous) {
                this.rawImage = this.image.getSubimage(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight);
            }
        }
        boolean bl2 = bl = this.rawImage != null;
        if (this.rawImage == null) {
            this.rawImage = this.createRawImage();
            if (this.rawImage == null) {
                throw new IIOException("Couldn't create image buffer!");
            }
        }
        WritableRaster writableRaster = this.rawImage.getRaster();
        if (this.isBilevel) {
            object4 = this.isImageSimple ? new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight) : writableRaster.getBounds();
            byArray = ImageUtil.getPackedBinaryData(writableRaster, (Rectangle)object4);
            n2 = 0;
            n3 = 1;
            n4 = (((Rectangle)object4).width + 7) / 8;
        } else {
            object4 = writableRaster.getSampleModel();
            object3 = writableRaster.getDataBuffer();
            n = 0;
            if (object4 instanceof ComponentSampleModel) {
                object2 = (ComponentSampleModel)object4;
                n2 = ((ComponentSampleModel)object2).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n4 = ((ComponentSampleModel)object2).getScanlineStride();
                if (object3 instanceof DataBufferByte) {
                    object = (DataBufferByte)object3;
                    byArray = ((DataBufferByte)object).getData();
                    n3 = ((ComponentSampleModel)object2).getPixelStride() * 8;
                    n = 1;
                } else if (object3 instanceof DataBufferUShort) {
                    object = (DataBufferUShort)object3;
                    sArray = ((DataBufferUShort)object).getData();
                    n3 = ((ComponentSampleModel)object2).getPixelStride() * 16;
                    n = 1;
                } else if (object3 instanceof DataBufferShort) {
                    object = (DataBufferShort)object3;
                    sArray = ((DataBufferShort)object).getData();
                    n3 = ((ComponentSampleModel)object2).getPixelStride() * 16;
                    n = 1;
                } else if (object3 instanceof DataBufferInt) {
                    object = (DataBufferInt)object3;
                    nArray = ((DataBufferInt)object).getData();
                    n3 = ((ComponentSampleModel)object2).getPixelStride() * 32;
                    n = 1;
                } else if (object3 instanceof DataBufferFloat) {
                    object = (DataBufferFloat)object3;
                    fArray = ((DataBufferFloat)object).getData();
                    n3 = ((ComponentSampleModel)object2).getPixelStride() * 32;
                    n = 1;
                }
            } else if (object4 instanceof MultiPixelPackedSampleModel) {
                object2 = (MultiPixelPackedSampleModel)object4;
                n2 = ((MultiPixelPackedSampleModel)object2).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n3 = ((MultiPixelPackedSampleModel)object2).getPixelBitStride();
                n4 = ((MultiPixelPackedSampleModel)object2).getScanlineStride();
                if (object3 instanceof DataBufferByte) {
                    object = (DataBufferByte)object3;
                    byArray = ((DataBufferByte)object).getData();
                    n = 1;
                } else if (object3 instanceof DataBufferUShort) {
                    object = (DataBufferUShort)object3;
                    sArray = ((DataBufferUShort)object).getData();
                    n = 1;
                } else if (object3 instanceof DataBufferInt) {
                    object = (DataBufferInt)object3;
                    nArray = ((DataBufferInt)object).getData();
                    n = 1;
                }
            } else if (object4 instanceof SinglePixelPackedSampleModel) {
                object2 = (SinglePixelPackedSampleModel)object4;
                n2 = ((SinglePixelPackedSampleModel)object2).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n4 = ((SinglePixelPackedSampleModel)object2).getScanlineStride();
                if (object3 instanceof DataBufferByte) {
                    object = (DataBufferByte)object3;
                    byArray = ((DataBufferByte)object).getData();
                    n3 = 8;
                    n = 1;
                } else if (object3 instanceof DataBufferUShort) {
                    object = (DataBufferUShort)object3;
                    sArray = ((DataBufferUShort)object).getData();
                    n3 = 16;
                    n = 1;
                } else if (object3 instanceof DataBufferInt) {
                    object = (DataBufferInt)object3;
                    nArray = ((DataBufferInt)object).getData();
                    n3 = 32;
                    n = 1;
                }
            }
            if (n == 0) {
                throw new IIOException("Unsupported raw image type: SampleModel = " + object4 + "; DataBuffer = " + object3);
            }
        }
        if (this.isBilevel) {
            this.decodeRaw(byArray, n2, n3, n4);
        } else {
            object4 = writableRaster.getSampleModel();
            if (TIFFDecompressor.isDataBufferBitContiguous((SampleModel)object4)) {
                if (byArray != null) {
                    this.decodeRaw(byArray, n2, n3, n4);
                } else if (fArray != null) {
                    this.decodeRaw(fArray, n2, n3, n4);
                } else if (sArray != null) {
                    if (TIFFDecompressor.areSampleSizesEqual((SampleModel)object4) && ((SampleModel)object4).getSampleSize(0) == 16) {
                        this.decodeRaw(sArray, n2, n3, n4);
                    } else {
                        int n5 = TIFFDecompressor.getBitsPerPixel((SampleModel)object4);
                        n = (n5 * this.srcWidth + 7) / 8;
                        object2 = new byte[n * this.srcHeight];
                        this.decodeRaw((byte[])object2, 0, n5, n);
                        TIFFDecompressor.reformatData((byte[])object2, n, this.srcHeight, sArray, null, n2, n4);
                    }
                } else if (nArray != null) {
                    if (TIFFDecompressor.areSampleSizesEqual((SampleModel)object4) && ((SampleModel)object4).getSampleSize(0) == 32) {
                        this.decodeRaw(nArray, n2, n3, n4);
                    } else {
                        int n6 = TIFFDecompressor.getBitsPerPixel((SampleModel)object4);
                        n = (n6 * this.srcWidth + 7) / 8;
                        object2 = new byte[n * this.srcHeight];
                        this.decodeRaw((byte[])object2, 0, n6, n);
                        TIFFDecompressor.reformatData((byte[])object2, n, this.srcHeight, null, nArray, n2, n4);
                    }
                }
            } else {
                int n7 = TIFFDecompressor.getBitsPerPixel((SampleModel)object4);
                n = (n7 * this.srcWidth + 7) / 8;
                object2 = new byte[n * this.srcHeight];
                this.decodeRaw((byte[])object2, 0, n7, n);
                TIFFDecompressor.reformatDiscontiguousData((byte[])object2, n, this.srcWidth, this.srcHeight, writableRaster);
            }
        }
        if (this.colorConverter != null) {
            float f;
            float f2;
            object4 = new float[3];
            if (byArray != null) {
                for (int i = 0; i < this.dstHeight; ++i) {
                    n = n2;
                    for (int j = 0; j < this.dstWidth; ++j) {
                        float f3 = byArray[n] & 0xFF;
                        f2 = byArray[n + 1] & 0xFF;
                        f = byArray[n + 2] & 0xFF;
                        this.colorConverter.toRGB(f3, f2, f, (float[])object4);
                        byArray[n] = (byte)((int)object4[0]);
                        byArray[n + 1] = (byte)((int)object4[1]);
                        byArray[n + 2] = (byte)((int)object4[2]);
                        n += 3;
                    }
                    n2 += n4;
                }
            } else if (sArray != null) {
                if (this.sampleFormat[0] == 2) {
                    for (int i = 0; i < this.dstHeight; ++i) {
                        n = n2;
                        for (int j = 0; j < this.dstWidth; ++j) {
                            float f4 = sArray[n];
                            f2 = sArray[n + 1];
                            f = sArray[n + 2];
                            this.colorConverter.toRGB(f4, f2, f, (float[])object4);
                            sArray[n] = (short)((int)object4[0]);
                            sArray[n + 1] = (short)((int)object4[1]);
                            sArray[n + 2] = (short)((int)object4[2]);
                            n += 3;
                        }
                        n2 += n4;
                    }
                } else {
                    for (int i = 0; i < this.dstHeight; ++i) {
                        n = n2;
                        for (int j = 0; j < this.dstWidth; ++j) {
                            float f5 = sArray[n] & 0xFFFF;
                            f2 = sArray[n + 1] & 0xFFFF;
                            f = sArray[n + 2] & 0xFFFF;
                            this.colorConverter.toRGB(f5, f2, f, (float[])object4);
                            sArray[n] = (short)((int)object4[0]);
                            sArray[n + 1] = (short)((int)object4[1]);
                            sArray[n + 2] = (short)((int)object4[2]);
                            n += 3;
                        }
                        n2 += n4;
                    }
                }
            } else if (nArray != null) {
                for (int i = 0; i < this.dstHeight; ++i) {
                    n = n2;
                    for (int j = 0; j < this.dstWidth; ++j) {
                        float f6 = nArray[n];
                        f2 = nArray[n + 1];
                        f = nArray[n + 2];
                        this.colorConverter.toRGB(f6, f2, f, (float[])object4);
                        nArray[n] = (int)object4[0];
                        nArray[n + 1] = (int)object4[1];
                        nArray[n + 2] = (int)object4[2];
                        n += 3;
                    }
                    n2 += n4;
                }
            } else if (fArray != null) {
                for (int i = 0; i < this.dstHeight; ++i) {
                    n = n2;
                    for (int j = 0; j < this.dstWidth; ++j) {
                        float f7 = fArray[n];
                        f2 = fArray[n + 1];
                        f = fArray[n + 2];
                        this.colorConverter.toRGB(f7, f2, f, (float[])object4);
                        fArray[n] = (float)object4[0];
                        fArray[n + 1] = (float)object4[1];
                        fArray[n + 2] = (float)object4[2];
                        n += 3;
                    }
                    n2 += n4;
                }
            }
        }
        if (this.photometricInterpretation == 0) {
            if (byArray != null) {
                int n8 = (this.srcWidth * n3 + 7) / 8;
                for (int i = 0; i < this.srcHeight; ++i) {
                    n = n2 + i * n4;
                    for (int j = 0; j < n8; ++j) {
                        int n9 = n + j;
                        byArray[n9] = (byte)(byArray[n9] ^ 0xFF);
                    }
                }
            } else if (sArray != null) {
                int n10;
                int n11 = (this.srcWidth * n3 + 15) / 16;
                if (this.sampleFormat[0] == 2) {
                    for (n10 = 0; n10 < this.srcHeight; ++n10) {
                        n = n2 + n10 * n4;
                        for (int i = 0; i < n11; ++i) {
                            int n12 = n + i;
                            sArray[n12] = (short)(Short.MAX_VALUE - sArray[n12]);
                        }
                    }
                } else {
                    for (n10 = 0; n10 < this.srcHeight; ++n10) {
                        n = n2 + n10 * n4;
                        for (int i = 0; i < n11; ++i) {
                            int n13 = n + i;
                            sArray[n13] = (short)(sArray[n13] ^ 0xFFFF);
                        }
                    }
                }
            } else if (nArray != null) {
                int n14 = (this.srcWidth * n3 + 15) / 16;
                for (int i = 0; i < this.srcHeight; ++i) {
                    n = n2 + i * n4;
                    for (int j = 0; j < n14; ++j) {
                        int n15 = n + j;
                        nArray[n15] = Integer.MAX_VALUE - nArray[n15];
                    }
                }
            } else if (fArray != null) {
                int n16 = (this.srcWidth * n3 + 15) / 16;
                for (int i = 0; i < this.srcHeight; ++i) {
                    n = n2 + i * n4;
                    for (int j = 0; j < n16; ++j) {
                        int n17 = n + j;
                        fArray[n17] = 1.0f - fArray[n17];
                    }
                }
            }
        }
        if (this.isBilevel) {
            Rectangle rectangle = this.isImageSimple ? new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight) : writableRaster.getBounds();
            ImageUtil.setPackedBinaryData(byArray, writableRaster, rectangle);
        }
        if (bl) {
            return;
        }
        WritableRaster writableRaster2 = this.rawImage.getRaster();
        object3 = writableRaster2.createChild(0, 0, this.srcWidth, this.srcHeight, this.srcMinX, this.srcMinY, this.planar ? null : this.sourceBands);
        WritableRaster writableRaster3 = this.image.getRaster();
        object2 = writableRaster3.createWritableChild(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight, this.dstMinX, this.dstMinY, this.destinationBands);
        if (this.subsampleX == 1 && this.subsampleY == 1 && !this.adjustBitDepths) {
            object3 = ((Raster)object3).createChild(this.activeSrcMinX, this.activeSrcMinY, this.activeSrcWidth, this.activeSrcHeight, this.dstMinX, this.dstMinY, null);
            ((WritableRaster)object2).setRect((Raster)object3);
        } else if (this.subsampleX == 1 && !this.adjustBitDepths) {
            int n18 = this.activeSrcMinY;
            int n19 = this.dstMinY;
            while (n18 < this.srcMinY + this.srcHeight) {
                Raster raster = ((Raster)object3).createChild(this.activeSrcMinX, n18, this.activeSrcWidth, 1, this.dstMinX, n19, null);
                ((WritableRaster)object2).setRect(raster);
                n18 += this.subsampleY;
                ++n19;
            }
        } else {
            object = ((Raster)object3).getPixel(this.srcMinX, this.srcMinY, (int[])null);
            int n20 = ((Object)object).length;
            int n21 = this.activeSrcMinY;
            int n22 = this.dstMinY;
            while (n21 < this.activeSrcMinY + this.activeSrcHeight) {
                int n23 = this.activeSrcMinX;
                int n24 = this.dstMinX;
                while (n23 < this.activeSrcMinX + this.activeSrcWidth) {
                    ((Raster)object3).getPixel(n23, n21, (int[])object);
                    if (this.adjustBitDepths) {
                        for (int i = 0; i < n20; ++i) {
                            object[i] = this.bitDepthScale[i][object[i]];
                        }
                    }
                    ((WritableRaster)object2).setPixel(n24, n22, (int[])object);
                    n23 += this.subsampleX;
                    ++n24;
                }
                n21 += this.subsampleY;
                ++n22;
            }
        }
    }

    public void decodeSpecial(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = this.planar ? 1 : this.samplesPerPixel;
        ByteOrder byteOrder = this.stream.getByteOrder();
        if (n3 == 1 && this.sampleFormat[0] == 3) {
            if (n2 == 16) {
                byte[] byArray2 = new byte[byArray.length];
                for (int i = 0; i < this.srcHeight; ++i) {
                    int n5 = (n + n4 * i * this.srcWidth) * 2;
                    int n6 = (n + n4 * i * this.srcWidth) * 4;
                    for (int j = 0; j < this.srcWidth * n4; ++j) {
                        int n7;
                        int n8;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            n8 = ((byArray[n5 + 1] & 0xFF) << 8 | byArray[n5] & 0xFF) & 0xFFFF;
                            n7 = O.\u00d400000(n8);
                            byArray2[n6] = (byte)(n7 & 0xFF);
                            byArray2[n6 + 1] = (byte)(n7 >> 8 & 0xFF);
                            byArray2[n6 + 2] = (byte)(n7 >> 16 & 0xFF);
                            byArray2[n6 + 3] = (byte)(n7 >> 24 & 0xFF);
                        } else {
                            n8 = ((byArray[n5] & 0xFF) << 8 | byArray[n5 + 1] & 0xFF) & 0xFFFF;
                            n7 = O.\u00d400000(n8);
                            byArray2[n6 + 3] = (byte)(n7 & 0xFF);
                            byArray2[n6 + 2] = (byte)(n7 >> 8 & 0xFF);
                            byArray2[n6 + 1] = (byte)(n7 >> 16 & 0xFF);
                            byArray2[n6] = (byte)(n7 >> 24 & 0xFF);
                        }
                        n5 += 2;
                        n6 += 4;
                    }
                }
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                this.adjustBitDepths = false;
            } else if (n2 == 24) {
                byte[] byArray3 = new byte[byArray.length];
                for (int i = 0; i < this.srcHeight; ++i) {
                    int n9 = (n + n4 * i * this.srcWidth) * 3;
                    int n10 = (n + n4 * i * this.srcWidth) * 4;
                    for (int j = 0; j < this.srcWidth * n4; ++j) {
                        int n11;
                        int n12;
                        if (byteOrder == ByteOrder.BIG_ENDIAN) {
                            n12 = (byArray[n9] & 0xFF) << 16 | (byArray[n9 + 1] & 0xFF) << 8 | byArray[n9 + 2] & 0xFF;
                            n11 = O.o00000(n12);
                            byArray3[n10 + 3] = (byte)(n11 & 0xFF);
                            byArray3[n10 + 2] = (byte)(n11 >> 8 & 0xFF);
                            byArray3[n10 + 1] = (byte)(n11 >> 16 & 0xFF);
                            byArray3[n10] = (byte)(n11 >> 24 & 0xFF);
                        } else {
                            n12 = (byArray[n9 + 2] & 0xFF) << 16 | (byArray[n9 + 1] & 0xFF) << 8 | byArray[n9] & 0xFF;
                            n11 = O.o00000(n12);
                            byArray3[n10] = (byte)(n11 & 0xFF);
                            byArray3[n10 + 1] = (byte)(n11 >> 8 & 0xFF);
                            byArray3[n10 + 2] = (byte)(n11 >> 16 & 0xFF);
                            byArray3[n10 + 3] = (byte)(n11 >> 24 & 0xFF);
                        }
                        n9 += 3;
                        n10 += 4;
                    }
                }
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                this.adjustBitDepths = false;
            } else {
                this.adjustBitDepths = false;
            }
        } else if (n3 == 2) {
            if (n2 == 8) {
                for (int i = 0; i < this.srcHeight; ++i) {
                    int n13 = n + n4 * (i * this.srcWidth + 1);
                    for (int j = n4; j < this.srcWidth * n4; ++j) {
                        int n14 = n13;
                        byArray[n14] = (byte)(byArray[n14] + byArray[n13 - n4]);
                        ++n13;
                    }
                }
            } else if (n2 == 16) {
                int n15 = n4 * 2;
                for (int i = 0; i < this.srcHeight; ++i) {
                    int n16 = (n + n4 * (i * this.srcWidth + 1)) * 2;
                    for (int j = n4; j < this.srcWidth * n4; ++j) {
                        int n17 = ((byArray[n16 - n15 + 1] & 0xFF) << 8 | byArray[n16 - n15] & 0xFF) & 0xFFFF;
                        int n18 = ((byArray[n16 + 1] & 0xFF) << 8 | byArray[n16] & 0xFF) & 0xFFFF;
                        int n19 = n18 + n17 & 0xFFFF;
                        byArray[n16 + 1] = (byte)(n19 >> 8 & 0xFF);
                        byArray[n16] = (byte)(n19 & 0xFF);
                        n16 += 2;
                    }
                }
            } else if (n2 == 32) {
                int n20 = n4 * 4;
                for (int i = 0; i < this.srcHeight; ++i) {
                    int n21 = (n + n4 * (i * this.srcWidth + 1)) * 4;
                    for (int j = n4; j < this.srcWidth * n4; ++j) {
                        int n22 = (byArray[n21 - n20 + 3] & 0xFF) << 24 | (byArray[n21 - n20 + 2] & 0xFF) << 16 | (byArray[n21 - n20 + 1] & 0xFF) << 8 | byArray[n21 - n20] & 0xFF;
                        int n23 = (byArray[n21 + 3] & 0xFF) << 24 | (byArray[n21 + 2] & 0xFF) << 16 | (byArray[n21 + 1] & 0xFF) << 8 | byArray[n21] & 0xFF;
                        int n24 = n23 + n22 & 0xFFFFFFFF;
                        byArray[n21 + 3] = (byte)(n24 >> 24 & 0xFF);
                        byArray[n21 + 2] = (byte)(n24 >> 16 & 0xFF);
                        byArray[n21 + 1] = (byte)(n24 >> 8 & 0xFF);
                        byArray[n21] = (byte)(n24 & 0xFF);
                        n21 += 4;
                    }
                }
            }
        } else if (n3 == 3) {
            int n25;
            int n26;
            int n27;
            int n28;
            int n29;
            int n30;
            byte[] byArray4 = new byte[byArray.length];
            this.adjustBitDepths = false;
            int n31 = 0;
            int n32 = 4;
            if (n2 == 8) {
                throw new IIOException("TIFF with 8-bit floating predictor is not supported!");
            }
            if (n2 == 16) {
                n31 = 2;
            } else if (n2 == 24) {
                n31 = 3;
            } else if (n2 == 32) {
                n31 = 4;
            }
            for (n30 = 0; n30 < this.srcHeight; ++n30) {
                n29 = this.srcWidth * n31 * n30 * n4;
                for (n28 = 1; n28 < this.srcWidth * n31; ++n28) {
                    for (n27 = 0; n27 < n4; ++n27) {
                        n26 = n28 * n4 + n27 + n29;
                        n25 = (n28 - 1) * n4 + n27 + n29;
                        int n33 = n26;
                        byArray[n33] = (byte)(byArray[n33] + byArray[n25]);
                    }
                }
            }
            for (n30 = 0; n30 < this.srcHeight; ++n30) {
                n29 = n30 * this.srcWidth * n4 * n31;
                n28 = this.srcWidth * n4;
                for (n27 = 0; n27 < n28; ++n27) {
                    for (n26 = 0; n26 < n31; ++n26) {
                        n25 = n31 * n27 + n26 + n29;
                        byArray4[n25] = byteOrder == ByteOrder.BIG_ENDIAN ? byArray[n26 * n28 + n27 + n29] : byArray[(n31 - n26 - 1) * n28 + n27 + n29];
                    }
                }
            }
            if (n31 != 4) {
                for (n30 = 0; n30 < this.srcHeight; ++n30) {
                    n29 = n30 * this.srcWidth * n4 * n31;
                    n28 = n30 * this.srcWidth * n4 * 4;
                    n27 = 0;
                    n26 = 0;
                    n25 = 0;
                    while (n27 < this.srcWidth * n4) {
                        int n34;
                        int n35;
                        int n36 = n26 + n29;
                        int n37 = n25 + n28;
                        if (n31 == 2) {
                            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                                n35 = (byArray4[n36 + 1] & 0xFF) << 8 | byArray4[n36] & 0xFF;
                                n34 = O.\u00d400000(n35);
                                byArray[n37] = (byte)(n34 & 0xFF);
                                byArray[n37 + 1] = (byte)(n34 >> 8 & 0xFF);
                                byArray[n37 + 2] = (byte)(n34 >> 16 & 0xFF);
                                byArray[n37 + 3] = (byte)(n34 >> 24 & 0xFF);
                            } else {
                                n35 = (byArray4[n36] & 0xFF) << 8 | byArray4[n36 + 1] & 0xFF;
                                n34 = O.\u00d400000(n35);
                                byArray[n37 + 3] = (byte)(n34 & 0xFF);
                                byArray[n37 + 2] = (byte)(n34 >> 8 & 0xFF);
                                byArray[n37 + 1] = (byte)(n34 >> 16 & 0xFF);
                                byArray[n37] = (byte)(n34 >> 24 & 0xFF);
                            }
                        } else if (n31 == 3) {
                            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                                n35 = (byArray4[n36 + 2] & 0xFF) << 16 | (byArray4[n36 + 1] & 0xFF) << 8 | byArray4[n36] & 0xFF;
                                n34 = O.o00000(n35);
                                byArray[n37] = (byte)(n34 & 0xFF);
                                byArray[n37 + 1] = (byte)(n34 >> 8 & 0xFF);
                                byArray[n37 + 2] = (byte)(n34 >> 16 & 0xFF);
                                byArray[n37 + 3] = (byte)(n34 >> 24 & 0xFF);
                            } else {
                                n35 = (byArray4[n36] & 0xFF) << 16 | (byArray4[n36 + 1] & 0xFF) << 8 | byArray4[n36 + 2] & 0xFF;
                                n34 = O.o00000(n35);
                                byArray[n37 + 3] = (byte)(n34 & 0xFF);
                                byArray[n37 + 2] = (byte)(n34 >> 8 & 0xFF);
                                byArray[n37 + 1] = (byte)(n34 >> 16 & 0xFF);
                                byArray[n37] = (byte)(n34 >> 24 & 0xFF);
                            }
                        }
                        ++n27;
                        n26 += n31;
                        n25 += 4;
                    }
                }
            } else {
                System.arraycopy(byArray4, 0, byArray, 0, byArray.length);
            }
        }
    }
}

