/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.stream;

import com.sun.media.imageio.stream.FileChannelImageInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileChannelImageOutputStream
extends ImageOutputStreamImpl {
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 0x100000;
    private FileChannel channel;
    private ByteBuffer byteBuffer;
    private ImageInputStream readStream = null;

    public FileChannelImageOutputStream(FileChannel fileChannel) throws IOException {
        if (fileChannel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        if (!fileChannel.isOpen()) {
            throw new IllegalArgumentException("channel.isOpen() == false");
        }
        this.channel = fileChannel;
        this.streamPos = this.flushedPos = fileChannel.position();
        this.byteBuffer = ByteBuffer.allocateDirect(0x100000);
        this.readStream = new FileChannelImageInputStream(fileChannel);
    }

    private ImageInputStream getImageInputStream() throws IOException {
        this.flushBuffer();
        this.readStream.setByteOrder(this.byteOrder);
        this.readStream.seek(this.streamPos);
        this.readStream.flushBefore(this.flushedPos);
        this.readStream.setBitOffset(this.bitOffset);
        return this.readStream;
    }

    private void flushBuffer() throws IOException {
        if (this.byteBuffer.position() != 0) {
            this.byteBuffer.limit(this.byteBuffer.position());
            this.byteBuffer.position(0);
            this.channel.write(this.byteBuffer);
            this.byteBuffer.clear();
        }
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        ImageInputStream imageInputStream = this.getImageInputStream();
        ++this.streamPos;
        return imageInputStream.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (n2 == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        ImageInputStream imageInputStream = this.getImageInputStream();
        int n3 = imageInputStream.read(byArray, n, n2);
        this.streamPos += (long)n3;
        return n3;
    }

    @Override
    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)(n & 0xFF)}, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (n2 == 0) {
            return;
        }
        this.flushBits();
        int n3 = 0;
        do {
            int n4;
            if ((n4 = Math.min(n2 - n3, this.byteBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            this.byteBuffer.put(byArray, n + n3, n4);
            n3 += n4;
        } while (n3 < n2);
        this.streamPos += (long)n2;
    }

    @Override
    public void readFully(char[] cArray, int n, int n2) throws IOException {
        this.getImageInputStream().readFully(cArray, n, n2);
        this.streamPos += (long)(2 * n2);
    }

    @Override
    public void readFully(short[] sArray, int n, int n2) throws IOException {
        this.getImageInputStream().readFully(sArray, n, n2);
        this.streamPos += (long)(2 * n2);
    }

    @Override
    public void readFully(int[] nArray, int n, int n2) throws IOException {
        this.getImageInputStream().readFully(nArray, n, n2);
        this.streamPos += (long)(4 * n2);
    }

    @Override
    public void readFully(long[] lArray, int n, int n2) throws IOException {
        this.getImageInputStream().readFully(lArray, n, n2);
        this.streamPos += (long)(8 * n2);
    }

    @Override
    public void readFully(float[] fArray, int n, int n2) throws IOException {
        this.getImageInputStream().readFully(fArray, n, n2);
        this.streamPos += (long)(4 * n2);
    }

    @Override
    public void readFully(double[] dArray, int n, int n2) throws IOException {
        this.getImageInputStream().readFully(dArray, n, n2);
        this.streamPos += (long)(8 * n2);
    }

    @Override
    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n2 == 0) {
            return;
        }
        this.flushBits();
        int n3 = 0;
        CharBuffer charBuffer = this.byteBuffer.asCharBuffer();
        do {
            int n4;
            if ((n4 = Math.min(n2 - n3, charBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            charBuffer.put(cArray, n + n3, n4);
            this.byteBuffer.position(this.byteBuffer.position() + 2 * n4);
            n3 += n4;
        } while (n3 < n2);
        this.streamPos += (long)(2 * n2);
    }

    @Override
    public void writeShorts(short[] sArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > sArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n2 == 0) {
            return;
        }
        this.flushBits();
        int n3 = 0;
        ShortBuffer shortBuffer = this.byteBuffer.asShortBuffer();
        do {
            int n4;
            if ((n4 = Math.min(n2 - n3, shortBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            shortBuffer.put(sArray, n + n3, n4);
            this.byteBuffer.position(this.byteBuffer.position() + 2 * n4);
            n3 += n4;
        } while (n3 < n2);
        this.streamPos += (long)(2 * n2);
    }

    @Override
    public void writeInts(int[] nArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n2 == 0) {
            return;
        }
        this.flushBits();
        int n3 = 0;
        IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
        do {
            int n4;
            if ((n4 = Math.min(n2 - n3, intBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            intBuffer.put(nArray, n + n3, n4);
            this.byteBuffer.position(this.byteBuffer.position() + 4 * n4);
            n3 += n4;
        } while (n3 < n2);
        this.streamPos += (long)(4 * n2);
    }

    @Override
    public void writeLongs(long[] lArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > lArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n2 == 0) {
            return;
        }
        this.flushBits();
        int n3 = 0;
        LongBuffer longBuffer = this.byteBuffer.asLongBuffer();
        do {
            int n4;
            if ((n4 = Math.min(n2 - n3, longBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            longBuffer.put(lArray, n + n3, n4);
            this.byteBuffer.position(this.byteBuffer.position() + 8 * n4);
            n3 += n4;
        } while (n3 < n2);
        this.streamPos += (long)(8 * n2);
    }

    @Override
    public void writeFloats(float[] fArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > fArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length");
        }
        if (n2 == 0) {
            return;
        }
        this.flushBits();
        int n3 = 0;
        FloatBuffer floatBuffer = this.byteBuffer.asFloatBuffer();
        do {
            int n4;
            if ((n4 = Math.min(n2 - n3, floatBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            floatBuffer.put(fArray, n + n3, n4);
            this.byteBuffer.position(this.byteBuffer.position() + 4 * n4);
            n3 += n4;
        } while (n3 < n2);
        this.streamPos += (long)(4 * n2);
    }

    @Override
    public void writeDoubles(double[] dArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length");
        }
        if (n2 == 0) {
            return;
        }
        this.flushBits();
        int n3 = 0;
        DoubleBuffer doubleBuffer = this.byteBuffer.asDoubleBuffer();
        do {
            int n4;
            if ((n4 = Math.min(n2 - n3, doubleBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            doubleBuffer.put(dArray, n + n3, n4);
            this.byteBuffer.position(this.byteBuffer.position() + 8 * n4);
            n3 += n4;
        } while (n3 < n2);
        this.streamPos += (long)(8 * n2);
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.readStream.close();
        this.readStream = null;
        this.channel = null;
        this.byteBuffer = null;
        super.close();
    }

    @Override
    public long length() {
        long l = -1L;
        try {
            l = this.channel.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public void seek(long l) throws IOException {
        super.seek(l);
        this.flushBuffer();
        this.channel.position(l);
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        super.setByteOrder(byteOrder);
        this.byteBuffer.order(byteOrder);
    }
}

