/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.imageioimpl;

import com.sun.media.jai.imageioimpl.I18N;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOParam;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;

final class ImageReadOpImage
extends OpImage {
    private ImageReadParam param;
    private ImageReader reader;
    private int imageIndex;
    private boolean readThumbnails;
    private boolean streamMetadataRead = false;
    private boolean imageMetadataRead = false;
    private ImageInputStream streamToClose;
    private int scaleX;
    private int scaleY;
    private int transX;
    private int transY;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, ImageReadParam imageReadParam, ImageReader imageReader, int n) throws IOException {
        Object object;
        Object object2;
        ImageLayout imageLayout2;
        ImageLayout imageLayout3 = imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        if (!imageLayout2.isValid(256) && !imageLayout2.isValid(512)) {
            Object object3 = object2 = imageReadParam != null && imageReadParam.getDestinationType() != null ? imageReadParam.getDestinationType() : imageReader.getRawImageType(n);
            if (object2 == null) {
                object = imageReader.getImageTypes(n);
                while (object2 == null && object.hasNext()) {
                    object2 = (ImageTypeSpecifier)object.next();
                }
            }
            if (object2 != null) {
                imageLayout2.setSampleModel(((ImageTypeSpecifier)object2).getSampleModel());
                imageLayout2.setColorModel(((ImageTypeSpecifier)object2).getColorModel());
            }
        }
        object2 = ImageReadOpImage.getSourceSize(imageReadParam, imageReader, n);
        object = new Rectangle();
        Rectangle rectangle = new Rectangle();
        ImageReadOpImage.computeRegions(imageReadParam, ((Dimension)object2).width, ((Dimension)object2).height, imageLayout2.getMinX(null), imageLayout2.getMinY(null), false, (Rectangle)object, rectangle);
        if (!rectangle.isEmpty()) {
            Rectangle rectangle2;
            if (!imageLayout2.isValid(4)) {
                imageLayout2.setWidth(rectangle.width);
            }
            if (!imageLayout2.isValid(8)) {
                imageLayout2.setHeight(rectangle.height);
            }
            if (!imageLayout2.isValid(1)) {
                imageLayout2.setMinX(rectangle.x);
            }
            if (!imageLayout2.isValid(2)) {
                imageLayout2.setMinY(rectangle.y);
            }
            if (rectangle.intersection(rectangle2 = new Rectangle(imageLayout2.getMinX(null), imageLayout2.getMinY(null), imageLayout2.getWidth(null), imageLayout2.getHeight(null))).isEmpty()) {
                throw new IllegalArgumentException(I18N.getString("ImageReadOpImage0"));
            }
        }
        if (!imageLayout2.isValid(16)) {
            imageLayout2.setTileGridXOffset(imageReader.getTileGridXOffset(n));
        }
        if (!imageLayout2.isValid(32)) {
            imageLayout2.setTileGridYOffset(imageReader.getTileGridYOffset(n));
        }
        if (!imageLayout2.isValid(64)) {
            imageLayout2.setTileWidth(imageReader.getTileWidth(n));
        }
        if (!imageLayout2.isValid(128)) {
            imageLayout2.setTileHeight(imageReader.getTileHeight(n));
        }
        return imageLayout2;
    }

    private static boolean isCompatibleType(ImageTypeSpecifier imageTypeSpecifier, ImageReader imageReader, int n) throws IOException {
        Iterator<ImageTypeSpecifier> iterator = imageReader.getImageTypes(n);
        boolean bl = false;
        while (iterator.hasNext()) {
            ImageTypeSpecifier imageTypeSpecifier2 = iterator.next();
            if (!imageTypeSpecifier2.equals(imageTypeSpecifier)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static Dimension getSourceSize(ImageReadParam imageReadParam, ImageReader imageReader, int n) throws IOException {
        Dimension dimension = null;
        if (imageReadParam != null && imageReadParam.canSetSourceRenderSize()) {
            dimension = imageReadParam.getSourceRenderSize();
        }
        if (dimension == null) {
            dimension = new Dimension(imageReader.getWidth(n), imageReader.getHeight(n));
        }
        return dimension;
    }

    private static Rectangle getSourceRegion(ImageReadParam imageReadParam, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        if (imageReadParam != null) {
            Rectangle rectangle2 = imageReadParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n3 = imageReadParam.getSubsamplingXOffset();
            int n4 = imageReadParam.getSubsamplingYOffset();
            rectangle.x += n3;
            rectangle.y += n4;
            rectangle.width -= n3;
            rectangle.height -= n4;
        }
        return rectangle;
    }

    private static void computeRegions(ImageReadParam imageReadParam, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            throw new IllegalArgumentException("srcRegion == null");
        }
        if (rectangle2 == null) {
            throw new IllegalArgumentException("destRegion == null");
        }
        rectangle.setBounds(0, 0, n, n2);
        rectangle2.setBounds(n3, n4, n, n2);
        int n5 = 1;
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        if (imageReadParam != null) {
            Rectangle rectangle3 = imageReadParam.getSourceRegion();
            if (rectangle3 != null) {
                rectangle.setBounds(rectangle.intersection(rectangle3));
            }
            n5 = imageReadParam.getSourceXSubsampling();
            n6 = imageReadParam.getSourceYSubsampling();
            n7 = imageReadParam.getSubsamplingXOffset();
            n8 = imageReadParam.getSubsamplingYOffset();
            rectangle.translate(n7, n8);
            rectangle.width -= n7;
            rectangle.height -= n8;
            Point point = imageReadParam.getDestinationOffset();
            rectangle2.translate(point.x, point.y);
        }
        if (bl) {
            if (rectangle2.x < 0) {
                int n9 = -rectangle2.x * n5;
                rectangle.x += n9;
                rectangle.width -= n9;
                rectangle2.x = 0;
            }
            if (rectangle2.y < 0) {
                int n10 = -rectangle2.y * n6;
                rectangle.y += n10;
                rectangle.height -= n10;
                rectangle2.y = 0;
            }
        }
        int n11 = (rectangle.width + n5 - 1) / n5;
        int n12 = (rectangle.height + n6 - 1) / n6;
        rectangle2.width = n11;
        rectangle2.height = n12;
        if (rectangle.isEmpty() || rectangle2.isEmpty()) {
            throw new IllegalArgumentException(I18N.getString("ImageReadOpImage1"));
        }
    }

    ImageReadOpImage(ImageLayout imageLayout, Map map, ImageReadParam object, ImageReader imageReader, int n, boolean bl, ImageInputStream imageInputStream) throws IOException {
        super(null, ImageReadOpImage.layoutHelper(imageLayout, (ImageReadParam)object, imageReader, n), map, false);
        Object object2;
        if (object == null) {
            object = imageReader.getDefaultReadParam();
        } else if (object instanceof Cloneable) {
            this.param = object;
        } else if (object.getClass().getName().equals("javax.imageio.ImageReadParam")) {
            object2 = new ImageReadParam();
            if (((IIOParam)object).hasController()) {
                ((IIOParam)object2).setController(((IIOParam)object).getController());
            }
            ((ImageReadParam)object2).setDestination(((ImageReadParam)object).getDestination());
            if (((IIOParam)object).getDestinationType() != null) {
                ((ImageReadParam)object2).setDestinationType(((IIOParam)object).getDestinationType());
            }
            ((ImageReadParam)object2).setDestinationBands(((ImageReadParam)object).getDestinationBands());
            ((IIOParam)object2).setDestinationOffset(((IIOParam)object).getDestinationOffset());
            ((IIOParam)object2).setSourceBands(((IIOParam)object).getSourceBands());
            ((IIOParam)object2).setSourceRegion(((IIOParam)object).getSourceRegion());
            if (((ImageReadParam)object).getSourceMaxProgressivePass() != Integer.MAX_VALUE) {
                ((ImageReadParam)object2).setSourceProgressivePasses(((ImageReadParam)object).getSourceMinProgressivePass(), ((ImageReadParam)object).getSourceNumProgressivePasses());
            }
            if (((ImageReadParam)object).canSetSourceRenderSize()) {
                ((ImageReadParam)object2).setSourceRenderSize(((ImageReadParam)object).getSourceRenderSize());
            }
            ((IIOParam)object2).setSourceSubsampling(((IIOParam)object).getSourceXSubsampling(), ((IIOParam)object).getSourceYSubsampling(), ((IIOParam)object).getSubsamplingXOffset(), ((IIOParam)object).getSubsamplingYOffset());
            object = object2;
        }
        if (bl && !imageReader.hasThumbnails(n)) {
            bl = false;
        }
        this.param = object;
        this.reader = imageReader;
        this.imageIndex = n;
        this.readThumbnails = bl;
        this.streamToClose = imageInputStream;
        if (((IIOParam)object).getDestinationType() != null && !ImageReadOpImage.isCompatibleType(((IIOParam)object).getDestinationType(), imageReader, n) && this.sampleModel != null && this.colorModel != null && ImageReadOpImage.isCompatibleType((ImageTypeSpecifier)(object2 = new ImageTypeSpecifier(this.colorModel, this.sampleModel)), imageReader, n)) {
            ((ImageReadParam)object).setDestinationType((ImageTypeSpecifier)object2);
        }
        object2 = ImageReadOpImage.getSourceSize((ImageReadParam)object, imageReader, n);
        Rectangle rectangle = ImageReadOpImage.getSourceRegion((ImageReadParam)object, ((Dimension)object2).width, ((Dimension)object2).height);
        Point point = this.param.getDestinationOffset();
        this.scaleX = this.param.getSourceXSubsampling();
        this.scaleY = this.param.getSourceYSubsampling();
        this.transX = rectangle.x + this.param.getSubsamplingXOffset() - this.param.getSourceXSubsampling() * (this.minX + point.x);
        this.transY = rectangle.y + this.param.getSubsamplingYOffset() - this.param.getSourceYSubsampling() * (this.minY + point.y);
        this.param.setDestinationOffset(new Point());
        this.setProperty("JAI.ImageReadParam", object);
        this.setProperty("JAI.ImageReader", imageReader);
        if (!imageReader.isIgnoringMetadata()) {
            ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
            if (imageReaderSpi == null || imageReaderSpi.isStandardStreamMetadataFormatSupported() || imageReaderSpi.getNativeStreamMetadataFormatName() != null) {
                this.setProperty("JAI.StreamMetadata", Image.UndefinedProperty);
            } else {
                this.streamMetadataRead = true;
            }
            if (imageReaderSpi == null || imageReaderSpi.isStandardImageMetadataFormatSupported() || imageReaderSpi.getNativeImageMetadataFormatName() != null) {
                this.setProperty("JAI.ImageMetadata", Image.UndefinedProperty);
            } else {
                this.imageMetadataRead = true;
            }
        }
        if (bl && imageReader.readerSupportsThumbnails()) {
            this.setProperty("JAI.Thumbnails", Image.UndefinedProperty);
        }
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    private Rectangle computeSourceRect(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = this.scaleX * rectangle.x + this.transX;
        rectangle2.y = this.scaleY * rectangle.y + this.transY;
        rectangle2.width = this.scaleX * (rectangle.x + rectangle.width) + this.transX - rectangle2.x;
        rectangle2.height = this.scaleY * (rectangle.y + rectangle.height) + this.transY - rectangle2.y;
        return rectangle2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int n, int n2) {
        Object object;
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        Rectangle rectangle3 = this.computeSourceRect(rectangle2);
        WritableRaster writableRaster = null;
        try {
            object = this.reader;
            synchronized (object) {
                this.param.setSourceRegion(rectangle3);
                BufferedImage bufferedImage = this.reader.read(this.imageIndex, this.param);
                WritableRaster writableRaster2 = bufferedImage.getRaster();
                writableRaster = writableRaster2.createWritableChild(0, 0, writableRaster2.getWidth(), writableRaster2.getHeight(), point.x, point.y, null);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        object = null;
        if (this.sampleModel == writableRaster.getSampleModel()) {
            object = writableRaster;
        } else {
            object = Raster.createWritableRaster(this.sampleModel, point);
            ((WritableRaster)object).setRect(writableRaster);
        }
        return object;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        throw new IllegalArgumentException(I18N.getString("ImageReadOpImage2"));
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        throw new IllegalArgumentException(I18N.getString("ImageReadOpImage2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        Object object = super.getProperty(string);
        if (object == null || object == Image.UndefinedProperty) {
            if (this.readThumbnails && string.equalsIgnoreCase("JAI.Thumbnails")) {
                ImageReader imageReader = this.reader;
                synchronized (imageReader) {
                    if (this.readThumbnails) {
                        try {
                            int n = this.reader.getNumThumbnails(this.imageIndex);
                            if (n > 0) {
                                BufferedImage[] bufferedImageArray = new BufferedImage[n];
                                for (int i = 0; i < n; ++i) {
                                    bufferedImageArray[i] = this.reader.readThumbnail(this.imageIndex, i);
                                }
                                this.setProperty("JAI.Thumbnails", bufferedImageArray);
                                object = bufferedImageArray;
                            }
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                        finally {
                            if (object == null) {
                                object = Image.UndefinedProperty;
                            }
                            this.readThumbnails = false;
                        }
                    }
                }
            }
            if (!this.reader.isIgnoringMetadata() && (!this.streamMetadataRead && string.equalsIgnoreCase("JAI.StreamMetadata") || !this.imageMetadataRead && string.equalsIgnoreCase("JAI.ImageMetadata"))) {
                ImageReader imageReader = this.reader;
                synchronized (imageReader) {
                    boolean bl = string.equalsIgnoreCase("JAI.StreamMetadata");
                    if (!(!bl ? this.imageMetadataRead : this.streamMetadataRead)) {
                        String string2 = bl ? "JAI.StreamMetadata" : "JAI.ImageMetadata";
                        IIOMetadata iIOMetadata = null;
                        try {
                            IIOMetadata iIOMetadata2 = iIOMetadata = bl ? this.reader.getStreamMetadata() : this.reader.getImageMetadata(this.imageIndex);
                            if (iIOMetadata != null) {
                                this.setProperty(string2, iIOMetadata);
                            }
                            object = iIOMetadata;
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                        finally {
                            if (object == null) {
                                object = Image.UndefinedProperty;
                            }
                            if (bl) {
                                this.streamMetadataRead = true;
                            } else {
                                this.imageMetadataRead = true;
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    public synchronized void dispose() {
        if (this.streamToClose != null) {
            try {
                this.streamToClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

