/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.CommonUtil;
import org.apache.rahas.impl.util.SAMLAttributeCallback;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.rahas.impl.util.SignKeyHolder;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xml.security.Init;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.core.impl.AssertionBuilder;
import org.opensaml.saml2.core.impl.ConditionsBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SAML2TokenIssuer
implements TokenIssuer {
    private String configParamName;
    private OMElement configElement;
    private String configFile;
    protected List<Signature> signatureList = new ArrayList<Signature>();
    private boolean isSymmetricKeyBasedHoK = false;
    private static Log log = LogFactory.getLog(SAML2TokenIssuer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPEnvelope issue(RahasData data) throws TrustException {
        MessageContext inMsgCtx = data.getInMessageContext();
        try {
            OMElement rstrElem;
            SAMLTokenIssuerConfig config = null;
            if (this.configElement != null) {
                config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            }
            if (config == null && this.configFile != null) {
                config = new SAMLTokenIssuerConfig(this.configFile);
            }
            if (config == null && this.configParamName != null) {
                Parameter param = inMsgCtx.getParameter(this.configParamName);
                if (param != null && param.getParameterElement() != null) {
                    config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
                } else {
                    throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
                }
            }
            if (config == null) {
                throw new TrustException("configurationIsNull");
            }
            SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
            Crypto crypto = config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader());
            Document doc = ((Element)env).getOwnerDocument();
            int keySize = data.getKeysize();
            String keyType = data.getKeyType();
            keySize = keySize == -1 ? config.keySize : keySize;
            AssertionBuilder assertionBuilder = new AssertionBuilder();
            Assertion assertion = assertionBuilder.buildObject();
            assertion.setVersion(SAMLVersion.VERSION_20);
            assertion.setID(UUIDGenerator.getUUID());
            IssuerBuilder issuerBuilder = new IssuerBuilder();
            Issuer issuer = issuerBuilder.buildObject();
            issuer.setValue(config.issuerName);
            assertion.setIssuer(issuer);
            assertion.setIssueInstant(new DateTime());
            DateTime creationDate = new DateTime();
            DateTime expirationDate = new DateTime(creationDate.getMillis() + config.ttl);
            Date creationTime = creationDate.toDate();
            Date expirationTime = expirationDate.toDate();
            Conditions conditions = new ConditionsBuilder().buildObject();
            conditions.setNotBefore(creationDate);
            conditions.setNotOnOrAfter(expirationDate);
            assertion.setConditions(conditions);
            Subject subject = !data.getKeyType().endsWith("/Bearer") ? this.createSubjectWithHolderOfKeySC(config, doc, crypto, creationDate, expirationDate, data) : this.createSubjectWithBearerSC(data);
            assertion.setSubject(subject);
            if (this.isSymmetricKeyBasedHoK) {
                AttributeStatement attrStmt = this.createAttributeStatement(data, config);
                assertion.getAttributeStatements().add(attrStmt);
            } else {
                AuthnStatement authStmt = this.createAuthnStatement(data);
                assertion.getAuthnStatements().add(authStmt);
                if (data.getClaimDialect() != null && data.getClaimElem() != null) {
                    assertion.getAttributeStatements().add(this.createAttributeStatement(data, config));
                }
            }
            SignKeyHolder signKeyHolder = this.createSignKeyHolder(config, crypto);
            assertion = this.setSignature(assertion, signKeyHolder);
            int wstVersion = data.getVersion();
            if (1 == wstVersion) {
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
            } else {
                OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
            }
            TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            if (keyType.endsWith("/SymmetricKey")) {
                TrustUtil.createKeySizeElement(wstVersion, rstrElem, keySize);
            }
            if (config.addRequestedAttachedRef) {
                TrustUtil.createRequestedAttachedRef(wstVersion, rstrElem, "#" + assertion.getID(), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            if (config.addRequestedUnattachedRef) {
                TrustUtil.createRequestedUnattachedRef(wstVersion, rstrElem, assertion.getID(), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            if (data.getAppliesToAddress() != null) {
                TrustUtil.createAppliesToElement(rstrElem, data.getAppliesToAddress(), data.getAddressingNs());
            }
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
            OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
            Element tempNode = assertion.getDOM();
            Element element = assertion.getDOM();
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            String elementString = byteArrayOutputStrm.toString();
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(elementString.trim().getBytes()));
            Element assertionElement = document.getDocumentElement();
            reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
            Token assertionToken = new Token(assertion.getID(), (OMElement)assertionElement, creationTime, expirationTime);
            assertionToken.setSecret(data.getEphmeralKey());
            TrustUtil.getTokenStore(inMsgCtx).add(assertionToken);
            if (keyType.endsWith("/SymmetricKey") && config.keyComputation != 1) {
                TokenIssuerUtil.handleRequestedProofToken(data, wstVersion, config, rstrElem, assertionToken, doc);
            }
            SOAPEnvelope sOAPEnvelope = env;
            return sOAPEnvelope;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
        }
        return null;
    }

    Subject createSubjectWithHolderOfKeySC(SAMLTokenIssuerConfig config, Document doc, Crypto crypto, DateTime creationTime, DateTime expirationTime, RahasData data) throws Exception {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        Object keyInfoElem = null;
        if (data.getKeyType().endsWith("/SymmetricKey")) {
            Element encryptedKeyElem;
            this.isSymmetricKeyBasedHoK = true;
            X509Certificate serviceCert = null;
            try {
                serviceCert = config.getServiceCert(crypto, data.getAppliesToAddress());
                WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
                encrKeyBuilder.setKeyIdentifierType(8);
                encrKeyBuilder.setUseThisCert(serviceCert);
                int keysize = data.getKeysize();
                keysize = keysize != -1 ? keysize : config.keySize;
                encrKeyBuilder.setEphemeralKey(TokenIssuerUtil.getSharedSecret(data, config.keyComputation, keysize));
                encrKeyBuilder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
                encrKeyBuilder.prepare(doc, crypto);
                byte[] tempKey = new byte[keysize / 8];
                System.arraycopy(encrKeyBuilder.getEphemeralKey(), 0, tempKey, 0, keysize / 8);
                data.setEphmeralKey(tempKey);
                encryptedKeyElem = encrKeyBuilder.getEncryptedKeyElement();
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{serviceCert.getSubjectDN().getName()}, e);
            }
            keyInfoElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
            ((OMElement)encryptedKeyElem).declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
            ((OMElement)encryptedKeyElem).declareNamespace("http://www.w3.org/2001/04/xmlenc#", "xenc");
            keyInfoElem.appendChild(encryptedKeyElem);
        } else if (data.getKeyType().endsWith("/PublicKey")) {
            try {
                String subjectNameId = data.getPrincipal().getName();
                NameIDBuilder nb = new NameIDBuilder();
                NameID nameID = nb.buildObject();
                nameID.setValue(subjectNameId);
                nameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                subject.setNameID(nameID);
                X509Certificate clientCert = data.getClientCert();
                if (clientCert == null) {
                    clientCert = CommonUtil.getCertificateByAlias(crypto, data.getPrincipal().getName());
                }
                byte[] clientCertBytes = clientCert.getEncoded();
                String base64Cert = Base64.encode((byte[])clientCertBytes);
                Text base64CertText = doc.createTextNode(base64Cert);
                Element x509CertElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Certificate");
                x509CertElem.appendChild(base64CertText);
                Element x509DataElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
                x509DataElem.appendChild(x509CertElem);
                if (x509DataElem != null) {
                    keyInfoElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
                    ((OMElement)x509DataElem).declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
                    keyInfoElem.appendChild(x509DataElem);
                }
            }
            catch (Exception e) {
                throw new TrustException("samlAssertionCreationError", e);
            }
        }
        String keyInfoElementString = keyInfoElem.toString();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(keyInfoElementString.trim().getBytes()));
        Element element = document.getDocumentElement();
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
        XMLObject keyInfoElement = null;
        try {
            keyInfoElement = unmarshaller.unmarshall(element);
        }
        catch (UnmarshallingException e) {
            throw new TrustException("Error unmarshalling KeyInfo Element", e);
        }
        SAMLObjectBuilder subjectConfirmationBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)subjectConfirmationBuilder.buildObject();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        SAMLObjectBuilder keyInfoSubjectConfirmationDataBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(KeyInfoConfirmationDataType.TYPE_NAME);
        KeyInfoConfirmationDataType scData = (KeyInfoConfirmationDataType)keyInfoSubjectConfirmationDataBuilder.buildObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME, KeyInfoConfirmationDataType.TYPE_NAME);
        scData.getKeyInfos().add(keyInfoElement);
        scData.setNotBefore(creationTime);
        scData.setNotOnOrAfter(expirationTime);
        subjectConfirmation.setSubjectConfirmationData((SubjectConfirmationData)scData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        log.debug((Object)"SAML2.0 subject is constructed successfully.");
        return subject;
    }

    private Subject createSubjectWithBearerSC(RahasData data) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        NameID nameID = new NameIDBuilder().buildObject();
        nameID.setValue(data.getPrincipal().getName());
        nameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        subject.setNameID(nameID);
        SAMLObjectBuilder subjectConfirmationBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)subjectConfirmationBuilder.buildObject();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        subject.getSubjectConfirmations().add(subjectConfirmation);
        return subject;
    }

    public Assertion setSignature(Assertion assertion, SignKeyHolder cred) throws Exception {
        Signature signature = (Signature)SAML2TokenIssuer.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)cred);
        signature.setSignatureAlgorithm(cred.getSignatureAlgorithm());
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            KeyInfo keyInfo = (KeyInfo)SAML2TokenIssuer.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)SAML2TokenIssuer.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            org.opensaml.xml.signature.X509Certificate cert = (org.opensaml.xml.signature.X509Certificate)SAML2TokenIssuer.buildXMLObject(org.opensaml.xml.signature.X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = org.apache.xml.security.utils.Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
            assertion.setSignature(signature);
            this.signatureList.add(signature);
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)assertion);
            marshaller.marshall((XMLObject)assertion);
            Init.init();
            Signer.signObjects(this.signatureList);
        }
        catch (CertificateEncodingException e) {
            throw new TrustException("Error in setting the signature", e);
        }
        catch (SignatureException e) {
            throw new TrustException("errorMarshellingOrSigning", e);
        }
        catch (MarshallingException e) {
            throw new TrustException("errorMarshellingOrSigning", e);
        }
        log.debug((Object)"SAML2.0 assertion is marshalled and signed..");
        return assertion;
    }

    protected static XMLObject buildXMLObject(QName objectQName) throws Exception {
        XMLObjectBuilder builder = org.opensaml.xml.Configuration.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new TrustException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    private SignKeyHolder createSignKeyHolder(SAMLTokenIssuerConfig config, Crypto crypto) throws TrustException {
        SignKeyHolder signKeyHolder = new SignKeyHolder();
        try {
            X509Certificate[] issuerCerts = CommonUtil.getCertificatesByAlias(crypto, config.issuerKeyAlias);
            String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            PrivateKey issuerPK = crypto.getPrivateKey(config.issuerKeyAlias, config.issuerKeyPassword);
            signKeyHolder.setIssuerCerts(issuerCerts);
            signKeyHolder.setIssuerPK(issuerPK);
            signKeyHolder.setSignatureAlgorithm(sigAlgo);
        }
        catch (Exception e) {
            throw new TrustException("Error creating issuer signature");
        }
        log.debug((Object)"SignKeyHolder object is created with the credentials..");
        return signKeyHolder;
    }

    private AttributeStatement createAttributeStatement(RahasData data, SAMLTokenIssuerConfig config) throws SAMLException, TrustException {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder attrStmtBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder attrBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        AttributeStatement attrstmt = (AttributeStatement)attrStmtBuilder.buildObject();
        Attribute[] attributes = null;
        if (config.getCallbackHandler() != null) {
            SAMLAttributeCallback cb = new SAMLAttributeCallback(data);
            SAMLCallbackHandler handler = config.getCallbackHandler();
            handler.handle(cb);
            attributes = cb.getSAML2Attributes();
        } else if (config.getCallbackHandlerName() != null && config.getCallbackHandlerName().trim().length() > 0) {
            SAMLAttributeCallback cb = new SAMLAttributeCallback(data);
            SAMLCallbackHandler handler = null;
            MessageContext msgContext = data.getInMessageContext();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            Class cbClass = null;
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)config.getCallbackHandlerName());
            }
            catch (ClassNotFoundException e) {
                throw new TrustException("cannotLoadPWCBClass", new String[]{config.getCallbackHandlerName()}, e);
            }
            try {
                handler = (SAMLCallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new TrustException("cannotCreatePWCBInstance", new String[]{config.getCallbackHandlerName()}, e);
            }
            handler.handle(cb);
            attributes = cb.getSAML2Attributes();
        } else {
            Attribute attribute = (Attribute)attrBuilder.buildObject();
            attribute.setName("Name");
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            XSStringBuilder attributeValueBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
            XSString stringValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            stringValue.setValue("Colombo/Rahas");
            attribute.getAttributeValues().add(stringValue);
            attributes = new Attribute[]{attribute};
        }
        attrstmt.getAttributes().addAll(Arrays.asList(attributes));
        log.debug((Object)"SAML2.0 attribute statement is constructed successfully.");
        return attrstmt;
    }

    private AuthnStatement createAuthnStatement(RahasData data) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        MessageContext inMsgCtx = data.getInMessageContext();
        SAMLObjectBuilder authStmtBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnStatement.DEFAULT_ELEMENT_NAME);
        AuthnStatement authStmt = (AuthnStatement)authStmtBuilder.buildObject();
        authStmt.setAuthnInstant(new DateTime());
        SAMLObjectBuilder authCtxBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME);
        AuthnContext authContext = (AuthnContext)authCtxBuilder.buildObject();
        SAMLObjectBuilder authCtxClassRefBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        AuthnContextClassRef authCtxClassRef = (AuthnContextClassRef)authCtxClassRefBuilder.buildObject();
        if (inMsgCtx.getProperty("username") != null) {
            authCtxClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        } else if (inMsgCtx.getProperty("X509Certificate") != null) {
            authCtxClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
        }
        authContext.setAuthnContextClassRef(authCtxClassRef);
        authStmt.setAuthnContext(authContext);
        log.debug((Object)"SAML2.0 authentication statement is constructed successfully.");
        return authStmt;
    }

    public String getResponseAction(RahasData data) throws TrustException {
        return null;
    }

    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }

    static {
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            log.error((Object)"SAML2TokenIssuerBootstrapError", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
        }
    }
}

