/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.opimage.FCT;
import com.sun.media.jai.util.MathJAI;
import com.sun.medialib.mlib.Image;
import java.util.Arrays;

public class FCTmediaLib
extends FCT {
    private int length;
    private boolean lengthIsSet = false;
    private double[] wr;
    private double[] wi;
    protected double[] real;
    protected double[] imag;

    public FCTmediaLib(boolean bl, int n) {
        this.isForwardTransform = bl;
        this.setLength(n);
    }

    public void setLength(int n) {
        if (this.lengthIsSet && n == this.length) {
            return;
        }
        if (!MathJAI.isPositivePowerOf2(n)) {
            throw new RuntimeException(JaiI18N.getString("FCTmediaLib0"));
        }
        this.length = n;
        if (this.real == null || n != this.real.length) {
            this.real = new double[n];
            this.imag = new double[n];
        }
        this.calculateFCTLUTs();
        this.lengthIsSet = true;
    }

    private void calculateFCTLUTs() {
        this.wr = new double[this.length];
        this.wi = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            double d = i == 0 ? Math.sqrt(1.0 / (double)this.length) : Math.sqrt(2.0 / (double)this.length);
            double d2 = Math.PI * (double)i / (2.0 * (double)this.length);
            this.wr[i] = d * Math.cos(d2);
            this.wi[i] = d * Math.sin(d2);
        }
    }

    public void setData(int n, Object object, int n2, int n3, int n4) {
        if (this.isForwardTransform) {
            this.setFCTData(n, object, n2, n3, n4);
        } else {
            this.setIFCTData(n, object, n2, n3, n4);
        }
    }

    public void getData(int n, Object object, int n2, int n3) {
        if (this.isForwardTransform) {
            this.getFCTData(n, object, n2, n3);
        } else {
            this.getIFCTData(n, object, n2, n3);
        }
    }

    private void setFCTData(int n, Object object, int n2, int n3, int n4) {
        switch (n) {
            case 4: {
                int n5;
                float[] fArray = (float[])object;
                for (n5 = 0; n5 < n4; ++n5) {
                    this.imag[n5] = fArray[n2];
                    n2 += n3;
                }
                for (n5 = n4; n5 < this.length; ++n5) {
                    this.imag[n5] = 0.0;
                }
                n5 = this.length - 1;
                int n6 = 0;
                for (int i = 0; i < n5; ++i) {
                    this.real[i] = this.imag[n6++];
                    this.real[n5--] = this.imag[n6++];
                }
                break;
            }
            case 5: {
                int n7;
                double[] dArray = (double[])object;
                for (n7 = 0; n7 < n4; ++n7) {
                    this.imag[n7] = dArray[n2];
                    n2 += n3;
                }
                for (n7 = n4; n7 < this.length; ++n7) {
                    this.imag[n7] = 0.0;
                }
                n7 = this.length - 1;
                int n8 = 0;
                for (int i = 0; i < n7; ++i) {
                    this.real[i] = this.imag[n8++];
                    this.real[n7--] = this.imag[n8++];
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FCTmediaLib1"));
            }
        }
        Arrays.fill(this.imag, 0, this.length, 0.0);
    }

    private void getFCTData(int n, Object object, int n2, int n3) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                for (int i = 0; i < this.length; ++i) {
                    fArray[n2] = (float)(this.wr[i] * this.real[i] + this.wi[i] * this.imag[i]);
                    n2 += n3;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i = 0; i < this.length; ++i) {
                    dArray[n2] = this.wr[i] * this.real[i] + this.wi[i] * this.imag[i];
                    n2 += n3;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FCTmediaLib1"));
            }
        }
    }

    private void setIFCTData(int n, Object object, int n2, int n3, int n4) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                for (int i = 0; i < n4; ++i) {
                    float f = fArray[n2];
                    this.real[i] = (double)f * this.wr[i];
                    this.imag[i] = (double)f * this.wi[i];
                    n2 += n3;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i = 0; i < n4; ++i) {
                    double d = dArray[n2];
                    this.real[i] = d * this.wr[i];
                    this.imag[i] = d * this.wi[i];
                    n2 += n3;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FCTmediaLib1"));
            }
        }
        if (n4 < this.length) {
            Arrays.fill(this.real, n4, this.length, 0.0);
            Arrays.fill(this.imag, n4, this.length, 0.0);
        }
    }

    private void getIFCTData(int n, Object object, int n2, int n3) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n4 = this.length - 1;
                for (int i = 0; i < n4; ++i) {
                    fArray[n2] = (float)this.real[i];
                    fArray[n2 += n3] = (float)this.real[n4--];
                    n2 += n3;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n5 = this.length - 1;
                for (int i = 0; i < n5; ++i) {
                    dArray[n2] = (float)this.real[i];
                    dArray[n2 += n3] = (float)this.real[n5--];
                    n2 += n3;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FCTmediaLib1"));
            }
        }
    }

    public void transform() {
        if (this.isForwardTransform) {
            Image.FFT_1((double[])this.real, (double[])this.imag);
        } else {
            Image.IFFT_2((double[])this.real, (double[])this.imag);
        }
    }
}

