/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PointOpImage;

final class MlibLookupOpImage
extends PointOpImage {
    private LookupTableJAI table;

    public MlibLookupOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, LookupTableJAI lookupTableJAI) {
        super(renderedImage, imageLayout, map, true);
        this.table = lookupTableJAI;
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (this.sampleModel.getTransferType() != lookupTableJAI.getDataType() || this.sampleModel.getNumBands() != lookupTableJAI.getDestNumBands(sampleModel.getNumBands())) {
            this.sampleModel = lookupTableJAI.getDestSampleModel(sampleModel, this.tileWidth, this.tileHeight);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Object object;
        mediaLibImage[] mediaLibImageArray;
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(null, raster);
        int n2 = MediaLibAccessor.findCompatibleTag(null, writableRaster);
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getNumBands() > 1) {
            int n3 = n & 0x80;
            int n4 = n2 & 0x80;
            int n5 = n & 0x7F;
            int n6 = n2 & 0x7F;
            if (!(n3 == 0 && n4 == 0 && MediaLibAccessor.isPixelSequential(sampleModel) && MediaLibAccessor.isPixelSequential(this.sampleModel) && MediaLibAccessor.hasMatchingBandOffsets((ComponentSampleModel)sampleModel, (ComponentSampleModel)this.sampleModel))) {
                n = n5 | 0x80;
                n2 = n6 | 0x80;
            }
        }
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor.getMediaLibImages();
        if (mediaLibImageArray2.length < (mediaLibImageArray = mediaLibAccessor2.getMediaLibImages()).length) {
            object = mediaLibImageArray2[0];
            mediaLibImageArray2 = new mediaLibImage[mediaLibImageArray.length];
            for (int i = 0; i < mediaLibImageArray.length; ++i) {
                mediaLibImageArray2[i] = (mediaLibImage)object;
            }
        }
        object = mediaLibAccessor2.getBandOffsets();
        Object object2 = this.getTableData((int[])object);
        int[] nArray = this.getTableOffsets((int[])object);
        for (int i = 0; i < mediaLibImageArray.length; ++i) {
            Image.LookUp2((mediaLibImage)mediaLibImageArray[i], (mediaLibImage)mediaLibImageArray2[i], (Object)object2, (int[])nArray);
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }

    private Object getTableData(int[] nArray) {
        int n = this.table.getNumBands();
        int n2 = this.sampleModel.getNumBands();
        Object object = null;
        switch (this.table.getDataType()) {
            case 0: {
                byte[][] byArrayArray = new byte[n2][];
                if (n < n2) {
                    for (int i = 0; i < n2; ++i) {
                        byArrayArray[i] = this.table.getByteData(0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        byArrayArray[i] = this.table.getByteData(nArray[i]);
                    }
                }
                object = byArrayArray;
                break;
            }
            case 1: 
            case 2: {
                short[][] sArrayArray = new short[n2][];
                if (n < n2) {
                    for (int i = 0; i < n2; ++i) {
                        sArrayArray[i] = this.table.getShortData(0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        sArrayArray[i] = this.table.getShortData(nArray[i]);
                    }
                }
                object = sArrayArray;
                break;
            }
            case 3: {
                int[][] nArrayArray = new int[n2][];
                if (n < n2) {
                    for (int i = 0; i < n2; ++i) {
                        nArrayArray[i] = this.table.getIntData(0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        nArrayArray[i] = this.table.getIntData(nArray[i]);
                    }
                }
                object = nArrayArray;
                break;
            }
            case 4: {
                float[][] fArrayArray = new float[n2][];
                if (n < n2) {
                    for (int i = 0; i < n2; ++i) {
                        fArrayArray[i] = this.table.getFloatData(0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArrayArray[i] = this.table.getFloatData(nArray[i]);
                    }
                }
                object = fArrayArray;
                break;
            }
            case 5: {
                double[][] dArrayArray = new double[n2][];
                if (n < n2) {
                    for (int i = 0; i < n2; ++i) {
                        dArrayArray[i] = this.table.getDoubleData(0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArrayArray[i] = this.table.getDoubleData(nArray[i]);
                    }
                }
                object = dArrayArray;
            }
        }
        return object;
    }

    private int[] getTableOffsets(int[] nArray) {
        int n = this.table.getNumBands();
        int n2 = this.sampleModel.getNumBands();
        int[] nArray2 = new int[n2];
        if (n < n2) {
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = this.table.getOffset(0);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = this.table.getOffset(nArray[i]);
            }
        }
        return nArray2;
    }
}

