/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.PiecewiseOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.CRIFImpl;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;

public class MatchCDFCRIF
extends CRIFImpl {
    private static void createHistogramMap(float[] fArray, float[] fArray2, double d, double d2, int n, float[] fArray3, float[] fArray4) {
        double d3 = d;
        int n2 = 0;
        int n3 = n - 1;
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            while (fArray2[n2] < f && n2 < n3) {
                ++n2;
            }
            fArray3[i] = (float)d3;
            fArray4[i] = (float)((double)n2 * d2);
            d3 += d2;
        }
    }

    private static float[][][] createSpecificationMap(Histogram histogram, float[][] fArray) {
        int n = histogram.getNumBands();
        float[][][] fArrayArray = new float[n][][];
        float[] fArray2 = null;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = histogram.getNumBins(i);
            fArrayArray[i] = new float[2][];
            fArrayArray[i][0] = new float[n3];
            fArrayArray[i][1] = new float[n3];
            int[] nArray = histogram.getBins(i);
            long l = nArray[0];
            for (n2 = 1; n2 < n3; ++n2) {
                l += (long)nArray[n2];
            }
            if (fArray2 == null || fArray2.length < n3) {
                fArray2 = new float[n3];
            }
            fArray2[0] = (float)nArray[0] / (float)l;
            for (n2 = 1; n2 < n3; ++n2) {
                fArray2[n2] = fArray2[n2 - 1] + (float)nArray[n2] / (float)l;
            }
            double d = (histogram.getHighValue(i) - histogram.getLowValue(i)) / (double)n3;
            MatchCDFCRIF.createHistogramMap(fArray2, fArray.length > 1 ? fArray[i] : fArray[0], histogram.getLowValue(i), d, n3, fArrayArray[i][0], fArrayArray[i][1]);
        }
        return fArrayArray;
    }

    public MatchCDFCRIF() {
        super("matchcdf");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Histogram histogram = (Histogram)renderedImage.getProperty("histogram");
        float[][] fArray = (float[][])parameterBlock.getObjectParameter(0);
        float[][][] fArray2 = MatchCDFCRIF.createSpecificationMap(histogram, fArray);
        return new PiecewiseOpImage(renderedImage, renderingHints, imageLayout, fArray2);
    }
}

