/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.ColorQuantizerOpImage;
import com.sun.media.jai.opimage.Cube;
import com.sun.media.jai.opimage.HistogramHash;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.UnpackedImageData;

public class MedianCutOpImage
extends ColorQuantizerOpImage {
    private int histogramSize;
    private int[] counts;
    private int[] colors;
    private Cube[] partition;
    private int bits = 8;
    private int mask;
    HistogramHash histogram;

    public MedianCutOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n, int n2, ROI rOI, int n3, int n4) {
        super(renderedImage, map, imageLayout, n, rOI, n3, n4);
        this.colorMap = null;
        this.histogramSize = n2;
    }

    protected synchronized void train() {
        int n;
        PlanarImage planarImage = this.getSourceImage(0);
        if (this.roi == null) {
            this.roi = new ROIShape(planarImage.getBounds());
        }
        int n2 = planarImage.getMinTileX();
        int n3 = planarImage.getMaxTileX();
        int n4 = planarImage.getMinTileY();
        int n5 = planarImage.getMaxTileY();
        int n6 = planarImage.getMinX();
        int n7 = planarImage.getMinY();
        this.histogram = new HistogramHash(this.histogramSize);
        block0: do {
            this.histogram.init();
            n = this.bits;
            this.mask = 255 << 8 - this.bits & 0xFF;
            this.mask = this.mask | this.mask << 8 | this.mask << 16;
            for (int i = n4; i <= n5; ++i) {
                for (int j = n2; j <= n3; ++j) {
                    Rectangle rectangle = planarImage.getTileRect(j, i);
                    if (!this.roi.intersects(rectangle)) continue;
                    if (this.checkForSkippedTiles && rectangle.x >= n6 && rectangle.y >= n7) {
                        int n8 = (this.xPeriod - (rectangle.x - n6) % this.xPeriod) % this.xPeriod;
                        int n9 = (this.yPeriod - (rectangle.y - n7) % this.yPeriod) % this.yPeriod;
                        if (n8 >= rectangle.width || n9 >= rectangle.height) continue;
                    }
                    this.computeHistogram(planarImage.getData(rectangle));
                    if (this.histogram.isFull()) break;
                }
                if (this.histogram.isFull()) continue block0;
            }
        } while (n != this.bits);
        this.counts = this.histogram.getCounts();
        this.colors = this.histogram.getColors();
        this.medianCut(this.maxColorNum);
        this.setProperty("LUT", this.colorMap);
        this.setProperty("JAI.LookupTable", this.colorMap);
    }

    private void computeHistogram(Raster raster) {
        LinkedList linkedList;
        if (!this.isInitialized) {
            this.srcPA = new PixelAccessor(this.getSourceImage(0));
            this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
            this.isInitialized = true;
        }
        Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
        if (this.roi == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = rectangle.intersection((Rectangle)listIterator.next());
            int n3 = rectangle2.x;
            int n4 = rectangle2.y;
            rectangle2.x = MedianCutOpImage.startPosition(n3, n, this.xPeriod);
            rectangle2.y = MedianCutOpImage.startPosition(n4, n2, this.yPeriod);
            rectangle2.width = n3 + rectangle2.width - rectangle2.x;
            rectangle2.height = n4 + rectangle2.height - rectangle2.y;
            if (rectangle2.isEmpty()) continue;
            UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, rectangle2, this.srcSampleType, false);
            switch (unpackedImageData.type) {
                case 0: {
                    this.computeHistogramByte(unpackedImageData);
                }
            }
        }
    }

    private void computeHistogramByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = rectangle.height * n;
        for (int i = 0; i < n5; i += n3) {
            int n6 = i + rectangle.width * n2;
            for (int j = i; j < n6; j += n4) {
                int n7 = (byArray2[j + unpackedImageData.bandOffsets[0]] & 0xFF) << 16 | (byArray3[j + unpackedImageData.bandOffsets[1]] & 0xFF) << 8 | byArray4[j + unpackedImageData.bandOffsets[2]] & 0xFF;
                if (this.histogram.insert(n7 & this.mask)) continue;
                --this.bits;
                return;
            }
        }
    }

    public void medianCut(int n) {
        int n2;
        this.partition = new Cube[n];
        int n3 = 0;
        Cube cube = new Cube();
        int n4 = 0;
        for (n2 = 0; n2 < this.histogramSize; ++n2) {
            if (this.counts[n2] == 0) continue;
            ++n4;
            cube.count += this.counts[n2];
        }
        cube.lower = 0;
        cube.upper = n4 - 1;
        cube.level = 0;
        this.shrinkCube(cube);
        this.partition[n3++] = cube;
        while (n3 < n) {
            int n5;
            n2 = 255;
            int n6 = -1;
            for (int i = 0; i < n3; ++i) {
                if (this.partition[i].lower == this.partition[i].upper || this.partition[i].level >= n2) continue;
                n2 = this.partition[i].level;
                n6 = i;
            }
            if (n6 == -1) break;
            cube = this.partition[n6];
            n2 = cube.level;
            int n7 = 77 * (cube.rmax - cube.rmin);
            int n8 = 150 * (cube.gmax - cube.gmin);
            int n9 = 29 * (cube.bmax - cube.bmin);
            int n10 = 0;
            if (n7 >= n8 && n7 >= n9) {
                n10 = 0xFF0000;
            }
            if (n8 >= n7 && n8 >= n9) {
                n10 = 65280;
            }
            if (n9 >= n7 && n9 >= n8) {
                n10 = 255;
            }
            this.quickSort(this.colors, cube.lower, cube.upper, n10);
            int n11 = 0;
            for (n5 = cube.lower; n5 <= cube.upper - 1 && n11 < cube.count / 2; n11 += this.counts[n5], ++n5) {
            }
            Cube cube2 = new Cube();
            cube2.lower = cube.lower;
            cube2.upper = n5 - 1;
            cube2.count = n11;
            cube2.level = cube.level + 1;
            this.shrinkCube(cube2);
            this.partition[n6] = cube2;
            Cube cube3 = new Cube();
            cube3.lower = n5;
            cube3.upper = cube.upper;
            cube3.count = cube.count - n11;
            cube3.level = cube.level + 1;
            this.shrinkCube(cube3);
            this.partition[n3++] = cube3;
        }
        this.createLUT(n3);
    }

    private void shrinkCube(Cube cube) {
        int n = 255;
        int n2 = 0;
        int n3 = 255;
        int n4 = 0;
        int n5 = 255;
        int n6 = 0;
        for (int i = cube.lower; i <= cube.upper; ++i) {
            int n7 = this.colors[i];
            int n8 = n7 >> 16;
            int n9 = n7 >> 8 & 0xFF;
            int n10 = n7 & 0xFF;
            if (n8 > n2) {
                n2 = n8;
            } else if (n8 < n) {
                n = n8;
            }
            if (n9 > n4) {
                n4 = n9;
            } else if (n9 < n3) {
                n3 = n9;
            }
            if (n10 > n6) {
                n6 = n10;
                continue;
            }
            if (n10 >= n5) continue;
            n5 = n10;
        }
        cube.rmin = n;
        cube.rmax = n2;
        cube.gmin = n3;
        cube.gmax = n4;
        cube.bmin = n5;
        cube.bmax = n6;
    }

    private void createLUT(int n) {
        if (this.colorMap == null) {
            this.colorMap = new LookupTableJAI(new byte[3][n]);
        }
        byte[] byArray = this.colorMap.getByteData(0);
        byte[] byArray2 = this.colorMap.getByteData(1);
        byte[] byArray3 = this.colorMap.getByteData(2);
        float f = 255.0f / (float)(this.mask & 0xFF);
        for (int i = 0; i < n; ++i) {
            Cube cube = this.partition[i];
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int j = cube.lower; j <= cube.upper; ++j) {
                int n2 = this.colors[j];
                int n3 = n2 >> 16;
                f2 += (float)n3 * (float)this.counts[j];
                int n4 = n2 >> 8 & 0xFF;
                f3 += (float)n4 * (float)this.counts[j];
                int n5 = n2 & 0xFF;
                f4 += (float)n5 * (float)this.counts[j];
            }
            byArray[i] = (byte)(f2 / (float)cube.count * f);
            byArray2[i] = (byte)(f3 / (float)cube.count * f);
            byArray3[i] = (byte)(f4 / (float)cube.count * f);
        }
    }

    void quickSort(int[] nArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        if (n2 > n) {
            int n6 = nArray[(n + n2) / 2] & n3;
            while (n4 <= n5) {
                while (n4 < n2 && (nArray[n4] & n3) < n6) {
                    ++n4;
                }
                while (n5 > n && (nArray[n5] & n3) > n6) {
                    --n5;
                }
                if (n4 > n5) continue;
                int n7 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = n7;
                n7 = this.counts[n4];
                this.counts[n4] = this.counts[n5];
                this.counts[n5] = n7;
                ++n4;
                --n5;
            }
            if (n < n5) {
                this.quickSort(nArray, n, n5, n3);
            }
            if (n4 < n2) {
                this.quickSort(nArray, n4, n2, n3);
            }
        }
    }
}

