/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JaiI18N;
import com.sun.media.jai.util.Job;
import com.sun.media.jai.util.Request;
import com.sun.media.jai.util.RequestJob;
import com.sun.media.jai.util.TileJob;
import com.sun.media.jai.util.WorkerThread;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class SunTileScheduler
implements TileScheduler {
    private static final int NUM_THREADS_DEFAULT = 2;
    private static final int NUM_PREFETCH_THREADS_DEFAULT = 1;
    private static int numInstances = 0;
    private static String name = JaiI18N.getString("SunTileSchedulerName");
    private ThreadGroup rootGroup;
    private ThreadGroup standardGroup;
    private ThreadGroup prefetchGroup;
    private int parallelism = 2;
    private int prefetchParallelism = 1;
    private int priority = 5;
    private int prefetchPriority = 1;
    private LinkedList queue = null;
    private LinkedList prefetchQueue = null;
    private Vector workers = new Vector();
    private Vector prefetchWorkers = new Vector();
    private int numWorkerThreads = 0;
    private int numPrefetchThreads = 0;
    private Map tilesInProgress = new HashMap();
    Map tileRequests = new HashMap();
    Map tileJobs = new HashMap();
    private String nameOfThisInstance;

    static Object tileKey(PlanarImage planarImage, int n, int n2) {
        long l = (long)n2 * (long)planarImage.getNumXTiles() + (long)n;
        BigInteger bigInteger = (BigInteger)planarImage.getImageID();
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3 + 8];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        int n4 = 7;
        int n5 = 0;
        while (n4 >= 0) {
            byArray2[n3++] = (byte)(l >> n5);
            --n4;
            n5 += 8;
        }
        return new BigInteger(byArray2);
    }

    static Set getListeners(List list) {
        int n = list.size();
        HashSet hashSet = null;
        for (int i = 0; i < n; ++i) {
            Request request = (Request)list.get(i);
            if (request.listeners == null || request.listeners.isEmpty()) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.addAll(request.listeners);
        }
        return hashSet;
    }

    private static String getStackTraceString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public SunTileScheduler(int n, int n2, int n3, int n4) {
        this();
        this.setParallelism(n);
        this.setPriority(n2);
        this.setPrefetchParallelism(n3);
        this.setPrefetchPriority(n4);
    }

    public SunTileScheduler() {
        this.queue = new LinkedList();
        this.prefetchQueue = new LinkedList();
        this.nameOfThisInstance = name + numInstances;
        this.rootGroup = new ThreadGroup(this.nameOfThisInstance);
        this.rootGroup.setDaemon(true);
        this.standardGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Standard");
        this.standardGroup.setDaemon(true);
        this.prefetchGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Prefetch");
        this.prefetchGroup.setDaemon(true);
        ++numInstances;
    }

    Exception compute(PlanarImage planarImage, Point[] pointArray, Raster[] rasterArray, int n, int n2, Request request) {
        Object object;
        Object object2;
        int n3;
        Exception exception = null;
        int n4 = n;
        if (request == null || request.listeners == null) {
            n3 = 0;
            while (n3 < n2) {
                Point point = pointArray[n4];
                try {
                    rasterArray[n4] = planarImage.getTile(point.x, point.y);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    break;
                }
                ++n3;
                ++n4;
            }
        } else {
            TileRequest[] tileRequestArray = new Request[]{request};
            int n5 = 0;
            while (n5 < n2) {
                Point point = pointArray[n4];
                Integer n6 = new Integer(1);
                request.tileStatus.put(point, n6);
                try {
                    rasterArray[n4] = planarImage.getTile(point.x, point.y);
                    object2 = request.listeners.iterator();
                    while (object2.hasNext()) {
                        n6 = new Integer(2);
                        request.tileStatus.put(point, n6);
                        object = (TileComputationListener)object2.next();
                        object.tileComputed(this, tileRequestArray, planarImage, point.x, point.y, rasterArray[n4]);
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                    break;
                }
                ++n5;
                ++n4;
            }
        }
        if (exception != null && request != null && request.listeners != null) {
            n3 = n4;
            int n7 = n2 - (n3 - n);
            int n8 = n3;
            for (int i = 0; i < n7; ++i) {
                object2 = new Integer(4);
                request.tileStatus.put(pointArray[n8++], object2);
            }
            TileRequest[] tileRequestArray = new Request[]{request};
            int n9 = n3;
            for (n8 = 0; n8 < n7; ++n8) {
                object = pointArray[n9++];
                Iterator iterator = request.listeners.iterator();
                while (iterator.hasNext()) {
                    TileComputationListener tileComputationListener = (TileComputationListener)iterator.next();
                    tileComputationListener.tileComputationFailure(this, tileRequestArray, planarImage, ((Point)object).x, ((Point)object).y, exception);
                }
            }
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Raster scheduleTile(OpImage opImage, int n, int n2) {
        if (opImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler1"));
        }
        Raster raster = null;
        Object object = SunTileScheduler.tileKey(opImage, n, n2);
        boolean bl = false;
        Object[] objectArray = null;
        Object[] objectArray2 = this.tilesInProgress;
        synchronized (this.tilesInProgress) {
            bl = !this.tilesInProgress.containsKey(object);
            if (bl) {
                objectArray = new Object[1];
                this.tilesInProgress.put(object, objectArray);
            } else {
                objectArray = (Object[])this.tilesInProgress.get(object);
            }
            // ** MonitorExit[objectArray2] (shouldn't be in output)
            if (bl) {
                try {
                    try {
                        try {
                            raster = opImage.computeTile(n, n2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            TileCache tileCache = opImage.getTileCache();
                            if (tileCache != null) {
                                tileCache.flush();
                                System.gc();
                            }
                            raster = opImage.computeTile(n, n2);
                        }
                        Object var11_14 = null;
                        Object[] objectArray3 = objectArray;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        if (throwable instanceof RuntimeException) {
                            this.sendExceptionToListener(JaiI18N.getString("SunTileScheduler6"), throwable);
                        } else {
                            String tileCache = JaiI18N.getString("SunTileScheduler6");
                            this.sendExceptionToListener(tileCache, new ImagingException(tileCache, throwable));
                        }
                        Object var11_15 = null;
                        Object[] objectArray3 = objectArray;
                        synchronized (objectArray) {
                            objectArray[0] = raster != null ? raster : new Object();
                            objectArray.notifyAll();
                            Map map = this.tilesInProgress;
                            synchronized (map) {
                                this.tilesInProgress.remove(object);
                            }
                            // ** MonitorExit[objectArray3] (shouldn't be in output)
                            return raster;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    Object[] objectArray5 = objectArray;
                    synchronized (objectArray) {
                        objectArray[0] = raster != null ? raster : new Object();
                        objectArray.notifyAll();
                        Map map = this.tilesInProgress;
                        synchronized (map) {
                            this.tilesInProgress.remove(object);
                        }
                        // ** MonitorExit[objectArray5] (shouldn't be in output)
                        throw throwable;
                    }
                }
                synchronized (objectArray) {
                    objectArray[0] = raster != null ? raster : new Object();
                    objectArray.notifyAll();
                    Map map = this.tilesInProgress;
                    synchronized (map) {
                        this.tilesInProgress.remove(object);
                    }
                    // ** MonitorExit[var12_17] (shouldn't be in output)
                    return raster;
                }
            }
            objectArray2 = objectArray;
            synchronized (objectArray) {
                if (objectArray[0] == null) {
                    try {
                        objectArray.wait();
                    }
                    catch (Exception string) {
                        // empty catch block
                    }
                }
                if (!(objectArray[0] instanceof Raster)) throw new RuntimeException(JaiI18N.getString("SunTileScheduler5"));
                return (Raster)objectArray[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object scheduleJob(PlanarImage planarImage, Point[] pointArray, boolean bl, boolean bl2, TileComputationListener[] tileComputationListenerArray) {
        Object object;
        Raster[] rasterArray;
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException();
        }
        if ((bl || bl2) && tileComputationListenerArray != null) {
            throw new IllegalArgumentException();
        }
        if (bl && bl2) {
            throw new IllegalArgumentException();
        }
        int n = pointArray.length;
        Object object2 = rasterArray = new Raster[n];
        int n2 = 0;
        Job[] jobArray = null;
        int n3 = 0;
        Object object3 = this.getWorkers(bl2);
        synchronized (object3) {
            n2 = this.getNumThreads(bl2);
            if (n2 > 0) {
                if (n <= n2 || !bl && !bl2) {
                    jobArray = new Job[n];
                    if (!bl && !bl2) {
                        object = new Request(this, planarImage, pointArray, tileComputationListenerArray);
                        object2 = object;
                        while (n3 < n) {
                            Point point = pointArray[n3];
                            Object object4 = SunTileScheduler.tileKey(planarImage, point.x, point.y);
                            Map map = this.tileRequests;
                            synchronized (map) {
                                List<Object> list = null;
                                if (this.tileRequests.containsKey(object4)) {
                                    list = (List)this.tileRequests.get(object4);
                                    list.add(object);
                                    --n;
                                } else {
                                    list = new ArrayList<Object>();
                                    list.add(object);
                                    this.tileRequests.put(object4, list);
                                    jobArray[n3] = new RequestJob(this, planarImage, point.x, point.y, rasterArray, n3);
                                    this.tileJobs.put(object4, jobArray[n3]);
                                    this.addJob(jobArray[n3++], false);
                                }
                            }
                        }
                    } else {
                        while (n3 < n) {
                            jobArray[n3] = new TileJob(this, bl, planarImage, pointArray, rasterArray, n3, 1);
                            this.addJob(jobArray[n3++], bl2);
                        }
                    }
                } else {
                    float f = 1.0f / (2.0f * (float)n2);
                    int n4 = n2 == 1 ? n : Math.min(Math.max(1, (int)(f * (float)n / 2.0f + 0.5f)), n);
                    int n5 = n2 == 1 ? 1 : (int)((float)n / (float)n4 + 0.5f);
                    jobArray = new TileJob[n5];
                    int n6 = 0;
                    int n7 = n - n6;
                    while (n7 > 0) {
                        int n8 = (int)(f * (float)n7 + 0.5f);
                        if (n8 < n4) {
                            n8 = n4;
                        }
                        if (n8 > n7) {
                            n8 = n7;
                        }
                        if ((n7 -= n8) < n4) {
                            n8 += n7;
                            n7 = 0;
                        }
                        jobArray[n3] = new TileJob(this, bl, planarImage, pointArray, rasterArray, n6, n8);
                        this.addJob(jobArray[n3++], bl2);
                        n6 += n8;
                    }
                }
            }
        }
        if (n2 != 0) {
            if (bl) {
                object3 = this.getQueue(bl2);
                for (int i = 0; i < n3; ++i) {
                    Object object5 = this;
                    synchronized (object5) {
                        while (jobArray[i].notDone()) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    object5 = jobArray[i].getException();
                    if (object5 == null) continue;
                    String string = JaiI18N.getString("SunTileScheduler7");
                    this.sendExceptionToListener(string, new ImagingException(string, (Throwable)object5));
                }
            }
        } else {
            object3 = null;
            if (!bl && !bl2) {
                object3 = new Request(this, planarImage, pointArray, tileComputationListenerArray);
                object2 = object3;
            }
            if ((object = this.compute(planarImage, pointArray, rasterArray, 0, n, (Request)object3)) != null) {
                String string = JaiI18N.getString("SunTileScheduler7");
                this.sendExceptionToListener(string, new ImagingException(string, (Throwable)object));
            }
        }
        return object2;
    }

    public Raster[] scheduleTiles(OpImage opImage, Point[] pointArray) {
        if (opImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        return (Raster[])this.scheduleJob(opImage, pointArray, true, false, null);
    }

    public TileRequest scheduleTiles(PlanarImage planarImage, Point[] pointArray, TileComputationListener[] tileComputationListenerArray) {
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler4"));
        }
        return (TileRequest)this.scheduleJob(planarImage, pointArray, false, false, tileComputationListenerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void cancelTiles(TileRequest tileRequest, Point[] pointArray) {
        Point[] pointArray2;
        if (tileRequest == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler3"));
        }
        Request request = (Request)tileRequest;
        Map map = this.tileRequests;
        // MONITORENTER : map
        List list = request.indices;
        if (pointArray != null && pointArray.length > 0) {
            List<Point> list2 = Arrays.asList(pointArray);
            list2.retainAll(list);
            pointArray2 = list2.toArray(new Point[0]);
        } else {
            pointArray2 = list.toArray(new Point[0]);
        }
        int n = pointArray2.length;
        Integer n2 = new Integer(3);
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                // MONITOREXIT : map
                return;
            }
            Point point = pointArray2[n3];
            Object object = SunTileScheduler.tileKey(request.image, point.x, point.y);
            List list3 = (List)this.tileRequests.get(object);
            if (list3 != null) {
                Object object2;
                TileRequest[] tileRequestArray;
                list3.remove(request);
                if (list3.isEmpty()) {
                    tileRequestArray = this.queue;
                    // MONITORENTER : this.queue
                    object2 = this.tileJobs.remove(object);
                    if (object2 != null) {
                        this.queue.remove(object2);
                    }
                    // MONITOREXIT : tileRequestArray
                    this.tileRequests.remove(object);
                }
                request.tileStatus.put(point, n2);
                if (request.listeners != null) {
                    tileRequestArray = new TileRequest[]{request};
                    object2 = request.listeners.iterator();
                    while (object2.hasNext()) {
                        TileComputationListener tileComputationListener = (TileComputationListener)object2.next();
                        tileComputationListener.tileCancelled(this, tileRequestArray, request.image, point.x, point.y);
                    }
                }
            }
            ++n3;
        }
    }

    public void prefetchTiles(PlanarImage planarImage, Point[] pointArray) {
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        this.scheduleJob(planarImage, pointArray, false, true, null);
    }

    public void setParallelism(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler2"));
        }
        this.parallelism = n;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setPrefetchParallelism(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler2"));
        }
        this.prefetchParallelism = n;
    }

    public int getPrefetchParallelism() {
        return this.prefetchParallelism;
    }

    public void setPriority(int n) {
        this.priority = Math.max(Math.min(n, 10), 1);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPrefetchPriority(int n) {
        this.prefetchPriority = Math.max(Math.min(n, 10), 1);
    }

    public int getPrefetchPriority() {
        return this.prefetchPriority;
    }

    private void createThreadGroup(boolean bl) {
        if (this.rootGroup == null || this.rootGroup.isDestroyed()) {
            this.rootGroup = new ThreadGroup(this.nameOfThisInstance);
            this.rootGroup.setDaemon(true);
        }
        if (bl && (this.prefetchGroup == null || this.prefetchGroup.isDestroyed())) {
            this.prefetchGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Prefetch");
            this.prefetchGroup.setDaemon(true);
        }
        if (!bl && (this.standardGroup == null || this.standardGroup.isDestroyed())) {
            this.standardGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Standard");
            this.standardGroup.setDaemon(true);
        }
        Vector vector = this.getWorkers(bl);
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            Thread thread = (Thread)vector.get(i);
            if (thread.isAlive()) continue;
            vector.remove(thread);
        }
        if (bl) {
            this.numPrefetchThreads = vector.size();
        } else {
            this.numWorkerThreads = vector.size();
        }
    }

    private int getNumThreads(boolean bl) {
        int n;
        int n2;
        int n3;
        this.createThreadGroup(bl);
        Vector vector = this.getWorkers(bl);
        if (bl) {
            n3 = this.numPrefetchThreads;
            n2 = this.prefetchParallelism;
            n = this.prefetchPriority;
        } else {
            n3 = this.numWorkerThreads;
            n2 = this.parallelism;
            n = this.priority;
        }
        if (n3 > 0 && ((Thread)vector.get(0)).getPriority() != n) {
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                Thread thread = (Thread)vector.get(i);
                if (thread == null || thread.getThreadGroup() == null) continue;
                thread.setPriority(n);
            }
        }
        if (n3 < n2) {
            while (n3 < n2) {
                WorkerThread workerThread = new WorkerThread(bl ? this.prefetchGroup : this.standardGroup, this, bl);
                workerThread.setPriority(n);
                vector.add(workerThread);
                ++n3;
            }
        } else {
            while (n3 > n2) {
                this.addJob(WorkerThread.TERMINATE, bl);
                --n3;
            }
        }
        if (bl) {
            this.numPrefetchThreads = n3;
        } else {
            this.numWorkerThreads = n3;
        }
        return n3;
    }

    Vector getWorkers(boolean bl) {
        return bl ? this.workers : this.prefetchWorkers;
    }

    LinkedList getQueue(boolean bl) {
        return bl ? this.prefetchQueue : this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJob(Object object, boolean bl) {
        LinkedList linkedList;
        if (object == null || object != WorkerThread.TERMINATE && !(object instanceof Job)) {
            throw new IllegalArgumentException();
        }
        LinkedList linkedList2 = linkedList = this.getQueue(bl);
        synchronized (linkedList) {
            if (bl || linkedList.isEmpty() || object instanceof RequestJob) {
                linkedList.addLast(object);
            } else {
                boolean bl2 = false;
                for (int i = linkedList.size() - 1; i >= 0; --i) {
                    if (!(linkedList.get(i) instanceof TileJob)) continue;
                    linkedList.add(i + 1, object);
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    linkedList.addFirst(object);
                }
            }
            linkedList.notify();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.terminateAll(false);
        this.terminateAll(true);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateAll(boolean bl) {
        Vector vector = this.getWorkers(bl);
        synchronized (vector) {
            int n = bl ? this.numPrefetchThreads : this.numWorkerThreads;
            for (int i = 0; i < n; ++i) {
                this.addJob(WorkerThread.TERMINATE, bl);
                if (bl) {
                    --this.numPrefetchThreads;
                    continue;
                }
                --this.numWorkerThreads;
            }
        }
    }

    void sendExceptionToListener(String string, Throwable throwable) {
        ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
        imagingListener.errorOccurred(string, throwable, this, false);
    }
}

