/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp.pixelparsers;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;
import org.apache.commons.imaging.formats.bmp.pixelparsers.PixelParserSimple;

public class PixelParserBitFields
extends PixelParserSimple {
    private final int redShift;
    private final int greenShift;
    private final int blueShift;
    private final int alphaShift;
    private final int redMask;
    private final int greenMask;
    private final int blueMask;
    private final int alphaMask;
    private int bytecount = 0;

    public PixelParserBitFields(BmpHeaderInfo bhi, byte[] ColorTable, byte[] ImageData) {
        super(bhi, ColorTable, ImageData);
        this.redMask = bhi.redMask;
        this.greenMask = bhi.greenMask;
        this.blueMask = bhi.blueMask;
        this.alphaMask = bhi.alphaMask;
        this.redShift = this.getMaskShift(this.redMask);
        this.greenShift = this.getMaskShift(this.greenMask);
        this.blueShift = this.getMaskShift(this.blueMask);
        this.alphaShift = this.alphaMask != 0 ? this.getMaskShift(this.alphaMask) : 0;
    }

    private int getMaskShift(int mask) {
        int trailingZeroes = 0;
        while ((1 & mask) == 0) {
            mask = Integer.MAX_VALUE & mask >> 1;
            ++trailingZeroes;
        }
        int maskLength = 0;
        while ((1 & mask) == 1) {
            mask = Integer.MAX_VALUE & mask >> 1;
            ++maskLength;
        }
        return trailingZeroes - (8 - maskLength);
    }

    public int getNextRGB() throws ImageReadException, IOException {
        int data;
        if (this.bhi.bitsPerPixel == 8) {
            data = 0xFF & this.imageData[this.bytecount + 0];
            ++this.bytecount;
        } else if (this.bhi.bitsPerPixel == 24) {
            data = this.is.read3Bytes("Pixel", "BMP Image Data");
            this.bytecount += 3;
        } else if (this.bhi.bitsPerPixel == 32) {
            data = this.is.read4Bytes("Pixel", "BMP Image Data");
            this.bytecount += 4;
        } else if (this.bhi.bitsPerPixel == 16) {
            data = this.is.read2Bytes("Pixel", "BMP Image Data");
            this.bytecount += 2;
        } else {
            throw new ImageReadException("Unknown BitsPerPixel: " + this.bhi.bitsPerPixel);
        }
        int red = this.redMask & data;
        int green = this.greenMask & data;
        int blue = this.blueMask & data;
        int alpha = this.alphaMask != 0 ? this.alphaMask & data : 255;
        red = this.redShift >= 0 ? red >> this.redShift : red << -this.redShift;
        green = this.greenShift >= 0 ? green >> this.greenShift : green << -this.greenShift;
        blue = this.blueShift >= 0 ? blue >> this.blueShift : blue << -this.blueShift;
        alpha = this.alphaShift >= 0 ? alpha >> this.alphaShift : alpha << -this.alphaShift;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        return rgb;
    }

    public void newline() throws ImageReadException, IOException {
        while (this.bytecount % 4 != 0) {
            this.is.readByte("Pixel", "BMP Image Data");
            ++this.bytecount;
        }
    }
}

