/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp.pixelparsers;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;
import org.apache.commons.imaging.formats.bmp.pixelparsers.PixelParser;

public class PixelParserRle
extends PixelParser {
    public PixelParserRle(BmpHeaderInfo bhi, byte[] ColorTable, byte[] ImageData) {
        super(bhi, ColorTable, ImageData);
    }

    private int getSamplesPerByte() throws ImageReadException {
        if (this.bhi.bitsPerPixel == 8) {
            return 1;
        }
        if (this.bhi.bitsPerPixel == 4) {
            return 2;
        }
        throw new ImageReadException("BMP RLE: bad BitsPerPixel: " + this.bhi.bitsPerPixel);
    }

    private int[] convertDataToSamples(int data) throws ImageReadException {
        int[] rgbs;
        if (this.bhi.bitsPerPixel == 8) {
            rgbs = new int[]{this.getColorTableRGB(data)};
        } else if (this.bhi.bitsPerPixel == 4) {
            rgbs = new int[2];
            int sample1 = data >> 4;
            int sample2 = 0xF & data;
            rgbs[0] = this.getColorTableRGB(sample1);
            rgbs[1] = this.getColorTableRGB(sample2);
        } else {
            throw new ImageReadException("BMP RLE: bad BitsPerPixel: " + this.bhi.bitsPerPixel);
        }
        return rgbs;
    }

    private int processByteOfData(int[] rgbs, int repeat, int x, int y, int width, int height, ImageBuilder imageBuilder) {
        int pixels_written = 0;
        for (int i = 0; i < repeat; ++i) {
            if (x >= 0 && x < width && y >= 0 && y < height) {
                int rgb = rgbs[i % rgbs.length];
                imageBuilder.setRGB(x, y, rgb);
            } else {
                System.out.println("skipping bad pixel (" + x + "," + y + ")");
            }
            ++x;
            ++pixels_written;
        }
        return pixels_written;
    }

    public void processImage(ImageBuilder imageBuilder) throws ImageReadException, IOException {
        int width = this.bhi.width;
        int height = this.bhi.height;
        int x = 0;
        int y = height - 1;
        boolean done = false;
        block5: while (!done) {
            int a = 0xFF & this.is.readByte("RLE (" + x + "," + y + ") a", "BMP: Bad RLE");
            int b = 0xFF & this.is.readByte("RLE (" + x + "," + y + ") b", "BMP: Bad RLE");
            if (a == 0) {
                switch (b) {
                    case 0: {
                        --y;
                        x = 0;
                        continue block5;
                    }
                    case 1: {
                        done = true;
                        continue block5;
                    }
                    case 2: {
                        int deltaX = 0xFF & this.is.readByte("RLE deltaX", "BMP: Bad RLE");
                        int deltaY = 0xFF & this.is.readByte("RLE deltaY", "BMP: Bad RLE");
                        x += deltaX;
                        y -= deltaY;
                        continue block5;
                    }
                }
                int SamplesPerByte = this.getSamplesPerByte();
                int size = b / SamplesPerByte;
                if (b % SamplesPerByte > 0) {
                    ++size;
                }
                if (size % 2 != 0) {
                    ++size;
                }
                byte[] bytes = this.is.readBytes("bytes", size, "RLE: Absolute Mode");
                int remaining = b;
                int i = 0;
                while (remaining > 0) {
                    int[] samples = this.convertDataToSamples(0xFF & bytes[i]);
                    int towrite = Math.min(remaining, SamplesPerByte);
                    int written = this.processByteOfData(samples, towrite, x, y, width, height, imageBuilder);
                    x += written;
                    remaining -= written;
                    ++i;
                }
                continue;
            }
            int[] rgbs = this.convertDataToSamples(b);
            x += this.processByteOfData(rgbs, a, x, y, width, height, imageBuilder);
        }
    }
}

