/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd.datareaders;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.PackBits;
import org.apache.commons.imaging.common.mylzw.BitsToByteInputStream;
import org.apache.commons.imaging.common.mylzw.MyBitInputStream;
import org.apache.commons.imaging.formats.psd.ImageContents;
import org.apache.commons.imaging.formats.psd.PsdHeaderInfo;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParser;
import org.apache.commons.imaging.formats.psd.datareaders.DataReader;

public class CompressedDataReader
extends DataReader {
    public CompressedDataReader(DataParser fDataParser) {
        super(fDataParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(InputStream is, BufferedImage bi, ImageContents imageContents, BinaryFileParser bfp) throws ImageReadException, IOException {
        PsdHeaderInfo header = imageContents.header;
        int width = header.Columns;
        int height = header.Rows;
        int scanline_count = height * header.Channels;
        int[] scanline_bytecounts = new int[scanline_count];
        for (int i = 0; i < scanline_count; ++i) {
            scanline_bytecounts[i] = BinaryFunctions.read2Bytes("scanline_bytecount[" + i + "]", is, "PSD: bad Image Data", bfp.getByteOrder());
        }
        bfp.setDebug(false);
        int depth = header.Depth;
        int channel_count = this.dataParser.getBasicChannelsCount();
        int[][][] data = new int[channel_count][height][];
        for (int channel = 0; channel < channel_count; ++channel) {
            for (int y = 0; y < height; ++y) {
                int index = channel * height + y;
                byte[] packed = BinaryFunctions.readBytes("scanline", is, scanline_bytecounts[index], "PSD: Missing Image Data");
                byte[] unpacked = new PackBits().decompress(packed, width);
                ByteArrayInputStream bais = new ByteArrayInputStream(unpacked);
                MyBitInputStream mbis = new MyBitInputStream(bais, ByteOrder.MOTOROLA);
                BitsToByteInputStream bbis = null;
                try {
                    bbis = new BitsToByteInputStream(mbis, 8);
                    int[] scanline = bbis.readBitsArray(depth, width);
                    data[channel][y] = scanline;
                    continue;
                }
                finally {
                    if (bbis != null) {
                        bbis.close();
                    }
                }
            }
        }
        this.dataParser.parseData(data, bi, imageContents);
    }
}

