/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.palette;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.palette.ColorComponent;
import org.apache.commons.imaging.palette.ColorCount;
import org.apache.commons.imaging.palette.ColorGroup;
import org.apache.commons.imaging.palette.ColorGroupCut;
import org.apache.commons.imaging.palette.MedianCutImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedianCutMostPopulatedBoxesImplementation
extends MedianCutImplementation {
    @Override
    public boolean performNextMedianCut(List<ColorGroup> colorGroups, boolean ignoreAlpha) throws ImageWriteException {
        int limit;
        int maxPoints = 0;
        ColorGroup colorGroup = null;
        for (int i = 0; i < colorGroups.size(); ++i) {
            if (colorGroups.get((int)i).max_diff <= 0) continue;
            ColorGroup c = colorGroups.get(i);
            if (c.totalPoints <= maxPoints) continue;
            colorGroup = c;
            maxPoints = c.totalPoints;
        }
        if (colorGroup == null) {
            return false;
        }
        double bestScore = Double.MAX_VALUE;
        Enum bestColorComponent = null;
        int bestMedianIndex = -1;
        for (ColorComponent colorComponent : ColorComponent.values()) {
            int median_index;
            if (ignoreAlpha && colorComponent == ColorComponent.ALPHA) continue;
            Collections.sort(colorGroup.color_counts, new ColorComparer(colorComponent));
            int count_half = (int)Math.round((double)colorGroup.totalPoints / 2.0);
            int old_count = 0;
            int new_count = 0;
            for (median_index = 0; median_index < colorGroup.color_counts.size(); ++median_index) {
                ColorCount color_count = colorGroup.color_counts.get(median_index);
                if ((new_count += color_count.count) >= count_half) break;
                old_count = new_count;
            }
            if (median_index == colorGroup.color_counts.size() - 1) {
                --median_index;
            } else if (median_index > 0) {
                int new_diff = Math.abs(new_count - count_half);
                int old_diff = Math.abs(count_half - old_count);
                if (old_diff < new_diff) {
                    --median_index;
                }
            }
            ArrayList<ColorCount> lowerColors = new ArrayList<ColorCount>(colorGroup.color_counts.subList(0, median_index + 1));
            ArrayList<ColorCount> upperColors = new ArrayList<ColorCount>(colorGroup.color_counts.subList(median_index + 1, colorGroup.color_counts.size()));
            if (lowerColors.size() == 0 || upperColors.size() == 0) continue;
            ColorGroup lowerGroup = new ColorGroup(lowerColors, ignoreAlpha);
            ColorGroup upperGroup = new ColorGroup(upperColors, ignoreAlpha);
            int diff = Math.abs(lowerGroup.totalPoints - upperGroup.totalPoints);
            double score = (double)diff / (double)Math.max(lowerGroup.totalPoints, upperGroup.totalPoints);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestColorComponent = colorComponent;
            bestMedianIndex = median_index;
        }
        if (bestColorComponent == null) {
            return false;
        }
        Collections.sort(colorGroup.color_counts, new ColorComparer((ColorComponent)bestColorComponent));
        ArrayList<ColorCount> lowerColors = new ArrayList<ColorCount>(colorGroup.color_counts.subList(0, bestMedianIndex + 1));
        ArrayList<ColorCount> upperColors = new ArrayList<ColorCount>(colorGroup.color_counts.subList(bestMedianIndex + 1, colorGroup.color_counts.size()));
        ColorGroup lowerGroup = new ColorGroup(lowerColors, ignoreAlpha);
        ColorGroup upperGroup = new ColorGroup(upperColors, ignoreAlpha);
        colorGroups.remove(colorGroup);
        colorGroups.add(lowerGroup);
        colorGroups.add(upperGroup);
        ColorCount median_value = colorGroup.color_counts.get(bestMedianIndex);
        switch (1.$SwitchMap$org$apache$commons$imaging$palette$ColorComponent[bestColorComponent.ordinal()]) {
            case 1: {
                limit = median_value.alpha;
                break;
            }
            case 2: {
                limit = median_value.red;
                break;
            }
            case 3: {
                limit = median_value.green;
                break;
            }
            case 4: {
                limit = median_value.blue;
                break;
            }
            default: {
                throw new Error("Bad mode.");
            }
        }
        colorGroup.cut = new ColorGroupCut(lowerGroup, upperGroup, (ColorComponent)bestColorComponent, limit);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColorComparer
    implements Comparator<ColorCount>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ColorComponent colorComponent;

        public ColorComparer(ColorComponent colorComponent) {
            this.colorComponent = colorComponent;
        }

        @Override
        public int compare(ColorCount c1, ColorCount c2) {
            switch (this.colorComponent) {
                case ALPHA: {
                    return c1.alpha - c2.alpha;
                }
                case RED: {
                    return c1.red - c2.red;
                }
                case GREEN: {
                    return c1.green - c2.green;
                }
                case BLUE: {
                    return c1.blue - c2.blue;
                }
            }
            return 0;
        }
    }
}

