<#assign last_page = (entrylist?size / entries_per_page)?ceiling />
<#assign total_rows = last_page * entries_per_page />
<script language="JavaScript" type="text/javascript">
  	  var currentPage = 1;
  	  var numberOfEntries = ${entrylist?size};
  	  var entriesPerPage = ${entries_per_page};
  	  var totalRows = ${total_rows};
  	  var lastPage = ${last_page};
  	  
  	  function switchToPage(x) {
  	    var previousPage = currentPage;
  	  
  	    if (x == "next") {
  	      currentPage += 1;
  	    } else if (x == "previous") {
  	      currentPage -= 1;
  	    } else {
  	      currentPage = x;
  	    }
      
      	checkBounds();  
        checkButtonStates();
  	    
  	    // break if the page has not changed
  	    if (currentPage == previousPage) {
  	      return;
  	    }
  	  
  	    // set page number indicator
  	    if (document.getElementById('pagenumber') != null) {
  	      document.getElementById('pagenumber').innerHTML = currentPage;
  	    }
  	    
  	  	hideAllRows();
  	   	showRowsOnCurrentPage();
  	  }
  	  
  	  function showRowsOnCurrentPage() {
  	    var start = (currentPage - 1) * entriesPerPage + 1;
  	    for (var row = start; row < (start + entriesPerPage); row++) {
  	    	if (row <= totalRows) {
  	    		document.getElementById('${entry_prefix}' + row).style.display = "block";
  	    	}  
  	    }
  	  }
  	  
  	  function hideAllRows() {
  	    for (var row = 1; row <= totalRows; row++) {
  	      var rowobj = document.getElementById('${entry_prefix}' + row);
  	      if (rowobj.style.display != "none") {
  	      	rowobj.style.display = "none";
  	      }
  	    }
  	  }
  	  
  	  function checkBounds() {  	  
  	    if (currentPage > lastPage) {
  	      currentPage = lastPage;
  	    } else if (currentPage < 1) {
  	      currentPage = 1;
  	    }
  	  }
  	  
      function checkButtonStates() {
        // enable / disable previous and next buttons
  	    if (currentPage == 1) {
  	      document.getElementById('prevbutton').className = "btnwhitedis";
  	    } else {
  	      document.getElementById('prevbutton').className = "btnwhite";
  	    }
  	    if (currentPage == lastPage) {
  	      document.getElementById('nextbutton').className = "btnwhitedis";
  	    } else {
  	      document.getElementById('nextbutton').className = "btnwhite";
  	    }
  	    // disable current page button / enable all other page buttons
  	    for (var page = 1; page <= lastPage; page++) {
  	      if (page == currentPage) {
  	      	document.getElementById('pagebutton'+page).className = "btnwhitedis";
  	      } else {
  	        document.getElementById('pagebutton'+page).className = "btnwhite";
  	      }
  	    }
      }  	   
</script>

