<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/byteprint.ftl">
<#include "/macros/barchart.ftl">
<#include "/macros/formtable.ftl">

   <@tableHeader Heading="FSI Server Administration Interface" />

   <table cellpadding="0" cellspacing="0" style="width: 500px;">
    <tr>
     <td class="pad1">Administration interface for the FSI Server. This interface allows performing all 
     administrative tasks to configure FSI Server and to manage user accounts.
     <#if sourcemanager_state=="disabled" >
     <span style="color:red;"><br /><br />The importer is currently disabled by the settings. All configuration 
     dialogs that require a running importer have been disabled.</span>
     </#if>
     </td>
    </tr>
   </table>

   <table cellpadding="0" cellspacing="0" style="width: 500px;">
    <tr><td colspan="2" class="sectionheader">General Information</td></tr>
    <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
    <tr><td class="pad1">FSI Server Version</td><td>${version}</td></tr>
    <tr>
     <td class="pad1">Uptime</td><td>
      <#if (uptime > (24*3600))>
       <#assign days=(uptime / (24*3600))?floor />
       <#assign hours=(((uptime - (days * 24 * 3600))/ 3600)?floor) />
       <#assign minutes=(((uptime - ((days * 24 * 3600) + (hours * 3600))) / 60)?floor) />
       ${days} days ${hours} hours ${minutes} minutes 
      <#elseif (uptime > 3600)>
       <#assign hours=(uptime / 3600)?floor />
       <#assign minutes=(((uptime - (hours * 3600))?floor / 60)?floor) />
       ${hours} hours ${minutes} minutes ${uptime - ((hours * 3600) + (minutes * 60))} seconds
      <#elseif (uptime > 60)>
        <#assign minutes=(uptime / 60)?floor />
        ${minutes} minutes ${uptime - (minutes * 60)} seconds
      <#else> 
    	${uptime} seconds
      </#if>
     </td>
    </tr>
    <tr><td class="pad1">Disk usage</td><td><@barChart used=usedspace total=(freespace+usedspace) height=17 width=100 /></td></tr>
    <tr><td class="pad1">CPU load</td><td><@barChart used=cpuload total=1 height=17 width=100 /></td></tr>
    <tr><td class="pad1">Images</td><td>${images}</td></tr>
   
    <tr><td colspan="2" class="sectionheader">Licence Information</td></tr>
    <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
    <tr><td class="pad1">Licence installed</td><td><#if licenced>yes<#else>no</#if></td></tr>
    <tr><td class="pad1">PID</td>
      <td>
     	<#if pid??>${pid}<#else>-</#if>   
      </td>
    </tr>
    <tr><td class="pad1">Edition</td>
      <td>
     	<#if licence_edition??>${licence_edition}<#else>-</#if>   
      </td>
    </tr>
    <tr><td class="pad1">Licensee</td>
      <td>
     	<#if licensee??>${licensee}<#else>-</#if>   
      </td>
    </tr>
    <tr><td class="pad1">Issue Date</td>
      <td>
     	<#if licence_date??>${licence_date}<#else>-</#if>   
      </td>
    </tr>
    <tr><td class="pad1">Expires</td><td>
      <#if (licenced && (expireResttime > 0))>
       <#if (expireResttime > (24*3600))>
        <#assign days=(expireResttime / (24*3600))?floor />
        <#assign hours=(((expireResttime - (days * 24 * 3600))/ 3600)?floor) />
        <#assign minutes=(((expireResttime - ((days * 24 * 3600) + (hours * 3600))) / 60)?floor) />
        ${days} days ${hours} hours ${minutes} minutes 
       <#elseif (expireResttime > 3600)>
        <#assign hours=(expireResttime / 3600)?floor />
        <#assign minutes=(((expireResttime - (hours * 3600))?floor / 60)?floor) />
        ${hours} hours ${minutes} minutes ${expireResttime - ((hours * 3600) + (minutes * 60))} seconds
       <#elseif (expireResttime > 60)>
         <#assign minutes=(expireResttime / 60)?floor />
         ${minutes} minutes ${expireResttime - (minutes * 60)} seconds
       <#else> 
    	 ${expireResttime} seconds
       </#if>
       <#elseif (licenced && (expireResttime < 0)) >
         <span style="color:red;">expired</span>
       <#else>-</#if></td></tr>
    <tr><td class="pad1">Max. Images</td>
      <td>
        <#if (maximages > 1)>
         <#if (images > maximages)><span style="color:red;">${images} / ${maximages}</span>
         <#else>${images} / ${maximages}</#if>
        <#elseif maximages == -1>${images} / unlimited
        <#else>-</#if>
      </td>
    </tr>
    <tr><td class="pad1">Max. User Groups</td>
      <td>
        <#if (maxgroups > 1)>
         <#if (groups > maxgroups)><span style="color:red;">${groups} / ${maxgroups}</span>
         <#else>${groups} / ${maxgroups}</#if>
        <#elseif maxgroups == -1>${groups} / unlimited
        <#else>-</#if>
      </td>
    </tr>
    <tr><td class="pad1">Max. Connectors</td>
      <td>
        <#if (maxconnectors > 1)>
         <#if (connectors > maxconnectors)><span style="color:red;">${connectors} / ${maxconnectors}</span>
         <#else>${connectors} / ${maxconnectors}</#if>
        <#elseif maxconnectors == -1>${connectors} / unlimited
        <#else>-</#if>
      </td>
    </tr>
    <tr><td class="pad1">JMX Support</td>
      <td>
     	<#if jmx>yes<#else>no</#if>   
      </td>
    </tr>
    <tr><td class="pad1">Batch Processing</td>
      <td>
     	<#if batch_processing>yes<#else>no</#if>   
      </td>
    </tr>
    <#if licence_nfr>
     <tr>
      <td class="pad1" colspan="2">
       The installed licence is an NFR license: Reseller "Not For Resale" license, for demonstrational purposes only.
      </td>
     </tr>
    </#if>
    <#if licence_non_profit>
     <tr>
      <td class="pad1" colspan="2">
       The installed licence is a non-profit license: For legally constituted organizations without a commercial profit interest.  
      </td>
     </tr> 
    </#if>
    
    <tr><td colspan="2" class="sectionheader">Source Manager State
       <#if sourcemanager_state!="disabled" >
      <span style="font-size: 8pt">(<a href="?<@printRequiredParams method="get" />action=sourcemanagerstate" class="txtsmall">show details</a>)</span>
      </#if>
      </td></tr>
    <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
    <tr>
      <td class="pad1">State:</td>
      <td>${sourcemanager_state}</td>
    </tr>
    <#if sourcemanager_state!="disabled" >
    <tr>
      <td class="pad1">Recently Imported:</td>
      <td>${recently_imported} images</td>
    </tr>
    </#if>
   </table>
<@tableFooter/>  
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">
