<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

  <#if show_chooser??>
  
    <@tableHeader Heading="FSI Viewer Skins" />
  
    <table cellspacing="0" cellpadding="0px" style="border: 0px; width: 500px;">
     <tr>
      <td class="pad1" colspan="2">
       Every installed FSI Viewer instance has its own skins. Please choose if you would like to manage the skins 
       of the default viewer or of a personalized user viewer.
      </td>
     </tr>
     <tr>
      <td class="sectionheader" colspan="2">Default viewer</td>
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1">
       Manage the skins for the default viewer. These skins will be available to all users that 
       do not have an own FSI Viewer instance.
      </td>
      <td class="pad1" style="text-align: right; vertical-align: bottom;">
       <form action="pt.do" method="post" onsubmit="this.submit();">
      	<@printRequiredParams method="post" />
      	<input type="hidden" name="action" value="listskins" />
      	<input type="hidden" name="defaultviewer" value="true" />
        <@formsubmit value="Manage Skins" helpid="manage_default_viewer_skins" />
       </form>
      </td>
     </tr>
     <tr>
      <td class="sectionheader" colspan="2">User viewer</td>
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1">
       Manage the skins for a User FSI Viewer instance. The skins managed here will only be available to the selected 
       FSI Viewer.
      </td>
      <td class="pad1" style="text-align: right; vertical-align: bottom;">
       <form action="pt.do" method="post" onsubmit="this.submit();">
      	<@printRequiredParams method="post" />
      	<input type="hidden" name="action" value="listskins" />
      	<@formgfxselect objid="user" itemlist=existing_userviewers preselect=existing_userviewers?first.value helpid="" /><br />
        <@formsubmit value="Manage Skins" helpid="manage_user_viewer_skins" />
       </form>
      </td>
    </table>    
  
  <#else>
  
   <#if user?? >
    <@tableHeader Heading="FSI Viewer Skins for user ${user}" />
   <#else>
    <@tableHeader Heading="FSI Viewer Skins for the default viewer" />
   </#if>
  
   <form action="pt.do" method="post" enctype="multipart/form-data" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
   	<input type="hidden" name="action" value="uploadskin" />
   	<#if user?? ><input type="hidden" name="user" value="${user}" /></#if>
   	
    <table cellspacing="0" cellpadding="0px" style="border: 0px; width: 500px;">
     <tr>
      <td class="pad1" colspan="5">
        <#if message??><div style="width: 100%; text-align: center; color: green">"${message}</div><br /><br /></#if>
        The following list shows the installed skins for the selected FSI Viewer instance and shows if the skins 
        include an intro and is usable for FSI Pages.   
      </td>
     </tr>
	 <tr>
	    <td class="sectionheader">Name</td>
	    <td class="sectionheader">Viewer</td>
	    <td class="sectionheader">Intro</td>
	    <td class="sectionheader">Pages</td>
	    <td class="sectionheader"></td>
	 </tr>
     <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
     <#assign i=1 />
	 <#list skins?keys?sort as skin>
	    <tr>
	      <td class="pad1">${skin}</td>
	      <td class="pad1" style="min-width: 0px;"><#if skins[skin].viewer?? ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	      <td class="pad1" style="min-width: 0px;"><#if skins[skin].intro?? ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	      <td class="pad1" style="min-width: 0px;"><#if skins[skin].pages?? ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	      <td class="pad1" style="min-width: 0px; text-align: right" >
            <a href="pt.do?<@printRequiredParams method="get" />action=deleteskin&skinname=${skin}<#if user??>&user=${user}</#if>"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Delete Skin" alt="Delete Skin" src="images/apps/app22/delete_profile.png" id="app1iconic" <#if i==1>help="<@appID />:delete_skin"</#if>/></a>
          </td>
	    </tr>
	    <#assign i=i+1 />
	 </#list>
	  
	 <tr>
	    <td class="sectionheader" colspan="5">Upload New Skin</td>
     </tr>
     <tr><td colspan="5"><hr size="1" class="hr1"/></td></tr>
	 <tr>
		  <td class="pad1">Select the skin zip file provided by NeptuneLabs or your local reseller:</td>
	      <td class="pad1" colspan="3" align="right"><input class="btnwhite" type="file" name="zipfile" onChange="document.getElementById('uploadbutton').className='btnwhite'" /></td>
	 </tr>
	 <tr>
	     <td class="pad1" align="right" colspan="5" style="padding-top: 10px;">
	       <@formsubmit disabled="true" id="uploadbutton" value="Upload Selected" helpid="upload_skin" />
	     </td>
	 </tr>
	</table>
   </form>
	  
  </#if>
  <@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">