<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Update Viewers" />
  
  <#if show_error?? >
  
    <table cellspacing="0" cellpadding="0" border="0" width="500px">
     <tr>
      <td class="pad1">
       <#if message??><span style="color: red">${message}</span></#if>
      </td>
     </tr>
     <tr>
      <td class="pad1" style="text-align: right;">
       <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
      </td>
     </tr>
    </table>
    
  <#elseif request_confirmation??>
    
    <script type="text/javascript">
      function toggle_ok() {
      	var cb = document.getElementById("confirmbutton");
      	if (cb.className == "btnwhite") {
      	  cb.className = "btnwhitedis"
      	} else {
      	  cb.className = "btnwhite"
      	}
      }
    </script>
    
    <form action="pt.do" method="post" onsubmit="this.submit();">    
     <@printRequiredParams method="post" />
     <input type="hidden" name="action" value="updateviewers">
     <input type="hidden" name="viewerToUpdate" value="${viewerToUpdate}">
     <#if user??>
       <input type="hidden" name="user" value="${user}">
     </#if>
     <input type="hidden" name="tmpname" value="${tmpname}">
     
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      
      <#if filelist??>
   	   <tr>
   	    <td class="sectionheader">Files included:</td>
   	   </tr>
   	   <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
   	   <tr>
   	    <td class="pad1" colspan="2">
          <textarea class=inwhite style="background-color: white" disabled="true" rows="5">
            <#list filelist as file>
${file}
            </#list> 
          </textarea>
        </td>
       </tr>
      </#if>
      
      <#if licenceHTML??>
       <tr>
   	    <td class="sectionheader" colspan="2">Licence Agreement:</td>
   	   </tr>
   	   <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr> 
   	   <tr>
   	    <td colspan="2">${licenceHTML}</td>
       </tr>
     <#elseif licenceTXT??>
       <tr>
   	    <td class="sectionheader" colspan="2">Licence Agreement:</td>
   	   </tr>
   	   <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
   	   <tr>
   	    <td class="pad1" colspan="2">
	      <textarea class=inwhite disabled="true" style="background-color:white; height: 350px" >${licenceTXT}</textarea>
        </td>
       </tr>
     </#if>
     
     <tr>
   	   <td class="pad1" style="padding-top: 10px;" align="right">
         Accept Licence Agreement?
       </td>
       <td class="pad1" style="padding-top: 10px;" align="right">
         <@formcheckbox objid="confirmed" preselect="false" disabled="false" callbackonchange="toggle_ok" helpid="" />
       </td>
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>  
     <tr>
   	   <td class="pad1" style="min-width: 0px; padding-top: 10px;" colspan="2" align="right">
   	     <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
         <@formsubmit id="confirmbutton" disabled="true" value="Install" />
       </td>
     </tr>  
     </table>
    </form>
  	
  <#elseif show_confirmation?? > 
  
    <table cellspacing="0" cellpadding="0" style="border: 0px;">
     <tr>
       <td class="sectionheader">Upload confirmation</td>
     </tr>
     <tr><td><hr size="1" class="hr1"/></td></tr>
     <tr>
       <td class="pad1">The viewer update was successfully installed and can be used immediately. It might be 
       necessary to clear your browsers cache to see the changes.</td>
     </tr>
     <tr>
       <td class="pad1" style="text-align: right; padding-top: 20px;">
         <#if user??>
          <@linkbutton value="Ok" targeturl="pt.do?action=viewersettings&user=${user}" />
         <#else>
          <@linkbutton value="Ok" targeturl="pt.do?action=viewersettings" />
         </#if>
       </td>
     </tr>
    </table>
    
  <#elseif show_form?? >
  
    <script type="text/javascript">
      function toggle_hidden() {
      	var viewerselector = document.getElementById("viewerToUpdate");
      	var userselector = document.getElementById("userselector");
      	if (viewerselector.value == "specific_viewer") {
      		userselector.style.display = 'table-row';
      	}
      	else {
      		userselector.style.display = 'none';
      	}
      }
    </script>
  
    <form action="pt.do" method="post" enctype="multipart/form-data" onsubmit="this.submit();">  
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="updateviewers">
    
    <table cellspacing="0" cellpadding="0" style="border: 0px;">
     <tr>
       <td class="sectionheader">Update FSI Viewers</td>
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     <tr>
       <td class="pad1">Select FSI Viewers to update</td>
       <#if preselect_viewer?? && preselect_viewer = "default">
         <td class="pad1"><@formgfxselect objid="viewerToUpdate" itemlist=viewer_update_options preselect="default_viewer" callbackonchange="toggle_hidden" helpid="choose_viewer_to_update" /></td>
       <#elseif preselect_viewer??>
         <td class="pad1"><@formgfxselect objid="viewerToUpdate" itemlist=viewer_update_options preselect="specific_viewer" callbackonchange="toggle_hidden" /></td>
       <#else>
         <td class="pad1"><@formgfxselect objid="viewerToUpdate" itemlist=viewer_update_options preselect=viewer_update_options?first.value callbackonchange="toggle_hidden" helpid="" /></td>
       </#if>
     </tr>
     <tr id="userselector" style="display: none">
       <td class="pad1">Choose User Viewer</td>
       <td class="pad1">
        <#if userviewers?size != 0 >
         <#if preselect_viewer?? && preselect_viewer != "default">
         	<@formgfxselect objid="user" itemlist=userviewers preselect=userviewers?first.value helpid="" />
         <#else>
         	<@formgfxselect objid="user" itemlist=userviewers preselect=preselect_viewer helpid="" />
         </#if>
        <#else>
         no user viewers installed 
        </#if>
       </td>
     </tr>
     <tr>
       <td class="pad1">Select Update Package</td>
       <td class="pad1"><input class="btnwhite" type="file" name="zipfile" onChange="document.getElementById('uploadbutton').className='btnwhite'" /></td>
     </tr>
     <tr>
	   <td class="pad1" align="right" colspan="2" style="padding-top: 10px;">
	     <@formsubmit disabled="true" id="uploadbutton" value="Upload Selected" helpid="upload_update" />
	   </td>
	 </tr>
    </table>
    </form>
    <script type="text/javascript">
      toggle_hidden();
    </script>
  </#if>
<@tableFooter/>
  
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">