/*!
 * FSI ImageFlow
 * Copyright (c) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 *
 * VERSION: 1.1.3
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,version,build){var self=this;this.instance=instance;this.strClassName=strClassName;this.version=version;this.build=build;var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var classDef=new $FSI.ClassDef($FSI,"FSI Core","2016","16.08.4");$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t=="boolean"){ret=value}else{if(t=="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady){if(typeof($FSI.iLoaderCSSSkin)!="object"){if(typeof($FSI.LoaderCSSSkin)!="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create <style> node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		@if (@_jscript_version < 9)
			el.style.setAttribute('cssText', strStyle);
		@else @*/
el.setAttribute("style",strStyle);
/*@end
		@*/
};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!=0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWith=window.innerWidth;$FSI.bElementPosRespectsScroll=true;var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}var uagent=$FSI.userAgent=navigator.userAgent.toLowerCase();var result;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!=-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("safari")>-1&&uagent.search("chrome")<1){$FSI.isSafari=true}else{if(uagent.search("firefox")>-1){$FSI.isFirefox=true}else{if(uagent.search("opera")>-1){$FSI.isOpera=true}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)=="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.getCachedScrollBarWidth=function(el,oReg,w){var cst;var cssOverflowY="";try{cst=top.window.getComputedStyle(el);cssOverflowY=cst["overflow-y"]}catch(e){return 0}if(cssOverflowY=="scroll"||el.scrollHeight>top.window.innerHeight){var orgStyle=el.style.overflowY;var styleID=orgStyle;styleID="S_"+styleID;if(1==1||oReg[styleID]==undefined){el.style.overflowY="hidden";var w2=$FSI.___elementScaleCheck.offsetWidth;if(w2-w>1){oReg[styleID]=w2-w}}}if(!isNaN(oReg[styleID])){ret=oReg[styleID]}else{ret=-1}return ret};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(step){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if(typeof(document.visualViewport)!="undefined"){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return document.visualViewport.pageScale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180==0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=window.outerWidth;return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.document.visualViewport.clientWidth,height:wnd.document.visualViewport.clientHeight}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.push)=="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)=="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])=="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag;if(typeof(document.querySelector)=="function"){var strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector)}else{var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"s*$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var scripts=document.getElementsByTagName("script");var t="/"+strScriptName;var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!="object"){if(typeof($FSI.LoaderJavascript)!="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)=="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!="string"){return false}var t=typeof(parameters);if(t!="object"&&t!="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)=="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!="string"||strClass.length<1){return}if(typeof(strRule)!="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var node=element;var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=scale.x}else{scale.y=targetDimension.height/(sourceDimension.height*range.height);scale.x=scale.y}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)=="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(document.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)=="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)=="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.dir=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c="FSI";this.on=true;this.doNothing=function(){};this.log=this.doNothing;this.error=this.doNothing;this.dir=this.doNothing;try{if(console&&console.log){this.log=function(e){console.log(c+e)}}if(console&&console.error){this.error=function(e){console.error(c+e)}}if(console&&console.dir){this.dir=function(e){console.dir(e)}}}catch(d){}this.setPrefix=function(e){c=e+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!=b){return}a.Config=function(m,v){if(!v||typeof(v)!="object"){v={}}this.parameters=(m)?m:{};this.queryParameters=b;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():b}catch(B){}this.plugins=new Object();this.arPlugins=new Array();this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=new Array();this.locales=new Object();this.locales.tips=new Object();var f=false;var o=this;this.strListFilePrefix="";this.strListFileSuffix="";var n={};var z=0;var y=false;var j;var A={};var s="FSI> ";var p=new a.EmptyDebugger();var r=false;var g={};var C;var w;var t=false;this.strConfigFileExtension=".xml";o.strTemplateSuffix=".json";var u;var i=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){u=function(E){var e;if(!a.isCrossDomain(E)){t=false;e=new XMLHttpRequest()}else{t=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){u=function(){return new XMLHttpRequest()}}}if(!u){try{i=new ActiveXObject("Msxml2.XMLHTTP");u=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(B){try{i=new ActiveXObject("Microsoft.XMLHTTP");u=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(B){i=null;u=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters=new Object();this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfgAliasNamesSecondLevel={renderer:"fpxservertemplate"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(E){o.reset();if(E){if(o.parameters){o.parameters=a.mergeObjects(o.parameters,E)}else{o.parameters=E}}l(o.parameters);o.getQueryParameters();o.cloneParameters(o.cfgDefaults,o.cfg);o.cloneParameters(o.queryParameters,o.cfg);o.elevateToHTTPS();q();o.BaseURL=o.getBaseURL();if(o.bForceVersion5==true){}var e=o.queryParameters.fsiviewerversion;if(o.bForceVersion5==true){e="5"}if(e!=b){if(parseInt(e)<6){o.strConfigFileExtension=".fsi"}}var F=o.queryParameters.fsiserverversion;if(o.bForceVersion5==true){F="2"}if(F!=b){if(parseInt(F)<3){o.strTemplateSuffix="_json"}}if(o.queryParameters.fsiviewerlocation!=b){o.locationFSIViewer=o.queryParameters.fsiviewerlocation}else{if(a!=b&&a._FSIViewerLocation!=b){p.log("FSI Viewer location gussed based on script location: "+a._FSIViewerLocation);o.locationFSIViewer=a._FSIViewerLocation}else{o.locationFSIViewer=o.BaseURL.split("/");if(o.locationFSIViewer.length>4){o.locationFSIViewer.splice(o.locationFSIViewer.length-3,2);o.locationFSIViewer=o.locationFSIViewer.join("/")}}}if(o.locationFSIViewer.charAt(o.locationFSIViewer.length-1)!="/"){o.locationFSIViewer+="/"}o.nextConfigURL=o.getReloadPath(o.locationFSIViewer,o.expandFSIPath(o.cfg.defaultcfg));o.checkDebug(false)};var l=this.makeObjectPropertiesLowerCase=function(e){for(var E in e){var F=E.toLowerCase();if(E!=F){if(e[F]==b){e[F]=e[E]}delete e[E]}}};var q=function(){f=o.makeBool(o.cfg.usenc,false);if(o.cfg.usencquery!=b&&o.cfg.usencquery.length>0){r=o.cfg.usencquery;f=true;o.queryToObject("?"+r,g)}};this.stopPendingRequests=function(){for(var E in n){var e=n[E];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){o.stopPendingRequests()};this.getBaseURL=function(){var F;var E=document.getElementsByTagName("base");if(E&&E.length>0){F=E[E.length-1].href;if(F&&F.charAt(F.length-1)!="/"){F+="/"}}else{F=document.location.href;var e=F.indexOf("?");if(e!=-1){F=F.slice(0,e)}e=F.indexOf("#");if(e!=-1){F=F.substring(0,e)}e=F.lastIndexOf("/");if(e!=-1){F=F.slice(0,e+1)}}return F};this.reset=function(){o.parameters={};p=new a.EmptyDebugger();o.stopPendingRequests();j=Math.random();o.nIncludedConfigs=0;o.completedConfigs=new Object();o.plugins=new Object();o.cfg=new Object();o.queryParameters=b;o.arUnrecognizedConfigNodes=[]};this.getQueryParameters=function(){if(o.queryParameters!=b){return}o.queryParameters=new Object();o.cloneParameters(o.parameters,o.queryParameters)};this.makeBool=function(G,e){if(typeof(e)!="boolean"){e=false}var E=e;switch(typeof(G)){case"string":var F=a.makeBool(G);if(F!=b){E=F}break;case"number":E=Boolean(G);break;case"boolean":E=G;break}return E};this.parsePositionParameter=function(E){if(typeof(E)!="string"||E.length<3){return b}var E=E.split(",");if(E.length<3){return b}for(var e=0;e<3;e++){E[e]=parseFloat(E[e]);if(isNaN(E[e])){E[e]=0}}return{x:E[0],y:E[1],z:E[2]}};this.loadLanguageFile=function(){var E=o.cfg.language;if(E==b){E="english"}var e=o.locationFSIViewer+"/languages/"+E+".xml";var F={};o.finishRequestParams(F);Ext.Ajax.request({url:e,overrideMimeType:"application/xml",params:F,method:"GET",scope:o,success:function(G,H){o.logXMLResponseOK(G);o.onLanguageLoaded(true,G)},failure:function(G,H){o.logLoadFileFailed(G,H);o.onLanguageLoaded(false,G)}})};this.logLoadFileFailed=function(e,G){if(!p.on){return}if(e&&e.status!=b){var F="HTTP "+e.status;if(e&&e.statusText){F+=", "+e.statusText}var E=(e._url)?e._url:"";p.error("Failed to load "+E+" ("+F+")")}else{p.error("Failed loading a file");if(e&&e._url){p.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(H){if(!H||!H.firstChild){return false}var e=H.firstChild.childNodes;var I,F,G;for(var E=0;E<e.length;E++){F=e[E];I=o.getAttributeValue(F,"id");if(I==b){continue}I=I.toLowerCase();if(F.childNodes.length>0){G=o.XMLChildNodesToString(F)}else{G=o.getAttributeValue(F,"txt")}o.locales.tips[I]=G}return true};this.getAttributeValue=function(E,e){if(!E){return}return E.getAttribute(e)};this.onLanguageLoaded=function(E,e){p.log("Language loaded");if(E){o.parseLanguage(e.responseXML)}o.initPagesParameters();if(v.onConfigReady){v.onConfigReady()}};this.onConfigReadyDone=function(){if(!o.readCustomPageNumbers()){o.loadImageList()}};this.swapParameters=function(F,e){F=F.toLowerCase();e=e.toLowerCase();var E=o.plugins.pages.parameters;if(E==b){return}o.swapValues(E,F,e);o.swapValues(o.cfg,"pages_"+F,"pages_"+e)};this.swapValues=function(G,F,E){var e=G[F];G[F]=G[E];G[E]=e};this.initPagesParameters=function(){o.LinkTemplates=o.getPagesParameter("LinkTemplates","").split(",");for(var e=0;e<o.LinkTemplates.length;e++){o.LinkTemplates[e]=a.urlDecode(o.LinkTemplates[e])}o.LinkTemplateData=o.getPagesParameter("LinkTemplateData","").split(",");for(var e=0;e<o.LinkTemplateData.length;e++){o.LinkTemplateData[e]=a.urlDecode(o.LinkTemplateData[e])}o.LinkTemplateCount=Math.max(o.LinkTemplates.length,o.LinkTemplateData.length)};this.getTranslation=function(E){var e=o.locales.tips[E.toLowerCase()];if(e==b){e=E}return e};this.getImageURL=function(F,e){if(F==b){return""}if(e==b){e={}}if(e.type==b){e.type="image"}if(e.renderer==b){e.renderer="jpeg"}e.source=F;for(var E in A){if(e[E]==b){e[E]=A[E]}}return o.requestBase+"?"+o.objectToQuery(e)};this.getImageInfoURL=function(E,e){if(E==b){return""}if(e==b){e={}}if(e.type==b){e.type="info"}if(e.tpl==b){if(o.cfg.fpxinfotemplate!=b){e.tpl=o.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(o.cfg.headers&&o.cfg.headers.length>0){e.headers=o.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=E;return o.requestBase+"?"+o.objectToQuery(e)};this.queryToObject=function(H,F){if(F==b){F={}}var G,J,I,e,E;G=H.indexOf("?");if(G!=-1){E=H.slice(G+1)}else{E=""}G=E.indexOf("#");if(G!=-1){E=E.substring(0,G)}E=E.split("&");for(G=0;G<E.length;G++){J=E[G].split("=");I=a.urlDecode(J[0]).toLowerCase();if(I.length>0){e=a.urlDecode(J[1]);F[I]=e}}return F};this.parseSceneSets=function(e,H){var O={};if(H==b){H=true}var T=[];var R=0;var P=0;var F;var J,I,G,N,L,S;var K,M,Q;var E=o.cfg.scenesets;if(e>1&&E!=b&&typeof(E)=="string"){M=E.split(";");for(J=0;J<M.length;J++){Q=new Array();K=M[J].split(",");P=0;for(I=0;I<K.length;I++){S=K[I].split("-");N=L=0;if(S.length==1){N=parseInt(S[0])}else{N=parseInt(S[0]);if(isNaN(N)){N=1}F=false;if(S[1].charAt(0)==">"){S[1]=S[1].substr(1);if(!isNaN(parseInt(S[1]))){F=true}}L=parseInt(S[1]);if(isNaN(L)){L=e}if(N>0&&L>0&&N<=e&&L<=e){if(F==true||N!=L){if(F!=true){if(L<N){for(G=N;G>=L;G--){Q[P]=G;P++}}else{for(G=N;G<=L;G++){Q[P]=G;P++}}}else{for(G=N;G<=e;G++){Q[P]=G;P++}for(G=1;G<=L;G++){Q[P]=G;P++}}}}}if(N>0&&N<=e&&(L==0||L==N)){Q[P]=N;P++}}if(P>0){T[R]={};T[R].arScenes=new Array();T[R].arScenes=T[R].arScenes.concat(Q);R++}}}if(R==0){O.bDefault=true;if(H){T[0]={};T[0].arScenes=new Array();for(J=0;J<e;J++){T[0][J]=J}}}O.nSceneSets=R;O.bHasMultipleSets=(O.nSceneSets>1);O.arSets=T;O.nCurrent=1;return O};this.objectToQuery=function(E){var e=[];if(f&&r!==false){for(var G in g){E[G]=g[G]}}for(var G in E){var F=encodeURIComponent(E[G]);e.push(encodeURIComponent(G)+"="+F)}return e.join("&")};this.loadConfigs=function(){o.loadNextConfig(true)};this.loadFile=function(E,F,H,I){if(!E||E.length<0){if(F){F(this,"",I)}return}if(H==b){H="application/json"}var e=u(E);if(!e){return}if(H&&e.overrideMimeType){e.overrideMimeType(H)}e._url=E;var G=z;n[z]=e;z++;if(t){e.onerror=function(){delete n[G];if(F==b||this.FSIaborted){return}o.logLoadFileFailed(this)};e.onload=function(){delete n[G];if(F==b||this.FSIaborted){return}var J=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var K=new ActiveXObject("Microsoft.XMLDOM");K.async=false;K.loadXML(J);J=this.responseXML=K}catch(L){p.log("Failed parsing XML using Microsoft.XMLDOM");p.log(E)}break;case"application/json":J={};try{J=a.JSON.parse(this.responseText)}catch(L){p.error("Failed parsing JSON from URL: "+E+" ("+L.message+")")}break}F(this,J,I)}}else{e.onreadystatechange=function(J){var K;if(e.readyState!=4){return}delete n[G];if(F==b||this.FSIaborted){return}if(this.status>299){o.logLoadFileFailed(this)}switch(H){case"application/xml":case"text/xml":K=this.responseXML;break;case"application/json":K={};try{K=a.JSON.parse(this.responseText)}catch(L){p.error("Failed parsing JSON from URL: "+E+" ("+L.message+")")}break}F(this,K,I)}}e.open("GET",E,true);e.send(null);return e};this.onConfigXMLLoaded=function(e,E){o.logXMLResponseOK(e.response);o.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(F){if(o.nextConfigURL==b){o.finalCheck();return}var e=!o.makeBool(o.cfg.ConfigCaching,true);var G={};if(o.makeBool(o.cfg.debug)||(!F&&!o.makeBool(o.cfg.configcaching,true)&&o.makeBool(o.cfg.enableconfigcachingparameter))){o.addNoCacheParams(G)}o.finishRequestParams(G);var E=o.addURLParameters(o.nextConfigURL,G);p.log("LOAD CONFIG: "+E);o.loadFile(E,o.onConfigXMLLoaded,"application/xml")};this.parseMargins=function(F,E,e,G){if(e==b){e=_root._FSI.StageWidth}if(G==b){G=_root._FSI.StageHeight}F[E+"Left"]=o.getFloatParameterPercent(E+"Left",0,e);F[E+"Top"]=o.getFloatParameterPercent(E+"Top",0,G);F[E+"Right"]=o.getFloatParameterPercent(E+"Right",0,e);F[E+"Bottom"]=o.getFloatParameterPercent(E+"Bottom",0,G);F[E+"Inner"]=o.getFloatParameterPercent(E+"Inner",0,e);F[E+"Outer"]=o.getFloatParameterPercent(E+"Outer",0,e)};this.getFloatParameterPercent=function(e,E,F){return o.parseFloatPercentDef(o.getPagesParameter(e),F,E,-1000000)};this.parseFloatPercentDef=function(G,F,E,e){if(G==b||G.length<1){return E}return Math.max(e,o.parseFloatPercent(G,F))};this.parsePercentDef=function(F,e){if(F==b||F.length<1){return e}var E=parseFloat(F);if(isNaN(E)){E=0}else{if(F.indexOf("%")!=-1){E/=100}}return E};this.parseFloatPercent=function(F,E){var e=parseFloat(F);if(isNaN(e)||e<0){e=0}else{if(F.indexOf("%")!=-1){e=Math.round(e*E/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){s=e+"> "};this.setDebugger=function(e){p=e};this.checkDebug=function(F){var E;var e;if(o.parameters.debug!=b){e=o.makeBool(o.parameters.debug)}else{e=o.makeBool(o.cfg.debug)}if(e){if(!p||!p.on){p=new a.Debugger();if(v.onDebuggerChange){E=v.onDebuggerChange(p,F)}}}else{if(!p||p.on===true){p=new a.EmptyDebugger();if(v.onDebuggerChange){E=v.onDebuggerChange(p,F)}}}return E};this.onConfigLoaded=function(E){o.parseConfig(E);o.elevateToHTTPS();if(o.checkDebug(true)==true){return}q();var e;if(o.cfg.includeconfig!=b&&o.nIncludedConfigs<10){e=o.getFSIPath(o.locationFSIViewer,o.expandFSIPath(o.cfg.includeconfig));o.nIncludedConfigs++;o.cfg["includeconfig("+o.nIncludedConfigs+")"]=o.cfg.includeconfig;o.cfg.includeconfig=b}else{if(o.cfg.cfg!=b){e=o.getFSIPath(o.locationFSIViewer,o.expandFSIPath(o.cfg.cfg))}}if(e!=b&&!o.completedConfigs[e]){o.completedConfigs[e]=true;o.nextConfigURL=e;o.loadNextConfig()}else{o.evaluateQuery(o.queryParameters,o.cfg);o.finalCheck()}};this.elevateToHTTPS=function(){if(!a.bHTTPS){return}if(!o.makeBool(o.cfg.autoelevatetohttps,true)){return}d("fpxbase");d("fpxserver")};var d=function(e){if(o.cfg[e]!=b&&o.cfg[e].length>0&&o.cfg[e].indexOf("http://")==0){o.cfg[e]="https"+o.cfg[e].substr(4)}};this.evaluateQuery=function(E,e){for(var F in E){o.setConfigParamByValue(e,F.toLowerCase(),E[F])}};this.parseConfig=function(E){var N="";if(E!=b){var F=E.firstChild;if(F&&F.nodeName=="xml"){F=F.nextSibling}var M=F.childNodes;for(var J=0;J<M.length;J++){var H=M[J];if(H.nodeType!=1){continue}var K=H.nodeName.toLowerCase();N=K;var G=H.childNodes;switch(K){case"licence":break;case"plugins":for(var I=0;I<G.length;I++){o.parsePluginNode(G[I])}break;case"info":case"options":N=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(var I=0;I<G.length;I++){var L=G[I];if(L.nodeType!=1){continue}var e=o.getValueFromXMLNode(L,N);o.setConfigParam(o.cfg,e)}break;default:o.arUnrecognizedConfigNodes.push(H)}}}};this.getData=function(){var e={};e.cfg={};for(var E in o.cfg){e.cfg[E]=o.cfg[E]}return e};this.setData=function(e){if(!e||!e.cfg){return}o.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var E in e){o.cfg[E]=e[E]}c()};this.getImagesNodeList=function(F){var e=[];if(F==b){F=o.getUnrecognizedConfigNode("images")}if(F){var G=F.firstChild;while(G){if(G.nodeType==1){var E={};E.attributes={};k(G,E.attributes);E.cfg={};o.parseConfigFragment(G,E.cfg);e.push(E)}G=G.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){o.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(G){var e;G=G.toLowerCase();for(var E=o.arUnrecognizedConfigNodes.length-1;E>-1;E--){var F=o.arUnrecognizedConfigNodes[E];if(F&&F.nodeName.toLowerCase()==G){e=F;break}}return e};this.parseConfigFragment=function(G,K,J){var O="";if(G!=b&&K!=b){if(J==b){J=[]}var E=G;var N=E.childNodes;for(var I=0;I<N.length;I++){var G=N[I];if(G.nodeType!=1){continue}var L=G.nodeName.toLowerCase();O=L;var F=G.childNodes;switch(L){case"info":case"options":O=b;case"fpx":case"image":case"include":for(var H=0;H<F.length;H++){var M=F[H];if(M.nodeType!=1){continue}var e=o.getValueFromXMLNode(M,O);o.setConfigParam(K,e)}break;default:J.push(G)}}}};this.findXMLNode=function(E,e){if(E==b||E.nodeType==b){return b}while(E){if(E.nodeName.toLowerCase()==e){break}if(E.firstChild!=b){E=E.firstChild}else{if(E.nextSibling!=b){E=E.nextSibling}else{E=E.parentNode.nextSibling}}}return E};this.getValueFromXMLNode=function(F,e){if(!F||F.nodeType!=1){return}var E=new Object();var G=(e)?e:"";E.name=G+F.nodeName.toLowerCase();var H=F.getAttribute("value");if(H){E.value=H;return E}E.value=o.XMLChildNodesToString(F);E.node=F;return E};this.getXMLNodeAttribute=function(G,F,e){if(!G||G.nodeType!=1||!G.getAttribute){return e}var E=G.getAttribute(F);if(E==b||E==null){E=e}return E};this.XMLChildNodesToString=function(E){if(!E||!E.firstChild){return""}var e="";if(E.childNodes.length==1&&E.firstChild.nodeType==3){e=E.firstChild.nodeValue}else{e=o._XMLChildNodesToString(E)}return e};this.hasPlugin=function(e){return(o.plugins&&o.plugins[e]!=b)};this.getPluginParameter=function(J,E,e,I){J=J.toLowerCase();E=E.toLowerCase();if(o.plugins[J]==b){p.error("CANNOT GET PLUGIN PARAMETER, because plugin not defined: "+J+"."+E);return e}var H;var G=J+"_"+E;if(o.cfg[G]!=b){H=o.cfg[G]}else{var F=o.plugins[J].parameters;if(F!=b&&F[E]!=b){H=F[E]}}if(H==b){H=e}if(I){H=o.makeBool(H,e)}return H};this.getUnescapedPagesParameter=function(G,F,E){var e=o.getPagesParameter(G,F);if(e==b&&E!=b){e=o.getPagesParameter(E,F)}if(e!=b){e=a.urlDecode(e)}return e};this.getIntParameterMinMax=function(E,F,e,G){return Math.min(G,Math.max(e,o.getIntParameter(E,F)))};this.getIntParameter=function(E,F){var e=parseInt(o.cfg[E.toLowerCase()]);if(isNaN(e)){e=F}return e};this.getStringParameter=function(E,F){var e=o.cfg[E.toLowerCase()];if(e==b){e=F}return e};this.getFloatParameter=function(E,F){var e=parseFloat(o.cfg[E.toLowerCase()]);if(isNaN(e)){e=F}return e};this.getRGBAValue=function(E){var e=new Object();if(E==b){E=""}if(E.charAt(0)=="#"){E=E.substr(1)}if(E.length>8){E=E.substr(0,8)}if(E.length>5){e.webColor="#"+E.substr(0,6);e.red=parseInt(E.substr(0,2),16);e.green=parseInt(E.substr(2,2),16);e.blue=parseInt(E.substr(4,2),16);if(E.length<7){e.alpha=255}else{e.alpha=parseInt(E.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};this.getPagesParameter=function(E,e,F){return o.getPluginParameter("pages",E,e,F)};var k=function(I,E){if(!I||!I.attributes||!I.attributes.length||!E){return false}var F=I.attributes;for(var H=0;H<F.length;H++){var e=F[H];var G=e.nodeName.toLowerCase();E[G]=e.value}return true};this.parsePluginNode=function(F){if(F.nodeType!=1){return}var H=new Object();k(F,H);var G=F.childNodes;for(var e=0;e<G.length;e++){var I=G[e];if(I.nodeType!=1){continue}var E=o.getValueFromXMLNode(I);if(E.value!=b){H[E.name]=E.value;if(E.node!=b){H[E.name+".node"]=E.node}}}this.addPluginFromString(H.src,H)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.addPluginsFromString=function(F){if(F==b||F.split==b||F.length<1){return}var e=F.split(",");for(var E=0;E<e.length;E++){var G=o.trimString(e[E]);o.addPluginFromString(G)}};this.addPluginFromString=function(E,F){if(E==b||E.length<1){p.error("PLUGIN without src parameter:");return}E=E.toLowerCase();if(F==b){F=new Object()}var e=o.plugins[E]=new Object();e.name=E;if(o.pluginDefaultParameters[E]!=b){e.parameters=new Object();o.cloneParameters(o.pluginDefaultParameters[E],e.parameters);o.cloneParameters(F,e.parameters)}else{e.parameters=F}};this.setConfigParamByValue=function(E,F,e){o.setConfigParam(E,{name:F.toLowerCase(),value:e})};this.setConfigParam=function(E,F){var G=F.name;var e=F.value;if(G==b){return}if(o.cfgAliasNames[G]!=b){G=o.cfgAliasNames[G]}if(E[G]!=b&&(typeof(e)=="string"&&a.BoolTable[e.toLowerCase()]==false)&&a.BoolTable[E[G]]==b){delete E[G]}else{switch(G){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(E[G]!=b&&E[G].length>0&&E[G].indexOf(e)==-1){E[G]+=","+e}else{E[G]=e}break;case"plugins":o.addPluginsFromString(e);break;case"fpxpath":E[G]=e;E.fpxsrc=encodeURIComponent(e);break;default:E[G]=e;if(F.node!=b){E[G+".node"]=F.node}}}};var c=function(){o.serverProfile=o.cfg.fpxservertemplate;o.serverProfileDoublePage=o.cfg.fpxservertemplatedoublepage;if(o.serverProfileDoublePage==b){o.serverProfileDoublePage="doublepage"}o.serverBase=o.cfg.fpxserver;if(o.serverBase==b){p.log("Note:",true);p.log("Parameter 'imageserver' undefined, guess from ["+o.locationFSIViewer+"]",true);var E;E=o.locationFSIViewer.indexOf("/users/");if(E!=-1){o.serverBase=o.locationFSIViewer.substring(0,E)+"/server"}else{E=o.locationFSIViewer.indexOf("/viewer/");o.serverBase=o.locationFSIViewer.substring(0,E)+"/server"}p.log("guessed location is: ["+o.serverBase+"]",true)}o.requestBase=o.serverBase;A={};var e=o.cfg.effects;if(e!=b){A.effects=e}e=o.cfg.lefteffects;if(e!=b){A.lefteffects=e}e=o.cfg.righteffects;if(e!=b){A.righteffects=e}e=o.cfg.quality;if(e!=b){A.quality=e}};var h=function(){for(var E in o.plugins){var F=E.toLowerCase();var e=o.makeBool(o.cfg[F],true);if(!e){o.plugins[E]=b}}};this.finalCheck=function(){o.elevateToHTTPS();h();c();if(v.onConfigsReady){v.onConfigsReady()}o.dumpConfig()};this.dumpConfig=function(){if(p.on){if(o.cfg.fpxsrc!=b){o.cfg["fpxsrc (decoded)"]=decodeURIComponent(o.cfg.fpxsrc)}p.log("Evaluated Configuration:");p.dir(o.cfg)}};var D=o.finishURL=function(e){if(!f||e==b){return e}var E;if(r===false){E="cache=0&cachernd="+j;if(e.indexOf("?")==-1){e+="?"+E}else{e+="&"+E}}else{E=r;if(e.indexOf("?")==-1){e+="?"+E}else{e+=E}}return e};this.addURLParameters=function(E,F){if(!E||!F){return E}var e=[];for(var G in F){e.push(encodeURIComponent(G)+"="+encodeURIComponent(F[G]))}if(e.length>0){if(E.indexOf("?")==-1){E+="?"}else{E+="&"}E+=e.join("&")}return E};this.finishRequestParams=function(E){if(f){if(r===false){E.cache=0;E.cachernd=j}else{for(var e in g){E[e]=g[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=j};this.parseQuery=function(E,e){if(e==b||E==b||E.length<1){return}o.queryToObject(E,e);if(e.ignorequeryparameters!=b){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=b){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,E){if(e==b||E==b){p.error("Cloning object failed: "+e+" / "+E)}for(var F in e){E[F]=e[F]}};this.getFSIPath=function(E,F){if(F.indexOf("//")!=-1){return F}if(o.cfg.fsibase!=b){F=o.cfg.fsibase+F}var e=o.getReloadPath(E,F);return e};this.expandFSIPath=function(E){var e=a.urlDecode(E);if(e.indexOf("?")!=-1||e.indexOf(o.strConfigFileExtension)==(e.length-4)){return E}return E+o.strConfigFileExtension};this.getReloadPath=function(G,I){var E,J,e,H;if(G==b){G=o.locationFSIViewer}if(I==b){I=""}var F="/";if(I.indexOf("//")!=-1){return I}E=G;H=E.lastIndexOf("?");if(H==-1){H=E.length}J=E.lastIndexOf("\\",H);e=E.lastIndexOf("/",H);J=Math.max(J,e);if(J==-1){J=E.length-1}E=E.slice(0,J);if(E.length>0&&I.indexOf(F)!=0){E+=F}return E+I};this.cloneValueObject=function(E){var e=new Object();for(var F in E){e[F]=E[F]}return e};this._getXMLConfigValue=function(e){var E;if(!e){return}if(e.childNodes.length>0){E=o._XMLChildNodesToString(e)}else{E=e.getAttribute("value")}return E};this._XMLChildNodesToString=function(G){if(!G||!G.firstChild){return""}var E="";try{if(G.xml!=b){for(var F=0;F<G.childNodes.length;F++){E+=G.childNodes[F].xml}}else{for(var F=0;F<G.childNodes.length;F++){E+=o.XMLSerializer.serializeToString(G.childNodes[F])}}}catch(H){}return E};this._findFirstXMLNode=function(F,G){var E,e;while(F){if(F.nodeName==G){e=F;break}E=F.firstChild;if(!E){E=F.nextSibling}if(!E&&F.parentNode){E=F.parentNode.nextSibling}F=E}return e};this._parseXMLImageList=function(E){var e=o._findFirstXMLNode(E,"images");if(!e){e=o._findFirstXMLNode(E,"images3d")}return parseXMLImageListNode(e)};this._parseXMLImageListNode=function(H){var K={};var e=K.arImages=[];var G="";var I="";var F;if(!H){return K}var E;E=o.getAttributeValue(H,"prefix");if(typeof(E)=="string"){G=E}E=o.getAttributeValue(H,"suffix");if(typeof(E)=="string"){I=E}var H=o._findFirstXMLNode(H,"image");if(!H){return K}while(H){if(H.nodeType==1){F=o._findFirstXMLNode(H,"path");var J=o._getXMLConfigValue(F);if(!J){J=a.urlDecode(o.getAttributeValue(H,"src"))}if(!J){J=a.urlDecode(o.getAttributeValue(H,"file"))}if(J!=b){e.push(G+J+I)}if(K.width==b){F=o._findFirstXMLNode(H,"width");F=o._getXMLConfigValue(F);if(F!=b){K.width=parseInt(F)}F=o._findFirstXMLNode(H,"height");F=o._getXMLConfigValue(F);if(F!=b){K.height=parseInt(F)}}}H=H.nextSibling}return K};this.getImageList=function(){var e;if(o.cfg&&o.cfg.fpxsources!=b){var G=o.cfg.fpxsources;if(typeof(G)=="string"||(typeof(G)=="object")&&typeof(G.push)=="function"){e={};e.oXML=null;if(typeof(G)=="string"){e.arImages=G.split(",");for(var F=0;F<e.arImages.length;F++){e.arImages[F]=a.urlDecode(e.arImages[F])}}else{e.arImages=G}return e}}if(o.arUnrecognizedConfigNodes&&o.arUnrecognizedConfigNodes.length>0){var E=o.arUnrecognizedConfigNodes;for(var F=0;F<E.length;F++){var H=E[F];if(typeof(H.nodeName)=="string"){var I=H.nodeName.toLowerCase();if(I=="images"||I=="images3d"){if(p.on){p.log("Reading image list from XML node: <"+H.nodeName+">")}e=o._parseXMLImageListNode(H);e.oXML=H;break}}}}if(o.cfg&&o.cfg.fpxsrc!=b){e={};e.oXML=null;e.arImages=[];e.arImages.push(a.urlDecode(o.cfg.fpxsrc));return e}return e};this.loadImageList=function(G,H,J,I){if(!o.serverBase||!G){H([],oResponse,I);return false}var F=o.serverBase+"?type=list";if(G.indexOf("tpl")==-1){var E=o.cfg.listtemplate;if(E&&E.length>0&&E.indexOf(".json")==-1&&E.indexOf(".xml")==-1){E+=".json"}F+="&tpl="+E}if(o.cfg.headers&&o.cfg.headers.length>0&&g.headers==b){F+="&headers="+o.cfg.headers}F+="&source="+encodeURIComponent(G);if(J!=b){F+=J}F=D(F);var e=o.loadFile(F,function(K,N){if(typeof(N)=="object"&&typeof(N.images)=="object"){N.images.pop();var O="";if(N&&N.imagesattributes&&N.imagesattributes.dir){O=N.imagesattributes.dir}var L=new Array(N.images.length);for(var M=0;M<N.images.length;M++){L[M]=O+N.images[M].src}H(L,N,I)}else{H([],N,I)}},"application/json",I);return e}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(k){var m=this;var d=[];var g={};var h={};var i=0;m._strClassName="$FSI.CustomEventListener";var l=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};var j=this.destroy=function(){for(var n=0;n<d.length;n++){var o=d[n];f(o.element,o.fn)}d=[];g={};h={};m.onDestroy()};this.fireEvent=function(n,o){if(!n||!n.enabled){return false}if(typeof(o)!="object"){o={}}if(n.paused){o.FSI_paused=true}o.FSI_custom_event=true;o.FSI_type=k;o.FSI_target=n.element;n.fn.call(n.element,o);return true};this.fireEvents=function(o){if(typeof(o)!="object"){o={}}o.FSI_custom_event=true;o.FSI_type=k;for(var p=0;p<d.length;p++){var n=d[p];if(n.enabled){if(n.paused){o.FSI_paused=true}else{if(o.FSI_paused){delete o.FSI_paused}}o.FSI_target=n.element;n.fn.call(n.element,o)}}};var c=this.addListener=function(r,q){if(typeof(r)!="object"||typeof(q)!="function"){a.console.error(m._strClassName+": Invalid parameters for addListener");return}if(r.__FSI==b){r.__FSI={}}if(r.__FSI.eventElementID==b){r.__FSI.eventElementListenerCount=1;r.__FSI.eventElementID=a.eventElementID++}else{r.__FSI.eventElementListenerCount++}if(q.__FSIEventFunctionID==b){q.__FSIEventFunctionListenerCount=1;q.__FSIEventFunctionID=a.eventFunctionID++}else{q.__FSIEventFunctionListenerCount++}var o=r.__FSI.eventElementID;var p=q.__FSIEventFunctionID;if(g[o]==b){var n=g[o]={};n.nFunction=0;n.oFunctions={}}if(g[o].oFunctions[p]==b){g[o].nFunction++;g[o].oFunctions[p]=[]}else{a.console.warn(m._strClassName+": There is already a listener for this exact element and function");a.console.log(r);a.console.log(q)}var s={};s.element=r;s.elementID=o;s.fn=q;s.fnID=p;s.instanceListener=m;s.enabled=true;s.paused=false;s.uniqueID=i++;g[o].oFunctions[p].push(s);d.push(s);h[s.uniqueID]=s;m._onListenerAdd(s);m._onListenerCountChange(d.length);return s};this.setListenerProps=function(q,o,p){var n=h[q];if(!n){return false}if(n.props==b){n.props={}}n.props[o]=p;return true};this.enableListener=function(p,o){var n=h[p];if(n==b||n.enabled==o){return}n.enabled=o};this.pauseListener=function(p,o){var n=h[p];if(n==b||n.paused==o){return}n.paused=o};var f=this.removeListener=function(r,q){if(typeof(r)!="object"||typeof(q)!="function"){a.console.error(m._strClassName+": Invalid parameters for removeListener");return}if(r.__FSI==b||r.__FSI.eventElementID==b||q.__FSIEventFunctionID==b){if(q.__FSIEventFunctionID==b){a.console.error(m._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(m._strClassName+": Element not registered for listener in removeListener")}return}var n=r.__FSI.eventElementID;var p=q.__FSIEventFunctionID;if(!g[n]){a.console.error(m._strClassName+": No registered listener for this element in removeListener");return}var o=g[n].oFunctions[p];if(o==b||typeof(o.pop)!="function"){a.console.error(m._strClassName+": No registered listener for this function in removeListener");return}var s=o.pop();s.fn.__FSIEventFunctionListenerCount--;s.element.__FSI.eventElementListenerCount--;if(s.element.__FSI.eventElementListenerCount==0){delete s.element.__FSI.eventElementListenerCount;delete s.element.__FSI.eventElementID}if(s.fn.__FSIEventFunctionListenerCount==0){delete s.fn.__FSIEventFunctionListenerCount;delete s.fn.__FSIEventFunctionID}if(o.length==0){delete g[n].oFunctions[p];g[n].nFunction--;if(g[n].nFunction==0){delete g[n]}}delete h[s.uniqueID];e();m._onListenerRemove(s);m._onListenerCountChange(d.length);return s};this.getEventListenerByID=function(n){return h[n]};this.getListenerObjectByID=function(n){return h[n]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var o in g){var q=g[o].oFunctions;for(var p in q){var n=q[p];d=d.concat(n)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(n){};this._onListenerAdd=function(o,n){};this._onListenerRemove=function(o,n){};this.triggerEvent=function(n){};this.triggerEvents=function(){};this.setListenerProps=function(p,n,o){};this.onDestroy=function(){};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerElementDimension!=b){return}a.CustomEventListenerElementDimension=a.oCustomEventListenerClasses.FSIElementDimension=function(){var m=this;var c=false;var i=25;var f;var d=0;var g={};g[0]=25;g[25]=50;g[50]=100;g[75]=250;var j=76;var e=-1;a.CustomEventListener.prototype.constructor.call(m,"FSIElementDimension");m._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(n){if(n<1){clearInterval(f);f=b}else{if(f==b){f=setInterval(l,g[0])}}};this._onListenerAdd=function(n){n.__elementWidth=n.element.offsetWidth;n.__elementHeight=n.element.offsetHeight};this.setListenerProps=function(q,o,p){if(typeof(o)!="string"){return false}var n=m.getListenerObjectByID(q);if(!n){return false}switch(o){case"treshold":if(p&&p>0){n.tresholdEnd=p}break;case"fireTresholdEventOnly":n.fireTresholdEventOnly=p;break}};var l=function(){var o=m.getListenersArray();var r=false;for(var q=0;q<o.length;q++){var n=o[q];if(n.__elementWidth!=n.element.offsetWidth||n.__elementHeight!=n.element.offsetHeight){r=true;if(n.tresholdEnd){n.treshold=i}k(n,false)}else{if(n.treshold>0){n.treshold+=i;if(n.treshold>=n.tresholdEnd){k(n,true);n.treshold=0}}}}if(r){d=0;h(g[0])}else{if(d<j){d++;var p=g[d];if(p!=b){h(p)}}}};var h=function(o){if(o==i||f==b){return}i=o;clearInterval(f);f=setInterval(l,i)};var k=function(n,p){var o={};if(p){o.FSI_after_treshold=n.treshold}o.FSI_target=n.element;o.FSI_dimension_old={width:n.__elementWidth,height:n.__elementHeight};n.__elementWidth=n.element.offsetWidth;n.__elementHeight=n.element.offsetHeight;o.FSI_dimension={width:n.__elementWidth,height:n.__elementHeight};if(p||!n.fireTresholdEventOnly){m.fireEvent(n,o)}};this.triggerEvent=function(o){var n=m.getEventListenerByID(o);if(!n){return}if(n.tresholdEnd){n.treshold=1}k(n)};this.triggerEvents=function(){var n=m.getListenersArray();for(var o=0;o<n.length;o++){if(n[o].tresholdEnd){n[o].treshold=1}k(n[o])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeInBounce:function(f,g,e,h){return h-jQuery.easing.easeOutBounce(x,g-f,0,h,g)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}},easeInOutBounce:function(f,g,e,h){if(f<g/2){return jQuery.easing.easeInBounce(x,f*2,0,h,g)*0.5+e}return jQuery.easing.easeOutBounce(x,f*2-g,0,h,g)*0.5+h*0.5+e}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(l,aT,aj,e,aN){var aD=this;var aK=false;var ai=true;var n=false;var aR=false;var aJ=false;var aB,D,i,ab;var aC,X,aH;var g=false;var ac;var p;var aW={};var ap=[];var aa=0;var H=window;var q;var aS;var d;var aV=[];var aP={x:0,y:0};var t={x:0,y:0};var aq=40;var m={};m.enabled=false;m.factor=5;m.fEndDiff=1;var ax={};ax.enabled=false;ax.minFrames=14;ax.factorAmount=23;ax.factorFrames=2.6;ax.offsetFrames=5;var ay;var aG,u,k;var E;var ar={};var W;var aM=false;var y=false;var ak={};ak.name="none";var M;var V;var Y={};if(!aT||typeof(aT)!="object"){aT={}}var am=function(){if(aK){aD.destroy()}aS=z;q=b;if(a.topWindow!=window){q=a.topWindow;try{var a1=a.getWindowOffset(window);if(a1.x!=b&&a1.y!=b){aS=ao}}catch(a0){aS=z;q=b}}else{q=b}E=aT.oPassTrough;if(aT.getPageCoords){p=aE}else{p=L}if(aT.afterTouch){for(var a2 in aT.afterTouch){ax[a2]=aT.afterTouch[a2]}}if(ax.fnStartStopAfterTouch&&typeof(ax.fnStartStopAfterTouch)!="function"){ax.fnStartStopAfterTouch=b}if(ax.fnStartStopAfterTouch){ax.useAnimationFrame=b}if(typeof(ax.modifyTarget)!="function"){ax.modifyTarget=b}if(typeof(ax.fnGetAfterTouchEnabled)=="function"){ay=ax.fnGetAfterTouchEnabled}else{ay=b}if(aT.smoothing){for(var a2 in aT.smoothing){m[a2]=aT.smoothing[a2]}}if(aT.detectClick==true){W=true}if(aT.preventSelection!==false){aT.preventSelection=true}if(!l){return}if(typeof(l.join)!="function"){l=[l]}if(typeof(aj)!="function"){aj=z}if(typeof(e)!="function"){e=z}if(typeof(aN)!="function"){aN=z}if(typeof(aT.onPinchChange)=="function"){M=aT.onPinchChange}else{M=b}aM=aT.detectGestures;aV=[];aw(true,aM);for(var aZ=0;aZ<l.length;aZ++){var aY=l[aZ];if(aY&&typeof(aY.nodeName)!="undefined"){var a2={};a2.element=aY;aV.push(a2);a.addEvent(aY,"mousedown",Q);if(a.isTouch){an(aY,Q);try{if(aY.style!=b){if(a.BrowserSupports.cssTouchAction()){if(ar.cssTouchAction!=b){o(aY,ar.cssTouchAction)}}}}catch(a0){}}}}};var R=this.enable=function(aY){if(ai==aY){return}if(!aY){P();af(false,false)}else{af(ar.captureScrollUser,ar.capturePinchUser)}ai=aY};this.getEnabled=function(){return ai};this.cancel=function(){O();ae();aI();P()};var aI=function(){if(m.enabled){h()}A()};this.cancelAfterTouch=function(){A()};this.getInitialDownEvent=function(){return V};var P=function(){if(!n){return}aI();n=false;V=b;y=false;c();aW={};ap=[];aa=0};this.destroy=function(){aD.cancel();var aY;for(var aZ=0;aZ<aV.length;aZ++){var a0=aV[aZ];aY=a0.element;a.removeEvent(aY,"mousedown",Q);v(aY,Q)}ar={}};var aA=function(aZ){if(!aZ||!aZ.style){return}var aY=aZ.style.touchAction;if(aY==b){aY=aZ.style.msTouchAction}return aY};var o=function(aY,aZ){if(!a.BrowserSupports.cssTouchAction()||!aY||!aY.style){return}aY.style.touchAction=aY.style.msTouchAction=aZ};var al=function(aZ){for(var aY=0;aY<aV.length;aY++){an(aV[aY].element,aZ)}};var F=function(aZ){for(var aY=0;aY<aV.length;aY++){v(aV[aY].element,aZ)}};var an=function(aZ,aY){a.addEvent(aZ,"touchstart",aY);a.addEvent(aZ,"MSPointerDown",aY);a.addEvent(aZ,"pointerdown",aY);a.addEvent(aZ,"MSHoldVisual",a.preventDefaultEvent)};var v=function(aZ,aY){a.removeEvent(aZ,"touchstart",aY);a.removeEvent(aZ,"MSPointerDown",aY);a.removeEvent(aZ,"pointerdown",aY);a.removeEvent(aZ,"MSHoldVisual",a.preventDefaultEvent)};var z=function(){return true};var aO=function(aY){if(aJ){U(aY,aY.pointerId)}else{var aZ=aY.changedTouches;for(var a0=0;a0<aZ.length;a0++){U(aZ[a0],aZ[a0].identifier)}}};var U=function(aY,a0){if(a0==b||aW[a0]!=b){if(aT.debug){if(a0==b){a.console.error("doRegisterPointer: no pointerId")}if(aW[a0]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a0)}}return}aa++;var aZ=aW[a0]={};aZ.identifier=a0;p(aZ,aY);ap.push(aZ)};var ah=function(aY){var a0=false;if(aJ){a0=J(aY.pointerId)}else{var aZ=aY.changedTouches;if(aZ){for(var a1=0;a1<aZ.length;a1++){a0=J(aZ[a1].identifier)}}}if(a0){ap=new Array(aa);var a3=0;for(var a2 in aW){ap[a3++]=aW[a2]}}};var J=function(aY){if(aY==b||aW[aY]==b){if(aT.debug){if(aY==b){a.console.error("doUnregisterPointer: no pointerId")}if(aW[aY]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+aY)}}return false}delete aW[aY];aa--;return true};var L=function(aZ,aY){aZ.x=aY.clientX;aZ.y=aY.clientY};var aE=function(aZ,aY){aZ.x=aY.pageX;aZ.y=aY.pageY};var r=function(aY){var aZ=aY.changedTouches;if(aZ){for(var a1=0;a1<aZ.length;a1++){var a0=aW[aZ[a1].identifier];if(a0){p(a0,aZ[a1])}}}if(ap.length>0){aP.x=ap[0].x;aP.y=ap[0].y}};var av=function(aY){var aZ=aW[aY.pointerId];if(aZ){p(aZ,aY)}if(ap.length>0){aP.x=ap[0].x;aP.y=ap[0].y;aS(aY,aP)}};var T=function(aY){p(aP,aY);aS(aY,aP)};this.getMousePositionPage=function(aZ){var aY={};aE(aY,aZ);aS(aZ,aY);return aY};this.getMousePositionClient=function(aZ){var aY={};L(aY,aZ);aS(aZ,aY);return aY};var s=function(aY,aZ){if(window!=aY.view){var a0=a.getWindowOffset(window);aZ.x-=a0.x;aZ.y-=a0.y}};var ao=function(aY){try{s(aY);aS=s}catch(aZ){aS=z}};var az=function(aY){if(!ai){return}var a0=aa;if(y&&a0==0){y=false}var a1=aY.type;if(n||ak.started){if(a1!=aB){if(ak.started){O();ae()}else{aY._FSI_Canceled=true;aX(aY,true)}}}aB=a1;d=false;var aZ=true;switch(a1){case"touchstart":aR=true;aJ=false;ac=r;i="touchmove";D="touchend";ab="touchcancel";aG=false;break;case"MSPointerDown":ac=av;aR=true;aJ=true;i="MSPointerDown";D="MSPointerUp";ab="MSPointerCancel";aG=false;d=true;break;case"pointerdown":ac=av;aR=true;aJ=true;i="pointermove";D="pointerup";ab="pointercancel";aG=true;d=true;break;default:aR=false;aJ=false;if(aT.preventSelection){aG=true}else{aG=false}aZ=false;ac=T;i="mousemove";D="mouseup";ab=b;d=true}if(aR&&aZ){aO(aY)}ac(aY);if(aG&&aY.preventDefault){aY.preventDefault()}if(aa>1){Y.bClick=false}u=false;if(aZ&&ag(aY)){if(a0==0){A();C()}return false}return true};var Q=function(aY){if(!az(aY)){return}if(n||aY.which>1){return}f(aY)};this.getCurrentPos=function(){return t};var f=function(aY){aI();if(n){return}ax.evtMove=b;if(m.enabled){t={x:aP.x,y:aP.y}}else{t=aP}Y.x=aP.x;Y.y=aP.y;var aZ=V;V=aY;if(!aj.call(H,aY,t,E)){V=aZ;return false}n=true;if(W&&!y){Y.bClick=true;Y.clickRadiusX=Y.clickRadiusY=0}else{Y.bClick=false}C();if(ax.enabled){ax.x=ax.y=0;ax.lastX=aP.x;ax.lastY=aP.y;if(ax.nInterval){clearInterval(ax.nInterval)}ax.nInterval=setInterval(Z,30)}return true};var c=function(){if(g&&X!=b){g=false;a.removeEvent(window,X,ad);a.removeEvent(window,aC,aX);if(d&&q){try{a.removeEvent(q,X,ad);a.removeEvent(q,aC,aX)}catch(aY){}}if(aH!=b){a.removeEvent(window,aH,at)}X=aC=aH=b}};var C=function(){if(g){c()}g=true;X=i;aC=D;aH=ab;a.addEvent(window,X,ad);a.addEvent(window,aC,aX);if(d&&q){try{a.addEvent(q,X,ad);a.addEvent(q,aC,aX)}catch(aY){}}if(ab!=b){a.addEvent(window,aH,at)}};var ad=function(aY){ac(aY);aY.FSI_start_x=Y.x;aY.FSI_start_y=Y.y;if(ax.enabled&&ax.evtMove==b){ax.evtMove=aY}if(n){if(Y.bClick){Y.clickRadiusX=Math.max(Y.clickRadiusX,Math.abs(aP.x-Y.x));if(Y.clickRadiusX>10){Y.bClick=false}else{Y.clickRadiusY=Math.max(Y.clickRadiusY,Math.abs(aP.y-Y.y));if(Y.clickRadiusY>10){Y.bClick=false}}}if(m.enabled){m.evt=aY;aU()}else{e.call(H,aY,t,E)}}else{if(ak.started){if(ak.nType==1){au(aY)}}}if(u&&!aY.FSI_allowEventDefault){aY.preventDefault()}};var au=function(aY){var aZ=j();if(!M){return}aY._FSI_PinchDeltaStart=ak.nPinchDistance-ak.pinchDistanceStart;aY._FSI_PinchDeltaRelative=ak.nPinchDistance-ak.pinchDistanceLast;aY._FSI_PinchScale=Math.max(aq,ak.pinchDistanceLast)/ak.pinchDistanceStartMaxed;ak.pinchDistanceLast=ak.nPinchDistance;aY._FSI_PinchDistance=aZ;M.call(H,aY,aP,E)};var at=function(aY){if(aR){ah(aY);if(aa<1){if(n){aY._FSI_Canceled=true;aX(aY,true);return}else{P();return}}}ac(aY);ag(aY)};var aX=function(aY,aZ){if(aZ){aY._FSI_Canceled=true}if(aR){ah(aY)}ac(aY);if(!aZ&&ag(aY)){return}aI();if(!aZ){if(!n||aa>0){return}}aY.FSI_start_x=Y.x;aY.FSI_start_y=Y.y;var a0=false;if(!aZ&&ax.enabled){if(ay==b||ay()){a0=S(aY)}}if(a0){P();w(aY)}else{if(W){aY._FSI_Click=Y.bClick}aN.call(H,aY,t,E);P()}if(aY.preventDefault){aY.preventDefault()}};var aL=function(aY){return aa};var G=function(aY){return ap};var aU=function(){if(m.animationFrame!=b){return}aQ()};var h=function(){if(m.animationFrame==b){return}cancelAnimationFrame(m.animationFrame);m.animationFrame=b};var aQ=function(){var aY=Math.abs(t.x-aP.x)+Math.abs(t.y-aP.y);if(aY>m.fEndDiff){t.x+=(aP.x-t.x)/m.factor;t.y+=(aP.y-t.y)/m.factor;m.animationFrame=requestAnimationFrame(aQ)}else{t.x=aP.x;t.y=aP.y;m.animationFrame=b}e.call(H,m.evt,t,E)};var S=function(aY){if(!ax.enabled){return false}if(ax.running){A()}ax.pos=0;var a0=ax.factorAmount;ax.startX=t.x;ax.startY=t.y;var aZ={};aZ.x=ax.startX+a0*ax.x;aZ.y=ax.startY+a0*ax.y;if(ax.roundTargetPos){aZ.x=Math.round(aZ.x);aZ.y=Math.round(aZ.y)}if(ax.modifyTarget){aZ=ax.modifyTarget.call(H,aZ,E)}ax.amountX=aZ.x-ax.startX;ax.amountY=aZ.y-ax.startY;a0=ax.factorFrames/100;ax.frames=ax.offsetFrames+Math.round(a0*Math.abs(ax.amountX)+a0*Math.abs(ax.amountY));if(ax.frames<ax.minFrames){return false}return true};this.isAfterTouchRunning=function(){return ax.running};var w=function(aY){if(typeof(aT.onAfterTouchStart)=="function"){aT.onAfterTouchStart.call(H,aY,t,E)}ax.running=true;ax.evtUp=aY;if(ax.fnStartStopAfterTouch){ax.fnStartStopAfterTouch.call(H,true,ax.evtMove,E)}else{if(ax.useAnimationFrame){ax.animationFrameRun=requestAnimationFrame(I)}else{ax.intervalRun=setInterval(I,16)}}return true};var aF=function(aZ,aY,a1,a0){return a1*((aZ=aZ/a0-1)*aZ*aZ+1)+aY};var I=this.runAfterTouch=function(){var aY=false;ax.pos++;t.x=aF(ax.pos,ax.startX,ax.amountX,ax.frames);t.y=aF(ax.pos,ax.startY,ax.amountY,ax.frames);e.call(H,ax.evtMove,t,E);if(ax.pos==ax.frames){A(true)}else{if(ax.useAnimationFrame){ax.animationFrameRun=requestAnimationFrame(I)}aY=true}return aY};this.enableAfterTouch=function(aY){if(ax.enabled==aY){return}if(!aY){A()}ax.enabled=aY};var A=function(aY){if(!ax.running){return}if(ax.fnStartStopAfterTouch){ax.fnStartStopAfterTouch.call(H,false,ax.evtMove,E)}else{if(ax.useAnimationFrame){if(ax.animationFrameRun){cancelAnimationFrame(ax.animationFrameRun)}}else{if(ax.intervalRun){clearInterval(ax.intervalRun);ax.intervalRun=b}}}if(typeof(ax.onAfterTouchEnd)=="function"){ax.onAfterTouchEnd.call(H,ax.evtMove,E)}ax.evtMove=b;ax.running=false;ax.evtUp._FSI_Canceled=(aY!==true);ax.evtUp._FSI_fromAfterTouch=true;aN.call(H,ax.evtUp,t,E)};var Z=function(){ax.x=(2*ax.x+aP.x-ax.lastX)/5;ax.y=(2*ax.y+aP.y-ax.lastY)/5;ax.lastX=aP.x;ax.lastY=aP.y};var aw=this.setCapture=function(aY,a0){var aZ=af(aY,a0);if(aZ){ar.captureScrollUser=aY;ar.capturePinchUser=a0}return aZ};var af=function(aY,a0){var aZ=0;if(aY){aZ+=2}if(a0){aZ+=4}if(aZ==ar.nCheck){return}ar.nCheck=aZ;ar.captureScroll=aY;ar.capturePinch=a0;if(a.BrowserSupports.cssTouchAction()){N(aY,a0)}return true};var N=function(aY,a2){var a1;switch(ar.nCheck){case 0:a1="auto";break;case 2:a1="pinch-zoom double-tap-zoom ";break;case 4:a1="pan-x pan-y double-tap-zoom";break;default:a1="double-tap-zoom"}ar.cssTouchAction=a1;for(var a0=0;a0<l.length;a0++){var aZ=l[a0];o(aZ,ar.cssTouchAction)}};var j=function(){if(ap.length<1){return 0}var aZ=Math.abs(ap[1].x-ap[0].x);var aY=Math.abs(ap[1].y-ap[0].y);var a0=ak.nPinchDistance=Math.sqrt(aZ*aZ+aY*aY);return a0};var ag=function(aY){u=false;if(!ai){return}var aZ=ap.length;if(!aM){u=(aZ==1&&ar.captureScroll);return}if(ak.pointerCount!=aZ){O(aY);if(aZ>1){ae();ak.nPointers=aZ;switch(aZ){case 2:ak.started=true;ak.name="pinch";ak.nType=1;if(typeof(aT.onPinchStart)=="function"){K(aY);ak.nPinchDistance=0;ak.nPinchDistance=j();ak.pinchDistanceStart=ak.pinchDistanceLast=ak.nPinchDistance;ak.pinchDistanceStartMaxed=Math.max(aq,ak.pinchDistanceStart);aY._FSI_PinchDistance=ak.nPinchDistance;aT.onPinchStart.call(H,aY,aP,E)}break;default:ak.started=true;ak.name="unknown";ak.nType=-1}if(ak.started){y=true;if(n){aI();n=false;aY._FSI_Canceled=true;aN.call(H,aY,t,E)}if(typeof(aT.onGestureStart)=="function"){K(aY);aT.onGestureStart.call(H,aY,aP,E)}}}else{if(aZ<1){ae()}}ak.pointerCount=aZ;u=false;if(aZ==1){if(ar.captureScroll){u=true}}else{if(ar.capturePinch&&ak.nType==1){u=true}}}return ak.started};var ae=function(){if(!ak.timeoutRestartDown){return}clearTimeout(ak.timeoutRestartDown);ak.timeoutRestartDown=b};var B=function(){if(aa!=1){return}f(V);ae()};var K=function(aY){aY._FSI_Gesture=ak.name;aY._FSI_GestureType=ak.nType;aY._FSI_PointerCount=ak.nPointers};var O=function(aY){if(!ak.started){return}ak.started=false;if(!aY){aY={}}if(ak.nType==1&&typeof(aT.onPinchEnd)=="function"){K(aY);aY._FSI_PinchDistance=ak.nPinchDistance;aT.onPinchEnd.call(H,aY,aP,E)}if(typeof(aT.onGestureEnd)=="function"){K(aY);aT.onGestureEnd.call(H,aY,aP,E)}ak.name="none";ak.nType=0;if(aY&&aa==1){ae();ak.timeoutRestartDown=setTimeout(B,20)}};am()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageFlow!=b){return}a.ImageFlow=function(d){var bK=new a.ClassDef(this,"FSI ImageFlow","2016","16.08.4");var aR=bK.instance;a.guessFSIViewerLocation("fsiimageflow.js",3);var bj=a.getViewerInstanceID();var bc=(d)?a.cloneParameters(d):{};bc.debug=true;var ax;var r;var ar;var aF;var w;var at;var bV=false;var bl;var y;var bW=[];var cv;var aS;var bd;var aa=0;var bF={};var bC;var ap,a1;var bS;var bB;var aV={};var a9=false;var D;var bE;var Y;var aM;var bo;var bZ;var aL;var b5;var c=4;var aO;var bU=false;var aX=false;var bO;var B;var aN;var M=false;var cl;var l;var bh;var bR;var aW;var bp;var cp;var aJ,aU,A;var R=0;var b1=0;var q;var b7;var ah;var bf;var bJ;var am;var bx;var bg,bI;var Z=[];var af={};var a8;var bi;var p={};var b6;var b9;var T={};var aD={};var cm;var V={};var ac;var X;var ct;var a7;var aH=0;var bY;var cn;var b2;var z;var br={};var aZ;var F;var a3=/((\?)|&)(width|height)=[^&]*/ig;var b3,aP,S,aY,a0;var aT;var bX;var cw;var cj;var ba;var au;var av;var bD;var aQ;var i;var ca={};var f=0;var aj=8;var g=[];var cf=true;var C=false;var ci=0;var bQ={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",headers:"cors",scrollColor:"#999",placeHolderColor:"#EEEEEE",backgroundColor:"#FFF",zoomBorderStyle:"solid",zoomBorderColor:"#777",zoomBackgroundColor:"white",zoomFadeColor:"white",imageBorderColor:"none",callBackFocus:"",callBackClick:"",callBackZoomStart:"",callBackZoomEnd:"",callBackStart:"",presentationType:"carousel",elementWidth:"10%",elementSpacing:"0.25%"},booleans:{autoDestroy:true,autoResize:true,enableZoom:true,enableScrollBar:true,transparency:false,centerZoomedImage:true,zoomCenteredImageOnly:false,positionQuantization:false,endlessScrolling:false,duplicateImagesIfNeeded:false},floats:{mirrorHeight:0.5,mirrorStartOpacity:0.5,backgroundDarkness:0.3,depthFadeout:0.2,curveHeight:0.35,autoRotateSpeed:0,scrollAlphaNormal:0.35,scrollAlphaActive:1},integers:{zIndexZoom:1000,preloadCount:20,paddingTop:10,paddingBottom:0,zoomFadeOpacity:80,zoomBorderWidth:4,scrollPadding:0,scrollHeight:16}};if(a.isMobileDevice){X=25}else{X=10}var r=new a.EmptyDebugger();var aC=function(cy,cx){if(cx&&!r.on&&cy.on){if(bE){bE.stopPendingRequests()}aR.destroy();aR.init(aF,bc,true);return true}r=cy;if(r.on){r.setPrefix(bK.strClassName+" ["+aF+"]")}};this.init=function(cy,cC,cx){var cA;if(!a.BrowserSupports.canvas()){r.error("<canvas> element not supported.");return}if(!cy){return}if(typeof(cy)=="object"){if(typeof(cy.id)=="string"){aF=cy.id}}else{if(typeof(cy)=="string"){aF=cy}}if(!aF){aF="fsi.imageflow #"+bj}if(aR._fsi_parameters){cC=aR._fsi_parameters;delete aR._fsi_parameters}if(typeof(cy)=="object"&&cy.tagName!=b){cA=cy}else{cA=document.getElementById(cy)}if(typeof(cC)=="object"&&typeof(window[cC.oninit])=="function"){var cz=window[cC.oninit](aR,aF,cC)}if(!cA){return}if(bV){aR.destroy()}cA.setAttribute("x-fsi-id",aF);ci++;bl=cA;cA.innerHTML="";y=document.createElement("div");a.setStyleAttr(y,"width:100%;height:100%;border:0px;none;margin:0px;padding:0px;overflow:hidden");bl.appendChild(y);bc=(cC)?a.cloneParameters(cC):bc;var cD={};cD.onConfigsReady=az;cD.onDebuggerChange=aC;bE=new a.Config(null,cD);var cB=bc;if(cx){cB=a.cloneObject(bc);cB.debug=true}bE.init(cB);r.log(aR.getVersion());at={};bE.loadConfigs();bV=true};this.getInitDone=function(){return bV};var bL=function(cy){var cx=cy.oCrop={};bw(cx,"rectLeft",cy.sourceWidth,0);bw(cx,"rectTop",cy.sourceHeight,0);bw(cx,"rectRight",cy.sourceWidth,1);bw(cx,"rectBottom",cy.sourceHeight,1);cx.rectWidth=1-cx.rectRight-cx.rectLeft;cx.rectHeight=1-cx.rectBottom-cx.rectTop;cx.bCrop=true;cx.query=cx.rectLeft+","+cx.rectTop+","+cx.rectWidth+","+cx.rectHeight};var bw=function(cC,cz,cA,cy){var cB=ca[cz];if(typeof(cB)!="string"){cC[cz]=cB;return}var cx=parseInt(cB);if(isNaN(cx)){cC[cz]=cy;return}cx=Math.max(0,Math.min(cA,cx));cC[cz]=cx/cA};var bG=function(cz,cy){cz=cz.toLowerCase();var cx=cy;if(cz.indexOf("px")!=-1){cx=parseInt(cz);if(isNaN(cx)||cx<=0){cx=cy}else{cx=""+cx+"live";ca.bLive=true}}else{if(cz.indexOf("%")!=-1){cx=Math.max(0,Math.min(100,parseFloat(cz)));cx/=100;if(isNaN(cx)||cx<0){cx=cy}}else{cx=Math.max(0,Math.min(1,parseFloat(cz)));if(isNaN(cx)||cx<0){cx=cy}}}return cx};var ag=function(){var cz=ca;cz.rectWidth=cz.rectHeight=1;cz.rectLeft=cz.rectTop=0;cz.bCrop=ca.bLive=false;cz.query="";if(at.cropValues&&at.cropValues.length>6){var cy=at.cropValues.split(",");cz.rectLeft=bG(cy[0],0);cz.rectTop=bG(cy[1],0);cz.rectRight=bG(cy[2],0);cz.rectBottom=bG(cy[3],0);cz.rectWidth=1-cz.rectRight-cz.rectLeft;cz.rectHeight=1-cz.rectBottom-cz.rectTop;cz.bCrop=true;if(!cz.bLive){cz.query=cz.rectLeft+","+cz.rectTop+","+cz.rectWidth+","+cz.rectHeight}}else{if(at.cropRect&&at.cropRect.length>6){var cy=at.cropRect.split(",");if(cy.length>3){while(cy.length>4){cy.pop()}for(var cx=0;cx<cy.length;cx++){cy[cx]=parseFloat(cy[cx])}var cA=cy[0]*cy[1]*cy[2]*cy[3];if(isNaN(cA)){return}cz.rectLeft=cy[0];cz.rectTop=cy[1];cz.rectRight=cy[0];cz.rectBottom=cy[1];cz.rectWidth=cy[2]-cy[0];cz.rectHeight=cy[3]-cy[1];cz.bCrop=true;cz.query=cz.rectLeft+","+cz.rectTop+","+cz.rectWidth+","+cz.rectHeight}}}};var bA=function(cz){var cy=at[cz];var cx;if(typeof(cy)=="string"&&cy.length>0){try{cx=window[cy]}catch(cA){}}else{if(typeof(cy)!="function"){cx=b}cx=cy}return cx};var az=function(){if(bE.cfg.viewerid){aR.assignFSIViewer(bE.cfg.viewerid)}var cy=bE.cfg.dir;if(!cy||cy.length==0){var cx=bE.getImageList();if(cx){al(cx.arImages,cx)}}else{bE.loadImageList(bE.cfg.dir,al)}};var al=function(cx,cy){if(!bV){return}ac=0;if(!cx){cx=[]}bW=cx;r.log("Image list loaded ("+bW.length+" images)");E();j()};var E=function(){s(at)};var a5=function(cy,cx,cB,cz){for(var cA in cB){cx[cA]=cy.getFloatParameter(cz+cA,cB[cA])}};var bs=function(cy,cx,cB,cz){for(var cA in cB){cx[cA]=cy.getIntParameter(cz+cA,cB[cA])}};var aq=function(cz,cy,cx,cA){for(var cB in cx){cy[cB]=cz.getStringParameter(cA+cB,cx[cB])}};var ak=function(cy,cx,cA,cz){for(var cB in cA){cx[cB]=cy.makeBool(cy.getStringParameter(cz+cB),cA[cB])}};var t=function(cy,cx,cA,cz){var cB;if(cA&&cA.length>0){if(cx[cA]==b){cx[cA]={}}cz=cz[cA];cB=cx[cA]}else{cB=cx}if(cz.strings){aq(cy,cB,cz.strings,cA)}if(cz.booleans){ak(cy,cB,cz.booleans,cA)}if(cz.floats){a5(cy,cB,cz.floats,cA)}if(cz.integers){bs(cy,cB,cz.integers,cA)}};var s=function(cx){if(cx==b){cx={}}cx.serverBase=bE.serverBase;t(bE,cx,"",bQ);var cA=/[\dabcdef]{3,6}/i;for(var cB in bQ.strings){if(cB.indexOf("Color")!=-1){var cz=at[cB];if(cz.indexOf("#")!=0){var cy=cz.match(cA);if(cy){if(cy[0].length==cz.length&&(cy[0].length==3||cy[0].length==6)){at[cB]="#"+cy[0]}}}}}};var j=function(){bO=at.presentationType.toLowerCase();if(a.isMobileDevice){c=3}else{c=1}cj=at.transparency;bU=at.endlessScrolling;b3=bA("callBackFocus");aP=bA("callBackClick");S=bA("callBackZoomStart");aY=bA("callBackZoomEnd");a0=bA("callBackStart");ag();cm=bW.length;var cy=at.placeHolderColor.toLowerCase();bX=(cy!="none"&&cy!="transparent");var cy=at.imageBorderColor.toLowerCase();i=(cy!="none"&&cy!="false");if(at.zoomCenteredImageOnly){bR=true}else{bR=at.positionQuantization}var cy=bn();aJ=A=aU=cy;au=-at.autoRotateSpeed;cl="rgba(0,255,0,";var cy=at.backgroundColor.toLowerCase();if(cy=="false"||cy=="transparent"||cy=="none"){at.backgroundColor=false;aO=bv;y.style.backgroundColor="transparent"}else{if(!cj&&at.backgroundDarkness==0){aO=L}else{aO=bv}var cy=at.backgroundColor;if(cy.indexOf("#")==0){cy=cy.substr(1)}if(cy.length==3){cy=cy.charAt(0)+cy.charAt(0)+cy.charAt(1)+cy.charAt(1)+cy.charAt(2)+cy.charAt(2)}var cA=parseInt("0x"+cy.substr(0,2));if(isNaN(cA)){cA=0}var cz=parseInt("0x"+cy.substr(2,2));if(isNaN(cz)){cz=0}var cx=parseInt("0x"+cy.substr(4,2));if(isNaN(cx)){cx=0}cl="rgba("+cA+","+cz+","+cx+",";y.style.backgroundColor=at.backgroundColor}cw=(aO==bv);ao();cv=a.cloneArray(bW);aS={};if(at.autoResize==true){if(bh==b){bh=a.addCustomEvent(bl,"FSIElementDimension",cc);a.setCustomEventListenerProperty(bh,"treshold",200)}}else{if(bh!=b){a.removeCustomEvent(bl,"FSIElementDimension",cc);bh=b}}bM();a6()};var by=function(cz){var cy,cx;if(typeof(cz)=="string"){cx=cz.indexOf("%");cy=parseFloat(cz)}else{cx=-1;cy=cz}if(cx!=-1){cy=Math.round(aJ.width*cy/100)}return{val:cy,bRelative:(cx!=-1)}};var ao=function(){var cx;cx=by(at.elementWidth);if(isNaN(cx.val)){cx=by(bQ.strings.elementWidth)}aW=bF.width=Math.max(1,cx.val);bF.widthRelative=cx.bRelative;cx=by(at.elementSpacing);if(isNaN(cx.val)){cx=by(bQ.strings.elementSpacing)}bp=bF.spacing=cx.val;bF.spacingRelative=cx.bRelative};var bM=function(){a9=false;n();if(cv.length<1){return}bC=0;bd={};aa=0;ci++;if(bW.length!=cv.length){bW=a.cloneArray(cv)}cm=bW.length;a7=!at.enableScrollBar;b7=aW+bp;aJ=aU;bg=aJ.width/2;var cC=0;aX=false;switch(bO){case"stacks":cC=2;C=false;cf=false;break;case"flat":aX=!bU;at.zoomCenteredImageOnly=false;cC=1;if(!bU){bg=0}else{bg-=b7/2}cf=false;C=true;break;default:cC=2;bO="carousel";C=false;cf=true;break}if(bO=="stacks"){bI=aJ.width/2-aW/2}else{bI=aJ.width/2-aW/4}G();var cA=b6;if(bU){var cD=false;R=0;if(cm==1){cD=true;bW.push(bW[0]);cm++}aI();u();if(cD){bW.pop();cm=1}if(Z.length+cC>cm){if(!at.duplicateImagesIfNeeded){bU=false}else{var cz=(Z.length+cC-cm);for(var cy=0;cy<cz;cy++){bW.push(bW[cy%cm])}cm=bW.length}}}aI();G();if(b6<=0){a7=true}b9={height:at.scrollHeight,padding:at.scrollPadding,alphaNormal:at.scrollAlphaNormal,alphaActive:at.scrollAlphaActive};b9.height=Math.max(3,b9.height);b9.padding=Math.max(0,b9.padding);b9.alpha=b9.alphaTarget=b9.alphaNormal;b9.width=Math.round(aJ.width-2*b9.padding);b9.y=Math.round(aJ.height-b9.height-b9.padding);if(!a7){var cx=Math.max(0,cA);b9.buttonWidth=Math.round(Math.max(20,b9.width*Math.min(1,aJ.width/(aJ.width+cx))))}else{b9.buttonWidth=20}b9.range=b9.width-b9.buttonWidth;if(!a7){a7=(b9.buttonWidth>=b9.width)}ct=(cm<2);if(!a7){a7=ct}if(!bU&&bO=="flat"&&cm*b7<aJ.width){bg=(aJ.width-cm*b7)/2}var cE=at.paddingBottom;if(!a7){cE=Math.max(b9.height,cE)}bD=aJ.height-at.paddingTop-cE;ah=0;at.mirrorHeight=Math.max(0,Math.min(1,at.mirrorHeight));if(at.mirrorHeight>0){ah=Math.round(at.mirrorHeight*bD/2);bf=(ah>0)}else{bf=false}bD-=ah;if(cf){aQ=Math.round(at.curveHeight*bD)}else{aQ=0}aE();if(l!=b){var cB=l.offsetLeft/l.xAdvance;R=cB*b7;l=b}if(bR){R=Math.round(R/b7)*b7}R=ae(R);a9=true;if(bD<1){r.error("Insufficient instance height. Resulting image height is "+bD+"px");return}bC=bW.length;ap=a2;a1=m;aw();if(at.preloadCount>0){U()}if(au!=0){ad()}};var aI=function(){if(cm<2){bS=o}else{if(aX){bS=h}else{bS=cq}}};var a6=function(){if(a0){a0(aR,aF,at.dir,bW.length)}I(0);cg()};var G=function(){b6=cm*b7;if(!bU){if(bO=="flat"){b6-=aJ.width}else{b6-=b7}}};var aE=function(){if(!aJ||aJ.width<1||aJ.height<1){return false}if(!D){D=document.createElement("canvas");D.setAttribute("draggable","false");D.style.width=D.style.height="100%";if(a.isIETouch){D.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}D.setAttribute("width",aJ.width);D.setAttribute("height",aJ.height);cp=D.getContext("2d");y.appendChild(D)}else{D.setAttribute("width",aJ.width);D.setAttribute("height",aJ.height)}if(bf&&!Y){Y=document.createElement("canvas");aM=Y.getContext("2d");aL=Y.cloneNode();b5=aL.getContext("2d");bo=Y.cloneNode();bZ=bo.getContext("2d")}if(bf){var cx=Math.ceil(aW);var cz=Math.ceil((bD+1));Y.setAttribute("width",cx);Y.setAttribute("height",cz);aL.setAttribute("width",cx);aL.setAttribute("height",cz);bo.setAttribute("width",cx);bo.setAttribute("height",cz);bJ=aM.createLinearGradient(0,0,0,ah);if(cw){bJ.addColorStop(0,cl+at.mirrorStartOpacity+")");bJ.addColorStop(1,cl+"0)")}else{bJ.addColorStop(0,cl+(1-at.mirrorStartOpacity)+")");bJ.addColorStop(1,cl+"1)")}aM.strokeStyle=at.imageBorderColor;aM.fillStyle=bJ;aM.lineWidth=0;bZ.strokeStyle=at.imageBorderColor}if(at.backgroundDarkness>0){am=cp.createLinearGradient(0,0,aJ.width,0);var cy="rgba(0,0,0,";am.addColorStop(0,cy+at.backgroundDarkness+")");am.addColorStop(0.4,cy+"0)");am.addColorStop(0.6,cy+"0)");am.addColorStop(1,cy+at.backgroundDarkness+")");bx=true}else{bx=false}if(!ax){var cA={};cA.detectClick=true;cA.afterTouch={enabled:true};cA.afterTouch.modifyTarget=bz;cA.afterTouch.factorAmount=23;cA.afterTouch.factorFrames=3.7;cA.afterTouch.minFrames=5;cA.afterTouch.offsetFrames=3;cA.detectGestures=true;ax=new a.TouchHandler(D,cA,bH,bP,be);ax.setCapture(true,false)}};var bz=function(cA,cx){if(bR){var cz=T.offsetLeft-T.x-T.startX;var cy=Math.round((cA.x+cz)/b7)*b7;cA.x=cy-cz}return cA};var b4=function(){var cx=a.getElementClientPos(D);T.x=cx.left;T.y=cx.top};var bH=function(cx,cA,cz){b4();aD.x=cA.x-T.x;aD.y=cA.y-T.y;bT(b9.alphaActive);aA();au=0;cancelAnimationFrame(bi);bi=b;R=ae(R);if(Q(aD.x,aD.y)){ax.enableAfterTouch(false);T.scrollOffsetX=0;bT(b9.alphaActive);b9.bDragging=true;bP(cx,cA,cz);ai();var cy=b9.padding+b9.x+b9.buttonWidth/2;T.scrollOffsetX=(cy-aD.x)}else{ax.enableAfterTouch(true);b9.bImageDragging=true;T.startX=aD.x;T.startY=aD.y;T.offsetLeft=R}aw();return true};var bP=function(cy,cB,cz){aD.x=cB.x-T.x;aD.y=cB.y-T.y;if(b9.bDragging){var cx=aD.x+T.scrollOffsetX-b9.padding-b9.buttonWidth/2;cx=Math.max(0,Math.min(b6-1,Math.round(cx*b6/b9.range)));R=ae(Math.min(0,Math.max(-cx,-b6)));aw()}else{if(b9.bImageDragging){T.dx=aD.x-T.startX;T.dy=aD.y-T.startY;var cA=R;R=ae(T.offsetLeft+T.dx);aw();if(cA==R||Math.abs(T.dy)>3*Math.abs(T.dx)){cy.FSI_allowEventDefault=true}}}};var be=function(cG,cB,cH){var cE=cG._FSI_Click;aD.x=cB.x-T.x;aD.y=cB.y-T.y;bT(b9.alphaNormal);if(b9.bDragging){bT(b9.alphaNormal);b9.bDragging=false;if(bR){var cI=Math.round(R/b7)*b7;var cy=Math.round(-ae(cI)/b7);I(cy);bu(cI,true,55)}}else{if(b9.bImageDragging){b9.bImageDragging=false;if(cE){var cD=aD.x;var cC=aD.y;var cx;var cF=0;var cz=Z[Z.length-1];for(var cA=0;cA<Z.length;cA++){var cz=Z[cA];if(cD>=cz.x&&cC>=cz.y&&cD<=cz.x+cz.drawWidth&&cC<=cz.y+cz.drawHeight){cF=1;if(aP){aP(aR,aF,cz.nIndex,bW[cz.nIndex])}if(!at.zoomCenteredImageOnly||aH==cz.nIndex){if(at.enableZoom){ce(cz)}}if(at.centerZoomedImage){ck(cz)}break}}}else{co()}}}aw()};var co=function(){if(bR){var cx=Math.round(R/b7)*b7;if(Math.abs(cx-R)>0.5){var cy=Math.round(-ae(cx)/b7);I(cy);bu(cx,true,30)}}};var I=function(cx){aH=cx;aT=b;if(b3){var cy=aS[cx];if(cy){b3(aR,aF,cy.nIndex,bW[cy.nIndex])}}};this.assignFSIViewer=function(cx){if(cx&&typeof(cx)=="string"){if(cx.toLowerCase()=="auto"){var cy=document.getElementsByTagName("fsi-viewer");if(cy&&cy.length>0){cx=cy[0]}else{cx=b}}else{cx=document.getElementById(cx)}}if(!cx||typeof(cx.changeImage)!="function"){B=b}else{B=cx}aN=false;cg()};var cg=function(){if(!bV||!B||aN||bW.length<1){return}aN=true;var cx={};cx.path=bW[0];N(cx)};var N=function(cx){if(!cx||!B||typeof(B.changeImage)!="function"){return}var cy={};cy.fpxsrc=cx.path;cy.imageWidth=cx.sourceWidth;cy.imageHeight=cx.sourceHeight;cy.cropRect=bE.cfg.croprect;cy.cropValues=bE.cfg.cropvalues;cy.effects=bE.cfg.effects;B.changeImage(cy)};var ce=function(cD){if(B!=b){N(cD);return}K(b,true);if(!cD.bReady){return}bY=document.createElement("div");cn=document.createElement("div");z=document.createElement("img");br.alphaShader=0;var cT=a.getDocumentScale();var cU=at.zoomBorderWidth/cT;var cL=at.zIndexZoom;var cM="position:absolute;z-index:"+(cL+1)+";border:"+cU+"px "+at.zoomBorderStyle+" "+at.zoomBorderColor+";line-height:0px;box-sizing: content-box;";var cI=at.zoomBackgroundColor.toLowerCase();if(cI!="none"&&cI!="transparent"){cM+="background-color:"+at.zoomBackgroundColor}bY.setAttribute("style",cM);var cB="position:absolute;z-index:"+cL+";background-color:"+at.zoomFadeColor+";opacity:0.0;filter:Alpha(opacity=0);";b2=cD.img.cloneNode();b2.style.width=b2.style.height="100%";bY.appendChild(b2);var cC=a.getElementClientPos(D);var cz=a.getElementClientPos(document.body);var cK=-cz.left;var cJ=-cz.top;br.startX=cK+cC.left+cD.x-cU;br.startY=cJ+cC.top+cD.y-cU;br.startWidth=cD.width;br.startHeight=cD.height;bY.style.width=br.startWidth+"px";bY.style.height=br.startHeight+"px";bY.style.left=br.startX+"px";bY.style.top=br.startY+"px";var cS=a.getViewportSize(window);if(a.getDevicePixelRatio()!=1){cS.width-=1;cS.height-=1}a.addEvent(cn,"mousedown",K,false);a.addEvent(window,"touchstart",K,false);a.addEvent(bY,"mousedown",K,false);a.addEvent(window,"scroll",K,false);var cQ=Math.ceil(40/cT);var cy=cS.width-cQ-2*cU;var cR=cS.height-cQ-2*cU;var cF=cD.maxWidth;var cO=cD.maxHeight;if(cy/cF<cR/cO){cF=cy;cO=Math.round(cF*cD.maxHeight/cD.maxWidth)}else{cO=cR;cF=Math.round(cO*cD.maxWidth/cD.maxHeight)}if(cF>cD.maxWidth||cO>cD.maxHeight){cF=cD.maxWidth;cO=cD.maxHeight}br.endWidth=cF;br.enddHeight=cO;br.dWidth=cF-br.startWidth;br.dHeight=cO-br.startHeight;br.endX=window.pageXOffset+Math.round((cS.width-cF)/2);br.endY=window.pageYOffset+Math.round((cS.height-cO)/2);br.dx=br.endX-br.startX;br.dy=br.endY-br.startY;cB+="left:"+window.pageXOffset+"px;top:"+window.pageYOffset+"px;width:"+(cS.width)+"px;height:"+cS.height+"px";br.bImageReady=false;var cA=cD.img.src;cA=cA.replace(a3,"$1");var cx=Math.min(cD.maxWidth,Math.round(cT*cF));var cN=Math.min(cD.maxHeight,Math.round(cT*cO));cA+="&width="+cx+"&height="+cN;av=true;a.addEvent(z,"load",ch,false);z.style.width=br.endWidth+"px";z.style.height=br.endHeight+"px";z.setAttribute("crossorigin","anonymous");z.src=cA;br.pos=0;var cG=br.startX-br.endX;var cE=br.startY-br.endY;var cH=br.startWidth-br.endWidth;var cP=br.startHeight-br.endHeight;br.frames=cd(20);cn.setAttribute("style",cB);document.body.appendChild(cn);document.body.appendChild(bY);br.alphaShader=0;cancelAnimationFrame(aZ);aZ=requestAnimationFrame(ay);br.posFader=0;br.framesShader=10;br.startAlpha=br.alphaShader;br.endAlpha=at.zoomFadeOpacity;br.dAlpha=br.endAlpha-br.startAlpha;F=requestAnimationFrame(v);if(S){S(aR,aF,cD.nIndex,cA)}if(!a.isMobileDevice){a.addEvent(window,"resize",K,false)}else{a.addEvent(window,"orientationchange",K,false)}};var cs=a.Easing.easeOutCubic;var ay=function(){br.pos++;if(br.pos>br.frames){aZ=b;requestAnimationFrame(cu);return}var cx=cs(br.pos,br.frames,br.startX,br.dx);var cA=cs(br.pos,br.frames,br.startY,br.dy);var cy=cs(br.pos,br.frames,br.startWidth,br.dWidth);var cz=cs(br.pos,br.frames,br.startHeight,br.dHeight);bY.style.left=cx+"px";bY.style.top=cA+"px";bY.style.width=cy+"px";bY.style.height=cz+"px";aZ=requestAnimationFrame(ay)};var cu=function(){if(!bY||!br.bImageReady||aZ!=b){return}bY.firstChild.style.width=z.style.width;bY.firstChild.style.height=z.style.height;bY.firstChild.src=z.src;z=b;bY.style.width="";bY.style.height=""};var ch=function(cx){br.bImageReady=true;a.removeEvent(z,"load",ch,false);av=false;cu()};var K=this.closeZoom=function(cx,cy){if(!bY){return}aT=b;if(!a.isMobileDevice){a.removeEvent(window,"resize",K,false)}else{a.removeEvent(window,"orientationchange",K,false)}if(F){cancelAnimationFrame(F);F=b}cancelAnimationFrame(aZ);aZ=b;a.removeEvent(cn,"mousedown",K,false);a.removeEvent(bY,"mousedown",K,false);a.removeEvent(window,"touchstart",K,false);a.removeEvent(window,"scroll",K,false);if(av){a.removeEvent(z,"load",ch,false)}if(z){z=b}a.removeChild(bY.parentNode,bY);bY=b;if(cy===true){a.removeChild(cn.parentNode,cn);cn=b}else{br.posFader=0;br.framesShader=10;br.startAlpha=br.alphaShader;br.endAlpha=0;br.dAlpha=br.endAlpha-br.startAlpha;F=requestAnimationFrame(v)}if(aY){aY(aR,aF)}if(cx&&cx.touches&&cx.touches.length==1){cx.cancelBubble=true;if(cx.stopPropagation){cx.stopPropagation()}if(cx.preventDefault){cx.preventDefault()}}};var W=function(cx){br.alphaShader=cx;cn.style.opacity=cx/100;cn.style.filter="Alpha(opacity="+cx+")"};var v=function(){br.posFader++;if(br.posFader>br.framesShader){if(br.endAlpha==0){a.removeChild(cn.parentNode,cn);cn=b}F=b;return}var cx=cs(br.posFader,br.framesShader,br.startAlpha,br.dAlpha,3);W(cx);F=requestAnimationFrame(v)};var Q=function(cx,cy){return(!a7&&cx>=b9.padding&&cy>=b9.y&&cx<=b9.padding+b9.width&&cy<=b9.y+b9.height)};this.focusImage=function(cx){if(cx<0||cx>=bW){return false}var cy=cb(cx);ck(cy);return true};this.zoomImage=function(cx){if(!at.enableZoom||!this.focusImage(cx)){return false}var cy=cb(cx);aT=cy.nIndex;aB()};var ck=function(cy,cx){if(!cy){return false}I(cy.nIndex);return bu(-cy.nIndex*b7,cx,30)};var ae=function(cx){if(bU){cx=Math.round(cx)%b6;if(cx>0){cx-=b6}}else{cx=Math.min(0,Math.max(-b6,cx))}return cx};var cd=function(cx){if(a.isMobileDevice){cx=Math.ceil(cx/1.8)}return cx};var bu=function(cA,cx,cz){cz=cd(cz);aA();if(cz==b){cz=40}if(!cx&&bU){cA=ae(cA);R=ae(R);var cy=cA-R;if(Math.abs(cy)>b6/2){if(cy>0){cA=-b6+cA}else{cA=b6+cA}}}if(cA==R||(bi!=b&&cA==p.end)){return false}cancelAnimationFrame(bi);bi=b;p.frames=cz;p.pos=0;p.start=R;p.end=cA;p.diff=p.end-p.start;bi=requestAnimationFrame(bN);return true};var bN=function(){p.pos++;if(p.pos==p.frames){R=ae(p.end);bi=b;bq();aB();return}R=cs(p.pos,p.frames,p.start,p.diff,3);if(!bU){R=ae(R)}bq();aB();bi=requestAnimationFrame(bN)};var cr=function(cy,cA,cB){if(!bV){return}if(!cA||!cB||cB.nInitID!=ci){return}f--;var cx,cz;cx=parseInt(cA.width);cz=parseInt(cA.height);if(isNaN(cx)&&isNaN(cz)){r.error("Failed to get image info.")}cB.nThumbnailDimWidth=aW;cB.nThumbnailDimHeight=bD;cB.bInfoReady=true;cB.bDrawPlaceHolder=bX;cB.sourceWidth=cx;cB.sourceHeight=cz;if(ca.bLive){bL(cB)}if(ca.bCrop){cB.objCropCurrent=(cB.oCrop)?cB.oCrop:ca;cB.maxWidth=Math.round(cB.objCropCurrent.rectWidth*cx);cB.maxHeight=Math.round(cB.objCropCurrent.rectHeight*cz)}else{cB.maxWidth=cx;cB.maxHeight=cz}aK(cB)};var aK=function(cy){var cE,cA;if(!cy.bInfoReady){return false}cy.nThumbnailDimWidth=aW;cy.nThumbnailDimHeight=bD;if(!cy.bThumbLoading){f++}cy.bThumbLoading=true;cy.bThumbLoadStarted=true;var cB=aW;var cD=bD;if(cB/cy.maxWidth<cD/cy.maxHeight){cE=cB;cA=Math.round(cE*cy.maxHeight/cy.maxWidth)}else{cA=cD;cE=Math.round(cA*cy.maxWidth/cy.maxHeight)}var cC=true;if(cE<1||cA<1){cE=cA=0;cC=false}cy.width=cE;cy.height=cA;cy.offsetX=(cB-cE)/2;cy.offsetY=cD-cA-aQ+at.paddingTop;var cF={width:cE,headers:"cors"};if(cy.objCropCurrent){cF.rect=cy.objCropCurrent.query}if(at.effects.length>0){cF.effects=at.effects}if(at.overlays.length>0){cF.overlays=at.overlays}if(at.quality.length>0){cF.quality=at.quality}if(at.fpxservertemplate.length>0){cF.renderer=at.fpxservertemplate}var cx=bE.getImageURL(cy.path,cF);var cz;if(cy.img==b){cz=cy.img=document.createElement("img");cz.oSprite=cy;cz.crossOrigin="anonymous"}else{cz=cy.img}cy.nInitID=ci;if(!cy.bHasEvents){aV[cy.nIndex]=cy;cy.bHasEvents=true;a.addEvent(cz,"load",J,false);a.addEvent(cz,"error",P,false)}if(cy.bDrawPlaceHolder){if(cy.myX!=b){b8(cy)}if(bk(cy)){aw()}}if(!cC){P.call(cz)}else{cy.src=cz.src=cx}return true};var bt=function(cx){if(cx.nThumbnailDimWidth!=aW||cx.nThumbnailDimHeight!=bD){return false}return true};var an=function(cx){if(!cx||cx.nInitID!=ci){return false}return true};var bb=function(cx){if(cx.bHasEvents){delete aV[cx.nIndex];a.removeEvent(cx.img,"load",J,false);a.removeEvent(cx.img,"error",P,false);cx.bHasEvents=false}};var P=function(cx){var cy=this.oSprite;if(!cy){return}cy.bReady=false;cy.bDrawPlaceHolder=false;cy.bLoadComplete=true;cy.bThumbLoading=false;bb(cy);if(an(cy)){f--}a1()};var J=function(cx){var cy=this.oSprite;if(!cy){return}bb(cy);if(!bV){return}cy.bReady=true;cy.bLoadComplete=true;cy.bThumbLoading=false;cy.bDrawPlaceHolder=false;if(!an(cy)){return}f--;if(!bt(cy)){return}H(cy);if(bk(cy)&&cy.myX!=b){b8(cy);aw()}aB();a1()};var aB=function(){if(aT==b){return}var cx=cb(aT);if(!cx.bReady||!bk(cx)){return}ce(cx);aT=b};var cb=function(cz,cC,cx){var cA;cz%=cm;if(cz<0){cz+=cm}if(bd[cz]!=b){return bd[cz]}var cB=aS[cz];if(cB==b){ac++;cB=aS[cz]={};cB.nIndex=cz;var cy=bD;cB.width=aW;cB.height=cy;cB.offsetX=0;cB.offsetY=cy-cB.height-aQ+at.paddingTop;cB.path=bW[cz];cA=true}else{if(cB.bThumbLoadStarted&&(cB.nThumbnailDimWidth!=aW||cB.nThumbnailDimHeight!=bD)){if(cB.bReady){cB.bReady=false;cB.oMirrorData=null;cB.bDrawPlaceHolder=false}cA=true}else{if(!cB.bLoadStarted){cA=true}}}if(cA){cB.bPreload=cC;g.push(cB);if(!cx){ap()}}return cB};var k=function(){};var n=function(){ap=a1=k;if(bB){clearTimeout(bB);bB=b}};var a2=function(){if(!bB){bB=setTimeout(m,50)}};var m=function(){if(bB){clearTimeout(bB);bB=b}while(g.length>0&&f<aj){var cy=g.shift();if(bd[cy.nIndex]==b&&(cy.bPreload||bk(cy))){bd[cy.nIndex]=cy;aa++;if(aa==cm){n()}bC--;cy.bLoadStarted=true;cy.nInitID=ci;if(!cy.bInfoLoading){f++;cy.bInfoLoading=true;var cx=bE.getImageInfoURL(cy.path);bE.loadFile(cx,cr,b,cy)}else{aK(cy)}}}};var a4=function(cz,cx){if(!bU&&(cz<0||cz>=cm)){return 0}var cA=cb(cz,false,true);cA.nImage=cz;cA.myX=cx;var cy=b8(cA);if(cy){Z.push(cA)}return cy};var b8=function(cB){var cz,cA;if(C){var cy=bg+cB.myX;cA=(cy+b7>=0&&cy<=aJ.width)?1:0;cB.z=1}else{cz=cB.myX/bI;cA=Math.cos(cz/1.3);if(cf){cB.z=cA}else{cB.z=1}}if(cA<at.depthFadeout){af[cB.nIndex]=false;return 0}cB.drawWidth=cB.z*cB.width;cB.drawHeight=cB.z*cB.height;af[cB.nIndex]=true;if(C){cB.x=bg+cB.myX+Math.round((b7-cB.width)/2)}else{var cx=bI*Math.sin(cz);cB.x=bg+cx-cB.drawWidth/2}if(cf){cB.y=aQ*cB.z+cB.offsetY+(cB.height-cB.drawHeight)}else{cB.y=cB.offsetY+(cB.height-cB.drawHeight)}return 1};var bk=function(cx){if(!cx){return false}return af[cx.nIndex]};var u=function(){if(g.length>0){g=[]}Z=[];af={};var cA;var cy;if(C){cy=ae(R)}else{cy=R}if(cy>0){cA=Math.ceil(-cy/b7)}else{cA=Math.floor(-cy/b7)}var cx=cy%b7;a4(cA,cx);var cz=bS(cA,cx);if(V.interval!=b&&bi==b){V.nLastLeftImage=cA-cz+1;V.nLastRightImage=cA+cz-1;V.nLoad=at.preloadCount}};var o=function(){return 0};var cq=function(cA,cx){var cB;var cz=0;var cy=0;do{cz+=b7;cy++;cB=a4(cA-cy,cx-cz);cB+=a4(cA+cy,cx+cz)}while(cB>0&&cy<cm);return cy};var h=function(cA,cx){var cB;var cz=0;var cy=0;do{cz+=b7;cy++;cB=a4(cA+cy,cx+cz)}while(cB>0&&cy<cm);return cy};var U=function(){if(V.interval!=b){return}V.interval=setInterval(aG,100)};var b0=function(){clearInterval(V.interval);V.interval=b};var aG=function(){if(g.length>0||V.nLoad<=0){return}if(bC<1){b0();return}while(g.length<2&&V.nLoad>0){if(!aX){cb(--V.nLastLeftImage,true,true);V.nLoad--}cb(++V.nLastRightImage,true,true);V.nLoad--}a1()};var aw=function(){if(q!=b){return}q=requestAnimationFrame(bq)};var bq=function(){if(q!=b){cancelAnimationFrame(q);q=b}if(M){return}u();aO();ap()};var bv=function(){if(!bV){return}cp.globalCompositeOperation="source-over";cp.globalAlpha=1;cp.clearRect(0,0,aJ.width,aJ.height);cp.strokeStyle=at.imageBorderColor;cp.lineWidth=0;for(var cz=Z.length-1;cz>-1;cz--){var cA=Z[cz];if(cA.bReady){cp.drawImage(cA.img,cA.x,cA.y,cA.drawWidth,cA.drawHeight);if(i){cp.strokeRect(cA.x+0.5,cA.y+0.5,cA.drawWidth-1,cA.drawHeight-1)}}else{if(cA.bDrawPlaceHolder){cp.fillStyle=at.placeHolderColor;cp.fillRect(cA.x,cA.y,cA.drawWidth,cA.drawHeight);if(i){cp.strokeRect(cA.x+0.5,cA.y+0.5,cA.drawWidth-1,cA.drawHeight-1)}}}if(cA.oMirrorData){var cy=cA.y+cA.drawHeight;var cB=Math.abs(cA.z)*cA.nMirrorWidthOut;var cx=Math.abs(cA.z)*cA.nMirrorHeightOut;if(!cj){cp.clearRect(cA.x,cy,cB,cx)}if(cA.bCorsFix){cp.drawImage(cA.mirrorCanvas,0,0,cA.nMirrorWidth,cA.nMirrorHeight,cA.x,cy,cB,cx)}else{b5.clearRect(0,0,cA.nMirrorWidth,cA.nMirrorHeight);b5.putImageData(cA.oMirrorData,0,0);cp.drawImage(aL,0,0,cA.nMirrorWidth,cA.nMirrorHeight,cA.x,cy,cB,cx)}}}if(bx){cp.globalCompositeOperation="source-atop";cp.fillStyle=am;cp.fillRect(0,0,aJ.width,aJ.height)}e()};var L=function(){if(!bV){return}cp.globalCompositeOperation="source-over";cp.globalAlpha=1;cp.clearRect(0,0,aJ.width,aJ.height);cp.strokeStyle=at.imageBorderColor;cp.lineWidth=0;for(var cz=Z.length-1;cz>-1;cz--){var cA=Z[cz];if(cA.bReady){cp.drawImage(cA.img,cA.x,cA.y,cA.drawWidth,cA.drawHeight);if(i){cp.strokeRect(cA.x+0.5,cA.y+0.5,cA.drawWidth-1,cA.drawHeight-1)}}else{if(cA.bDrawPlaceHolder){cp.fillStyle=at.placeHolderColor;cp.fillRect(cA.x,cA.y,cA.drawWidth,cA.drawHeight);if(i){cp.strokeRect(cA.x+0.5,cA.y+0.5,cA.drawWidth-1,cA.drawHeight-1)}}}}if(bx){cp.globalCompositeOperation="source-atop";cp.fillStyle=am;cp.fillRect(0,0,aJ.width,aJ.height)}cp.globalCompositeOperation="destination-over";for(var cz=0;cz<Z.length;cz++){var cA=Z[cz];if(cA.oMirrorData){var cy=cA.y+cA.drawHeight;var cB=Math.abs(cA.z)*cA.nMirrorWidthOut;var cx=Math.abs(cA.z)*cA.nMirrorHeightOut;if(cA.bCorsFix){cp.drawImage(cA.mirrorCanvas,0,0,cA.nMirrorWidth,cA.nMirrorHeight,cA.x,cy,cB,cx)}else{b5.clearRect(0,0,cA.nMirrorWidth,cA.nMirrorHeight);b5.putImageData(cA.oMirrorData,0,0);cp.drawImage(aL,0,0,cA.nMirrorWidth,cA.nMirrorHeight,cA.x,cy,cB,cx)}}}e()};var bT=function(cx){if(a7||b9.alphaTarget==cx){return}b9.alphaTarget=cx;aw()};var ai=function(){var cx=ae(R);b9.x=Math.min(b9.range,-cx/b6*b9.range)};var e=function(){if(a7){return}ai();cp.globalCompositeOperation="source-over";if(b9.alpha!=b9.alphaTarget){if(Math.abs(b9.alpha-b9.alphaTarget)>0.01){b9.alpha+=(b9.alphaTarget-b9.alpha)/10;aw()}else{b9.alpha=b9.alphaTarget}}cp.globalAlpha=b9.alpha;cp.fillStyle=at.scrollColor;var cB=b9.y;var cz=cB+b9.height-1;var cA=cz-cB-1;cp.fillRect(b9.padding,cB,b9.width,1);cp.fillRect(b9.padding,cz,b9.width,1);cB++;cp.fillRect(b9.padding,cB,1,cA);cp.fillRect(b9.width-1,cB,1,cA);var cx=Math.max(1,Math.round(b9.x));var cy=Math.min(b9.buttonWidth,b9.width-1-cx);cp.fillRect(b9.padding+cx,b9.y+1,cy,b9.height-2)};var H=function(cB){if(!bf||!bV){return}var cz=c;cz=Math.min(cz,Math.min(cB.img.width/20,cB.img.height/20));var cx=Math.min(Y.width,cB.img.width/cz);var cy=Math.min(Y.height,cB.img.height/cz);var cD=Math.min(ah/cz,Math.floor(cy*at.mirrorHeight));var cC=cy-cD;aM.save();aM.globalCompositeOperation="source-over";if(!cw){aM.clearRect(0,0,cx,cD);aM.scale(1,-1);aM.drawImage(cB.img,0,cC*cz,cx*cz,cD*cz,0,-cD,cx,cD);aM.restore();aM.save();if(i){aM.strokeRect(0,0,cx,cy)}aM.scale(1,cD/ah);aM.fillRect(0,0,cx+1,ah+1)}else{aM.clearRect(0,0,cx,cD);aM.scale(1,cD/ah);aM.fillRect(0,0,cx+1,ah+1);aM.restore();aM.save();aM.globalCompositeOperation="source-in";aM.scale(1,-1);if(i){bZ.clearRect(0,0,cx,cD);bZ.drawImage(cB.img,0,cC*cz,cx*cz,cD*cz,0,0,cx,cD);bZ.strokeRect(0,0,cx,cB.height);aM.drawImage(bo,0,0,cx,cD,0,-cD,cx,cD)}else{aM.drawImage(cB.img,0,cC*cz,cx*cz,cD*cz,0,-cD,cx,cD)}}aM.restore();try{cB.oMirrorData=aM.getImageData(0,0,cx,cD)}catch(cA){cB.mirrorCanvas=Y.cloneNode();cB.oMirrorData=cB.mirrorCanvas.getContext("2d");cB.oMirrorData.drawImage(Y,0,0);cB.bCorsFix=true}cB.nMirrorWidth=cx;cB.nMirrorHeight=cD;cB.nMirrorWidthOut=cx*cz;cB.nMirrorHeightOut=cD*cz};var ad=function(){if(ba!=b){return}ba=requestAnimationFrame(ab)};var ab=function(){R=ae(R+au);aw();ba=requestAnimationFrame(ab)};var aA=function(){if(ba==b){return}cancelAnimationFrame(ba);ba=b};var bn=function(){var cx=a.getElementDimension(y);if(cx.width<1){cx.width=1}if(cx.height<1){cx.height=1}return cx};var bm=function(){aJ=aU=bn()};var cc=function(cx){if(!a9||cv.length<1){return}if(l==b){l={};l.offsetLeft=R;l.xAdvance=b7;l.nCenter=bg}if(cx.FSI_after_treshold!=b){aA();cancelAnimationFrame(bi);M=false;ax.enable(true);n();b0();g=[];bm();if(aJ.width>1&&aJ.height>1){if(D){D.style.display="block"}var cy=aJ.height/A.height;aW=Math.round(bF.width*cy);bp=Math.round(bF.spacing*cy);bM()}else{}return}if(!M){M=true;ax.cancel();ax.enable(false);if(D){cp.clearRect(0,0,aJ.width,aJ.height)}}};this.destroyOnDetach=function(){if(at&&at.autoDestroy!=false){O()}};var O=this.destroy=function(){if(!bV){return}bV=false;bl.removeAttribute("x-fsi-id");n();b0();for(var cx in aV){bb(aV[cx])}aV={};if(bh!=b){a.removeCustomEvent(bl,"FSIElementDimension",cc);bh=b}B=b;aN=false;g=[];aA();aT=b;K(b,true);aH=0;cancelAnimationFrame(aZ);cancelAnimationFrame(q);q=b;cancelAnimationFrame(bi);bi=b;cancelAnimationFrame(F);F=b;Z=[];V={};ac=0;if(ax){ax.destroy();ax=b}R=b1=0;a8=b;bW=[];if(D){a.removeChild(y,D);D=b}cp=b;aL=b5=aM=Y=bZ=bo=b;ca={};b3=aP=S=aY=a0=b;af={};f=0;a.removeChild(y.parentNode,y)}};(function(){var d="fsi-imageflow";var e="display:block;width:300px;height:100px;";var g=a.customTags[d];if(g){return}var c=function(i){var h=a.attributes2parameters(i);if(h.src!=b&&h.dir==b){h.dir=h.src}return h};var f={};f.registerElement=function(){a.addViewerClassCSSRule(d,e);var h=Object.create(HTMLDivElement.prototype);h.createdCallback=function(){a.customTagDimFromAttributes(this);a.ImageFlow.prototype.constructor.call(this)};h.attachedCallback=function(){if(this.getInitDone()){return}this.init(this,c(this))};h.detachedCallback=function(){this.destroyOnDetach()};document.registerElement(d,{prototype:h})};f.replaceTagInit=function(h){a.addViewerClassCSSRule(d,e)};f.replaceTag=function(h){if(!h||(typeof(h.getInitDone)=="function"&&h.getInitDone())){return}a.customTagDimFromAttributes(h);a.ImageFlow.prototype.constructor.call(h);h.init(h,c(h))};g=a.registerCustomTag(d,f)}())}(window.$FSI=window.$FSI||{}));