/*!
 * FSI TouchZoom
 * Copyright (c) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 *
 * VERSION: 1.1.3
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,version,build){var self=this;this.instance=instance;this.strClassName=strClassName;this.version=version;this.build=build;var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var classDef=new $FSI.ClassDef($FSI,"FSI Core","2016","16.08.4");$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t=="boolean"){ret=value}else{if(t=="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady){if(typeof($FSI.iLoaderCSSSkin)!="object"){if(typeof($FSI.LoaderCSSSkin)!="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create <style> node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		@if (@_jscript_version < 9)
			el.style.setAttribute('cssText', strStyle);
		@else @*/
el.setAttribute("style",strStyle);
/*@end
		@*/
};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!=0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWith=window.innerWidth;$FSI.bElementPosRespectsScroll=true;var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}var uagent=$FSI.userAgent=navigator.userAgent.toLowerCase();var result;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!=-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("safari")>-1&&uagent.search("chrome")<1){$FSI.isSafari=true}else{if(uagent.search("firefox")>-1){$FSI.isFirefox=true}else{if(uagent.search("opera")>-1){$FSI.isOpera=true}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)=="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.getCachedScrollBarWidth=function(el,oReg,w){var cst;var cssOverflowY="";try{cst=top.window.getComputedStyle(el);cssOverflowY=cst["overflow-y"]}catch(e){return 0}if(cssOverflowY=="scroll"||el.scrollHeight>top.window.innerHeight){var orgStyle=el.style.overflowY;var styleID=orgStyle;styleID="S_"+styleID;if(1==1||oReg[styleID]==undefined){el.style.overflowY="hidden";var w2=$FSI.___elementScaleCheck.offsetWidth;if(w2-w>1){oReg[styleID]=w2-w}}}if(!isNaN(oReg[styleID])){ret=oReg[styleID]}else{ret=-1}return ret};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(step){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if(typeof(document.visualViewport)!="undefined"){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return document.visualViewport.pageScale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180==0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=window.outerWidth;return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.document.visualViewport.clientWidth,height:wnd.document.visualViewport.clientHeight}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.push)=="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)=="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])=="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag;if(typeof(document.querySelector)=="function"){var strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector)}else{var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"s*$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var scripts=document.getElementsByTagName("script");var t="/"+strScriptName;var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!="object"){if(typeof($FSI.LoaderJavascript)!="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)=="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!="string"){return false}var t=typeof(parameters);if(t!="object"&&t!="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)=="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!="string"||strClass.length<1){return}if(typeof(strRule)!="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var node=element;var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=scale.x}else{scale.y=targetDimension.height/(sourceDimension.height*range.height);scale.x=scale.y}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)=="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(document.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)=="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)=="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return(h<0)?-h:h};this.height=function(){var h=e.bottom-e.top;return(h<0)?-h:h};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(m){e.normalizeRect();m.normalizeRect();var l=Math.min(e.left,m.left);var h=Math.min(e.top,m.top);var j=Math.max(e.right,m.right);var k=Math.max(e.bottom,m.bottom);var i=new a.Rect(l,h,j,k);return i};this.equalRect=function(h){if(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom){return true}else{return false}};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ObjectCollection!=b){return}a.ObjectCollection=function(){var d=this;var f;var h;var c=0;var g;var e;this.reset=function(){c=0;d.empty()};this.empty=function(){f=[];h={};g=0;e=false};this.getCount=function(){return g};this.add=function(j){if(!j){return}c++;h[c]=j;j.__id=c;j.__arrayPos=f.length;f.push(j);g++;return c};this.deleteObject=function(j){if(!j||!j.__id){return}return d.deleteObjectById(j.__id)};this.deleteObjectById=function(j){if(!h[j]){console.error("ObjectCollection deleteObjectById "+j+" failed.");return}g--;delete h[j];e=true;return true};this.replace=function(j,k){if(!j||!k){return}return d.replaceById(j.__id,k)};this.replaceById=function(m,l){if(h[m]==b||l==b){return}var k=h[m];var j=h[m].__arrayPos;delete h[m];c++;l.__id=c;l.__arrayPos=j;f[j]=l;h[c]=l;return true};var i=function(){if(!e){return}f=new Array(g);var l=0;for(var k in h){var j=h[k];j.__arrayPos=l;f[l]=j;l++}e=false};this.getById=function(j){return h[j]};this.getArray=function(){if(e){i()}return f};this.getObjects=function(){return h};d.empty()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageTagCollection!=b){return}a.ImageTagCollection=function(c,m){a.ObjectCollection.prototype.constructor.apply(this,arguments);var o=this;var n=false;var i=false;var l=false;var p;var d,f;this.init=function(){if(typeof(c.NameID)=="string"){p=c.NameID}else{p="$FSI_ImageTagID"}if(typeof(m.fnFilterImageSource)=="function"){i=m.fnFilterImageSource}if(typeof(m.addCSSClass)=="string"){l=m.addCSSClass}if(typeof(m.enableByCSSClass)=="string"&&m.enableByCSSClass.length>0){f={};var r=m.enableByCSSClass.split(",");for(var q=0;q<r.length;q++){f[r[q]]=true}}if(typeof(m.disableByCSSClass)=="string"&&m.disableByCSSClass.length>0){d={};var r=m.disableByCSSClass.split(",");for(var q=0;q<r.length;q++){d[r[q]]=true}}n=(d!=b||f!=b)};var k=this.isValidFSIImageServerImageSource=function(q){if(typeof(q)!="string"){return false}if(q.length<1||q.search(/[?,&]type=image|directoryimage/i)==-1||q.search(/[?,&]source=/i)==-1){return false}return true};var h=this.createObjectForImageTag=function(r,u){var q=false;var s=r.src;if(u==b){s=u=r.src;if(i!=false){q=true;u=i(u,r)}}if(!k(u)){return}if(!e(r)){return}if(l){a.addClass(r,l)}var t={};t.img=r;t.src=u;t.orgSrc=s;if(q){t.bIgnoreSourceChange=true}return t};this.addBaseMethod=this.add;this.add=function(q,s){if(q[p]!=b){return}var r=h(q,s);if(r){this.addBaseMethod(r);q[p]=r.__id}return r};this.replaceBaseMethod=this.replace;this.replace=function(q,r){if(o.replaceBaseMethod(q,r)){r.img[p]=r.__id}};var j=this.releaseImage=function(r){if(!r||!r.img){return false}var q=r.img;if(!q[p]==b||q[p]!=r.__id){return}if(l){a.removeClass(q,l)}return true};var g=this.remove=function(q){if(!this.deleteObject(q)){return false}j(q);return true};var e=this.isImageEnabledByCSSClass=function(q){if(!n){return true}var r=false;var t=q.className;if(typeof(t)!="string"){t=[]}else{t=t.split(" ")}if(d){r=true;for(var s=0;s<t.length;s++){if(d[t[s]]){r=false;break}}}if(f){for(var s=0;s<t.length;s++){if(f[t[s]]){r=true;break}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.dir=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c="FSI";this.on=true;this.doNothing=function(){};this.log=this.doNothing;this.error=this.doNothing;this.dir=this.doNothing;try{if(console&&console.log){this.log=function(e){console.log(c+e)}}if(console&&console.error){this.error=function(e){console.error(c+e)}}if(console&&console.dir){this.dir=function(e){console.dir(e)}}}catch(d){}this.setPrefix=function(e){c=e+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(k){var m=this;var d=[];var g={};var h={};var i=0;m._strClassName="$FSI.CustomEventListener";var l=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};var j=this.destroy=function(){for(var n=0;n<d.length;n++){var o=d[n];f(o.element,o.fn)}d=[];g={};h={};m.onDestroy()};this.fireEvent=function(n,o){if(!n||!n.enabled){return false}if(typeof(o)!="object"){o={}}if(n.paused){o.FSI_paused=true}o.FSI_custom_event=true;o.FSI_type=k;o.FSI_target=n.element;n.fn.call(n.element,o);return true};this.fireEvents=function(o){if(typeof(o)!="object"){o={}}o.FSI_custom_event=true;o.FSI_type=k;for(var p=0;p<d.length;p++){var n=d[p];if(n.enabled){if(n.paused){o.FSI_paused=true}else{if(o.FSI_paused){delete o.FSI_paused}}o.FSI_target=n.element;n.fn.call(n.element,o)}}};var c=this.addListener=function(r,q){if(typeof(r)!="object"||typeof(q)!="function"){a.console.error(m._strClassName+": Invalid parameters for addListener");return}if(r.__FSI==b){r.__FSI={}}if(r.__FSI.eventElementID==b){r.__FSI.eventElementListenerCount=1;r.__FSI.eventElementID=a.eventElementID++}else{r.__FSI.eventElementListenerCount++}if(q.__FSIEventFunctionID==b){q.__FSIEventFunctionListenerCount=1;q.__FSIEventFunctionID=a.eventFunctionID++}else{q.__FSIEventFunctionListenerCount++}var o=r.__FSI.eventElementID;var p=q.__FSIEventFunctionID;if(g[o]==b){var n=g[o]={};n.nFunction=0;n.oFunctions={}}if(g[o].oFunctions[p]==b){g[o].nFunction++;g[o].oFunctions[p]=[]}else{a.console.warn(m._strClassName+": There is already a listener for this exact element and function");a.console.log(r);a.console.log(q)}var s={};s.element=r;s.elementID=o;s.fn=q;s.fnID=p;s.instanceListener=m;s.enabled=true;s.paused=false;s.uniqueID=i++;g[o].oFunctions[p].push(s);d.push(s);h[s.uniqueID]=s;m._onListenerAdd(s);m._onListenerCountChange(d.length);return s};this.setListenerProps=function(q,o,p){var n=h[q];if(!n){return false}if(n.props==b){n.props={}}n.props[o]=p;return true};this.enableListener=function(p,o){var n=h[p];if(n==b||n.enabled==o){return}n.enabled=o};this.pauseListener=function(p,o){var n=h[p];if(n==b||n.paused==o){return}n.paused=o};var f=this.removeListener=function(r,q){if(typeof(r)!="object"||typeof(q)!="function"){a.console.error(m._strClassName+": Invalid parameters for removeListener");return}if(r.__FSI==b||r.__FSI.eventElementID==b||q.__FSIEventFunctionID==b){if(q.__FSIEventFunctionID==b){a.console.error(m._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(m._strClassName+": Element not registered for listener in removeListener")}return}var n=r.__FSI.eventElementID;var p=q.__FSIEventFunctionID;if(!g[n]){a.console.error(m._strClassName+": No registered listener for this element in removeListener");return}var o=g[n].oFunctions[p];if(o==b||typeof(o.pop)!="function"){a.console.error(m._strClassName+": No registered listener for this function in removeListener");return}var s=o.pop();s.fn.__FSIEventFunctionListenerCount--;s.element.__FSI.eventElementListenerCount--;if(s.element.__FSI.eventElementListenerCount==0){delete s.element.__FSI.eventElementListenerCount;delete s.element.__FSI.eventElementID}if(s.fn.__FSIEventFunctionListenerCount==0){delete s.fn.__FSIEventFunctionListenerCount;delete s.fn.__FSIEventFunctionID}if(o.length==0){delete g[n].oFunctions[p];g[n].nFunction--;if(g[n].nFunction==0){delete g[n]}}delete h[s.uniqueID];e();m._onListenerRemove(s);m._onListenerCountChange(d.length);return s};this.getEventListenerByID=function(n){return h[n]};this.getListenerObjectByID=function(n){return h[n]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var o in g){var q=g[o].oFunctions;for(var p in q){var n=q[p];d=d.concat(n)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(n){};this._onListenerAdd=function(o,n){};this._onListenerRemove=function(o,n){};this.triggerEvent=function(n){};this.triggerEvents=function(){};this.setListenerProps=function(p,n,o){};this.onDestroy=function(){};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerDocumentZoom!=b){return}a.CustomEventListenerDocumentZoom=a.oCustomEventListenerClasses.FSIDocumentZoomChange=function(){var p=this;var c=false;var g;var h;var o=0;var l=0;var f=false;var e;var n;a.CustomEventListener.prototype.constructor.call(p,"FSIDocumentZoomChange");p._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(document,"visualviewportchanged",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(document,"visualviewportchanged",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(q){var r=(q>0);if(r!=c){if(r){j()}else{i()}}};var m=function(){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=r;k(r);q=true}else{q=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return q};this.triggerEvent=function(s){var q=p.getEventListenerByID(s);if(!q){return}var r={};r.FSI_scale=a.getDocumentScale();r.FSI_scale_with_pixel_ratio=a.getDocumentScaleWithPixelRatio();p.fireEvent(q,r)};this.triggerEvents=function(){k(a.getDocumentScaleWithPixelRatio())};var k=function(r){var q={};q.FSI_scale=a.getDocumentScale();q.FSI_scale_with_pixel_ratio=r;p.fireEvents(q)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerViewport!=b){return}a.CustomEventListenerViewport=a.oCustomEventListenerClasses.FSIViewport=function(){var m=this;var d=false;var i=new a.Rect(0,0,0,0);var j=new a.Rect(0,0,0,0);var n=new a.Rect(0,0,0,0);var I=new a.Rect(0,0,0,0);var v={left:0,top:0};var T;var C;var D="";var g=false;var q=b;var z;var k=1;var p=1;var s=10;var G;var u=0;var w;var F;var S=0;var c=100;var p=1;var A=1;var O=32;var y;var r;var H=a.BrowserSupports.visualViewportAPI();try{r=window.frameElement}catch(Q){}a.CustomEventListener.prototype.constructor.call(m,"FSIViewport");m._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){o()};var N=function(){if(d){return}d=true;h(a.addEvent);G=a.addCustomEvent(m,"FSIDocumentZoomChange",J);p=a.getDocumentScale();A=p*a.getDevicePixelRatio()};var o=function(){if(!d){return}d=false;h(a.removeEvent);a.removeCustomEvent(m,"FSIDocumentZoomChange",J);G=b;if(q){clearInterval(q);q=b}t();u=0;if(y!=b){clearTimeout(y);y=b}};var h=function(U){var e=window;U(e.document,"scroll",l,false);U(e,"resize",l,false);if(H){U(e.document,"visualviewportchanged",l,false)}else{if(a.isTouch&&!a.isIETouch&&r){U(e,"touchmove",R,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",l,false);if(H){U(e.document,"visualviewportchanged",l,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",R,false)}}U(e,"resize",l,false)}}U(window,"orientationchange",l,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=m.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!=b){u--;e.tresholdEnd=b}if(V&&V>0){u++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=b){u--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!=d){if(U){N()}else{o()}}};var J=function(e){p=e.FSI_scale;A=e.FSI_scale_with_pixel_ratio;l()};var l=function(){if(y!=b){return}y=setTimeout(L,O);L()};var L=function(){if(y!=b){clearTimeout(y);y=b}var e=false;var U=M();if(D!=U){D=U;e=true;f()}return e};var K=function(){p=a.getDocumentScale();A=p*a.getDevicePixelRatio();M()};this.triggerEvent=function(V){var e=m.getEventListenerByID(V);if(!e){return}K();var U=P();m.fireEvent(e,U)};this.triggerEvents=function(){K();f()};var f=this.fireEvents=function(){var U=P();var V=m.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){m.fireEvent(e,U)}}B()};var P=function(){var e={};e.FSI_scale=a.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=j;e.FSI_scroll=v;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=C;return e};var M=function(){C=a.getViewportSize(a.topWindow);T=a.getBoundingClientRect(a.topWindow.document.documentElement);i.left=a.topWindow.pageXOffset;i.top=a.topWindow.pageYOffset;i.right=i.left+C.width;i.bottom=i.top+C.height;if(r){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);j.left=0;j.top=0;j.right=j.left+e.width;j.bottom=j.top+e.height;v.left=-window.pageXOffset;v.top=-window.pageYOffset;n.copyRect(j);n.left=-U.x+i.left+T.left;n.top=-U.y+i.top+T.top;n.right=n.left+C.width;n.bottom=n.top+C.height;j.interSectRectValidate(n);var V=a.getBoundingClientRect(window.document.body);I.copyRect(j);I.offsetRect(U.x+V.top,U.y+V.left)}else{v.left=T.left;v.top=T.top;I.copyRect(i);j.copyRect(i);j.offsetRect(T.left,T.top)}return p+"_"+I.toString()+" "+C.width+" x "+C.height};var R=function(){z=s;if(q!=b){return}q=setInterval(x,100)};var x=function(){if(!L()){z--}else{z=s}if(z<1){clearInterval(q);q=b}};var t=function(){if(F!=b){clearInterval(F);F=b;w=b}};var B=function(){t();if(u>0){F=setInterval(E,c)}};var E=function(){S+=c;if(w==b){S=c;w=[];var V=m.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(e.tresholdEnd>0){w.push(e)}}}var U;for(var W=w.length-1;W>-1;W--){var e=w[W];if(e.tresholdEnd<=S){if(m.getEventListenerByID(e.uniqueID)!=b){if(U==b){U=P();U.FSI_after_treshold=true}m.fireEvent(e,U)}w.splice(W,1)}}if(w.length==0){t()}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchZoom!=b){return}a.TouchZoom=function(t){var E=new a.ClassDef(this,"FSI TouchZoom","2016","16.08.4");var aj=E.instance;a.guessFSIViewerLocation("fsitouchzoom.js",3);var Y=a.getViewerInstanceID();var B=(t)?a.cloneParameters(t):{};var Z=(!a.BrowserSupports.documentZoom()&&!a.makeBool(B.enableDesktopBrowsers,true));var I=a.makeBool(B.useImageTiles,true);var H=a.makeBool(B.fadeImageTiles,true);var ac;var al;var T;var c;var az={};var O={};var am=false;var u;var N=1;var ai=1;var U={};var ae=false;var ax=4;var k;var aC=4000000;var aq=900;var ap=900;var s;var au=0;var p;var w=0;var g=0;var V;var r;var ah=false;var l;var aa=/((\?)|&)(width|height)=[^&]*/ig;var ab=/((\?)|&)(rect|pixelRange|referenceWidth|referenceHeight)=[^&]*/ig;var C=/[?&]effects=[^&]*pad|flip|distort\(/i;var q=/[?&]referencewidth=([^&]*)/i;var W=/[?&]referenceheight=([^&]*)/i;var K;var S=a.makeBool(B.debug,false);var an=false;var i="position:absolute!important;display:block;border:0px none!important;margin:0px!important;padding:0px!important;-webkit-transform:none!important;-ms-transform:none!important;transform:none!important;max-width:none!important;max-height:none!important";if(S){u=new a.Debugger();u.setPrefix(E.strClassName)}else{u=new a.EmptyDebugger()}u.log(aj.getVersion());this.init=function(aE){if(typeof(a._FSITouchZoomInstance)=="object"){a.console.error("An initialized FSI TouchZoom instance already exists, aborting init(). Scanning for new images and returning the existing instance.");a._FSITouchZoomInstance.scanForNewImages();return a._FSITouchZoomInstance}if(an){aj.destroy()}if(aj.bAutoInitialized){u.log("Init (auto initialized)")}else{u.log("Init")}if(Z){return}an=true;ah=false;V=true;ae=a.mobileOS=="ios";if(!c){var aI={NameID:"$FSITouchZoom_TagID"};c=new a.ImageTagCollection(aI,B);c.init()}a._FSITouchZoomInstance=aj;if(I){if(navigator.userAgent.match(/Windows Phone/gi)&&navigator.userAgent.match(/Trident/gi)){I=false}}am=a.makeBool(B.useDevicePixelRatio,true);if(B.headers==b){B.headers="cors"}if(B.headers.length>0){k="&headers="+B.headers}else{k=""}if(B.zoomPrecision!=b){var aJ=parseInt(B.zoomPrecision);if(isNaN(aJ)||(aJ<1&&aJ!=0)){}else{ax=aJ}}K=false;if(a.makeBool(B.debugTiles,false)){K=true;aq=300;ap=300}var aD=document.getElementsByTagName("img");if(S){u.log("Parameters: ");u.log("zoomPrecision: "+ax);u.log("useTiledImages: "+I);u.log("useDevicePixelRatio: "+a.makeBool(B.useDevicePixelRatio,true)+" (ratio: "+a.getDevicePixelRatio()+")");u.log("enableByCSSClass: "+B.enableByCSSClass);u.log("disableByCSSClass: "+B.disableByCSSClass);var aG=a.makeBool(B.loadingImage);if(B.loadingImage==b||aG===true){aG="images/loading.gif"}else{aG=B.loadingImage}u.log("loadingImage: "+aG);u.log("Preparing images (total images: "+aD.length+")")}var aH=aD.length;for(var aF=0;aF<aH;aF++){ar(aD[aF])}aA();u.log(c.getCount()+" images have been prepared for FSI TouchZoom.")};this.destroy=function(){if(!an){return}an=false;r=false;V=false;a._FSITouchZoomInstance=b;a.removeCustomEvent(aj,"FSIViewport",h);clearTimeout(s);var aD=c.getArray();var aF=c.getCount();for(var aE=0;aE<aF;aE++){at(aD[aE])}c.empty();r=b;T=b;u.log("instance destroyed.")};var aA=function(){if(r){return false}if(c.getCount()>0){var aH=E.strClassName;if(!a.cssClassExists(aH)){var aE="fsi_touch_zoom img{"+i+"}\n";aE+="fsi_touch_zoom_tiles.root{ position:relative;left:0px;top:0px}\n";aE+="img.fsi_touch_zoom_background_image{position:absolute!important;left:0px;top:0px;}\n";aE+="fsi_touch_zoom_tiles{ position:absolute;display:block;overflow:hidden;white-space:nowrap;border:0px none;margin:0px;padding:0px;zoom:1;-webkit-transform:none;-ms-transform:none;transform:none}\n";aE+="@keyframes fsifadetilesin{from {opacity:0} to {opacity:1}}\n";aE+="@-webkit-keyframes fsifadetilesin{from {opacity:0} to {opacity:1}}\n";aE+="img.__FSITouchZoomLoading{opacity:0}\n";aE+="img.__FSITouchZoomLoadingFadeIn{animation-name: fsifadetilesin; animation-duration: 1.0s;animation-delay:0.5s; animation-iteration-count: 1;animation-fill-mode: forwards;animation-timing-function:ease-out;-webkit-animation-name: fsifadetilesin; -webkit-animation-duration: 1.0s;-webkit-animation-delay:0.5s; -webkit-animation-iteration-count: 1;-webkit-animation-fill-mode: forwards;-webkit-animation-timing-function:ease-out}\n";aE+="fsi_touch_zoom img.fadein{animation-name:fsifadetilesin; animation-duration: 0.3s;animation-iteration-count: 1;animation-timing-function:ease-out;-webkit-animation-name:fsifadetilesin; -webkit-animation-duration: 0.3s;-webkit-animation-iteration-count: 1;-webkit-animation-timing-function:ease-out}\n";a.addCSSClass(aH,aE)}if(B.loadingImage==b){B.loadingImage=a.makeBool(B.loadingImage,false)}if(B.loadingImage){var aF;if(typeof(B.loadingImage)=="string"&&B.loadingImage.length>0){aF=B.loadingImage}else{var aD="images/";if(a._FSIViewerLocation!=b){aD=a._FSIViewerLocation+"/applications/touchzoom/images/"}aF=aD+"loading.gif"}var aG=p=document.createElement("img");aG.style.position="absolute";aG.style.zIndex="90000";aG.style.left="0px";aG.style.top="0px";aG.className="__FSITouchZoomLoading";aG.src=aF}x();return true}else{return false}};var x=function(){if(r){return}ac=a.addCustomEvent(aj,"FSIViewport",h);a.setCustomEventListenerProperty(ac,"treshold",150);a.setCustomEventListenerProperty(ac,"fireTresholdEventOnly",true);a.triggerCustomEvent(ac);r=true};var y=function(aD,aF,aE){if(!aE){aE=new Object()}aE.img=aD;aE.bLoading=false;aE.orgSrc=aE.srcCurrent=aF;aE.elPosition=aE.img;a.addEvent(aD,"load",X,false);a.addEvent(aD,"error",o,false);return aE};var z=function(aE){if(!aE){return}delete O[aE.FSITouchZoom_ID];if(aE.bLoading){Q(aE,false)}var aD=aE.img;if(!aD){return}a.removeEvent(aD,"load",X,false);a.removeEvent(aD,"error",o,false);aD.$FSITouchZoom_ID=b;delete aD.$FSITouchZoom_ID;aD.$FSITouchZoom_TagID=b;delete aD.$FSITouchZoom_TagID};var at=function(aE){if(!c.releaseImage(aE)){return}if(aE.bZoomed){J(aE)}z(aE);var aD=aE.img;if(aE.bWaitingForRestore){if(!aD.oAfterRelease){aD.oAfterRelease={};aD.oAfterRelease.img=aD;aD.oAfterRelease.FSITouchZoom_ID=aE.FSITouchZoom_ID;aD.oAfterRelease.orgAttrWidth=aE.orgAttrWidth;aD.oAfterRelease.orgAttrHeight=aE.orgAttrHeight;a.addEvent(aD,"load",P,false);a.addEvent(aD,"error",P,false)}}else{L(aE)}};var P=function(aD){var aE=aD.srcElement;if(!aE){aE=aD.target}a.removeEvent(aE,"load",P,false);a.removeEvent(aE,"error",P,false);if(aE.oAfterRelease){var aF=aE.oAfterRelease;delete aE.oAfterRelease;L(aF)}};var L=function(aE){var aD=aE.img;if(!aD||aD.oAfterRelease){return}if(aE.orgAttrWidth){aD.setAttribute("width",aE.orgAttrWidth,0)}else{aD.removeAttribute("width")}if(aE.orgAttrHeight){aD.setAttribute("height",aE.orgAttrHeight,0)}else{aD.removeAttribute("height")}};this.removeImages=function(aD,aF){if(!an){return}if(aD==b){if(!aF){u.error("removeImages: invalid argument (img dom element or array of img dom elements required)")}return}if(typeof(aD.join)!="function"){aD=[aD]}var aJ=0;var aH=aD.length;for(var aG=0;aG<aH;aG++){var aE=aD[aG];if(aE&&aE.$FSITouchZoom_TagID){var aI=c.getById(aE.$FSITouchZoom_TagID);if(aI){c.deleteObjectById(aE.$FSITouchZoom_TagID);at(aI);aJ++}}}if(aJ>0){aw()}if(!aF){u.log("removeImages: "+aJ+" images have been removed, total images for TouchZoom now: "+c.getCount()+" images.")}return aJ};this.addImage=function(aD,aF){if(!an){return}if(!aD||!aD.src){u.log("Image NOT added. Invalid img argument.");return}var aE=v(aD);if(aE){u.log("Image NOT added. Image already added to FSI TouchZoom.");return}aE=ar(aD,aF);if(aE){u.log("Image added. Total images for TouchZoom now: "+c.getCount()+" images.");ak()}else{u.error("The requested image has not been added. Total images for TouchZoom now: "+c.getCount()+" images.")}return(aE!=b)};var ak=function(){aA();aw()};var ar=function(aD,aF){var aE=c.add(aD,aF);if(aE){y(aD,aE.src,aE);A(aE,aE.__id)}return aE};var A=function(aE,aD){O[aD]=aE;aE.FSITouchZoom_ID=aD;aE.img.$FSITouchZoom_ID=aD};var v=function(aD){if(!aD||!aD.$FSITouchZoom_ID){return}return O[aD.$FSITouchZoom_ID]};var m=function(aE){if(!aE||!aE.img){return}var aD=aE.img;aE.src=ay(aE.orgSrc);aE.tileSrc=D(aE.src);if(!aD.oAfterRelease){if(aD.width!=b&&aD.width>0){aE.width=aD.width}if(aD.height!=b&&aD.height>0){aE.height=aD.height}}if(aE.width>0&&aE.height>0){F(aE)}else{aE.bFinishOnLoad=true}aE.bPrepared=true;return aE};var F=function(aE){if(aE.width<1||aE.height<1){return}aE.orgAttrWidth=aE.img.getAttribute("width");aE.orgAttrHeight=aE.img.getAttribute("height");aE.ready=true;aE.wOrg=aE.width;aE.hOrg=aE.height;if(aE.wLast==b){aE.wLast=aE.width}if(!aE.img.getAttribute("width")){aE.img.setAttribute("width",aE.width,0)}if(!aE.img.getAttribute("height")){aE.img.setAttribute("height",aE.height,0)}if(I){var aD=aE.src.search(C);if(aD!=-1){aE.bDoNotTile=true}else{if(aE.orgSrc.search(/[?,&]renderer=animate/i)!==-1){aE.bDoNotTile=true}}}else{aE.bDoNotTile=true}};var ay=function(aD){return aD.replace(aa,"$2")};var D=function(aD){return aD.replace(ab,"$2")};var h=function(aD){if(ah||!V){return}if(T!=aD.FSI_scale_with_pixel_ratio){T=aD.FSI_scale_with_pixel_ratio;if(am){N=aD.FSI_scale_with_pixel_ratio}else{N=aD.FSI_scale}if(ax>0){ai=Math.round(N*ax)/ax}else{ai=N}}U=aD.FSI_scroll;al=aD.FSI_viewport_rect;ao()};var aw=this.triggerRefresh=function(){if(!an){return}clearTimeout(s);s=setTimeout(n,100)};this.updateImagePositions=function(){if(!an){return}aw()};var n=function(){clearTimeout(s);a.triggerCustomEvent(ac)};var av=function(aG){if(aG.bIgnoreSourceChange){return false}if(aG.bLocked){aG.bSourceChangeOnUnlock=true}else{aG.bSourceChangeOnUnlock=b;u.log("Image src change detected for image #"+aG.__id+":");u.log("OLD: "+aG.srcCurrent);u.log("NEW: "+aG.img.src);var aD=aG;var aF=aG.__id;at(aD);var aE=c.createObjectForImageTag(aD.img);if(!aE){c.deleteObjectById(aF);u.error("New image not applicable for TouchZoom, removing existing image from TouchZoom");return}c.replace(aD,aE);A(aE,aE.__id);y(aE.img,aE.src,aE);if(aD.bInfo&&aD.bLockedSourceDimension){aE.bInfo=true;aE.sourceWidth=aD.sourceWidth;aE.sourceHeight=aD.sourceHeight;m(aE);ag(aE)}if(!aE.bLocked){aw()}}return true};var o=function(aD){var aE=aD.srcElement;if(!aE){aE=aD.target}var aF=v(aE);if(!aF){return}Q(aF,false);aF.ready=false};var X=function(aD){var aE=aD.srcElement;if(!aE){aE=aD.target}var aF=v(aE);if(!aF){return}delete aF.bWaitingForRestore;if(aF.bTile){if(H){aE.className="fadein"}aF.img.style.visibility=""}if(aF.bFinishOnLoad){delete aF.bFinishOnLoad;aF.width=aE.width;aF.height=aE.height;F(aF);R(aF)}else{Q(aF,false);if(!aF.bTile&&aF.img.src!=aF.srcCurrent){av(aF)}}};this.resetImage=function(aD){if(!an){return}var aE=v(aD);if(aE){J(aE)}};var J=function(aD){if(!aD.bZoomed){return}aD.bZoomed=false;delete az[aD.FSITouchZoom_ID];Q(aD,false);if(aD.bTiled){e(aD)}aD.wLast=aD.wOrg;if(aD.bTile){return}if(aD.srcCurrent!=aD.img.src){return}if(aD.img.src!=aD.orgSrc){aD.bWaitingForRestore=true;aD.img.src=aD.orgSrc}aD.srcCurrent=aD.orgSrc};var aB=function(aG){if(!aG||aG.bInfo!=b){return}aG.bInfo=false;var aF=aG.src.split("?");var aE=aF[0]+"?type=info&tpl=info.json"+k;if(aF.length>1){aE+="&"+aF[1]}var aD=new XMLHttpRequest();aD.onload=function(aH){G(aG,aD.responseText)};aD.open("GET",aE,true);aD.send(null)};var G=function(aG,aE){var aD;if(!O[aG.FSITouchZoom_ID]){return}try{aD=a.JSON.parse(aE);aG.sourceWidth=aD.width;aG.sourceHeight=aD.height;ag(aG)}catch(aF){}if(aG.ready){R(aG)}};var ag=function(aD){if(!aD.sourceWidth||!aD.sourceHeight){aD.ready=false;return}if(!aD.bTile){af(aD)}if(aD.rectWidth){aD.maxWidth=Math.round(aD.rectWidth*aD.sourceWidth);aD.maxHeight=Math.round(aD.rectHeight*aD.sourceHeight)}else{aD.maxWidth=aD.sourceWidth;aD.maxHeight=aD.sourceHeight}aD.bInfo=true};var af=function(aJ){if(!aJ||aJ.bCropChecked){return}aJ.rectWidth=aJ.rectHeight=1;aJ.rectLeft=aJ.rectTop=0;var aF=aJ.src.match(ab);if(aF){aF=aF[0].toLowerCase();var aE=aF.indexOf("=");var aG=aF.substr(0,aE);aG=aG.substr(1);var aH=aF.substr(aE+1).split(",");if(aH.length==4){for(var aK=0;aK<aH.length;aK++){aH[aK]=parseFloat(aH[aK])}if(aG=="pixelrange"){var aI=aJ.src.match(q);if(aI&&aI.length>1){aI=parseInt(aI[1]);if(isNaN(aI)||aI<1){aI=b}}else{aI=b}var aD=aJ.src.match(W);if(aD&&aD.length>1){aD=parseInt(aD[1]);if(isNaN(aD)||aD<1){aD=b}}else{aD=b}if(aI==b&&aD==b){aI=aJ.sourceWidth;aD=aJ.sourceHeight}else{if(aI==b){aI=Math.round(aD/aJ.sourceHeight*aJ.sourceWidth)}else{if(aD==b){aD=Math.round(aI/aJ.sourceWidth*aJ.sourceHeight)}}}aH[0]/=aI;aH[1]/=aD;aH[2]/=aI;aH[3]/=aD}aJ.rectLeft=aH[0];aJ.rectTop=aH[1];aJ.rectWidth=aH[2];aJ.rectHeight=aH[3]}}aJ.bCropChecked=true};var ao=function(){var aD=c.getArray();var aF=c.getCount();for(var aE=0;aE<aF;aE++){R(aD[aE])}};var R=function(aD){if(aD.bLocked){return"locked"}if(ai<=1){if(aD.bZoomed){J(aD)}return"viewport not zoomed"}var aG=a.getBoundingClientRect(aD.elPosition);if(!aD.img.parentNode||aG.right<al.left||aG.bottom<al.top||aG.left>al.right||aG.top>al.bottom){if(aD.bZoomed){J(aD)}return"not in viewport"}if(!aD.bPrepared){m(aD)}if(!aD.ready){return"not ready"}var aK=Math.ceil(aD.width*ai);var aH=Math.ceil(aD.height*ai);if(ae&&aD.bDoNotTile){if((aK*aH)>aC){var aI=Math.sqrt(aC/(aK*aH));aK=Math.floor(aK*aI);aH=Math.floor(aH*aI)}}if(!aD.bTile&&(aK>aD.maxWidth||aH>aD.maxHeight)){aK=aD.maxWidth;aH=aD.maxHeight}if(!aD.bInfo&&aD.wLast!=aK){aB(aD);return"no info"}if(!aD.bDoNotTile&&(aK>aq||aH>ap)&&(aD.wOrg>3&&aD.hOrg>3)){if(!aD.bTiled){ad(aD)}j(aD);var aE=aD.arImages.length;for(var aF=0;aF<aE;aF++){R(aD.arImages[aF])}if(aD.bLoading){Q(aD,false)}}else{if(aD.bTiled){e(aD)}if(!aD.bTile&&aD.img.src!=aD.srcCurrent){if(av(aD)){return}}if(aD.wLast==aK){return true}aD.wLast=aK;var aJ=false;if(aD.bTile){aJ=d(aD)}else{var aL=aD.src+"&width="+aK+"&height="+aH;if(aD.srcCurrent!=aL){aD.srcCurrent=aD.img.src=aL;aJ=true}}if(aJ){Q(aD,true)}}az[aD.FSITouchZoom_ID]=aD;aD.bZoomed=true;return true};var Q=function(aF,aD){if(aD==aF.bLoading){return}aF.bLoading=aD;if(aD){au++}else{au--}if(!p){return}if(!aD){if(aF.elLoading){a.removeChild(aF.elLoading.parentNode,aF.elLoading);aF.elLoading=b;a.removeClass(aE,"fadeIn")}}else{if(aF.elLoading==b){if(!w&&p.width>0){w=p.width;g=p.height}aF.elLoading=p.cloneNode(true);document.body.appendChild(aF.elLoading)}var aE=aF.elLoading;var aG=a.getBoundingClientRect(aF.img);aE.style.left=(aG.left-U.left)+"px";aE.style.top=(aG.top-U.top)+"px";aE.style.width=Math.round(w/N)+"px";aE.style.height=Math.round(g/N)+"px";a.addClass(aE,"__FSITouchZoomLoadingFadeIn")}};var j=function(aD){if(aD.refScale==ai){return}aD.refScale=ai;if(!aD.bTile){aD.refWidth=Math.min(aD.sourceWidth,Math.round(aD.wOrg*ai/aD.rectWidth));aD.refHeight=Math.min(aD.sourceHeight,Math.round(aD.hOrg*ai/aD.rectHeight));aD.resultingWidth=Math.min(aD.maxWidth,Math.round(aD.wOrg*ai));aD.resultingHeight=Math.min(aD.maxHeight,Math.round(aD.hOrg*ai));aD.tileWidth=Math.floor(aD.resultingWidth/aD.tilesX);aD.tileHeight=Math.floor(aD.resultingHeight/aD.tilesY);aD.containerOffsetX=Math.round(aD.rectLeft*aD.refWidth);aD.containerOffsetY=Math.round(aD.rectTop*aD.refHeight);aD.refQuery="&referenceWidth="+aD.refWidth+"&referenceHeight="+aD.refHeight}else{var aE=aD.parentImage;aD.containerOffsetX=aE.containerOffsetX+aD.tilePosX*aE.tileWidth;aD.containerOffsetY=aE.containerOffsetY+aD.tilePosY*aE.tileHeight;aD.resultingWidth=(!aD.bRestX)?aE.tileWidth:aE.tileWidth+aE.resultingWidth%aE.tileWidth;aD.resultingHeight=(!aD.bRestY)?aE.tileHeight:aE.tileHeight+aE.resultingHeight%aE.tileHeight;aD.tileWidth=Math.floor(aE.tileWidth/aD.tilesX);aD.tileHeight=Math.floor(aE.tileHeight/aD.tilesY)}};var d=function(aE){var aG=aE.parentImage;if(aE.parentRefScale==aG.refScale){return}aE.parentRefScale=aG.refScale;var aI=aG.containerOffsetX+aE.tilePosX*aG.tileWidth;var aH=aG.containerOffsetY+aE.tilePosY*aG.tileHeight;var aJ=(!aE.bRestX)?aG.tileWidth:aG.tileWidth+aG.resultingWidth%aG.tileWidth;var aF=(!aE.bRestY)?aG.tileHeight:aG.tileHeight+aG.resultingHeight%aG.tileHeight;var aK="&pixelRange="+aI+","+aH+","+aJ+","+aF;var aL=aE.rootImage.tileSrc+aK+aE.rootImage.refQuery;if(aL==aE.srcCurrent){return false}else{if(K){var aD=Math.round(360*Math.random());aL+="&effects=Colorize("+aD+",100,0)"}aE.srcCurrent=aE.img.src=aL}return true};var ad=function(aY){var aR=document.createElement("fsi_touch_zoom_tiles");var aX=false;var a1;aY.refScale=b;if(!aY.bTile){var aE=document.createElement("fsi_touch_zoom");aR.className="root";aY.outerContainer=aE;a1=aY;if(typeof(getComputedStyle)=="function"){var aP=getComputedStyle(aY.img);if(typeof(aP.msUserSelect)!="undefined"&&aP.cssText.length<1){aX=true;for(var aG in aP){var a7=aP[aG];if(typeof(a7)=="string"&&a7.length>0){aE.style[aG]=a7}}}else{if(aP.cssText.length>0){aX=true;aE.setAttribute("style",aP.cssText)}}}if(!aX){if(aY.img.currentStyle){aX=true;var aS=aY.img.currentStyle;for(var aH in aS){if(typeof(aS[aH])=="string"&&aH!="cssText"){aE.style[aH]=aS[aH]}}}}if(!aX){aE.style.display=aY.img.style.display}var aF=aE.style.display;if(aF==b||aF=="inline"){aE.style.display="inline-block"}aE.appendChild(aR)}else{aE=aR;a1=aY.rootImage;aR.style.left=aY.px+"px";aR.style.top=aY.py+"px"}aR.style.width=aY.wOrg+"px";aR.style.height=aY.hOrg+"px";var aJ,aI;if(aY.parentImage&&aY.parentImage.childTilesX!=b){aJ=aY.parentImage.childTilesX;aI=aY.parentImage.childTilesY}else{if(aY.wOrg>aY.hOrg){aJ=3;aI=Math.max(1,Math.round(aY.hOrg/aY.wOrg*aJ))}else{aI=3;aJ=Math.max(1,Math.round(aY.wOrg/aY.hOrg*aI))}if(aY.parentImage){aY.parentImage.childTilesX=aJ;aY.parentImage.childTilesY=aI}}aY.tilesX=aJ;aY.tilesY=aI;var a5=aJ-1;var aO=aI-1;var aD=Math.floor(aY.wOrg/aJ);var aL=Math.floor(aY.hOrg/aI);var aW=document.createElement("img");aW.style.visibility="hidden";aW.setAttribute("width",aD);aW.style.width=a0+"px";aW.setAttribute("height",aL);aW.style.height=aV+"px";var aV,a0;var aQ,a6;var aN,aM;aY.arImages=new Array();aV=aL;var a4=false;var a3=false;var aU=0;var aT=0;var aK=aY.FSITouchZoom_ID+"_";if(!aY.bTile&&aY.img.src){var aZ=document.createElement("img");aZ.src=aY.img.src;var a2=aY.img.getAttribute("width");aZ.setAttribute("width",a2);aZ.style.width=a2+"px";var a2=aY.img.getAttribute("height");aZ.setAttribute("height",a2);aZ.style.height=a2+"px";aZ.className="fsi_touch_zoom_background_image";aR.appendChild(aZ)}for(aM=0;aM<aI;aM++){a0=aD;a4=false;aU=0;if(aM==aO){aV=aL+aY.hOrg%aI;a3=true;aW.setAttribute("height",aV)}aW.style.top=aT+"px";for(aN=0;aN<aJ;aN++){a6=aW.cloneNode();a6.style.left=aU+"px";if(aN==a5){a0=aD+aY.wOrg%aJ;a4=true;a6.setAttribute("width",a0)}a6.style.height=aV+"px";a6.style.width=a0+"px";aQ=y(a6,a1.src);if(aQ){A(aQ,aK+aN+"x"+aM);aQ.px=aU;aQ.py=aT;aQ.srcCurrent=b;aQ.rootImage=a1;aQ.parentImage=aY;aQ.bTile=true;aQ.wLast=0;aQ.tilePosX=aN;aQ.tilePosY=aM;aQ.bRestX=a4;aQ.bRestY=a3;aQ.sourceWidth=aY.sourceWidth;aQ.sourceHeight=aY.sourceHeight;ag(aQ);aY.arImages.push(aQ)}aR.appendChild(a6);aU+=a0}aT+=aV}aY.orgDisplay=aY.img.style.display;aY.img.style.display="none";aY.img.parentNode.insertBefore(aE,aY.img);aY.bTiled=true;aY.container=aY.elPosition=aR};var e=function(aF){if(!aF.bTiled){return}aF.bTiled=false;var aD=aF.arImages.length;for(var aG=0;aG<aD;aG++){var aE=aF.arImages[aG];e(aE);z(aE);delete az[aE.FSITouchZoom_ID]}a.removeChild(aF.container.parentNode,aF.container);aF.img.style.display=aF.orgDisplay;aF.elPosition=aF.img;delete aF.container;delete aF.arImages;if(aF.outerContainer){a.removeChild(aF.outerContainer.parentNode,aF.outerContainer);delete aF.outerContainer}};this.setZoomPrecision=function(aD){if(isNaN(aD)||(aD<1&&aD!=0)){return false}T=b;ax=aD;aw();return true};this.lockImageSourceDimension=function(aD,aE){if(!an||!aD){return}var aF=v(aD);if(!aF||aF.bLockedSourceDimension==aE){return}aF.bLockedSourceDimension=aE};this.lockImage=function(aD,aE){if(!an||!aD){return}var aF=v(aD);if(!aF||aF.bLocked==aE){return}aF.bLocked=aE;if(aF.bSourceChangeOnUnlock==true){aF.bSourceChangeOnUnlock=false;av(aF)}if(!aE){aw()}else{J(aF)}};var f=this.lockUpdates=function(aD){if(!aD&&ah){aw()}ah=aD};var M=this.enable=function(aD){if(!an){return}if(V==aD){return}if(!aD){N=ai=1;n();V=false}else{V=true;T=b;n()}};this.scanForNewImages=function(){if(!an){return}var aD=document.getElementsByTagName("img");var aE=0;u.log("...scanning for new images: "+aD.length+" image(s) in total");for(var aF=0;aF<aD.length;aF++){if(aD[aF].$FSITouchZoom_ID==b){if(ar(aD[aF])){aE++}}}u.log(aE+" new image(s) found");if(aE>0){aA();aw()}}};a.addEvent(window,"DOMContentLoaded",function(){if(typeof(a.touchZoomParameters)!="object"||a.makeBool(a.touchZoomParameters.autoInit,true)){if(typeof(a.touchZoom)=="object"&&typeof(a.touchZoom.destroy)=="function"){a.touchZoom.destroy()}var c;if(typeof(a.touchZoomParameters)=="object"){c=a.touchZoomParameters}a.touchZoom=new a.TouchZoom(c);a.touchZoom.bAutoInitialized=true;a.touchZoom.init()}})}(window.$FSI=window.$FSI||{}));