/*!
 * FSI Viewer JS
 * Copyright (c) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 *
 * VERSION: 1.1.3
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,version,build){var self=this;this.instance=instance;this.strClassName=strClassName;this.version=version;this.build=build;var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var classDef=new $FSI.ClassDef($FSI,"FSI Core","2016","16.08.4");$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t=="boolean"){ret=value}else{if(t=="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady){if(typeof($FSI.iLoaderCSSSkin)!="object"){if(typeof($FSI.LoaderCSSSkin)!="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create <style> node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		@if (@_jscript_version < 9)
			el.style.setAttribute('cssText', strStyle);
		@else @*/
el.setAttribute("style",strStyle);
/*@end
		@*/
};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!=0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWith=window.innerWidth;$FSI.bElementPosRespectsScroll=true;var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}var uagent=$FSI.userAgent=navigator.userAgent.toLowerCase();var result;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!=-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("safari")>-1&&uagent.search("chrome")<1){$FSI.isSafari=true}else{if(uagent.search("firefox")>-1){$FSI.isFirefox=true}else{if(uagent.search("opera")>-1){$FSI.isOpera=true}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)=="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.getCachedScrollBarWidth=function(el,oReg,w){var cst;var cssOverflowY="";try{cst=top.window.getComputedStyle(el);cssOverflowY=cst["overflow-y"]}catch(e){return 0}if(cssOverflowY=="scroll"||el.scrollHeight>top.window.innerHeight){var orgStyle=el.style.overflowY;var styleID=orgStyle;styleID="S_"+styleID;if(1==1||oReg[styleID]==undefined){el.style.overflowY="hidden";var w2=$FSI.___elementScaleCheck.offsetWidth;if(w2-w>1){oReg[styleID]=w2-w}}}if(!isNaN(oReg[styleID])){ret=oReg[styleID]}else{ret=-1}return ret};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(step){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if(typeof(document.visualViewport)!="undefined"){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return document.visualViewport.pageScale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180==0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=window.outerWidth;return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.document.visualViewport.clientWidth,height:wnd.document.visualViewport.clientHeight}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.push)=="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)=="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])=="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag;if(typeof(document.querySelector)=="function"){var strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector)}else{var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"s*$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var scripts=document.getElementsByTagName("script");var t="/"+strScriptName;var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!="object"){if(typeof($FSI.LoaderJavascript)!="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)=="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!="string"){return false}var t=typeof(parameters);if(t!="object"&&t!="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)=="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!="string"||strClass.length<1){return}if(typeof(strRule)!="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var node=element;var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=scale.x}else{scale.y=targetDimension.height/(sourceDimension.height*range.height);scale.x=scale.y}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)=="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(document.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)=="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)=="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.dir=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c="FSI";this.on=true;this.doNothing=function(){};this.log=this.doNothing;this.error=this.doNothing;this.dir=this.doNothing;try{if(console&&console.log){this.log=function(e){console.log(c+e)}}if(console&&console.error){this.error=function(e){console.error(c+e)}}if(console&&console.dir){this.dir=function(e){console.dir(e)}}}catch(d){}this.setPrefix=function(e){c=e+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!=b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(m,n,p,r){var l=i(m);if(!l){return}if(p&&l.overrideMimeType){l.overrideMimeType(p)}l._url=m;var o=d;c[d]=l;d++;var k=-1;if(g){l.onerror=function(){delete c[o];if(n==b||this.FSIaborted){return}n(this,this.responseText,r,400)};l.onload=function(){delete c[o];if(n==b||this.FSIaborted){return}var s=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var t=new ActiveXObject("Microsoft.XMLDOM");t.async=false;t.loadXML(s);s=this.responseXML=t}catch(u){}break}n(this,s,r,200)}}else{l.onreadystatechange=function(e){if(l.readyState!=4){return}delete c[o];if(n==b||this.FSIaborted){return}var s=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;n(this,s,r,l.status)}}try{l.open("GET",m,true);l.send(null)}catch(q){n(this,"",r,500)}return l};this.stopPendingRequests=function(){for(var k in c){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CanvasProgressBar!=b){return}a.CanvasProgressBar=function(r,l,j,d,p,e){var q=this;var r=r;if(!e){e={}}if(typeof(e.border)!="string"){e.frame="#58a8ff"}if(typeof(e.color)!="string"){e.color="#58a8ff"}if(typeof(e.background)!="string"){e.background="rgba(255,255,255,0.5)"}if(typeof(e.text)!="string"){e.text="#FFFFFF"}var o=l;var n=j;var g=p;var k=d;var h=0;this.draw=function(s){var t=k/100*s;i(o,n,k,g,h);c(o,n,t,g,h,k);f(o,n,t,g,h,k)};this.setCtx=function(s){r=s};this.setPos=function(s,t){o=s;n=t};var i=function(u,w,v,t,s){r.save();r.fillStyle=e.border;m(u-1,w-1,v+2,1,s);m(u-1,w+t,v+2,1,s);m(u-1,w-1,1,t+2,s);m(u+v,w-1,1,t+2,s);r.fillStyle=e.background;m(u,w,v,t,s);r.restore()};var c=function(v,z,w,u,t,s){r.fillStyle=e.color;m(v,z,w,u,t)};var m=function(u,w,v,t,s){r.fillRect(u,w,v,t)};var f=function(A,w,s,C,v,z){r.save();r.font="10px Arial";r.textAlign="start";r.textBaseline="alphabetic";r.fillStyle=e.text;var B=Math.floor(s/z*100)+"%";var t=r.measureText(B).width;var u=A+s-t-v/2-4;if(s<=v+t){u=A+v/2}r.fillText(B,u,w+C/2+3.25);r.restore()}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!=b){return}a.Config=function(m,v){if(!v||typeof(v)!="object"){v={}}this.parameters=(m)?m:{};this.queryParameters=b;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():b}catch(B){}this.plugins=new Object();this.arPlugins=new Array();this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=new Array();this.locales=new Object();this.locales.tips=new Object();var f=false;var o=this;this.strListFilePrefix="";this.strListFileSuffix="";var n={};var z=0;var y=false;var j;var A={};var s="FSI> ";var p=new a.EmptyDebugger();var r=false;var g={};var C;var w;var t=false;this.strConfigFileExtension=".xml";o.strTemplateSuffix=".json";var u;var i=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){u=function(E){var e;if(!a.isCrossDomain(E)){t=false;e=new XMLHttpRequest()}else{t=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){u=function(){return new XMLHttpRequest()}}}if(!u){try{i=new ActiveXObject("Msxml2.XMLHTTP");u=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(B){try{i=new ActiveXObject("Microsoft.XMLHTTP");u=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(B){i=null;u=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters=new Object();this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfgAliasNamesSecondLevel={renderer:"fpxservertemplate"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(E){o.reset();if(E){if(o.parameters){o.parameters=a.mergeObjects(o.parameters,E)}else{o.parameters=E}}l(o.parameters);o.getQueryParameters();o.cloneParameters(o.cfgDefaults,o.cfg);o.cloneParameters(o.queryParameters,o.cfg);o.elevateToHTTPS();q();o.BaseURL=o.getBaseURL();if(o.bForceVersion5==true){}var e=o.queryParameters.fsiviewerversion;if(o.bForceVersion5==true){e="5"}if(e!=b){if(parseInt(e)<6){o.strConfigFileExtension=".fsi"}}var F=o.queryParameters.fsiserverversion;if(o.bForceVersion5==true){F="2"}if(F!=b){if(parseInt(F)<3){o.strTemplateSuffix="_json"}}if(o.queryParameters.fsiviewerlocation!=b){o.locationFSIViewer=o.queryParameters.fsiviewerlocation}else{if(a!=b&&a._FSIViewerLocation!=b){p.log("FSI Viewer location gussed based on script location: "+a._FSIViewerLocation);o.locationFSIViewer=a._FSIViewerLocation}else{o.locationFSIViewer=o.BaseURL.split("/");if(o.locationFSIViewer.length>4){o.locationFSIViewer.splice(o.locationFSIViewer.length-3,2);o.locationFSIViewer=o.locationFSIViewer.join("/")}}}if(o.locationFSIViewer.charAt(o.locationFSIViewer.length-1)!="/"){o.locationFSIViewer+="/"}o.nextConfigURL=o.getReloadPath(o.locationFSIViewer,o.expandFSIPath(o.cfg.defaultcfg));o.checkDebug(false)};var l=this.makeObjectPropertiesLowerCase=function(e){for(var E in e){var F=E.toLowerCase();if(E!=F){if(e[F]==b){e[F]=e[E]}delete e[E]}}};var q=function(){f=o.makeBool(o.cfg.usenc,false);if(o.cfg.usencquery!=b&&o.cfg.usencquery.length>0){r=o.cfg.usencquery;f=true;o.queryToObject("?"+r,g)}};this.stopPendingRequests=function(){for(var E in n){var e=n[E];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){o.stopPendingRequests()};this.getBaseURL=function(){var F;var E=document.getElementsByTagName("base");if(E&&E.length>0){F=E[E.length-1].href;if(F&&F.charAt(F.length-1)!="/"){F+="/"}}else{F=document.location.href;var e=F.indexOf("?");if(e!=-1){F=F.slice(0,e)}e=F.indexOf("#");if(e!=-1){F=F.substring(0,e)}e=F.lastIndexOf("/");if(e!=-1){F=F.slice(0,e+1)}}return F};this.reset=function(){o.parameters={};p=new a.EmptyDebugger();o.stopPendingRequests();j=Math.random();o.nIncludedConfigs=0;o.completedConfigs=new Object();o.plugins=new Object();o.cfg=new Object();o.queryParameters=b;o.arUnrecognizedConfigNodes=[]};this.getQueryParameters=function(){if(o.queryParameters!=b){return}o.queryParameters=new Object();o.cloneParameters(o.parameters,o.queryParameters)};this.makeBool=function(G,e){if(typeof(e)!="boolean"){e=false}var E=e;switch(typeof(G)){case"string":var F=a.makeBool(G);if(F!=b){E=F}break;case"number":E=Boolean(G);break;case"boolean":E=G;break}return E};this.parsePositionParameter=function(E){if(typeof(E)!="string"||E.length<3){return b}var E=E.split(",");if(E.length<3){return b}for(var e=0;e<3;e++){E[e]=parseFloat(E[e]);if(isNaN(E[e])){E[e]=0}}return{x:E[0],y:E[1],z:E[2]}};this.loadLanguageFile=function(){var E=o.cfg.language;if(E==b){E="english"}var e=o.locationFSIViewer+"/languages/"+E+".xml";var F={};o.finishRequestParams(F);Ext.Ajax.request({url:e,overrideMimeType:"application/xml",params:F,method:"GET",scope:o,success:function(G,H){o.logXMLResponseOK(G);o.onLanguageLoaded(true,G)},failure:function(G,H){o.logLoadFileFailed(G,H);o.onLanguageLoaded(false,G)}})};this.logLoadFileFailed=function(e,G){if(!p.on){return}if(e&&e.status!=b){var F="HTTP "+e.status;if(e&&e.statusText){F+=", "+e.statusText}var E=(e._url)?e._url:"";p.error("Failed to load "+E+" ("+F+")")}else{p.error("Failed loading a file");if(e&&e._url){p.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(H){if(!H||!H.firstChild){return false}var e=H.firstChild.childNodes;var I,F,G;for(var E=0;E<e.length;E++){F=e[E];I=o.getAttributeValue(F,"id");if(I==b){continue}I=I.toLowerCase();if(F.childNodes.length>0){G=o.XMLChildNodesToString(F)}else{G=o.getAttributeValue(F,"txt")}o.locales.tips[I]=G}return true};this.getAttributeValue=function(E,e){if(!E){return}return E.getAttribute(e)};this.onLanguageLoaded=function(E,e){p.log("Language loaded");if(E){o.parseLanguage(e.responseXML)}o.initPagesParameters();if(v.onConfigReady){v.onConfigReady()}};this.onConfigReadyDone=function(){if(!o.readCustomPageNumbers()){o.loadImageList()}};this.swapParameters=function(F,e){F=F.toLowerCase();e=e.toLowerCase();var E=o.plugins.pages.parameters;if(E==b){return}o.swapValues(E,F,e);o.swapValues(o.cfg,"pages_"+F,"pages_"+e)};this.swapValues=function(G,F,E){var e=G[F];G[F]=G[E];G[E]=e};this.initPagesParameters=function(){o.LinkTemplates=o.getPagesParameter("LinkTemplates","").split(",");for(var e=0;e<o.LinkTemplates.length;e++){o.LinkTemplates[e]=a.urlDecode(o.LinkTemplates[e])}o.LinkTemplateData=o.getPagesParameter("LinkTemplateData","").split(",");for(var e=0;e<o.LinkTemplateData.length;e++){o.LinkTemplateData[e]=a.urlDecode(o.LinkTemplateData[e])}o.LinkTemplateCount=Math.max(o.LinkTemplates.length,o.LinkTemplateData.length)};this.getTranslation=function(E){var e=o.locales.tips[E.toLowerCase()];if(e==b){e=E}return e};this.getImageURL=function(F,e){if(F==b){return""}if(e==b){e={}}if(e.type==b){e.type="image"}if(e.renderer==b){e.renderer="jpeg"}e.source=F;for(var E in A){if(e[E]==b){e[E]=A[E]}}return o.requestBase+"?"+o.objectToQuery(e)};this.getImageInfoURL=function(E,e){if(E==b){return""}if(e==b){e={}}if(e.type==b){e.type="info"}if(e.tpl==b){if(o.cfg.fpxinfotemplate!=b){e.tpl=o.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(o.cfg.headers&&o.cfg.headers.length>0){e.headers=o.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=E;return o.requestBase+"?"+o.objectToQuery(e)};this.queryToObject=function(H,F){if(F==b){F={}}var G,J,I,e,E;G=H.indexOf("?");if(G!=-1){E=H.slice(G+1)}else{E=""}G=E.indexOf("#");if(G!=-1){E=E.substring(0,G)}E=E.split("&");for(G=0;G<E.length;G++){J=E[G].split("=");I=a.urlDecode(J[0]).toLowerCase();if(I.length>0){e=a.urlDecode(J[1]);F[I]=e}}return F};this.parseSceneSets=function(e,H){var O={};if(H==b){H=true}var T=[];var R=0;var P=0;var F;var J,I,G,N,L,S;var K,M,Q;var E=o.cfg.scenesets;if(e>1&&E!=b&&typeof(E)=="string"){M=E.split(";");for(J=0;J<M.length;J++){Q=new Array();K=M[J].split(",");P=0;for(I=0;I<K.length;I++){S=K[I].split("-");N=L=0;if(S.length==1){N=parseInt(S[0])}else{N=parseInt(S[0]);if(isNaN(N)){N=1}F=false;if(S[1].charAt(0)==">"){S[1]=S[1].substr(1);if(!isNaN(parseInt(S[1]))){F=true}}L=parseInt(S[1]);if(isNaN(L)){L=e}if(N>0&&L>0&&N<=e&&L<=e){if(F==true||N!=L){if(F!=true){if(L<N){for(G=N;G>=L;G--){Q[P]=G;P++}}else{for(G=N;G<=L;G++){Q[P]=G;P++}}}else{for(G=N;G<=e;G++){Q[P]=G;P++}for(G=1;G<=L;G++){Q[P]=G;P++}}}}}if(N>0&&N<=e&&(L==0||L==N)){Q[P]=N;P++}}if(P>0){T[R]={};T[R].arScenes=new Array();T[R].arScenes=T[R].arScenes.concat(Q);R++}}}if(R==0){O.bDefault=true;if(H){T[0]={};T[0].arScenes=new Array();for(J=0;J<e;J++){T[0][J]=J}}}O.nSceneSets=R;O.bHasMultipleSets=(O.nSceneSets>1);O.arSets=T;O.nCurrent=1;return O};this.objectToQuery=function(E){var e=[];if(f&&r!==false){for(var G in g){E[G]=g[G]}}for(var G in E){var F=encodeURIComponent(E[G]);e.push(encodeURIComponent(G)+"="+F)}return e.join("&")};this.loadConfigs=function(){o.loadNextConfig(true)};this.loadFile=function(E,F,H,I){if(!E||E.length<0){if(F){F(this,"",I)}return}if(H==b){H="application/json"}var e=u(E);if(!e){return}if(H&&e.overrideMimeType){e.overrideMimeType(H)}e._url=E;var G=z;n[z]=e;z++;if(t){e.onerror=function(){delete n[G];if(F==b||this.FSIaborted){return}o.logLoadFileFailed(this)};e.onload=function(){delete n[G];if(F==b||this.FSIaborted){return}var J=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var K=new ActiveXObject("Microsoft.XMLDOM");K.async=false;K.loadXML(J);J=this.responseXML=K}catch(L){p.log("Failed parsing XML using Microsoft.XMLDOM");p.log(E)}break;case"application/json":J={};try{J=a.JSON.parse(this.responseText)}catch(L){p.error("Failed parsing JSON from URL: "+E+" ("+L.message+")")}break}F(this,J,I)}}else{e.onreadystatechange=function(J){var K;if(e.readyState!=4){return}delete n[G];if(F==b||this.FSIaborted){return}if(this.status>299){o.logLoadFileFailed(this)}switch(H){case"application/xml":case"text/xml":K=this.responseXML;break;case"application/json":K={};try{K=a.JSON.parse(this.responseText)}catch(L){p.error("Failed parsing JSON from URL: "+E+" ("+L.message+")")}break}F(this,K,I)}}e.open("GET",E,true);e.send(null);return e};this.onConfigXMLLoaded=function(e,E){o.logXMLResponseOK(e.response);o.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(F){if(o.nextConfigURL==b){o.finalCheck();return}var e=!o.makeBool(o.cfg.ConfigCaching,true);var G={};if(o.makeBool(o.cfg.debug)||(!F&&!o.makeBool(o.cfg.configcaching,true)&&o.makeBool(o.cfg.enableconfigcachingparameter))){o.addNoCacheParams(G)}o.finishRequestParams(G);var E=o.addURLParameters(o.nextConfigURL,G);p.log("LOAD CONFIG: "+E);o.loadFile(E,o.onConfigXMLLoaded,"application/xml")};this.parseMargins=function(F,E,e,G){if(e==b){e=_root._FSI.StageWidth}if(G==b){G=_root._FSI.StageHeight}F[E+"Left"]=o.getFloatParameterPercent(E+"Left",0,e);F[E+"Top"]=o.getFloatParameterPercent(E+"Top",0,G);F[E+"Right"]=o.getFloatParameterPercent(E+"Right",0,e);F[E+"Bottom"]=o.getFloatParameterPercent(E+"Bottom",0,G);F[E+"Inner"]=o.getFloatParameterPercent(E+"Inner",0,e);F[E+"Outer"]=o.getFloatParameterPercent(E+"Outer",0,e)};this.getFloatParameterPercent=function(e,E,F){return o.parseFloatPercentDef(o.getPagesParameter(e),F,E,-1000000)};this.parseFloatPercentDef=function(G,F,E,e){if(G==b||G.length<1){return E}return Math.max(e,o.parseFloatPercent(G,F))};this.parsePercentDef=function(F,e){if(F==b||F.length<1){return e}var E=parseFloat(F);if(isNaN(E)){E=0}else{if(F.indexOf("%")!=-1){E/=100}}return E};this.parseFloatPercent=function(F,E){var e=parseFloat(F);if(isNaN(e)||e<0){e=0}else{if(F.indexOf("%")!=-1){e=Math.round(e*E/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){s=e+"> "};this.setDebugger=function(e){p=e};this.checkDebug=function(F){var E;var e;if(o.parameters.debug!=b){e=o.makeBool(o.parameters.debug)}else{e=o.makeBool(o.cfg.debug)}if(e){if(!p||!p.on){p=new a.Debugger();if(v.onDebuggerChange){E=v.onDebuggerChange(p,F)}}}else{if(!p||p.on===true){p=new a.EmptyDebugger();if(v.onDebuggerChange){E=v.onDebuggerChange(p,F)}}}return E};this.onConfigLoaded=function(E){o.parseConfig(E);o.elevateToHTTPS();if(o.checkDebug(true)==true){return}q();var e;if(o.cfg.includeconfig!=b&&o.nIncludedConfigs<10){e=o.getFSIPath(o.locationFSIViewer,o.expandFSIPath(o.cfg.includeconfig));o.nIncludedConfigs++;o.cfg["includeconfig("+o.nIncludedConfigs+")"]=o.cfg.includeconfig;o.cfg.includeconfig=b}else{if(o.cfg.cfg!=b){e=o.getFSIPath(o.locationFSIViewer,o.expandFSIPath(o.cfg.cfg))}}if(e!=b&&!o.completedConfigs[e]){o.completedConfigs[e]=true;o.nextConfigURL=e;o.loadNextConfig()}else{o.evaluateQuery(o.queryParameters,o.cfg);o.finalCheck()}};this.elevateToHTTPS=function(){if(!a.bHTTPS){return}if(!o.makeBool(o.cfg.autoelevatetohttps,true)){return}d("fpxbase");d("fpxserver")};var d=function(e){if(o.cfg[e]!=b&&o.cfg[e].length>0&&o.cfg[e].indexOf("http://")==0){o.cfg[e]="https"+o.cfg[e].substr(4)}};this.evaluateQuery=function(E,e){for(var F in E){o.setConfigParamByValue(e,F.toLowerCase(),E[F])}};this.parseConfig=function(E){var N="";if(E!=b){var F=E.firstChild;if(F&&F.nodeName=="xml"){F=F.nextSibling}var M=F.childNodes;for(var J=0;J<M.length;J++){var H=M[J];if(H.nodeType!=1){continue}var K=H.nodeName.toLowerCase();N=K;var G=H.childNodes;switch(K){case"licence":break;case"plugins":for(var I=0;I<G.length;I++){o.parsePluginNode(G[I])}break;case"info":case"options":N=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(var I=0;I<G.length;I++){var L=G[I];if(L.nodeType!=1){continue}var e=o.getValueFromXMLNode(L,N);o.setConfigParam(o.cfg,e)}break;default:o.arUnrecognizedConfigNodes.push(H)}}}};this.getData=function(){var e={};e.cfg={};for(var E in o.cfg){e.cfg[E]=o.cfg[E]}return e};this.setData=function(e){if(!e||!e.cfg){return}o.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var E in e){o.cfg[E]=e[E]}c()};this.getImagesNodeList=function(F){var e=[];if(F==b){F=o.getUnrecognizedConfigNode("images")}if(F){var G=F.firstChild;while(G){if(G.nodeType==1){var E={};E.attributes={};k(G,E.attributes);E.cfg={};o.parseConfigFragment(G,E.cfg);e.push(E)}G=G.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){o.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(G){var e;G=G.toLowerCase();for(var E=o.arUnrecognizedConfigNodes.length-1;E>-1;E--){var F=o.arUnrecognizedConfigNodes[E];if(F&&F.nodeName.toLowerCase()==G){e=F;break}}return e};this.parseConfigFragment=function(G,K,J){var O="";if(G!=b&&K!=b){if(J==b){J=[]}var E=G;var N=E.childNodes;for(var I=0;I<N.length;I++){var G=N[I];if(G.nodeType!=1){continue}var L=G.nodeName.toLowerCase();O=L;var F=G.childNodes;switch(L){case"info":case"options":O=b;case"fpx":case"image":case"include":for(var H=0;H<F.length;H++){var M=F[H];if(M.nodeType!=1){continue}var e=o.getValueFromXMLNode(M,O);o.setConfigParam(K,e)}break;default:J.push(G)}}}};this.findXMLNode=function(E,e){if(E==b||E.nodeType==b){return b}while(E){if(E.nodeName.toLowerCase()==e){break}if(E.firstChild!=b){E=E.firstChild}else{if(E.nextSibling!=b){E=E.nextSibling}else{E=E.parentNode.nextSibling}}}return E};this.getValueFromXMLNode=function(F,e){if(!F||F.nodeType!=1){return}var E=new Object();var G=(e)?e:"";E.name=G+F.nodeName.toLowerCase();var H=F.getAttribute("value");if(H){E.value=H;return E}E.value=o.XMLChildNodesToString(F);E.node=F;return E};this.getXMLNodeAttribute=function(G,F,e){if(!G||G.nodeType!=1||!G.getAttribute){return e}var E=G.getAttribute(F);if(E==b||E==null){E=e}return E};this.XMLChildNodesToString=function(E){if(!E||!E.firstChild){return""}var e="";if(E.childNodes.length==1&&E.firstChild.nodeType==3){e=E.firstChild.nodeValue}else{e=o._XMLChildNodesToString(E)}return e};this.hasPlugin=function(e){return(o.plugins&&o.plugins[e]!=b)};this.getPluginParameter=function(J,E,e,I){J=J.toLowerCase();E=E.toLowerCase();if(o.plugins[J]==b){p.error("CANNOT GET PLUGIN PARAMETER, because plugin not defined: "+J+"."+E);return e}var H;var G=J+"_"+E;if(o.cfg[G]!=b){H=o.cfg[G]}else{var F=o.plugins[J].parameters;if(F!=b&&F[E]!=b){H=F[E]}}if(H==b){H=e}if(I){H=o.makeBool(H,e)}return H};this.getUnescapedPagesParameter=function(G,F,E){var e=o.getPagesParameter(G,F);if(e==b&&E!=b){e=o.getPagesParameter(E,F)}if(e!=b){e=a.urlDecode(e)}return e};this.getIntParameterMinMax=function(E,F,e,G){return Math.min(G,Math.max(e,o.getIntParameter(E,F)))};this.getIntParameter=function(E,F){var e=parseInt(o.cfg[E.toLowerCase()]);if(isNaN(e)){e=F}return e};this.getStringParameter=function(E,F){var e=o.cfg[E.toLowerCase()];if(e==b){e=F}return e};this.getFloatParameter=function(E,F){var e=parseFloat(o.cfg[E.toLowerCase()]);if(isNaN(e)){e=F}return e};this.getRGBAValue=function(E){var e=new Object();if(E==b){E=""}if(E.charAt(0)=="#"){E=E.substr(1)}if(E.length>8){E=E.substr(0,8)}if(E.length>5){e.webColor="#"+E.substr(0,6);e.red=parseInt(E.substr(0,2),16);e.green=parseInt(E.substr(2,2),16);e.blue=parseInt(E.substr(4,2),16);if(E.length<7){e.alpha=255}else{e.alpha=parseInt(E.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};this.getPagesParameter=function(E,e,F){return o.getPluginParameter("pages",E,e,F)};var k=function(I,E){if(!I||!I.attributes||!I.attributes.length||!E){return false}var F=I.attributes;for(var H=0;H<F.length;H++){var e=F[H];var G=e.nodeName.toLowerCase();E[G]=e.value}return true};this.parsePluginNode=function(F){if(F.nodeType!=1){return}var H=new Object();k(F,H);var G=F.childNodes;for(var e=0;e<G.length;e++){var I=G[e];if(I.nodeType!=1){continue}var E=o.getValueFromXMLNode(I);if(E.value!=b){H[E.name]=E.value;if(E.node!=b){H[E.name+".node"]=E.node}}}this.addPluginFromString(H.src,H)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.addPluginsFromString=function(F){if(F==b||F.split==b||F.length<1){return}var e=F.split(",");for(var E=0;E<e.length;E++){var G=o.trimString(e[E]);o.addPluginFromString(G)}};this.addPluginFromString=function(E,F){if(E==b||E.length<1){p.error("PLUGIN without src parameter:");return}E=E.toLowerCase();if(F==b){F=new Object()}var e=o.plugins[E]=new Object();e.name=E;if(o.pluginDefaultParameters[E]!=b){e.parameters=new Object();o.cloneParameters(o.pluginDefaultParameters[E],e.parameters);o.cloneParameters(F,e.parameters)}else{e.parameters=F}};this.setConfigParamByValue=function(E,F,e){o.setConfigParam(E,{name:F.toLowerCase(),value:e})};this.setConfigParam=function(E,F){var G=F.name;var e=F.value;if(G==b){return}if(o.cfgAliasNames[G]!=b){G=o.cfgAliasNames[G]}if(E[G]!=b&&(typeof(e)=="string"&&a.BoolTable[e.toLowerCase()]==false)&&a.BoolTable[E[G]]==b){delete E[G]}else{switch(G){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(E[G]!=b&&E[G].length>0&&E[G].indexOf(e)==-1){E[G]+=","+e}else{E[G]=e}break;case"plugins":o.addPluginsFromString(e);break;case"fpxpath":E[G]=e;E.fpxsrc=encodeURIComponent(e);break;default:E[G]=e;if(F.node!=b){E[G+".node"]=F.node}}}};var c=function(){o.serverProfile=o.cfg.fpxservertemplate;o.serverProfileDoublePage=o.cfg.fpxservertemplatedoublepage;if(o.serverProfileDoublePage==b){o.serverProfileDoublePage="doublepage"}o.serverBase=o.cfg.fpxserver;if(o.serverBase==b){p.log("Note:",true);p.log("Parameter 'imageserver' undefined, guess from ["+o.locationFSIViewer+"]",true);var E;E=o.locationFSIViewer.indexOf("/users/");if(E!=-1){o.serverBase=o.locationFSIViewer.substring(0,E)+"/server"}else{E=o.locationFSIViewer.indexOf("/viewer/");o.serverBase=o.locationFSIViewer.substring(0,E)+"/server"}p.log("guessed location is: ["+o.serverBase+"]",true)}o.requestBase=o.serverBase;A={};var e=o.cfg.effects;if(e!=b){A.effects=e}e=o.cfg.lefteffects;if(e!=b){A.lefteffects=e}e=o.cfg.righteffects;if(e!=b){A.righteffects=e}e=o.cfg.quality;if(e!=b){A.quality=e}};var h=function(){for(var E in o.plugins){var F=E.toLowerCase();var e=o.makeBool(o.cfg[F],true);if(!e){o.plugins[E]=b}}};this.finalCheck=function(){o.elevateToHTTPS();h();c();if(v.onConfigsReady){v.onConfigsReady()}o.dumpConfig()};this.dumpConfig=function(){if(p.on){if(o.cfg.fpxsrc!=b){o.cfg["fpxsrc (decoded)"]=decodeURIComponent(o.cfg.fpxsrc)}p.log("Evaluated Configuration:");p.dir(o.cfg)}};var D=o.finishURL=function(e){if(!f||e==b){return e}var E;if(r===false){E="cache=0&cachernd="+j;if(e.indexOf("?")==-1){e+="?"+E}else{e+="&"+E}}else{E=r;if(e.indexOf("?")==-1){e+="?"+E}else{e+=E}}return e};this.addURLParameters=function(E,F){if(!E||!F){return E}var e=[];for(var G in F){e.push(encodeURIComponent(G)+"="+encodeURIComponent(F[G]))}if(e.length>0){if(E.indexOf("?")==-1){E+="?"}else{E+="&"}E+=e.join("&")}return E};this.finishRequestParams=function(E){if(f){if(r===false){E.cache=0;E.cachernd=j}else{for(var e in g){E[e]=g[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=j};this.parseQuery=function(E,e){if(e==b||E==b||E.length<1){return}o.queryToObject(E,e);if(e.ignorequeryparameters!=b){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=b){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,E){if(e==b||E==b){p.error("Cloning object failed: "+e+" / "+E)}for(var F in e){E[F]=e[F]}};this.getFSIPath=function(E,F){if(F.indexOf("//")!=-1){return F}if(o.cfg.fsibase!=b){F=o.cfg.fsibase+F}var e=o.getReloadPath(E,F);return e};this.expandFSIPath=function(E){var e=a.urlDecode(E);if(e.indexOf("?")!=-1||e.indexOf(o.strConfigFileExtension)==(e.length-4)){return E}return E+o.strConfigFileExtension};this.getReloadPath=function(G,I){var E,J,e,H;if(G==b){G=o.locationFSIViewer}if(I==b){I=""}var F="/";if(I.indexOf("//")!=-1){return I}E=G;H=E.lastIndexOf("?");if(H==-1){H=E.length}J=E.lastIndexOf("\\",H);e=E.lastIndexOf("/",H);J=Math.max(J,e);if(J==-1){J=E.length-1}E=E.slice(0,J);if(E.length>0&&I.indexOf(F)!=0){E+=F}return E+I};this.cloneValueObject=function(E){var e=new Object();for(var F in E){e[F]=E[F]}return e};this._getXMLConfigValue=function(e){var E;if(!e){return}if(e.childNodes.length>0){E=o._XMLChildNodesToString(e)}else{E=e.getAttribute("value")}return E};this._XMLChildNodesToString=function(G){if(!G||!G.firstChild){return""}var E="";try{if(G.xml!=b){for(var F=0;F<G.childNodes.length;F++){E+=G.childNodes[F].xml}}else{for(var F=0;F<G.childNodes.length;F++){E+=o.XMLSerializer.serializeToString(G.childNodes[F])}}}catch(H){}return E};this._findFirstXMLNode=function(F,G){var E,e;while(F){if(F.nodeName==G){e=F;break}E=F.firstChild;if(!E){E=F.nextSibling}if(!E&&F.parentNode){E=F.parentNode.nextSibling}F=E}return e};this._parseXMLImageList=function(E){var e=o._findFirstXMLNode(E,"images");if(!e){e=o._findFirstXMLNode(E,"images3d")}return parseXMLImageListNode(e)};this._parseXMLImageListNode=function(H){var K={};var e=K.arImages=[];var G="";var I="";var F;if(!H){return K}var E;E=o.getAttributeValue(H,"prefix");if(typeof(E)=="string"){G=E}E=o.getAttributeValue(H,"suffix");if(typeof(E)=="string"){I=E}var H=o._findFirstXMLNode(H,"image");if(!H){return K}while(H){if(H.nodeType==1){F=o._findFirstXMLNode(H,"path");var J=o._getXMLConfigValue(F);if(!J){J=a.urlDecode(o.getAttributeValue(H,"src"))}if(!J){J=a.urlDecode(o.getAttributeValue(H,"file"))}if(J!=b){e.push(G+J+I)}if(K.width==b){F=o._findFirstXMLNode(H,"width");F=o._getXMLConfigValue(F);if(F!=b){K.width=parseInt(F)}F=o._findFirstXMLNode(H,"height");F=o._getXMLConfigValue(F);if(F!=b){K.height=parseInt(F)}}}H=H.nextSibling}return K};this.getImageList=function(){var e;if(o.cfg&&o.cfg.fpxsources!=b){var G=o.cfg.fpxsources;if(typeof(G)=="string"||(typeof(G)=="object")&&typeof(G.push)=="function"){e={};e.oXML=null;if(typeof(G)=="string"){e.arImages=G.split(",");for(var F=0;F<e.arImages.length;F++){e.arImages[F]=a.urlDecode(e.arImages[F])}}else{e.arImages=G}return e}}if(o.arUnrecognizedConfigNodes&&o.arUnrecognizedConfigNodes.length>0){var E=o.arUnrecognizedConfigNodes;for(var F=0;F<E.length;F++){var H=E[F];if(typeof(H.nodeName)=="string"){var I=H.nodeName.toLowerCase();if(I=="images"||I=="images3d"){if(p.on){p.log("Reading image list from XML node: <"+H.nodeName+">")}e=o._parseXMLImageListNode(H);e.oXML=H;break}}}}if(o.cfg&&o.cfg.fpxsrc!=b){e={};e.oXML=null;e.arImages=[];e.arImages.push(a.urlDecode(o.cfg.fpxsrc));return e}return e};this.loadImageList=function(G,H,J,I){if(!o.serverBase||!G){H([],oResponse,I);return false}var F=o.serverBase+"?type=list";if(G.indexOf("tpl")==-1){var E=o.cfg.listtemplate;if(E&&E.length>0&&E.indexOf(".json")==-1&&E.indexOf(".xml")==-1){E+=".json"}F+="&tpl="+E}if(o.cfg.headers&&o.cfg.headers.length>0&&g.headers==b){F+="&headers="+o.cfg.headers}F+="&source="+encodeURIComponent(G);if(J!=b){F+=J}F=D(F);var e=o.loadFile(F,function(K,N){if(typeof(N)=="object"&&typeof(N.images)=="object"){N.images.pop();var O="";if(N&&N.imagesattributes&&N.imagesattributes.dir){O=N.imagesattributes.dir}var L=new Array(N.images.length);for(var M=0;M<N.images.length;M++){L[M]=O+N.images[M].src}H(L,N,I)}else{H([],N,I)}},"application/json",I);return e}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return(h<0)?-h:h};this.height=function(){var h=e.bottom-e.top;return(h<0)?-h:h};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(m){e.normalizeRect();m.normalizeRect();var l=Math.min(e.left,m.left);var h=Math.min(e.top,m.top);var j=Math.max(e.right,m.right);var k=Math.max(e.bottom,m.bottom);var i=new a.Rect(l,h,j,k);return i};this.equalRect=function(h){if(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom){return true}else{return false}};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!=b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!=b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!=b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!=0||u!=0||v!=0||q!=0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!=-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!=-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!=b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!=b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRectByRefWidth=function(q){};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r==b&&u==b){r=i.width();u=i.height();A=1}else{if(r!=b){A=i.width()/r;if(u==b){u=i.height()/A}}else{A=i.height()/u;if(r==b){r=i.width()/A}}}if(z==b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left==0&&v.top==0&&v.width()==v._refWidth&&v.height()==v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left==0&&r.top==0&&r.width()==r._refWidth&&r.height()==r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Sprite!=b){return}a.Sprite=function(k,i,t,o,s,m,f){var n=this;var c=0.075;var d;var e=true;var u;var j;var v=1;var l=n.margin={left:0,top:0,right:0,bottom:0};var r={};r.width=i;r.height=t;var p=(s)?"canvas":"div";var d=n.element=document.createElement(p);d.setAttribute("draggable","false");if(f){d.className=f}var g="";switch(m){case"inline":break;default:g+="position:absolute;z-index:"+o}a.setStyleAttr(d,g);if(s){n.canvas=n.element;n.canvas.setAttribute("crossorigin","anonymous");n.canvas.setAttribute("width",r.width);n.canvas.setAttribute("height",r.height);n.ctx=n.canvas.getContext("2d")}k.appendChild(d);this.remove=function(){a.removeChild(k,d)};this.setPos=function(h,w){n.x=h;n.y=w;d.style.marginLeft=h+"px";d.style.marginTop=w+"px"};this.isVisible=function(){return(v>0)?true:false};this.show=function(h,w){if(e==h){return}e=h;if(!w){v=(h)?1:0;d.style.display=(h)?"block":"none"}else{if(j!=b){cancelAnimationFrame(j);j=b}u=(h)?c:-c;if(h){d.style.display="block"}q()}};this.updateMargins=function(){l=n.margin=a.getElementMargins(d)};this.getClientDim=function(){var h=a.getElementClientDim(n.element);return h};this.updateDimension=function(){r=a.getElementClientDim(d)};this.width=function(){return r.width};this.height=function(){return r.height};var q=function(){v+=u;if(u>0){if(v>=1){v=1;j=b}else{j=requestAnimationFrame(q)}}else{if(v<=0){v=0;j=b;d.style.display="none"}else{j=requestAnimationFrame(q)}}d.style.opacity=v};if(!s){this.setSize=function(y,z){r.width=y;r.height=z;if(typeof(y)!="string"){y+="px"}if(typeof(z)!="string"){z+="px"}n.element.style.width=y;n.element.style.height=z};this.clear=function(){}}else{this.setSize=function(y,z){r.width=y;r.height=z;n.canvas.width=y;n.canvas.height=z};this.clear=function(){n.ctx.clearRect(0,0,r.width,r.height)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ToolTip!=b){return}a.ToolTip=function(c){var q=this;var n;var h;var d;var l;var j;var k=false;var e={};var g=false;var i;var p=function(){n=document.createElement("div");a.setStyleAttr(n,"background-color:none;display:block;position:relative;vertical-align:top;clear:none;float:none;margin:0px;padding:0px;z-index:1000;");a.addClass(n,"fsi-ui-tool-tip-container fsi-ui-tool-tip-container-hidden");h=document.createElement("div");a.setStyleAttr(h,"position:relative;left:0px;top:0px;display:inline-block;");a.addClass(h,"fsi-ui-tool-tip");n.appendChild(h);d=document.createElement("div");a.setStyleAttr(d,"position:relative;display:block;margin:0px;top:0px;");a.addClass(d,"fsi-ui-tool-tip-arrow");n.appendChild(d)};var m=this.destroy=function(){q.hide();clearTimeout(j)};this.setContent=function(r){i=r};this.show=function(t,s,r,w,v){if(!i){return}e.strTip=t;e.elSrc=s;e.x=r;e.y=w;e.fnGetToolTipText=v;clearTimeout(l);var u=(k)?100:1000;l=setTimeout(f,u)};var f=function(){clearTimeout(l);var t=e.strTip;var u;if(e.fnGetToolTipText!=b){u=e.fnGetToolTipText(t,i);if(u==b){u=i[t]}}else{u=i[t]}if(u!=b){t=u}else{t="<b>"+t+"</b>"}h.innerHTML=t;c.appendChild(n);d.style.left="0px";n.style.display="inline-block";n.style.width=c.offsetWidth+"px";var w=a.getElementClientPos(h);n.style.display="block";n.style.width=w.width+"px";d.style.left=(n.offsetWidth/2-7.5)+"px";var r=e.x;if(r==b){r=0}var z=e.y;if(z==b){z=0}if(e.elSrc!=b){var v=a.getElementClientPos(c);var s=a.getElementClientPos(e.elSrc);r+=s.left-v.left+(s.right-s.left)/2;z+=s.top-v.top}var w=a.getElementClientPos(n);n.style.left=(r-w.width/2)+"px";n.style.top=(z-w.height-2)+"px";g=true;k=true;clearTimeout(j);j=setTimeout(o,1000);a.removeClass(n,"fsi-ui-tool-tip-container-hidden");a.addClass(n,"fsi-ui-tool-tip-container-visible")};var o=function(){k=false};this.hide=function(){clearTimeout(l);if(g){a.removeClass(n,"fsi-ui-tool-tip-container-visible");a.addClass(n,"fsi-ui-tool-tip-container-hidden");a.removeChild(c,n);g=false}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FullScreen!=b){return}a.FullScreen={};a.FullScreen.__initDone=false;a.FullScreen.__init=function(){var d=a.FullScreen;if(d.__initDone){return}d.__initDone=true;var c=0;if(document.exitFullscreen){c=0}else{if(document.msExitFullscreen){c=1}else{if(document.mozCancelFullScreen){c=2}else{if(document.webkitExitFullscreen){c=3}}}}switch(c){case 1:d.requestFullscreen="msRequestFullscreen";d.exitFullscreen="msExitFullscreen";d.fullscreenPsudoClass=":-ms-fullscreen";d.fullscreenChange="MSFullscreenChange";d.fullscreenError="MSFullscreenError";d.fullScreen="msFullscreenElement";d.fullscreenElement="msFullscreenElement";break;case 2:d.requestFullscreen="mozRequestFullScreen";d.exitFullscreen="mozCancelFullScreen";d.fullscreenPsudoClass=":-moz-full-screen";d.fullscreenChange="mozfullscreenchange";d.fullscreenError="mozfullscreenerror";d.fullScreen="mozFullScreen";d.fullscreenElement="mozFullscreenElement";break;case 3:d.requestFullscreen="webkitRequestFullscreen";d.exitFullscreen="webkitExitFullscreen";d.fullscreenPsudoClass=":-webkit-full-screen";d.fullscreenChange="webkitfullscreenchange";d.fullscreenError="webkitfullscreenerror";d.fullScreen="webkitIsFullScreen";d.fullscreenElement="webkitFullscreenElement";break;default:d.requestFullscreen="requestFullscreen";d.exitFullscreen="exitFullscreen";d.fullscreenPsudoClass=":fullscreen";d.fullscreenChange="fullscreenChange";d.fullscreenError="fullscreenError";d.fullScreen="fullScreen";d.fullscreenElement="fullscreenElement"}d.nMode=c};a.FullScreen.start=function(c){a.FullScreen.__init();a.FullScreen.quit();c[a.FullScreen.requestFullscreen]()};a.FullScreen.quit=function(){a.FullScreen.__init();document[a.FullScreen.exitFullscreen]()};a.FullScreen.toggle=function(c){if(a.FullScreen.getEnabled()){a.FullScreen.quit()}else{a.FullScreen.start(c)}};a.FullScreen.getFullscreenPseudoClass=function(){a.FullScreen.__init();return a.FullScreen.fullscreenPsudoClass};a.FullScreen.addChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)=="function"){a.addEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)=="function"){a.addEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.removeChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)=="function"){a.removeEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)=="function"){a.removeEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.getAvailable=function(d){a.FullScreen.__init();var c=d[a.FullScreen.requestFullscreen];return(!c)?false:true};a.FullScreen.getEnabled=function(){a.FullScreen.__init();var c=a.FullScreen.getElement();return(!c)?false:true};a.FullScreen.getElement=function(){a.FullScreen.__init();return document[a.FullScreen.fullscreenElement]}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeInBounce:function(f,g,e,h){return h-jQuery.easing.easeOutBounce(x,g-f,0,h,g)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}},easeInOutBounce:function(f,g,e,h){if(f<g/2){return jQuery.easing.easeInBounce(x,f*2,0,h,g)*0.5+e}return jQuery.easing.easeOutBounce(x,f*2-g,0,h,g)*0.5+h*0.5+e}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(l,aT,aj,e,aN){var aD=this;var aK=false;var ai=true;var n=false;var aR=false;var aJ=false;var aB,D,i,ab;var aC,X,aH;var g=false;var ac;var p;var aW={};var ap=[];var aa=0;var H=window;var q;var aS;var d;var aV=[];var aP={x:0,y:0};var t={x:0,y:0};var aq=40;var m={};m.enabled=false;m.factor=5;m.fEndDiff=1;var ax={};ax.enabled=false;ax.minFrames=14;ax.factorAmount=23;ax.factorFrames=2.6;ax.offsetFrames=5;var ay;var aG,u,k;var E;var ar={};var W;var aM=false;var y=false;var ak={};ak.name="none";var M;var V;var Y={};if(!aT||typeof(aT)!="object"){aT={}}var am=function(){if(aK){aD.destroy()}aS=z;q=b;if(a.topWindow!=window){q=a.topWindow;try{var a1=a.getWindowOffset(window);if(a1.x!=b&&a1.y!=b){aS=ao}}catch(a0){aS=z;q=b}}else{q=b}E=aT.oPassTrough;if(aT.getPageCoords){p=aE}else{p=L}if(aT.afterTouch){for(var a2 in aT.afterTouch){ax[a2]=aT.afterTouch[a2]}}if(ax.fnStartStopAfterTouch&&typeof(ax.fnStartStopAfterTouch)!="function"){ax.fnStartStopAfterTouch=b}if(ax.fnStartStopAfterTouch){ax.useAnimationFrame=b}if(typeof(ax.modifyTarget)!="function"){ax.modifyTarget=b}if(typeof(ax.fnGetAfterTouchEnabled)=="function"){ay=ax.fnGetAfterTouchEnabled}else{ay=b}if(aT.smoothing){for(var a2 in aT.smoothing){m[a2]=aT.smoothing[a2]}}if(aT.detectClick==true){W=true}if(aT.preventSelection!==false){aT.preventSelection=true}if(!l){return}if(typeof(l.join)!="function"){l=[l]}if(typeof(aj)!="function"){aj=z}if(typeof(e)!="function"){e=z}if(typeof(aN)!="function"){aN=z}if(typeof(aT.onPinchChange)=="function"){M=aT.onPinchChange}else{M=b}aM=aT.detectGestures;aV=[];aw(true,aM);for(var aZ=0;aZ<l.length;aZ++){var aY=l[aZ];if(aY&&typeof(aY.nodeName)!="undefined"){var a2={};a2.element=aY;aV.push(a2);a.addEvent(aY,"mousedown",Q);if(a.isTouch){an(aY,Q);try{if(aY.style!=b){if(a.BrowserSupports.cssTouchAction()){if(ar.cssTouchAction!=b){o(aY,ar.cssTouchAction)}}}}catch(a0){}}}}};var R=this.enable=function(aY){if(ai==aY){return}if(!aY){P();af(false,false)}else{af(ar.captureScrollUser,ar.capturePinchUser)}ai=aY};this.getEnabled=function(){return ai};this.cancel=function(){O();ae();aI();P()};var aI=function(){if(m.enabled){h()}A()};this.cancelAfterTouch=function(){A()};this.getInitialDownEvent=function(){return V};var P=function(){if(!n){return}aI();n=false;V=b;y=false;c();aW={};ap=[];aa=0};this.destroy=function(){aD.cancel();var aY;for(var aZ=0;aZ<aV.length;aZ++){var a0=aV[aZ];aY=a0.element;a.removeEvent(aY,"mousedown",Q);v(aY,Q)}ar={}};var aA=function(aZ){if(!aZ||!aZ.style){return}var aY=aZ.style.touchAction;if(aY==b){aY=aZ.style.msTouchAction}return aY};var o=function(aY,aZ){if(!a.BrowserSupports.cssTouchAction()||!aY||!aY.style){return}aY.style.touchAction=aY.style.msTouchAction=aZ};var al=function(aZ){for(var aY=0;aY<aV.length;aY++){an(aV[aY].element,aZ)}};var F=function(aZ){for(var aY=0;aY<aV.length;aY++){v(aV[aY].element,aZ)}};var an=function(aZ,aY){a.addEvent(aZ,"touchstart",aY);a.addEvent(aZ,"MSPointerDown",aY);a.addEvent(aZ,"pointerdown",aY);a.addEvent(aZ,"MSHoldVisual",a.preventDefaultEvent)};var v=function(aZ,aY){a.removeEvent(aZ,"touchstart",aY);a.removeEvent(aZ,"MSPointerDown",aY);a.removeEvent(aZ,"pointerdown",aY);a.removeEvent(aZ,"MSHoldVisual",a.preventDefaultEvent)};var z=function(){return true};var aO=function(aY){if(aJ){U(aY,aY.pointerId)}else{var aZ=aY.changedTouches;for(var a0=0;a0<aZ.length;a0++){U(aZ[a0],aZ[a0].identifier)}}};var U=function(aY,a0){if(a0==b||aW[a0]!=b){if(aT.debug){if(a0==b){a.console.error("doRegisterPointer: no pointerId")}if(aW[a0]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a0)}}return}aa++;var aZ=aW[a0]={};aZ.identifier=a0;p(aZ,aY);ap.push(aZ)};var ah=function(aY){var a0=false;if(aJ){a0=J(aY.pointerId)}else{var aZ=aY.changedTouches;if(aZ){for(var a1=0;a1<aZ.length;a1++){a0=J(aZ[a1].identifier)}}}if(a0){ap=new Array(aa);var a3=0;for(var a2 in aW){ap[a3++]=aW[a2]}}};var J=function(aY){if(aY==b||aW[aY]==b){if(aT.debug){if(aY==b){a.console.error("doUnregisterPointer: no pointerId")}if(aW[aY]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+aY)}}return false}delete aW[aY];aa--;return true};var L=function(aZ,aY){aZ.x=aY.clientX;aZ.y=aY.clientY};var aE=function(aZ,aY){aZ.x=aY.pageX;aZ.y=aY.pageY};var r=function(aY){var aZ=aY.changedTouches;if(aZ){for(var a1=0;a1<aZ.length;a1++){var a0=aW[aZ[a1].identifier];if(a0){p(a0,aZ[a1])}}}if(ap.length>0){aP.x=ap[0].x;aP.y=ap[0].y}};var av=function(aY){var aZ=aW[aY.pointerId];if(aZ){p(aZ,aY)}if(ap.length>0){aP.x=ap[0].x;aP.y=ap[0].y;aS(aY,aP)}};var T=function(aY){p(aP,aY);aS(aY,aP)};this.getMousePositionPage=function(aZ){var aY={};aE(aY,aZ);aS(aZ,aY);return aY};this.getMousePositionClient=function(aZ){var aY={};L(aY,aZ);aS(aZ,aY);return aY};var s=function(aY,aZ){if(window!=aY.view){var a0=a.getWindowOffset(window);aZ.x-=a0.x;aZ.y-=a0.y}};var ao=function(aY){try{s(aY);aS=s}catch(aZ){aS=z}};var az=function(aY){if(!ai){return}var a0=aa;if(y&&a0==0){y=false}var a1=aY.type;if(n||ak.started){if(a1!=aB){if(ak.started){O();ae()}else{aY._FSI_Canceled=true;aX(aY,true)}}}aB=a1;d=false;var aZ=true;switch(a1){case"touchstart":aR=true;aJ=false;ac=r;i="touchmove";D="touchend";ab="touchcancel";aG=false;break;case"MSPointerDown":ac=av;aR=true;aJ=true;i="MSPointerDown";D="MSPointerUp";ab="MSPointerCancel";aG=false;d=true;break;case"pointerdown":ac=av;aR=true;aJ=true;i="pointermove";D="pointerup";ab="pointercancel";aG=true;d=true;break;default:aR=false;aJ=false;if(aT.preventSelection){aG=true}else{aG=false}aZ=false;ac=T;i="mousemove";D="mouseup";ab=b;d=true}if(aR&&aZ){aO(aY)}ac(aY);if(aG&&aY.preventDefault){aY.preventDefault()}if(aa>1){Y.bClick=false}u=false;if(aZ&&ag(aY)){if(a0==0){A();C()}return false}return true};var Q=function(aY){if(!az(aY)){return}if(n||aY.which>1){return}f(aY)};this.getCurrentPos=function(){return t};var f=function(aY){aI();if(n){return}ax.evtMove=b;if(m.enabled){t={x:aP.x,y:aP.y}}else{t=aP}Y.x=aP.x;Y.y=aP.y;var aZ=V;V=aY;if(!aj.call(H,aY,t,E)){V=aZ;return false}n=true;if(W&&!y){Y.bClick=true;Y.clickRadiusX=Y.clickRadiusY=0}else{Y.bClick=false}C();if(ax.enabled){ax.x=ax.y=0;ax.lastX=aP.x;ax.lastY=aP.y;if(ax.nInterval){clearInterval(ax.nInterval)}ax.nInterval=setInterval(Z,30)}return true};var c=function(){if(g&&X!=b){g=false;a.removeEvent(window,X,ad);a.removeEvent(window,aC,aX);if(d&&q){try{a.removeEvent(q,X,ad);a.removeEvent(q,aC,aX)}catch(aY){}}if(aH!=b){a.removeEvent(window,aH,at)}X=aC=aH=b}};var C=function(){if(g){c()}g=true;X=i;aC=D;aH=ab;a.addEvent(window,X,ad);a.addEvent(window,aC,aX);if(d&&q){try{a.addEvent(q,X,ad);a.addEvent(q,aC,aX)}catch(aY){}}if(ab!=b){a.addEvent(window,aH,at)}};var ad=function(aY){ac(aY);aY.FSI_start_x=Y.x;aY.FSI_start_y=Y.y;if(ax.enabled&&ax.evtMove==b){ax.evtMove=aY}if(n){if(Y.bClick){Y.clickRadiusX=Math.max(Y.clickRadiusX,Math.abs(aP.x-Y.x));if(Y.clickRadiusX>10){Y.bClick=false}else{Y.clickRadiusY=Math.max(Y.clickRadiusY,Math.abs(aP.y-Y.y));if(Y.clickRadiusY>10){Y.bClick=false}}}if(m.enabled){m.evt=aY;aU()}else{e.call(H,aY,t,E)}}else{if(ak.started){if(ak.nType==1){au(aY)}}}if(u&&!aY.FSI_allowEventDefault){aY.preventDefault()}};var au=function(aY){var aZ=j();if(!M){return}aY._FSI_PinchDeltaStart=ak.nPinchDistance-ak.pinchDistanceStart;aY._FSI_PinchDeltaRelative=ak.nPinchDistance-ak.pinchDistanceLast;aY._FSI_PinchScale=Math.max(aq,ak.pinchDistanceLast)/ak.pinchDistanceStartMaxed;ak.pinchDistanceLast=ak.nPinchDistance;aY._FSI_PinchDistance=aZ;M.call(H,aY,aP,E)};var at=function(aY){if(aR){ah(aY);if(aa<1){if(n){aY._FSI_Canceled=true;aX(aY,true);return}else{P();return}}}ac(aY);ag(aY)};var aX=function(aY,aZ){if(aZ){aY._FSI_Canceled=true}if(aR){ah(aY)}ac(aY);if(!aZ&&ag(aY)){return}aI();if(!aZ){if(!n||aa>0){return}}aY.FSI_start_x=Y.x;aY.FSI_start_y=Y.y;var a0=false;if(!aZ&&ax.enabled){if(ay==b||ay()){a0=S(aY)}}if(a0){P();w(aY)}else{if(W){aY._FSI_Click=Y.bClick}aN.call(H,aY,t,E);P()}if(aY.preventDefault){aY.preventDefault()}};var aL=function(aY){return aa};var G=function(aY){return ap};var aU=function(){if(m.animationFrame!=b){return}aQ()};var h=function(){if(m.animationFrame==b){return}cancelAnimationFrame(m.animationFrame);m.animationFrame=b};var aQ=function(){var aY=Math.abs(t.x-aP.x)+Math.abs(t.y-aP.y);if(aY>m.fEndDiff){t.x+=(aP.x-t.x)/m.factor;t.y+=(aP.y-t.y)/m.factor;m.animationFrame=requestAnimationFrame(aQ)}else{t.x=aP.x;t.y=aP.y;m.animationFrame=b}e.call(H,m.evt,t,E)};var S=function(aY){if(!ax.enabled){return false}if(ax.running){A()}ax.pos=0;var a0=ax.factorAmount;ax.startX=t.x;ax.startY=t.y;var aZ={};aZ.x=ax.startX+a0*ax.x;aZ.y=ax.startY+a0*ax.y;if(ax.roundTargetPos){aZ.x=Math.round(aZ.x);aZ.y=Math.round(aZ.y)}if(ax.modifyTarget){aZ=ax.modifyTarget.call(H,aZ,E)}ax.amountX=aZ.x-ax.startX;ax.amountY=aZ.y-ax.startY;a0=ax.factorFrames/100;ax.frames=ax.offsetFrames+Math.round(a0*Math.abs(ax.amountX)+a0*Math.abs(ax.amountY));if(ax.frames<ax.minFrames){return false}return true};this.isAfterTouchRunning=function(){return ax.running};var w=function(aY){if(typeof(aT.onAfterTouchStart)=="function"){aT.onAfterTouchStart.call(H,aY,t,E)}ax.running=true;ax.evtUp=aY;if(ax.fnStartStopAfterTouch){ax.fnStartStopAfterTouch.call(H,true,ax.evtMove,E)}else{if(ax.useAnimationFrame){ax.animationFrameRun=requestAnimationFrame(I)}else{ax.intervalRun=setInterval(I,16)}}return true};var aF=function(aZ,aY,a1,a0){return a1*((aZ=aZ/a0-1)*aZ*aZ+1)+aY};var I=this.runAfterTouch=function(){var aY=false;ax.pos++;t.x=aF(ax.pos,ax.startX,ax.amountX,ax.frames);t.y=aF(ax.pos,ax.startY,ax.amountY,ax.frames);e.call(H,ax.evtMove,t,E);if(ax.pos==ax.frames){A(true)}else{if(ax.useAnimationFrame){ax.animationFrameRun=requestAnimationFrame(I)}aY=true}return aY};this.enableAfterTouch=function(aY){if(ax.enabled==aY){return}if(!aY){A()}ax.enabled=aY};var A=function(aY){if(!ax.running){return}if(ax.fnStartStopAfterTouch){ax.fnStartStopAfterTouch.call(H,false,ax.evtMove,E)}else{if(ax.useAnimationFrame){if(ax.animationFrameRun){cancelAnimationFrame(ax.animationFrameRun)}}else{if(ax.intervalRun){clearInterval(ax.intervalRun);ax.intervalRun=b}}}if(typeof(ax.onAfterTouchEnd)=="function"){ax.onAfterTouchEnd.call(H,ax.evtMove,E)}ax.evtMove=b;ax.running=false;ax.evtUp._FSI_Canceled=(aY!==true);ax.evtUp._FSI_fromAfterTouch=true;aN.call(H,ax.evtUp,t,E)};var Z=function(){ax.x=(2*ax.x+aP.x-ax.lastX)/5;ax.y=(2*ax.y+aP.y-ax.lastY)/5;ax.lastX=aP.x;ax.lastY=aP.y};var aw=this.setCapture=function(aY,a0){var aZ=af(aY,a0);if(aZ){ar.captureScrollUser=aY;ar.capturePinchUser=a0}return aZ};var af=function(aY,a0){var aZ=0;if(aY){aZ+=2}if(a0){aZ+=4}if(aZ==ar.nCheck){return}ar.nCheck=aZ;ar.captureScroll=aY;ar.capturePinch=a0;if(a.BrowserSupports.cssTouchAction()){N(aY,a0)}return true};var N=function(aY,a2){var a1;switch(ar.nCheck){case 0:a1="auto";break;case 2:a1="pinch-zoom double-tap-zoom ";break;case 4:a1="pan-x pan-y double-tap-zoom";break;default:a1="double-tap-zoom"}ar.cssTouchAction=a1;for(var a0=0;a0<l.length;a0++){var aZ=l[a0];o(aZ,ar.cssTouchAction)}};var j=function(){if(ap.length<1){return 0}var aZ=Math.abs(ap[1].x-ap[0].x);var aY=Math.abs(ap[1].y-ap[0].y);var a0=ak.nPinchDistance=Math.sqrt(aZ*aZ+aY*aY);return a0};var ag=function(aY){u=false;if(!ai){return}var aZ=ap.length;if(!aM){u=(aZ==1&&ar.captureScroll);return}if(ak.pointerCount!=aZ){O(aY);if(aZ>1){ae();ak.nPointers=aZ;switch(aZ){case 2:ak.started=true;ak.name="pinch";ak.nType=1;if(typeof(aT.onPinchStart)=="function"){K(aY);ak.nPinchDistance=0;ak.nPinchDistance=j();ak.pinchDistanceStart=ak.pinchDistanceLast=ak.nPinchDistance;ak.pinchDistanceStartMaxed=Math.max(aq,ak.pinchDistanceStart);aY._FSI_PinchDistance=ak.nPinchDistance;aT.onPinchStart.call(H,aY,aP,E)}break;default:ak.started=true;ak.name="unknown";ak.nType=-1}if(ak.started){y=true;if(n){aI();n=false;aY._FSI_Canceled=true;aN.call(H,aY,t,E)}if(typeof(aT.onGestureStart)=="function"){K(aY);aT.onGestureStart.call(H,aY,aP,E)}}}else{if(aZ<1){ae()}}ak.pointerCount=aZ;u=false;if(aZ==1){if(ar.captureScroll){u=true}}else{if(ar.capturePinch&&ak.nType==1){u=true}}}return ak.started};var ae=function(){if(!ak.timeoutRestartDown){return}clearTimeout(ak.timeoutRestartDown);ak.timeoutRestartDown=b};var B=function(){if(aa!=1){return}f(V);ae()};var K=function(aY){aY._FSI_Gesture=ak.name;aY._FSI_GestureType=ak.nType;aY._FSI_PointerCount=ak.nPointers};var O=function(aY){if(!ak.started){return}ak.started=false;if(!aY){aY={}}if(ak.nType==1&&typeof(aT.onPinchEnd)=="function"){K(aY);aY._FSI_PinchDistance=ak.nPinchDistance;aT.onPinchEnd.call(H,aY,aP,E)}if(typeof(aT.onGestureEnd)=="function"){K(aY);aT.onGestureEnd.call(H,aY,aP,E)}ak.name="none";ak.nType=0;if(aY&&aa==1){ae();ak.timeoutRestartDown=setTimeout(B,20)}};am()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderCSSSkin!=b){return}a.LoaderCSSSkin=function(){var k=this;var d=0;var f={};var e=0;var g=new a.CORSLoader();var c=function(m){var l=false;try{if(m.cssRules!=b){l=m.cssRules}else{l=m.rules}}catch(n){console.error(n.message)}return l};var h=function(n,q,p,r){var m=this;var l;this.uniqueID=e++;this.bReleased=false;this.getSkinName=function(){return q.getSkinName()};this.callReadyDelayed=function(s,t,u){l=setTimeout(function(){m.callReady(s,t,u)},1)};this.callReady=function(s,t,u){o();if(this.bReleased){return}p.call(r,s,t,u)};var o=function(){if(l!=b){clearTimeout(l);l=b}};this.remove=function(){o();if(m.bReleased){return}q.removeWaiter(m.uniqueID);this.bReleased=true}};var j=function(l,n){var m=this;this.sheet=n;this.skinName=l;var o;var p=function(){o=m.rulesReg={};var s=c(n);if(typeof(s)!="object"||s.length<1){return}for(var q=0;q<s.length;q++){var r=s[q];if(typeof(r.selectorText)=="string"){o[r.selectorText]=r.style}}};this.getStyle=function(q,t,s){if(o==b){p()}var r=b;if(o[q]!=b){r=o[q][t];if(t=="content"){r=r.replace(/^["']/,"");r=r.replace(/["']$/,"");r=a.trim(r);r=r.replace(/\\"/g,'"')}if(s){r=r.replace(/^[^{]*/g,"");r=r.replace(/[^}]*$/g,"");if(r.length>0){try{r=a.JSON.parse(r)}catch(u){a.console.error("ERROR parsing JSON from CSS selector '"+q+"' property '"+t+"'.");a.console.error(u.message)}}else{r={}}}}if(s&&r==b){r={}}return r}};var i=function(l){var v=false;var m=0;var y={};var s=false;var t=false;var u;var q;var o;var r;o=l.match(/(.*)\/[^/]*$/);o=o[1]+"/";q=l.replace(/\.[^/]*$/,"");q=q.match(/([^/]*)$/);q=q[1].toLowerCase();var n=new j(l);this.removeWaiter=function(z){if(y[z]==b){return}delete y[z];m--};this.addWaiter=function(z){if(z.uniqueID==b){return}if(s){z.callReadyDelayed(t,n,"ALREADY LOADED")}else{if(y[z.uniqueID]==b){y[z.uniqueID]=z;m++;if(!v){w()}}}};this.getSkinName=function(){return q};var p=function(G,B,H,C){var F=false;if(C>299||typeof(B)!="string"){a.console.error("Failed to load Skin CSS (HTTP "+C+"): "+l)}else{F=true;B=B.replace(/\/\*.*\*\//g,"");B=B.replace(/([:|,])\s*url\s*\(\s*['"]*\s*([^)'"]*)[^)]*\)/gi,function(J,L,M){var K=J;if(!M.match(/:\/\//)){K=L+'url("'+o+M+'")'}return K});u=document.createElement("style");u.setAttribute("type","text/css");u.setAttribute("x_generated_by","FSI");u.setAttribute("x_fsi_skin",q);u.appendChild(document.createTextNode(B));var E=document.head;if(!E){E=document.getElementsByTagName("head");if(E&&E.length>0){E=E[0]}}if(E&&E.firstChild){try{var A=E.firstChild;var I=E.getElementsByTagName("style");if(I.length>0){A=I[0]}E.insertBefore(u,A)}catch(D){E.appendChild(u)}}else{E.appendChild(u)}n=new j(q,u.sheet);s=true;t=F}for(var z in y){y[z].callReady(F,n,"onLoaded")}y={};m=0};var w=function(){v=true;if(typeof(l)!="string"||l.length<0){return false}g.load(l,p,"text/css");return true}};this.load=function(l,o,n){var q=false;if(a.versionInternetExplorer<9){q=true}if(q){a.console.error("Unable to load skin: unsupported browser version.");if(n){n.call(o,false)}return false}if(a._FSIViewerLocation==b||typeof(l)!="string"||l.length<1){a.console.error("Unable to load skin:");if(a._FSIViewerLocation==b){a.console.error("FSI Viewer path not known")}else{a.console.error("Invalid skin URL "+l)}if(n){n.call(o,false)}return false}var m=l;if(m.indexOf("http")!=0){m=a._FSIViewerLocation+"/skins/"+m}if(!m.match(/\.css$/)){m+=".css"}var p;if(f[m]==b){d++;p=f[m]=new i(m)}else{p=f[m]}var r=new h(m,p,n,o);p.addWaiter(r);return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderJavascript!=b){return}a.LoaderJavascript=function(){var e={};this.load=function(h,l,n,j,m){var k=e[h];if(n==b){n=window}if(typeof(j)!="function"){return false}if(k==b){k=e[h]={};k.path=h;k.loaded=false;k.failed=false;f(k);if(!g(k)){k.failed=true;k.loaded=true;k.addNodeFailed=true}}else{if(k.oListeners[l]!=b){d(h,l)}}k.nListeners++;var i=k.oListeners[l]={};i.argScope=n;i.argFunction=j;i.oPassThrough=m;if(k.loaded==true){c(k)}return true};var d=this.release=function(h,j){var i=e[h];if(i==b){return}if(i.oListeners[j]!=b){delete i.oListeners[j];i.nListeners--}};var g=function(m){var i=false;try{var j=document.getElementsByTagName("head");if(j&&j.length>0){j=j[0];var k=m.node=document.createElement("script");var l=m.onLoad=function(o){if(o.type=="error"){m.failed=true;c(m)}else{m.failed=false;c(m)}m.loaded=true};a.addEvent(k,"load",l);var h=m.onError=function(o){m.failed=true;c(m);m.loaded=true};a.addEvent(k,"error",l);j.appendChild(k);k.src=m.path;i=true}}catch(n){}return i};var c=function(j){var h=!j.failed;a.removeEvent(j.node,j.onLoad);a.removeEvent(j.node,j.onError);for(var k in j.oListeners){var i=j.oListeners[k];i.argFunction.call(i.argScope,h,j.path,i.oPassThrough)}f(j)};var f=function(h){h.oListeners={};h.nListeners=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.AboutWindow!=b){return}a.AboutWindow=function(d,l){var n=this;var e;var g;var h;var f;var i;var j;var m=function(){e=document.createElement("div");a.setStyleAttr(e,"position: absolute;z-index:1000;width:12em;");e.className="fsi-ui-info-window";h=document.createElement("div");h.className="fsi-ui-title";f=document.createElement("div");f.style.display="inline-block";f.innerHTML=l.title;h.appendChild(f);j=document.createElement("div");j.style.display="inline-block";j.style["float"]="right";j.style.cursor="pointer";j.innerHTML="X";h.appendChild(j);e.appendChild(h);g=document.createElement("div");g.className="fsi-ui-content";var p=l.strLongVersion;p="<h3>"+p.replace(/ build/,'</h3><span class="small">build')+"</span>";var o;if(l.strCopyright==b){o="<br/><br/>&copy; 2016 NeptuneLabs GmbH<br/>";o+='<hr/><a style="color:inherit;text-decoration:none" href="//www.neptunelabs.com" target="_blank">www.neptunelabs.com</a><br/><br/><span class="small">FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany<br/></span>'}else{l.strCopy=l.strCopyright}p+="<br/>"+o;g.innerHTML=p;e.appendChild(g);d.appendChild(e);a.addEvent(e,"click",k);c()};var c=function(){var p=a.getElementPosition(d);p.width=(p.right-p.left);p.height=(p.bottom-p.top);var o=a.getElementPosition(e);o.width=(o.right-o.left);o.height=(o.bottom-o.top);e.style.left=Math.round(0*p.left+(p.width-o.width)/2)+"px";e.style.top=Math.round(0*p.left+(p.height-o.height)/2)+"px"};var k=this.destroy=function(){if(typeof(l.fnOnDestroy)=="function"){if(!l.fnOnDestroy.call(this)){return}}a.removeEvent(e,"click",k);a.removeChild(e.parentNode,e)};m()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(k){var m=this;var d=[];var g={};var h={};var i=0;m._strClassName="$FSI.CustomEventListener";var l=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};var j=this.destroy=function(){for(var n=0;n<d.length;n++){var o=d[n];f(o.element,o.fn)}d=[];g={};h={};m.onDestroy()};this.fireEvent=function(n,o){if(!n||!n.enabled){return false}if(typeof(o)!="object"){o={}}if(n.paused){o.FSI_paused=true}o.FSI_custom_event=true;o.FSI_type=k;o.FSI_target=n.element;n.fn.call(n.element,o);return true};this.fireEvents=function(o){if(typeof(o)!="object"){o={}}o.FSI_custom_event=true;o.FSI_type=k;for(var p=0;p<d.length;p++){var n=d[p];if(n.enabled){if(n.paused){o.FSI_paused=true}else{if(o.FSI_paused){delete o.FSI_paused}}o.FSI_target=n.element;n.fn.call(n.element,o)}}};var c=this.addListener=function(r,q){if(typeof(r)!="object"||typeof(q)!="function"){a.console.error(m._strClassName+": Invalid parameters for addListener");return}if(r.__FSI==b){r.__FSI={}}if(r.__FSI.eventElementID==b){r.__FSI.eventElementListenerCount=1;r.__FSI.eventElementID=a.eventElementID++}else{r.__FSI.eventElementListenerCount++}if(q.__FSIEventFunctionID==b){q.__FSIEventFunctionListenerCount=1;q.__FSIEventFunctionID=a.eventFunctionID++}else{q.__FSIEventFunctionListenerCount++}var o=r.__FSI.eventElementID;var p=q.__FSIEventFunctionID;if(g[o]==b){var n=g[o]={};n.nFunction=0;n.oFunctions={}}if(g[o].oFunctions[p]==b){g[o].nFunction++;g[o].oFunctions[p]=[]}else{a.console.warn(m._strClassName+": There is already a listener for this exact element and function");a.console.log(r);a.console.log(q)}var s={};s.element=r;s.elementID=o;s.fn=q;s.fnID=p;s.instanceListener=m;s.enabled=true;s.paused=false;s.uniqueID=i++;g[o].oFunctions[p].push(s);d.push(s);h[s.uniqueID]=s;m._onListenerAdd(s);m._onListenerCountChange(d.length);return s};this.setListenerProps=function(q,o,p){var n=h[q];if(!n){return false}if(n.props==b){n.props={}}n.props[o]=p;return true};this.enableListener=function(p,o){var n=h[p];if(n==b||n.enabled==o){return}n.enabled=o};this.pauseListener=function(p,o){var n=h[p];if(n==b||n.paused==o){return}n.paused=o};var f=this.removeListener=function(r,q){if(typeof(r)!="object"||typeof(q)!="function"){a.console.error(m._strClassName+": Invalid parameters for removeListener");return}if(r.__FSI==b||r.__FSI.eventElementID==b||q.__FSIEventFunctionID==b){if(q.__FSIEventFunctionID==b){a.console.error(m._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(m._strClassName+": Element not registered for listener in removeListener")}return}var n=r.__FSI.eventElementID;var p=q.__FSIEventFunctionID;if(!g[n]){a.console.error(m._strClassName+": No registered listener for this element in removeListener");return}var o=g[n].oFunctions[p];if(o==b||typeof(o.pop)!="function"){a.console.error(m._strClassName+": No registered listener for this function in removeListener");return}var s=o.pop();s.fn.__FSIEventFunctionListenerCount--;s.element.__FSI.eventElementListenerCount--;if(s.element.__FSI.eventElementListenerCount==0){delete s.element.__FSI.eventElementListenerCount;delete s.element.__FSI.eventElementID}if(s.fn.__FSIEventFunctionListenerCount==0){delete s.fn.__FSIEventFunctionListenerCount;delete s.fn.__FSIEventFunctionID}if(o.length==0){delete g[n].oFunctions[p];g[n].nFunction--;if(g[n].nFunction==0){delete g[n]}}delete h[s.uniqueID];e();m._onListenerRemove(s);m._onListenerCountChange(d.length);return s};this.getEventListenerByID=function(n){return h[n]};this.getListenerObjectByID=function(n){return h[n]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var o in g){var q=g[o].oFunctions;for(var p in q){var n=q[p];d=d.concat(n)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(n){};this._onListenerAdd=function(o,n){};this._onListenerRemove=function(o,n){};this.triggerEvent=function(n){};this.triggerEvents=function(){};this.setListenerProps=function(p,n,o){};this.onDestroy=function(){};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerDocumentZoom!=b){return}a.CustomEventListenerDocumentZoom=a.oCustomEventListenerClasses.FSIDocumentZoomChange=function(){var p=this;var c=false;var g;var h;var o=0;var l=0;var f=false;var e;var n;a.CustomEventListener.prototype.constructor.call(p,"FSIDocumentZoomChange");p._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(document,"visualviewportchanged",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(document,"visualviewportchanged",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(q){var r=(q>0);if(r!=c){if(r){j()}else{i()}}};var m=function(){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=r;k(r);q=true}else{q=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return q};this.triggerEvent=function(s){var q=p.getEventListenerByID(s);if(!q){return}var r={};r.FSI_scale=a.getDocumentScale();r.FSI_scale_with_pixel_ratio=a.getDocumentScaleWithPixelRatio();p.fireEvent(q,r)};this.triggerEvents=function(){k(a.getDocumentScaleWithPixelRatio())};var k=function(r){var q={};q.FSI_scale=a.getDocumentScale();q.FSI_scale_with_pixel_ratio=r;p.fireEvents(q)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerViewport!=b){return}a.CustomEventListenerViewport=a.oCustomEventListenerClasses.FSIViewport=function(){var m=this;var d=false;var i=new a.Rect(0,0,0,0);var j=new a.Rect(0,0,0,0);var n=new a.Rect(0,0,0,0);var J=new a.Rect(0,0,0,0);var v={left:0,top:0};var U;var D;var E="";var g=false;var q=b;var A;var k=1;var p=1;var s=10;var H;var u=0;var w;var G;var T=0;var c=100;var p=1;var B=1;var P=32;var z;var r;var I=a.BrowserSupports.visualViewportAPI();try{r=window.frameElement}catch(R){}a.CustomEventListener.prototype.constructor.call(m,"FSIViewport");m._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){o()};var O=function(){if(d){return}d=true;h(a.addEvent);H=a.addCustomEvent(m,"FSIDocumentZoomChange",K);p=a.getDocumentScale();B=p*a.getDevicePixelRatio()};var o=function(){if(!d){return}d=false;h(a.removeEvent);a.removeCustomEvent(m,"FSIDocumentZoomChange",K);H=b;if(q){clearInterval(q);q=b}t();u=0;if(z!=b){clearTimeout(z);z=b}};var h=function(V){var e=window;V(e.document,"scroll",l,false);V(e,"resize",l,false);if(I){V(e.document,"visualviewportchanged",l,false)}else{if(a.isTouch&&!a.isIETouch&&r){V(e,"touchmove",S,false)}}while(e.frameElement){e=e.parent.window;if(e){V(e.document,"scroll",l,false);if(I){V(e.document,"visualviewportchanged",l,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){V(e,"touchmove",S,false)}}V(e,"resize",l,false)}}V(window,"orientationchange",l,false)};this.setListenerProps=function(X,V,W){if(typeof(V)!="string"){return false}var e=m.getListenerObjectByID(X);if(!e){return false}switch(V){case"treshold":if(e.tresholdEnd!=b){u--;e.tresholdEnd=b}if(W&&W>0){u++;e.tresholdEnd=W}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=W;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=b){u--}};this._onListenerCountChange=function(e){var V=(e>0);if(V!=d){if(V){O()}else{o()}}};var K=function(e){p=e.FSI_scale;B=e.FSI_scale_with_pixel_ratio;l()};var l=function(){if(z!=b){return}z=setTimeout(M,P);M()};var M=function(){if(z!=b){clearTimeout(z);z=b}var e=false;var V=N();if(E!=V){E=V;e=true;f()}return e};var L=function(){p=a.getDocumentScale();B=p*a.getDevicePixelRatio();N()};this.triggerEvent=function(W){var e=m.getEventListenerByID(W);if(!e){return}L();var V=Q();m.fireEvent(e,V)};this.triggerEvents=function(){L();f()};var f=this.fireEvents=function(){var V=Q();var W=m.getListenersArray();for(var X=0;X<W.length;X++){var e=W[X];if(!e.fireTresholdEventOnly){m.fireEvent(e,V)}}C()};var Q=function(){var e={};e.FSI_scale=a.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=j;e.FSI_scroll=v;e.FSI_client_rect_body_top=U;e.FSI_viewport_size_top=D;return e};var N=function(){D=a.getViewportSize(a.topWindow);U=a.getBoundingClientRect(a.topWindow.document.documentElement);i.left=a.topWindow.pageXOffset;i.top=a.topWindow.pageYOffset;i.right=i.left+D.width;i.bottom=i.top+D.height;if(r){var e=a.getViewportSize(window);var V=a.getWindowOffset(window);j.left=0;j.top=0;j.right=j.left+e.width;j.bottom=j.top+e.height;v.left=-window.pageXOffset;v.top=-window.pageYOffset;n.copyRect(j);n.left=-V.x+i.left+U.left;n.top=-V.y+i.top+U.top;n.right=n.left+D.width;n.bottom=n.top+D.height;j.interSectRectValidate(n);var W=a.getBoundingClientRect(window.document.body);J.copyRect(j);J.offsetRect(V.x+W.top,V.y+W.left)}else{v.left=U.left;v.top=U.top;J.copyRect(i);j.copyRect(i);j.offsetRect(U.left,U.top)}return p+"_"+J.toString()+" "+D.width+" x "+D.height};var S=function(){A=s;if(q!=b){return}q=setInterval(y,100)};var y=function(){if(!M()){A--}else{A=s}if(A<1){clearInterval(q);q=b}};var t=function(){if(G!=b){clearInterval(G);G=b;w=b}};var C=function(){t();if(u>0){G=setInterval(F,c)}};var F=function(){T+=c;if(w==b){T=c;w=[];var W=m.getListenersArray();for(var X=0;X<W.length;X++){var e=W[X];if(e.tresholdEnd>0){w.push(e)}}}var V;for(var X=w.length-1;X>-1;X--){var e=w[X];if(e.tresholdEnd<=T){if(m.getEventListenerByID(e.uniqueID)!=b){if(V==b){V=Q();V.FSI_after_treshold=true}m.fireEvent(e,V)}w.splice(X,1)}}if(w.length==0){t()}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerElementDimension!=b){return}a.CustomEventListenerElementDimension=a.oCustomEventListenerClasses.FSIElementDimension=function(){var m=this;var c=false;var i=25;var f;var d=0;var g={};g[0]=25;g[25]=50;g[50]=100;g[75]=250;var j=76;var e=-1;a.CustomEventListener.prototype.constructor.call(m,"FSIElementDimension");m._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(n){if(n<1){clearInterval(f);f=b}else{if(f==b){f=setInterval(l,g[0])}}};this._onListenerAdd=function(n){n.__elementWidth=n.element.offsetWidth;n.__elementHeight=n.element.offsetHeight};this.setListenerProps=function(q,o,p){if(typeof(o)!="string"){return false}var n=m.getListenerObjectByID(q);if(!n){return false}switch(o){case"treshold":if(p&&p>0){n.tresholdEnd=p}break;case"fireTresholdEventOnly":n.fireTresholdEventOnly=p;break}};var l=function(){var o=m.getListenersArray();var r=false;for(var q=0;q<o.length;q++){var n=o[q];if(n.__elementWidth!=n.element.offsetWidth||n.__elementHeight!=n.element.offsetHeight){r=true;if(n.tresholdEnd){n.treshold=i}k(n,false)}else{if(n.treshold>0){n.treshold+=i;if(n.treshold>=n.tresholdEnd){k(n,true);n.treshold=0}}}}if(r){d=0;h(g[0])}else{if(d<j){d++;var p=g[d];if(p!=b){h(p)}}}};var h=function(o){if(o==i||f==b){return}i=o;clearInterval(f);f=setInterval(l,i)};var k=function(n,p){var o={};if(p){o.FSI_after_treshold=n.treshold}o.FSI_target=n.element;o.FSI_dimension_old={width:n.__elementWidth,height:n.__elementHeight};n.__elementWidth=n.element.offsetWidth;n.__elementHeight=n.element.offsetHeight;o.FSI_dimension={width:n.__elementWidth,height:n.__elementHeight};if(p||!n.fireTresholdEventOnly){m.fireEvent(n,o)}};this.triggerEvent=function(o){var n=m.getEventListenerByID(o);if(!n){return}if(n.tresholdEnd){n.treshold=1}k(n)};this.triggerEvents=function(){var n=m.getListenersArray();for(var o=0;o<n.length;o++){if(n[o].tresholdEnd){n[o].treshold=1}k(n[o])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerMouseWheel!=b){return}a.CustomEventListenerMouseWheel=a.oCustomEventListenerClasses.FSIMouseWheel=function(){var c=this;var f=false;var e=100000;a.CustomEventListener.prototype.constructor.call(c,"FSIMouseWheel");c._strClassName="$FSI.CustomEventListenerMouseWheel";this._onListenerAdd=function(g){g.callback=function(h){d(g,h)};a.addEvent(g.element,"mousewheel",g.callback);a.addEvent(g.element,"DOMMouseScroll",g.callback)};this._onListenerRemove=function(g){a.removeEvent(g.element,"mousewheel",g.callback);a.removeEvent(g.element,"DOMMouseScroll",g.callback)};var d=function(g,h){var i=0;if(h.detail){i=h.detail}else{if(h.wheelDelta){i=-h.wheelDelta}}if(i!=0){e=Math.min(e,Math.abs(i))}h.FSI_delta=-i;h.FSI_weighted_delta=h.FSI_delta/e;c.fireEvent(g,h)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.NavigatorWindow!=b){return}a.NavigatorWindow=function(o,B,v,E){var j=this;var ag=o.iViewer;var t;var y;var q={};var ab=0;var m;var n,C;var g;var F,p;var h,e;var R,Q;var u=false;var w=false;var s=o.getRootContainer();var L=o.getElementSpace();var M=o.getinPlaceZoom();var f=ag.getImageIsTransparent();var U=o.getDrawRatio();var r=ag.getSrcDim();var ae=o.getdrawRatioUnZoomed();var G=o.getdrawRatioUnResized();var W=o.viewport;var I;var V;var c={x:2,y:2};var d;var af;var N=false;var Y;var P;var ad={};var H;var A;var J;var aa=function(){u=B.result.autoHideNav;m=[];ab=4;g=16;var ak=l(B.result.navWidth,W.width,120);var ar=l(B.result.navHeight,W.height,120);var ao=Math.min(L.width-2*ab,ak);var ap=Math.min(L.height-2*ab-20,ar);ao=Math.max(60,ao);ap=Math.max(40,ap);var an,ai;an=ao;ai=an/ae.imageWidth*ae.imageHeight;if(ai>ap){ai=ap;an=ai/ae.imageHeight*ae.imageWidth}n=Math.max(10,Math.round(an));C=Math.max(10,Math.round(ai));var aq=n+2*ab;var am=C+2*ab+g;F=aq;p=am;j.sprite=new a.Sprite(s,aq,am,500);a.addClass(j.sprite.element,"fsi-ui-nav-window");j.sprite.element.style.width=j.sprite.element.style.height="auto";if(v){d=v.navFrameBorderColor;af=v.navFrameBackgroundColor}else{d="red";af="rgba(255,255,255,0.5)"}var al=j.sprite.getClientDim();j.canvasSprite=new a.Sprite(j.sprite.element,n,C,2,true,"inline");j.canvasSprite.element.style.clear="both";a.addClass(j.canvasSprite.element,"fsi-ui-nav-window-image");if(B.hasPlugin("zoommeter")){I=document.createElement("div");a.addClass(I,"fsi-ui-nav-window-zoom-text");j.sprite.element.appendChild(I);V=document.createTextNode("100 %");I.appendChild(V);var aj=B.getPluginParameter("zoommeter","color");if(aj){I.style.color="#"+aj}N=B.getPluginParameter("zoommeter","srcrelative",false,true)}j.sprite.updateMargins();j.sprite.updateDimension();var ah={};ah.smoothing={enabled:true,factor:7,fEndDiff:0.03};A=new a.TouchHandler(j.canvasSprite.canvas,ah,S,X,T);P=j.canvasSprite.ctx;K();if(u){j.sprite.show(false)}};var Z=this.destroy=function(){if(A){A.destroy();A=b}a.removeChild(s,j.sprite.element)};var i=this.enable=function(ah){A.enable(ah)};var l=function(ak,ai,aj){var ah=parseInt(ak);if(typeof(ak)=="string"&&ak.indexOf("%")!=-1){ah=Math.max(0,Math.min(100,ah));ah=Math.round(ah*ai/100)}else{ah=parseInt(ak)}if(isNaN(ah)){ah=aj}return ah};this.isDragging=function(){return w};var S=function(ai,al){o.stopAutoSpin();var aj=a.getElementPosition(j.canvasSprite.element);h=-aj.left;e=-aj.top;var ah=al.x+h;var ak=al.y+e;if(ah<0||ak<0||ah>n||ak>C){return false}w=true;o.stopDesktopAnimation();o.stopAfterTouch();z(al,true);o.autoShowHideHotSpots(false);return true};var X=function(ah,ai){z(ai,true)};var T=function(ah,ai){w=false;z(ai,false);o.onAfterinPlaceZoomChanged();o.autoShowHideHotSpots(true)};var z=function(ak,ai){var ah=ak.x+h-n/2;var aj=ak.y+e-C/2;M.panPos.left=J*-ah;M.panPos.top=J*-aj;o.updateInPlaceZoom(ai)};var O=function(ay,aw,ak,am,an){var ap,al,ah,aj,au,ax,ar,ao;ar=aw;ao=ak;aw=Math.max(1,Math.round(aw/2));if(aw<am){aw=am}ak=Math.max(1,Math.round(ak/2));if(ak<an){ak=an}al=aj=document.createElement("canvas");aj.setAttribute("crossorigin","anonymous");aj.width=aw;aj.height=ak;au=aj.getContext("2d");au.drawImage(ay,0,0,ar,ao,0,0,aw,ak);var ai=document.createElement("canvas");ai.setAttribute("crossorigin","anonymous");var at=ai.getContext("2d");var aq=false;while(aw>am||ak>an){ap=al;ar=aw;ao=ak;if(aq){al=aj;ah=au;aq=false}else{al=ai;ah=at;aq=true}aw=Math.round(aw/2);if(aw<am){aw=am}ak=Math.round(ak/2);if(ak<an){ak=an}al.width=aw;al.height=ak;ah.drawImage(ap,0,0,ar,ao,0,0,aw,ak)}var az;try{az=ah.getImageData(0,0,aw,ak);Y=D}catch(av){az=al;Y=k}return az};var D=function(ai,ah,aj){P.putImageData(ai,ah,aj)};var k=function(ai,ah,aj){P.drawImage(ai,ah,aj)};var K=function(){switch(c.x){case 1:R=(L.width-j.sprite.width())/2;break;case 2:R=L.width-j.sprite.width()-j.sprite.margin.right;break;default:R=j.sprite.margin.left;break}switch(c.y){case 1:Q=(L.height-j.sprite.height())/2;break;case 2:Q=L.height-j.sprite.height()-j.sprite.margin.bottom-ag.getMenuHeight("navWindow");break;default:Q=j.sprite.margin.top;break}j.sprite.setPos(R,Q)};this.setContainerSize=function(ah,ak,aj){var ai=j.sprite.element.style.display;j.sprite.element.style.display="block";j.sprite.updateDimension();U=ak;ae=aj;L=ah;K();j.sprite.element.style.display=ai};var ac=this.autoShowHide=function(ah){if(!u){return}if(M.scale<1.05){j.sprite.show(false,ah)}else{j.sprite.show(true,ah)}};this.setPreviewImageSize=function(ah,ai){if(ah==b){H=b}else{ad.width=ah;ad.height=ai;H=ad}};this.update=function(aB,am){ac(true);if(!j.sprite.isVisible()){return}J=U.imageWidth/n;var ar=P;if(m[aB]==b){var av=o.getPreviewImage(aB);var ax=(H)?H:av;m[aB]=O(av,ax.width,ax.height,n,C)}ar.lineWidth=0;var ao=0;var an=0;if(I&&t!=am){t=am;var aw,ah;if(N){aw=am*G.imageWidth/r.width}else{aw=U.imageWidth/ae.imageWidth}aw=Math.round(100*10*aw)/10;ah=""+aw;if(ah.indexOf(".")==-1){ah+=".0"}ah+=" %";V.nodeValue=ah}Y(m[aB],ao,an);var aA=M.scale;if(aA>1.05){var aq=n/G.imageWidth/aA;var ak=aq*W.width;var at=aq*W.height;var ay=n/U.imageWidth;var ap=(n-ak)/2-M.panPos.left*ay;var az=(C-at)/2-M.panPos.top*ay;var aj=ao+ap;var ai=an+az;var al=ao;var au=an;if(ak<4||at<4){aj+=ak/2;ai+=at/2;ar.strokeStyle=d;ar.strokeRect(aj,ai-3,1,7);ar.strokeRect(aj-3,ai,7,1)}else{ar.save();ar.fillStyle=af;ar.beginPath();ar.rect(al,au,n,ai-au);ar.rect(al,ai,aj-al,at);ar.rect(aj+ak,ai,n-ap-ak,at);ar.rect(al,ai+at,n,C-az-at);ar.closePath();ar.clip();ar.fillRect(ao,an,n,C);ar.restore();ar.save();ar.strokeStyle=d;ar.beginPath();ar.rect(ao,an,n,C);ar.clip();ar.strokeRect(aj,ai,ak,at);ar.restore()}}};this.reverseImageSequence=function(){m.reverse();m.unshift(m.pop())};aa()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MenuBar!=b){return}a.MenuBar=function(s,n,j){var v=this;var g=this.myViewer=s.iViewer;var w=s.getRootContainer();var K=s.getElementSpace();var m;var A;var B;var c=s.getToolTipObject();var e=0;var h=this.nIconWidth=32;var H=this.nIconHeight=32;var p=[];var y=b;this.bEnabled=b;var F=this.oButtonOffset={x:0,y:0};var o=false;var q={};var l={};var u=0;var E=0;var t="";var d="fsi-ui-button-icon";var C=function(){v.btnID=0;v.sprite=new a.Sprite(w,K.width,u,450,b,b,"fsi-ui-menu-bar");v.sprite.element.style.width="100%";v.iconClassNamesNormal=d;v.iconClassNamesHover=d+" "+d+"-hover";v.iconClassNamesActive=d+" "+d+"-active";v.iconClassNamesDisabled=d+" "+d+"-disabled";y=setTimeout(z,0)};var z=function(){if(v.sprite.element.offsetHeight!=0||e++>200){y=b;D()}else{y=setTimeout(z,25)}};var D=function(){var M=v.sprite.getClientDim();u=Math.round(M.height);v.sprite.setSize("100%",u);v.setEnabled(false);i();if(typeof(n.urlLogo)=="string"&&n.urlLogo.length>0){m=document.createElement("div");a.addClass(m,"fsi-ui-viewer-logo");a.setStyleAttr(m,"position:absolute;display:none");var L=document.createElement("img");L.src=n.urlLogo;m.appendChild(L);a.addEvent(L,"load",r);v.sprite.element.appendChild(m);a.addEvent(m,"click",g.showAboutWindow)}a.addEvent(v.sprite.element,"mouseup",J);a.addEvent(v.sprite.element,"contextmenu",I);if(o){v.sprite.show(false,false)}j()};var G=this.destroy=function(){if(y!=b){clearTimeout(y);y=b}if(m){a.removeEvent(m,"click",g.showAboutWindow)}a.removeEvent(v.sprite.element,"mouseup",J);a.removeEvent(v.sprite.element,"contextmenu",I);for(var L=0;L<p.length;L++){p[L].destroy()}a.removeChild(w,v.sprite.element)};var J=function(L){if(L.which&&L.which==3){E=new Date().getTime()}};var I=function(M){if(E){var L=new Date().getTime()-E;if(L<300){return}}M.preventDefault&&M.preventDefault()};this.getHeight=function(){return u};var k=function(L,N){var O;if(!L||!N){return O}if(L.indexOf("_")!=-1){var M=L.split("_");switch(M[0]){case"MouseMode":O="";if(N.Mode){O+="<b>"+N.Mode+"</b>"}if(N["Mode"+M[1]]){O+=" "+N["Mode"+M[1]]}break}}return O};this.showButtonToolTip=function(L){if(!c){return}v.showToolTip(L.getCMD(),L.elButton)};this.showToolTip=function(N,M,L,O){if(!c){return}c.show(N,M,L,O,k)};this.hideToolTip=function(){if(!c){return}c.hide()};this.setEnabled=function(L,M){if(v.bEnabled==L){return}v.bEnabled=L;if(M){return}if(L){a.removeClass(v.sprite.element,"fsi-ui-menu-bar-disabled")}else{a.addClass(v.sprite.element,"fsi-ui-menu-bar-disabled")}};this.getButtonEnabled=function(M){var L=l[M];if(L==b){return}return L.bEnabled};this.enableButton=function(N,L){var M=l[N];if(M==b){return false}return M.setEnabled(L)};this.getButtonPressed=function(M){var L=l[M];if(L==b){return false}return L.getPressed()};this.setButtonPressed=function(N,L){var M=l[N];if(M==b){return false}M.setPressed(L);return true};var f=function(M,N){var L;if(q[N]==b){L=q[N]={};L.arButtons=[]}else{L=q[N]}L.arButtons.push(M);M.oGroup=L;M.makeRadioButton()};this.removeButtons=function(L){p=[];q={};l={};i()};this.addButtons=function(N){var M;var R=u-6;var L,Q;var P;if(B){B.remove()}B=new a.Sprite(v.sprite.element,K.width,u,2);a.setStyleAttr(B.element,"position:relative");a.addClass(B.element,"fsi-ui-button-container");for(var O=0;O<N.length;O++){M=N[O];if(M.cmd){if(M.width==b){L=R}else{L=M.width}if(M.height==b){Q=R}else{Q=M.height}P=new a.MenuBarButton(v,B.element,M.cmd,M.bCheckButton);l[M.cmd]=P;p.push(P);if(M.groupID!=b){f(P,M.groupID)}}if(M.enabled===false){v.enableButton(M.cmd,false)}}for(var S in q){q[S].arButtons[0].setPressed(true)}i();r()};var i=function(){var M=0;var L=K.height-u;v.sprite.setPos(M,L)};this.setContainerSize=function(L){var M=v.sprite.element.style.display;v.sprite.element.style.display="block";var N=a.getElementClientDim(v.sprite.element);u=N.height;v.sprite.updateDimension();K=L;v.sprite.setSize("100%",u);i();v.sprite.element.style.display=M;r();v.sprite.show(true)};var r=function(){if(!m){return}m.style.display="";if(m.firstChild!=b&&m.firstChild.offsetWidth>0&&B!=b){var L=(v.sprite.element.offsetWidth-B.element.offsetWidth)/2;if(L-8<m.firstChild.offsetWidth){m.style.display="none"}}};C()};a.MenuBarButton=function(r,f,s,g){var p=this;var h=r;var w;this.bEnabled=true;var i;var m;this.id=h.btnID++;var d={};var k=false;var v;var c;var j="";var t=function(){v=p.elButton=document.createElement("div");a.addClass(v,"fsi-ui-button");c=document.createElement("div");a.addClass(c,h.iconClassNamesNormal);v.appendChild(c);f.appendChild(v);if(s.length>0){j=s.toLowerCase()}else{j==""}if(!a.isMobileDevice){a.addEvent(v,"mousedown",p.onMouseDown);a.addEvent(v,"mouseup",p.onMouseUp);a.addEvent(v,"mouseout",p.onMouseOut);a.addEvent(v,"mouseover",p.onMouseOver)}if(a.isTouch){a.addEvent(v,"touchstart",p.onTouchDown);a.addEvent(v,"touchcancel",p.onTouchUp);a.addEvent(v,"touchend",p.onTouchUp)}q(1)};this.destroy=function(){if(!a.isMobileDevice){a.removeEvent(v,"mousedown",p.onMouseDown);a.removeEvent(v,"mouseup",p.onMouseUp);a.removeEvent(v,"mouseout",p.onMouseOut);a.removeEvent(v,"mouseover",p.onMouseOver)}if(a.isTouch){a.removeEvent(v,"touchstart",p.onTouchDown);a.removeEvent(v,"touchcancel",p.onTouchUp);a.removeEvent(v,"touchend",p.onTouchUp)}};this.getCMD=function(){return s};this.makeCheckButton=function(){g=true};this.makeRadioButton=function(){g=true;k=true};this.getState=function(){return w};var q=this.setState=function(y){if(w==y){return}n(y)};var n=this.setState=function(B){w=B;var A;var C="fsi-ui-button "+j+" ";if(!p.bEnabled){C+="fsi-ui-button-disabled ";A=h.iconClassNamesDisabled}else{A=h.iconClassNamesNormal}switch(w){case 2:C+="fsi-ui-button-hover";A=h.iconClassNamesHover;break;case 3:C+="fsi-ui-button-active";A=h.iconClassNamesActive;break;case 4:C+="fsi-ui-button-active";A=h.iconClassNamesActive;if(p.oGroup!=b){for(var z=0;z<p.oGroup.arButtons.length;z++){var y=p.oGroup.arButtons[z];if(y.id!=p.id){y.setPressed(false)}}}break;default:break}v.className=C;c.className=A};this.onMouseOver=function(y){h.showButtonToolTip(p);if(!p.bEnabled||!h.bEnabled){return}if(w==1){q(2)}};this.onMouseOut=function(y){h.hideToolTip();if(!p.bEnabled||!h.bEnabled){return}if(w==3){p.onMouseUpOutside()}if(w!=1&&w!=4){q(1)}};this.onMouseDown=function(y){if(y.type=="mousedown"){if(y.which!=1){return true}y.cancelBubble=true;if(y.stopPropagation){y.stopPropagation()}if(y.preventDefault){y.preventDefault()}}h.hideToolTip();if(!p.bEnabled||!h.bEnabled){return}if(g){if(w==4){if(!k){q(3)}}else{q(4)}}else{q(3)}o(y)};this.onTouchDown=function(y){p.onMouseDown(y);if(y.preventDefault){y.preventDefault()}};this.onTouchUp=function(y){p.onMouseUp(y);if(y.preventDefault){y.preventDefault()}};this.onMouseUp=function(z){if(!p.bEnabled||!h.bEnabled){return}var y=(z.type=="touchend")?1:2;if(g){if(w==3){q(y)}}else{q(y)}l()};this.onMouseUpOutside=function(y){if(!g){q(1)}l()};this.setEnabled=function(y){if(p.bEnabled==y){return}if(!y&&(w==1||!g)){p.setState(1)}if(y){a.removeClass(v,"fsi-ui-button-disabled")}else{a.addClass(v,"fsi-ui-button-disabled")}p.bEnabled=y;return true};var u=this.getPressed=function(){return(w>2)};var e=this.setPressed=function(y){if(!g){return}if(y){q(4)}else{q(1)}};var o=function(y){h.myViewer.onMenuButtonPress(s,y)};var l=function(){h.myViewer.onMenuButtonRelease(s)};t()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Viewer!=b){return}a.Viewer=function(fD,dO){var ci=new a.ClassDef(this,"FSI Viewer","2016","16.08.4");var aY=ci.instance;a.guessFSIViewerLocation("fsiviewer.js",3);var dn=a.getViewerInstanceID();var f5;var aj;var l;var fL;var Q;var c8;var f3={};var z;var ep;var bi;var cT=false;var E;var db=0;var aw={};var ei=8;var gx=1;var aa;var cV;var d=false;var gh;var fp;var bO;var be;var cF;var ew;var go,cw;var ev;var bj=true;var fQ=100;var bK=true;var d7;var bz;var au;var cC;var gg;var c5;var ee;var q;var ba;var dl=false;var eN=new a.CroppedImage();var eM=new a.Rect();var aB=a.Easing.easeOutCubic;var el;var em={width:0,height:0};var bq;var R;var ap={};var f4;var bh;var aJ={};var ch=10000;var gs=ch;var eu;var bc;var O;var cQ;var aQ={x:0,y:0,z:0};var fX;var Z;var aS=new a.Rect(0,0,-1,-1);var dh=new a.Rect(0,0,-1,-1);var eT=new a.Rect(0,0,-1,-1);var e8=new a.Rect(0,0,-1,-1);var fn=new a.Rect(0,0,-1,-1);var aE=new a.Rect(0,0,0,0);var fU=new a.Rect(0,0,0,0);var at=false;var P=true;var D;var dA=false;var bp=false;var bs=false;var cE=true;var di=false;var y;var eF=false;var gl;var cN=false;var fS=true;var gf=false;var fi=false;var eO;var bH=new a.Rect(0,0,0,0);var d2=0;var cW;var co=0;var bk=0;var ab=0;var aL,cZ;var dT=0;var dH=0;var ca=0;var da={x:0,y:0};var U={};var a0={};var t={};var d4="auto";var d6;var eP=1;var an;var a8;var fM=true;var aN={};aN.cursors={};var cl;var eY=b;var f;var cI;var gv=false;var d9=false;var ds=true;var cS=true;var fF=false;var b1=false;var ez=false;var e1;var bN;var f8;var bd=false;var fV;var d5;var a1;var eC={};var b7;var cU;var fw;var b8;var du;var W;var dE;var dQ;var c3;var gr;var e=[];var gd=[];var dc;var dj={};var cc={};var fz;var dD=false;var gq;var dm;var K;var de;var T;var gi={};var ae;var aZ=f3.viewport={};var c9=a.SVGNameSpaceURL;var fd="1.1";var bg;var ge;var al;var bS=1;var cp;var az;var bU;var cn=0;var ex;var eS=0;var et=1;var ak=2;var fr=eS;var fC;var h=false;var I;var by;var fh;var gm;var aC=false;var e6=false;var fE;var eg=1;var bI={};var C=false;var a3;var fs;var fN;var eX;var cv={width:0,height:0};var bJ=false;var bZ=/((\?)|&)(width|height)=[^&]*/ig;var aA=false;var dC;var bV="&limit=0,360";var eq;var c1=true;var f6=false;var u;var ed=b;var gj;var eQ=false;var bD;var b3="&effects=Matte(FFFFFF)";var c;var ai;var ey;var aq;var cB={};var a9=true;var fu;var ct;var fb;var dg;var b0;var f0;var bm=0;var cb=0;var bn={};var cq=false;var eo=true;var F;var eJ={};var ah=0;var aP={};var cr={};var dF={};var c6=new a.EmptyDebugger();var gn=function(gy,o){if(o&&!c6.on&&gy.on){fz.stopPendingRequests();aY.destroy();aY.init(K,dF,true);aY.start();return true}c6=gy;if(c6.on){c6.setPrefix(ci.strClassName+" ["+K+"]")}};this.init=function(gy,gC,o){if(typeof(gy)=="object"){if(typeof(gy.id)=="string"){K=gy.id}}else{if(typeof(gy)=="string"){K=gy}}if(!K){K="fsi.viewer #"+dn}if(aY._fsi_parameters){gC=aY._fsi_parameters;delete aY._fsi_parameters;aY._fsi_parameters=b}if(a.isMobileDevice){fC=5000000}else{fC=8000000}if(fF){aY.destroy()}var gA;if(typeof(gy)=="object"&&gy.tagName!=b){gA=gy}else{gA=document.getElementById(gy)}if(typeof(gC)=="object"&&typeof(window[gC.oninit])=="function"){var gz=window[gC.oninit](aY,K,gC)}dF=(gC&&typeof(gC)=="object")?a.cloneParameters(gC):{};fJ();var gB=dF;if(o){gB=a.cloneObject(dF);gB.debug=true}fz.init(gB);if(c6.on){c6.log(aY.getVersion())}w();if(!gA){c6.error("A DOM element with the id '"+gy+"' could not be found. Aborting.");return}bg="1.5px";if(a.isSmallMobileDevice){c6.log("Small mobile Device detected.");bJ="fsi-ui-hotspot-mobile fsi-ui-hotspot-mobile-small";bg="4px"}else{if(a.isMobileDevice){c6.log("Mobile Device detected.");bJ="fsi-ui-hotspot-mobile"}}if(gA.firstChild!=b){gA.innerHTML=""}aj=gA;if(aj.tagName.toLowerCase()!="fsi-viewer"){a.addClass(aj,"fsi-viewer")}aj.setAttribute("x-fsi-id",K);ex=(a.isMobileDevice)?0.2:0.1;if(!f5){f5=document.createElement("div");f5.className="fsi-viewer-root";a.setStyleAttr(f5,"position:relative;left:0px;top:0px;padding:0px;margin:0px;border:0px none;z-index:0;width:100%;height:100%;text-align:left;vertical-align:top;");gA.appendChild(f5)}ad();if(c6.on){c6.log("Container element: "+ae.width+" x "+ae.height+" ("+gA.nodeName+")")}fF=true;ba=a.getCSSTransformStyleName();if(ba=="msTransform"||(!isNaN(a.versionInternetExplorer)&&a.versionInternetExplorer<11)){d7=false;bK=false}else{if(a.mobileOS=="ios"){d7=false}else{d7=true}}d7=false};var fJ=function(){var o={};o.onConfigsReady=dx;o.onDebuggerChange=gn;fz=new a.Config(null,o)};this.getInitDone=function(){return fF};var ad=function(){ae=a.getElementDimension(f5);var o=(fL&&fL.minInstanceSize>1)?fL.minInstanceSize:60;if(ae.width<o||ae.height-cb<o){ae.visible=false;ae.width=o;ae.height=o+cb}else{ae.visible=true}aZ.width=ae.width;aZ.height=ae.height-cb};var bC=function(o){if(bD==o){return}bD=o;gm.style.cursor=aN.cursors[o]};var e2=function(gE,gD,gG,gC,o){var gA=aZ.width*ap.scale;var gy=aZ.height*ap.scale;if(gE==b){gE=gA/2}if(gD==b){gD=gy/2}var gz;if(gG!=b){gz=Math.max(1,Math.min(bI.maxScale,bI.scale+gG))}else{gz=bI.defaultZoom}var gF=gz/bI.scale;var gE=gF*(bI.panPos.left-(gE-gA/2));var gD=gF*(bI.panPos.top-(gD-gy/2));var gB=(gC)?0:o;eh(gE,gD,gz,gB)};var fG=function(o,gB,gz,gy){if(!bI.enabled){return}if(bI.panPos.left==0&&bI.panPos.top==0&&(ge<=1||(O&&bI.targetZoom==1))){return}var gA=(gz)?0:gy;eh(0,0,1,gA)};var ea=function(o){if(ap.scale>1){o.scaleRect(1/ap.scale)}var gH=o.width();var gC=o.height();if(gH<1||gC<1){return}var gD=gH/gC;var gB=aZ.width/aZ.height;if(gD>gB){gC=gH*aZ.height/aZ.width;o.inflateRect(0,gC-o.height())}else{if(gD<gB){gH=gC*aZ.width/aZ.height;o.inflateRect(gH-o.width(),0)}}var gy=ge*aZ.width/gH;gy=Math.max(1,Math.min(bI.maxScale,gy));var gG=gy/ge;var gA=o.left+o.width()/2;var gz=o.top+o.height()/2;var gF=(bI.panPos.left-gA+aZ.width/2)*gG;var gE=(bI.panPos.top-gz+aZ.height/2)*gG;eh(gF*ap.scale,gE*ap.scale,gy)};var eh=function(o,gB,gA,gy){gA=Math.max(1,Math.min(bI.maxScale,gA));d0();bI.pos=0;bI.frames=(gy!=b)?gy:28;if(bI.frames<1){bI.frames=1}bI.sourceZoom=bI.scale;bI.sourceX=bI.panPos.left;bI.sourceY=bI.panPos.top;if(o==b){o=bI.sourceX}if(gB==b){gB=bI.sourceY}var gz=gc(o,gB,gA);bI.targetX=gz.x;bI.targetY=gz.y;bI.targetZoom=gA;bI.dX=gz.x-bI.sourceX;bI.dY=gz.y-bI.sourceY;bI.dZoom=gA-bI.sourceZoom;a2()};var v=f3.stopAfterTouch=function(){if(F){F.cancelAfterTouch()}};var aG=f3.autoShowHideHotSpots=function(o){if(cS==o){return}cS=o;if(!d9||!a.isMobileDevice){return}ds=o;fq(o);df();if(o){gk()}};var a2=function(){if(O){return}bI.lockPanAnimation=false;C=true;aG(false);O=true;gk()};var d0=f3.stopDesktopAnimation=function(){if(O){aG(true);C=false;O=false;bI.pos=bI.frames=0;bI.targetZoom=b;bG();dp();fc();cy()}};var bR=function(){if(O||gv){return}if(typeof aY.onAnimationComplete=="function"){aY.onAnimationComplete(aY)}};var eV=function(){bI.pos++;fo(aB(bI.pos,bI.frames,bI.sourceZoom,bI.dZoom,3));if(!bI.lockPanAnimation){bI.panPos.left=aB(bI.pos,bI.frames,bI.sourceX,bI.dX,3);bI.panPos.top=aB(bI.pos,bI.frames,bI.sourceY,bI.dY,3)}bG();if(bI.pos==bI.frames){d0();bR();return false}return true};var ek=f3.onAfterinPlaceZoomChanged=function(){bG();dp();fc()};this.getMouseMode=function(){return d4};var eB=this.setMouseMode=function(o){var gy=d4;d4=o;switch(o){case"auto":if(u){o=(bI.bZoomedIn)?1:0}else{o=(bI.bAutoMouseModePan)?1:2}break;case 0:case 1:break;case 2:if(u){o=(bI.bZoomedIn)?1:0}else{o=2}break}cm(o)};var cm=function(o){if(F){F.cancel()}d6=o;switch(d6){case 0:bC("zoom");break;case 1:bC("pan");break;case 2:if(aP.nSceneSets>1){bC("rotate3d")}else{bC("rotate")}break}if(ct){ct.setButtonPressed("MouseMode_"+d6,true)}};var fc=function(){if(!bI.enabled||d4!="auto"){return}var o=(ge>1);if(bI.bZoomedIn==o){return}bI.bZoomedIn=o;if(o){bI.bAutoMouseModePan=true;if(u){cm(1)}else{cm(1)}}else{bI.bAutoMouseModePan=false;if(u){cm(0)}else{cm(2)}}};var gc=function(o,gE,gD){var gB={x:o,y:gE};var gC=Math.round(a0.imageWidth*gD);var gz=Math.round(a0.imageHeight*gD);var gA=Math.max(0,(gC-U.maxPanReferenceWidth)/2);var gy=Math.max(0,(gz-U.maxPanReferenceHeight)/2);gB.x=Math.max(-gA,Math.min(gA,o));gB.y=Math.max(-gy,Math.min(gy,gE));return gB};this.getZoom=function(){var o=ge/bI.maxScale*100;return o};this.setZoom=function(gz,o,gy){if(!b1||!bI.enabled){return false}av(true);d0();var gz=gz*bI.maxScale/100;if(gy){eh(b,b,gz);return}else{fo(gz)}bG(o);if(!o){dp();fc()}return true};var cj=function(gA){if(typeof(gA)!="string"){gA=""}var o=[1,1,0,0,1,1,0];var gz;gA=gA.split(",");for(var gy=gA.length;gy<7;gy++){gA.push(o[gy])}return gA.join(",")};var b9=this.getViewString=function(){if(!aq){return b}var gA=[];var gE=aP.nCurrent+1;var gB=1+Math.round(d2/(dT/bk));if(isNaN(gB)){gB=1}var gC=U.imageWidth;var gz=gC/aq.width*aq.height;var gF=1/ge;var gD=0.5-bI.panPos.left/gC-gF/2;var gy=0.5-bI.panPos.top/gz-gF/2;var o=new a.Rect(gD,gy,gD+gF,gy+gF);o.round();gA.push(gE);gA.push(gB);gA.push(o.toString());gA.push(0);return gA.join(",")};var ec=function(gy){var o=parseFloat(gy);if(isNaN(o)){o=def}return o};var dW=function(gD){var gC={SceneSet:0,scene:0};if(gD==b||typeof(gD)!="string"||gD.length<3){return gC}var gE=gD.split(",");if(gE.length<2){return gC}if(aP.nSceneSets<2){gC.SceneSet=0}else{gC.SceneSet=parseInt(gE[0])-1;if(isNaN(gC.SceneSet)){gC.SceneSet=b}}gC.scene=parseInt(gE[1]);if(isNaN(gC.scene)){gC.scene=1}gC.scene=gC.scene%bk-1;if(gC.scene<0){gC.scene+=bk}gC.frame=gC.scene*dT/bk;if(gE.length>5){var gH=ec(gE[2]);var gz=ec(gE[3]);var gG=ec(gE[4]);var gA=ec(gE[5]);var gy=gC.rc=new a.Rect(gH,gz,gG,gA);gy.normalizeRect();var gB=gy.width();var gI=gy.height();var gJ=1/Math.max(gB,gI);gC.zoom=gJ=Math.max(1,Math.min(bI.maxScale,gJ));var gF=a0.imageWidth;var gK=a0.imageWidth/aq.width*aq.height;gC.x=-gF*gJ*((gy.left+gy.width()/2)-0.5);gC.y=-gK*gJ*((gy.top+gy.height()/2)-0.5)}return gC};var f9=this.gotoViewString=function(gz,gA){if(!b1){return false}var o=(gA)?30:0;var gy=dW(gz);if(gy.scene==b){return false}var gB=dW(b9());if(gy.scene==gB.scene&&Math.abs(gy.x-gB.x)<1&&Math.abs(gy.y-gB.y)<1&&Math.abs(gy.zoom-gB.zoom)<0.000001){return true}aY.spinToTarget(gy.frame,gy.SceneSet,o);if(bI.enabled&&gy.rc!=b){eh(gy.x,gy.y,gy.zoom,o)}return true};this.changeImage=function(gy,gz){fz.makeObjectPropertiesLowerCase(gy);if(!ez){e1=arguments;return}ai=b9();if(c6.on){a.console.log("")}c6.log("--- changeImage() called ---");fz.stopPendingRequests();var gA=false;if(gy!=b){if(gy.fpxsrc!=b||gy.imagepath!=b){gA=true}if(gy.dir!=b){gA=true}}if(!gA){return aY.gotoViewString(gz,true)}fz.setData(ey);if(gy.imagepath!=b){gy.fpxsrc=gy.imagepath;gy.imagepath=b}gy.fpxsrc=encodeURIComponent(gy.fpxsrc);var o=function(gB){fz.cfg[gB]=b;delete fz.cfg[gB]};o("fpxsrc");o("imagepath");o("imagesource");o("imagewidth");o("imageheight");o("transparency");fz.setCfgValues(gy);w();c=gz;bb();fz.dumpConfig();e4();return true};var bY=function(){var gy={};var o=a0.imageWidth/aq.width*aq.height;gy.x=((aZ.width-a0.imageWidth)/a0.imageWidth);gy.y=((aZ.height-o)/o);return gy};var ft=function(){var o=bq;if(ge<=1){ew=1;o=az;return o}var gz=ge*t.imageWidth;var gB=Math.round(aq.width/em.width*gz);var gA;for(var gy=0;gy<be.length;gy++){if(be[gy]>=gB){gA=R=be[gy];break}}if(!gA){if(be.length>0){gA=be[be.length-1]}if(gA<=1.1*t.imageWidth){gA=b}}if(gA){o=Math.round(gA*eN.getImageRect().width()/aq.width)}ew=o/az;return o};var fo=function(o){o=Math.max(1,Math.min(bI.maxScale,o));bI.scale=o;ge=bI.scale*ap.scale;al=Math.min(bI.maxScaleInitial,bS*bI.scale);cF=bI.scale*bS};var e7=function(){var o=Math.min(bI.maxScaleInitial,bS);if(o*bI.scale>bI.maxScaleInitial){bI.scale=bI.maxScaleInitial/o}al=Math.min(bI.maxScaleInitial,bS*bI.scale);return o};var X=function(o){ap.scale=o;ge=ap.scale*bI.scale;al=Math.min(bI.maxScaleInitial,bS*bI.scale);bI.scale=Math.max(1,al/bS);cF=bS*bI.scale};var bG=f3.updateInPlaceZoom=function(gy){if(O){gy=true}var gz=false;if(gy){if(bI.nLastScalePreliminary!=ge){bI.nLastScalePreliminary=ge;gz=true}}else{if(bI.nLastScaleFinal!=ge){bI.nLastScaleFinal=ge;gz=true}}if(gz){if(gy&&cU&&ge-cU.renderScale<-1){eL()}U.imageWidth=gi.testWidth=Math.round(t.imageWidth*ge);U.imageHeight=Math.round(t.imageHeight*ge);U.imageX=Math.round(a0.imageX-(U.imageWidth-a0.imageWidth)/2);U.imageY=Math.round(a0.imageY-(U.imageHeight-a0.imageHeight)/2);U.maxImageOffsetX=Math.max(0,(U.imageWidth-U.maxPanReferenceWidth)/2);U.maxImageOffsetY=Math.max(0,(U.imageHeight-U.maxPanReferenceHeight)/2);if(f8){U.videoWidth=Math.round(t.videoWidth*ge);U.videoHeight=Math.round(t.videoHeight*ge);U.videoX=a0.videoX-(U.videoWidth-a0.videoWidth)/2;U.videoY=a0.videoY-(U.videoHeight-a0.videoHeight)/2}if(!gy){var o;if(ct||aY.onEnableMenuButton){o=(bI.scale>1);cd("ZoomOut",o);if(fr<ak){cd("MouseMode_1",o)}o=(bI.scale<bI.maxScale);cd("ZoomIn",o);cd("MaxZoom",em.width!=U.imageWidth)}bq=ft()}if(aY.onZoomChange!=b){var gA=ge*100/bI.maxScale;aY.onZoomChange(gA)}}if(!O){bI.panPos.left=Math.max(-U.maxImageOffsetX,Math.min(U.maxImageOffsetX,bI.panPos.left));bI.panPos.top=Math.max(-U.maxImageOffsetY,Math.min(U.maxImageOffsetY,bI.panPos.top))}if(!gy){bI.panPos.left=Math.round(bI.panPos.left);bI.panPos.top=Math.round(bI.panPos.top)}gf=true;df();y=true;gk()};var dp=function(){if(!cI&&!gv){eG()}};var bT=function(){var o=a.getElementClientPos(ev);aS.copyRect(bH);fn.copyRect(o);aS.interSectRectValidate(fn);aS.offsetRect(-fn.left,-fn.top);var gy=(aS.width()>0&&aS.height()>0);var gz=(gy!=ap.visible);ap.visible=gy;return gz};var bX=function(o){e8.copyRect(o);e8.offsetRect(-t.imageX,-t.imageY);if(bj&&e8.width()>0&&e8.height()>0){e8.inflateRect(fQ/ge,fQ/ge)}e8.scaleRect(ew)};var j=function(){var gy;var o;var gz=cF;gy=(aS.left+aS.width()/2)-ap.widthUnScaled/2;if(ap.leftLast!=gy){ap.leftLast=gy;if(gy<0){gy=0}if(gy>ap.maxLeft){gy=ap.maxLeft}ap.left=gy}ap.drawOffsetX=ap.scale*(-gy-ap.left+gy);o=(aS.top+aS.height()/2)-ap.heightUnScaled/2;if(ap.topLast!=o){ap.topLast=o;if(o<0){o=0}if(o>ap.maxTop){o=ap.maxTop}ap.top=o}ap.drawOffsetY=ap.scale*(-o-ap.top+o);if(dA){dj.renderer.setSize(ap.totalWidth,ap.totalHeight);gf=true;df()}};var r=function(gy){var gF=bS;if(!h){k(U.widthForRatio,U.heightForRatio,true);gk();return}var gB=false;var gz=e7();cF=bI.scale*bS;var gC=bT();if(gC){gy=true;if(ap.visible){}else{}}else{if(!ap.visible){return}}if(!gy&&cU){if((gC&&!ap.visible)||(ap.widthUnScaled<aS.width()||ap.heightUnScaled<aS.height())||(Math.abs(gz-ap.scale)>1)){if(gz>1){gF=gz=1;gy=true}}}if(!gy){var gA=ap.left;var gJ=ap.top;j();cQ=(ap.left!=gA||gJ!=ap.top);y=true;gk();return}if(ap.lastScale!=gz){ap.lastScale=gz;X(gz);var gD=Math.round(aZ.width*gz);var o=Math.round(aZ.height*gz);var gI,gH;var gG=0;if(bj){gG=fQ}ap.maxWidth=Math.round((window.innerWidth*bS+gG)*gz/gF);ap.maxHeight=Math.round((window.innerHeight*bS+gG)*gz/gF);if(gD>ap.maxWidth){gI=ap.maxWidth}else{gI=gD}if(o>ap.maxHeight){gH=ap.maxHeight}else{gH=o}ap.width=gI;ap.height=gH;ap.widthUnScaled=Math.ceil(gI/gz);ap.heightUnScaled=Math.ceil(gH/gz);ap.totalWidth=gD;ap.totalHeight=o;gB=(fw.width!=gI||fw.height!=gH)}ap.maxLeft=(ap.totalWidth-ap.width)/ap.scale;ap.maxTop=(ap.totalHeight-ap.height)/ap.scale;if(d7){if(ap.scale!=1){var gE=1/ap.scale;if(bK){ap.strTransformScale=" scale3d("+gE+","+gE+","+gE+")"}else{ap.strTransformScale=" scale("+gE+","+gE+")"}}else{ap.strTransformScale=""}}else{ap.strTransformScale=""}j();if(gB){if(bK){g(fw,"translate3d("+ap.left+"px,"+ap.top+"px,0px)"+ap.strTransformScale)}else{g(fw,"translate("+ap.left+"px,"+ap.top+"px)"+ap.strTransformScale)}if(!d7){fw.style.width=gI/gz+"px";fw.style.height=gH/gz+"px"}fw.width=gI;fw.height=gH;b8=fw.getContext("2d");go=gD;cw=o;k(U.widthForRatio,U.heightForRatio,true);bq=ft();if(bI.enabled){cD();bG()}}else{if(bK){g(fw,"translate3d("+ap.left+"px,"+ap.top+"px,0px)"+ap.strTransformScale)}else{g(fw,"translate("+ap.left+"px,"+ap.top+"px)"+ap.strTransformScale)}if(!d7){fw.style.width=fw.width/gz+"px";fw.style.height=fw.height/gz+"px"}}if(!bN){eG();y=true;gk()}else{ck()}};var g=function(o,gy){o.style[ba]=gy};this.showAboutWindow=function(){if(l){l.destroy();l=b;return}var o={};o.title="About FSI Viewer";o.fnOnDestroy=gu;o.strLongVersion=aY.getVersion();l=new a.AboutWindow(f5,o)};var gu=function(){l=b;return true};this.changeConfig=function(o,gy){if(c6.on){a.console.log("")}if(F){F.cancel()}fz.stopPendingRequests();fY();ai=b9();fz.cfg.dir=b;fz.cfg.fpxsrc=b;fz.cfg.fpxpath=b;fz.cfg.fpxsources=b;if(gy!=null&&typeof(gy)=="object"){dF=a.cloneParameters(gy)}if(o!=b){dF.cfg=o}fB();aY.start()};var eD=function(o,gy){if(!o){return}if(!gy){if(o.FSI_prevDisplayState==b){o.FSI_prevDisplayState=o.style.display}o.style.display="none"}else{if(o.FSI_prevDisplayState!=b){o.style.display=o.FSI_prevDisplayState}o.FSI_prevDisplayState=b}};var dv=function(o){if(o==c1){return}c1=o;eD(ev,o);eD(gm,o);fq(o)};var fq=function(o){if(!cT){o=false}eD(T,o)};var dN=function(gy,gz,o){if(gy==b){return}gy.style.width=(typeof(gz)!="string")?gz+"px":gz;gy.style.height=(typeof(gz)!="string")?o+"px":o};var dd=function(gy,o){dN(ev,gy,o);dN(gm,gy,o)};var aT=function(o){if(!eu){eu=true;gp();bc=b9();if(F){F.cancel()}dv(false);eD(ev,true);fw.style.width=fw.style.height="100%";if(fb){fb.hide()}}ev.style.display="none";var gA=a.getElementDimension(f5);ev.style.display="block";var gz=gA.width;var gB=gA.height-cb;var gy;if(gz/gB>aZ.width/aZ.height){gy=gB*aZ.width/aZ.height;ev.style.marginLeft=(gz-gy)/2+"px";ev.style.marginTop="0px";gz=gy}else{gy=gz*aZ.height/aZ.width;ev.style.marginLeft="0px";ev.style.marginTop=(gB-gy)/2+"px";gB=gy}ev.style.width=gz+"px";ev.style.height=gB+"px";if(ct){ct.setContainerSize(gA)}if(fu){fu.setContainerSize(gA,U,a0)}if(o.FSI_after_treshold!=b){bB()}};var bB=this.updateSize=function(){r();dY();ad();dd(aZ.width,aZ.height);dv(true);eu=false;if(fw==b||aZ.width<1||aZ.height<1){return}var o=cC;e0();fw.style.width=fw.style.height="";ev.style.marginLeft=ev.style.marginTop="";if(fw!=b){go=fw.width=ap.widthUnScaled=aZ.width;cw=fw.height=ap.heightUnScaled=aZ.height}k(U.widthForRatio,U.heightForRatio);if(dA){dj.renderer.setSize(aZ.width,aZ.height);bQ();df();y=true;gf=true}ee=cC=b;eL();aD();if(fu){fu.setContainerSize(ae,U,a0)}if(ct){ct.setContainerSize(ae)}f9(bc);eA();bG();ej(o)};var fB=function(o){gp();aw={};dw();aJ={};ey=b;c6=new a.EmptyDebugger();w();if(fz){fz.reset();fz.init(dF)}fL={}};var fY=function(){if(el&&by){el.lockImageSourceDimension(by,false);el.lockImage(by,false);el.removeImages(by,false)}};var cD=function(){bI.nLastScalePreliminary=b;bI.nLastScaleFinal=b};var aD=function(){cD();bq=R=b;eO=b};var fR=function(){gi={}};var dY=function(){ap={};X(1);var o,gy;if(fw){o=fw.width;gy=fw.height}ap.leftLast=ap.topLast=b;ap.width=ap.widthUnScaled=ap.totalWidth=o;ap.height=ap.heightUnScaled=ap.totalHeight=gy;ap.left=ap.top=0;ap.drawOffsetX=ap.drawOffsetY=0};var w=function(){gp();db=0;fS=true;bl();if(F){F.cancel()}av();bw();d0();M();eL();af();dP();bI.panPos={left:0,top:0};bI.maxScale=bI.maxScaleInitial=1;bI.scaleToSourceImage=1;bI.scale=1;bI.pos=bI.frames=0;bI.sourceX=bI.sourceY=0;bI.targetX=bI.targetY=0;bI.sourceZoom=bI.targetZoom=1;bI.dX=bI.dY=bI.dZoom=0;bI.lockPanAnimation=false;dY();fo(1);bS=eg=1;fR();bh=b;em={width:0,height:0};ah++;aD();ds=true;fq(false);au=b;cC=b;ee=b;gv=false;cE=true;bs=false;if(ct){ct.setEnabled(false,true)}bd=false;c=b;b1=false;if(!h&&by){a.removeEvent(by,"load",c0)}cv={width:0,height:0};fY();gs=ch;fc();if(fs){clearTimeout(fs);fs=b}if(dC){clearTimeout(dC);dC=b}dR("image",true);if(du){du=b}e=new Array();if(d9){for(var o=0;o<fL.hotspots.points.length;o++){var gy=fL.hotspots.points[o];if(gy&&gy.tooltip){if(gy.interactive){a.removeEvent(gy.tooltip,"mouseover",eH);a.removeEvent(gy.tooltip,"mouseout",eH)}a.removeChild(gy.tooltip.parentNode,gy.tooltip);a.removeChild(gy.marker.parentNode,gy.marker)}}}bN=false;d9=false;dT=b;a1="";dc=0;I=b;gd=[];dP();if(b7){b7=b}eC={};dE=b};var dP=function(){if(dm){eZ(dm);if(dm.parentNode){a.removeChild(dm.parentNode,dm)}dm=b}};var eZ=function(gz){try{if(gz&&gz.FSIEvents){for(var gB in gz.FSIEvents){var gy=gz.FSIEvents[gB];a.removeEvent(gz,gB,gy.fn,gy.phase)}}}catch(gA){}};var dS=function(o,gy){if(o.touches){if(o.touches.length>0){gy.x=o.touches[0].clientX;gy.y=o.touches[0].clientY}}else{gy.x=o.clientX;gy.y=o.clientY}};var dV=function(o,gB,gA){if(!b1){return false}cM("mousedown");av();gp();bw();if(bI.enabled){var gz=false;if(cB.timeStamp!=b&&(o.timeStamp-cB.timeStamp)<300){if(Math.abs(cB._posx-gB.x)<50&&Math.abs(cB._posy-gB.y)<50){gz=true}}if(!gz){var gy=(O)?bI.targetZoom:bI.scale;eo=(gy<=1)}cB=o;cB._posx=gB.x;cB._posy=gB.y;d0()}cI=true;if(el&&d6==2&&!u){el.lockImageSourceDimension(by,true);el.lockImage(by,true)}fw.lastOffsetX=gB.x;fw.lastOffsetY=gB.y;ca=dH;da.x=gB.x;da.y=gB.y;switch(d6){case 0:if(bI.enabled){aE.clientOffset=a.getElementPosition(gm);aE.setRect(gB.x,gB.y,gB.x,gB.y);fi=true;gk()}break;case 2:da.SceneSetStart=da.SceneSetLast=aP.nCurrent;aE.clientOffset=a.getElementPosition(gm);bE("mouseDown");break}return true};var S=function(gE,gD,gF){var gy=fw.lastOffsetX-gD.x;var o=fw.lastOffsetY-gD.y;switch(d6){case 0:if(bI.enabled){aE.setRect(aE.left,aE.top,gD.x,gD.y);gk()}break;case 2:if(aP.nSceneSets<2){if(Math.abs(o)>3*Math.abs(gy)){gE.FSI_allowEventDefault=true}}else{var gG=gD.y-da.y;var gC=da.SceneSetStart-Math.round(gG*aP.nSceneSets/aZ.height);gC=V(gC);if(gC!=da.SceneSetLast){fa(gC);da.SceneSetLast=gC}}gb(ca-(gD.x-gE.FSI_start_x)/eP);dc=(gy<0)?-1:1;break;default:var gz=false;if(bI.enabled){var gB=bI.panPos.left;var gA=bI.panPos.top;bI.panPos.left-=gy*ap.scale;bI.panPos.top-=o*ap.scale;bG();gz=(gB!=bI.panPos.left||gA!=bI.panPos.top);if(!gz){aG(true);gE.FSI_allowEventDefault=true}else{aG(false);gk()}}else{gE.FSI_allowEventDefault=true}}fw.lastOffsetX=gD.x;fw.lastOffsetY=gD.y};var e5=function(gy,gD,gC){if(!eJ.bActive){aG(true)}var o=gy._FSI_Canceled;var gA=gy._FSI_Click;cI=false;fi=false;cM("mouseup");if(o){if(d6==2){fA("pointer up - canceled")}return}switch(d6){case 0:if(bI.enabled){fI();if(!gA&&bI.maxScale>1){ea(fU)}gk()}break;case 1:if(fr==ak&&ge<=1){fG(0,0)}break;case 2:var gz=false;if(!gy._FSI_fromAfterTouch){eb(b,false)}else{var gB=cR(dH,false);dK(gB,gB,1,1);fA("pointer up")}break}fc();if(gA){bA(gy,gD,gC)}};var a4=function(){return(d6==2||(d6==1&&ge>1))};var L=function(gE){if(d6==2){var gz=dT/bk;var gy=gE.x-da.x;var o=-gy/eP+ca;var gD=Math.round(o/gz)*gz;var gC=-(gD-ca)*eP;gE.x=gC+da.x;var gB=gE.x-da.x;var gA=-(gE.x-da.x)/eP+ca}return gE};var bA=function(gy,gC,gA){if(fE&&cM("click")){return}if(!eo){fG(0,0)}else{if(bI.maxScale>1){var gz=a.getElementPosition(gm);var o=gC.x-gz.left;var gB=gC.y-gz.top;e2(o*ap.scale,gB*ap.scale)}}};var cM=function(gy){var gz=F.getInitialDownEvent();if(!gz||!gz.target){return false}var o=gz.target;if(o.FSIHotspot){fe(gy,o);return true}};var fx=function(gz,gy,gC,gA){for(var gB in gC){gy[gB]=gz.getFloatParameter(gA+gB,gC[gB])}};var dM=function(gz,gy,gC,gA){for(var gB in gC){gy[gB]=gz.getIntParameter(gA+gB,gC[gB])}};var cX=function(gA,gz,gy,gB){for(var gC in gy){gz[gC]=gA.getStringParameter(gB+gC,gy[gC])}},s=function(gz,gy,gB,gA){for(var gC in gB){gy[gC]=gz.makeBool(gz.getStringParameter(gA+gC),gB[gC])}};var cK=function(gy,o,gA,gz){var gB;if(gA&&gA.length>0){if(o[gA]==b){o[gA]={}}gz=gz[gA];gB=o[gA]}else{gB=o}if(gz.strings){cX(gy,gB,gz.strings,gA)}if(gz.booleans){s(gy,gB,gz.booleans,gA)}if(gz.floats){fx(gy,gB,gz.floats,gA)}if(gz.integers){dM(gy,gB,gz.integers,gA)}};var b4=function(gy){var gz={strings:{dir:"",skin:"black",language:"english",backgroundColor:"#FFF",hotspotLineColor1:"#000000",hotspotLineColor2:"#FFFFFF",hotspotDotColor1:"#58a8ff",hotspotDotColor2:"#FFFFFF",hotspotCallbackFunction:b,headers:"cors",fpxservertemplate:b,imagemattecolor:"FFFFFF",initialview:"",initialMouseMode:"auto",navWidth:"120",navHeight:"120",panLimits:"strict",inPlaceZoom:"auto",documentZoom:"auto",hideUI:"false",spinDirectionImage:"right"},booleans:{useDevicePixelRatio:true,adaptiveUISize:true,drawCube:false,drawTable:false,drawGroundPlate:false,pellets:true,enableHotspots:true,decodeHTMLEntitiesInHotSpotTexts:false,enableZoom:true,noCanvas:false,useMaskedJPEGs:true,noNav:false,autoHideNav:true,autoDisablePointerActions:true,loadExactPreviewImagesAfterResize:false,preventImageTransparency:false,noSetLoop:false,noSceneLoop:false,initialViewPersistent:false,showPreviewWhileLoading:true,spinPreviewWhileLoading:true,showProgressbar:true,reverseSceneSets:false,autoDestroy:true},floats:{pelletsOpacity:0.15,fMouseSensitivity:1,desktopClickZoomScale:3,autoSpinSpeed:0,tableDiameter:950,maxZoom:100},integers:{hotspotDotRadius:4,zoomPrecision:1,minInstanceSize:60,quality:-1,},video:{strings:{skin:"black",base:"videos/",source:"",spinDirection:"right",sceneSet:0},integers:{captureFrames:120,frameOffset:0},floats:{captureOffsetStart:0,captureOffsetEnd:0,widthCorrectionFactor:1,heightCorrectionFactor:1,xCorrectionFactor:0,yCorrectionFactor:0}},camera:{strings:{position:"",targetPosition:"",armJointPosition:""},floats:{digitalCropFactor:1,focalLength:50,distanceToTableCenter:1500,heightAboveTable:500,heightTable:b,heightCamera:b,targetHeightOffset:0,targetWidthOffset:0,shiftX:0,armLength:0,armAngleMeasureSetup:0,armAngleStart:0,armAngleEnd:0}},virtualSpace:{strings:{position:""},floats:{cubeSizeX:100,cubeSizeY:100,cubeSizeZ:100,cubeLineWidth:1,baseRotationX:0,rotationXRange:180,baseRotationY:0,rotationYRange:360,baseRotationZ:0,shiftX:0,shiftZ:0,shiftY:0}}};if(gy==b){gy={}}gy.serverBase=fz.serverBase;cK(fz,gy,"",gz);cK(fz,gy,"camera",gz);cK(fz,gy,"virtualSpace",gz);cK(fz,gy,"video",gz);if(fL.enableHotspots){var o=fz.getUnrecognizedConfigNode("hotspots3d");cJ(o)}b3="&effects=Matte("+encodeURIComponent(fL.imagemattecolor)+")"};var cJ=function(gA){var gI={strings:{normalClass:"",hoverClass:"",activeClass:"",text:"",actionParameter:b,url:b,urlTarget:"_self",cssStyle:"",cssClass:""},booleans:{interactive:false},floats:{perimeterZoom:1,perimeterImageWidth:0,perimeterAngle:b,perimeterAngleRange:30,perimeterAngleFadeOut:10,perimeterAngleX:b,perimeterAngleXRange:30,perimeterAngleXFadeOut:10,perimeterAngleY:b,perimeterAngleYRange:30,perimeterAngleYFadeOut:10,verticalMarkerSize:100,horizontalMarkerSize:30,markerAngle:45,horizontalMarkerPosition:0,verticalMarkerPosition:0.5,perimeterDistance:b,perimeterTerminator:b,x:0,y:0,z:0}};var gC=[];var gB;var gG=new a.Config();if(fz.cfg.hotspots!=b&&fz.cfg.hotspots.length>0&&typeof(fz.cfg.hotspots.join)=="function"){c6.log("Using HotSpots from JS parameters");fL.hotspots={};fL.hotspots.defaults={};fL.hotspots.points=new Array(fz.cfg.hotspots.length);var gz=fz.cfg.hotspotsdefaults;if(gz==b){gz=fz.cfg.hotspotdefaults}if(gz!=b){gG.makeObjectPropertiesLowerCase(gz);gG.cfg=gz;gB={};cK(gG,gB,"",gI);for(var gy in gI){var gF=gI[gy];for(var gJ in gF){if(gB[gJ]!=b){gF[gJ]=gB[gJ]}}}var gz=gB;gB={};for(var gy in gz){if(gz[gy]!=b){gB[gy]=gz[gy]}}fL.hotspots.defaults=gB}for(var gE=0;gE<fz.cfg.hotspots.length;gE++){var gH=fz.cfg.hotspots[gE];gG.makeObjectPropertiesLowerCase(gH);gG.cfg=gH;var gH={};cK(gG,gH,"",gI);fL.hotspots.points[gE]=gH}}else{if(!gA){return}gA=gA.firstChild;while(gA){if(gA.nodeType!=1){gA=gA.nextSibling;continue}var gD=gA.nodeName.toLowerCase();switch(gD){case"hotspot":gC.push(gA);break;case"defaults":gB=d3(gG,gA,gI);break}gA=gA.nextSibling}if(gB!=b){for(var gy in gI){var gF=gI[gy];for(var gJ in gF){if(gB[gJ]!=b){gF[gJ]=gB[gJ]}}}var gz=gB;gB={};for(var gy in gz){if(gz[gy]!=b){gB[gy]=gz[gy]}}}if(gC.length>0){for(var gE=0;gE<gC.length;gE++){gC[gE]=d3(gG,gC[gE],gI)}fL.hotspots={};fL.hotspots.points=gC;fL.hotspots.defaults=gB}}if(fL.hotspots&&fL.hotspots.points){c6.log("HotSpots parsed: "+fL.hotspots.points.length);d9=(fL.hotspots.points.length>0)}else{d9=false}};var d3=function(gy,gB,gA){var o={};gB=gB.firstChild;while(gB){if(gB.nodeType!=1){gB=gB.nextSibling;continue}var gz=gy.getValueFromXMLNode(gB,"");o[gz.name]=gz.value;gB=gB.nextSibling}gy.cfg=o;var gC={};cK(gy,gC,"",gA);return gC};var fm=function(o){var gy=fL[o];if(gy==b){return}if(gy.indexOf("r")==-1&&gy.indexOf("#")!=0){fL[o]="#"+gy}};var dz=function(){b4(fL);fz.result=fL;var o=Math.PI/180;fL.virtualSpace.baseRotationXRad=fL.virtualSpace.baseRotationX*o;fL.virtualSpace.baseRotationYRad=fL.virtualSpace.baseRotationY*o;fL.virtualSpace.baseRotationZRad=fL.virtualSpace.baseRotationZ*o};var fT=function(o,gH){c6.log("Video Dimension: "+o+" x "+gH+"px");var gD=eN.isCropped();var gE=false;var gy=eN.getCropMargins();var gB=aq.width;var gG=gB/o;var gF=gH*gG;var gC=Math.round((aq.height-gF)/2);if(gC>gy.top){gE=true;gy.top=gC}if(gC>gy.bottom){gE=true;gy.bottom=gC}if(gE){c6.log("Cropping images to match video dimension ("+gC+"px)");eN.setCropValues(gy.left+"px",gy.top+"px",gy.right+"px",gy.bottom+"px");n()}if(gD){gy=eN.getCropMargins();gy.scaleRectInt(1/gG);gC=Math.round(gC/gG);eM.left=gy.left;eM.right=gy.right;eM.top=gy.top-gC;eM.bottom=gy.bottom-gC}else{eM.setRect(0,0,0,0)}bh=b;bt();var gz=o-eM.left-eM.right;var gA=gH-eM.top-eM.bottom;cv={width:o,height:gH,croppedWidth:gz,croppedHeight:gA};k(gz,gA);dq();gt();if(b8&&fL.pellets&&fL.pelletsOpacity>0){b6()}};var k=function(gH,gW,gK){if(!fL||!fL.video||!fL.video.widthCorrectionFactor){return}var gI=0;var gG=0;var gJ,gT,gP,gB;if(!h){gP=aZ.width;gB=aZ.height}else{gP=go;gB=cw}var gX=gH/gW;var gF=gP/gB;var gE,o;if(gX>gF){gE=gP}else{o=gB}bt();var gO=eN.getFloatRect();var gL=gO.getRange();var gN=a.getFSIServerImageDim(aq.width,aq.height,gE,o,gL,true);gJ=gN.width;gT=gN.height;if(gJ>em.width||gT>em.height){gJ=em.width;gT=em.height}bq=Math.min(gs,Math.round(gJ));gI=Math.round((gP-gJ)/2);gG=Math.round((gB-gT)/2);U.widthForRatio=gH;U.heightForRatio=gW;U.imageWidth=gJ;U.imageHeight=gT;U.imageX=gI;U.imageY=gG;U.videoWidth=gJ*fL.video.widthCorrectionFactor;U.videoHeight=gT*fL.video.heightCorrectionFactor;U.videoX=gI+gJ*fL.video.xCorrectionFactor-(gJ*fL.video.widthCorrectionFactor-gJ)/2;U.videoY=gG+gT*fL.video.yCorrectionFactor-(gT*fL.video.heightCorrectionFactor-gT)/2;if(!gK){az=bq;d1(t)}d1(a0);if(!gK){var gO=eN.getImageRect();var gQ;if(gO.width()>0){gQ=aq.width/gO.width()}else{gQ=0}var gC=Math.ceil(gQ*t.imageWidth);if(aq.__levelsCalculatedFor!=gC){aq.__levelsCalculatedFor=gC;c6.log("Calculating image levels for image base width: "+gC+" px");c6.log("Source image dimension: "+aq.width+" x "+aq.height);var gM=Math.ceil(1.1*gC);be=new Array();if(gC>0){if(aq.levels&&aq.levels.length>0){var gV=new Array();for(var gR=0;gR<aq.levels.length;gR++){var gA=parseInt(aq.levels[gR].width);if(!isNaN(gA)){if(gA>gM){gV.push(gA)}else{break}}}if(c6.on){c6.log("Matching server side image levels: "+gV.join(", "))}if(gV.length>0){gV.push(gC);var gz=gV[0];be.push(gz);for(var gR=1;gR<gV.length;gR++){var gS=gV[gR];var gD=gz/gS;while(gD>2.5){gz/=2;gD=gz/gS;if(gz>gM){be.push(Math.round(gz))}}be.push(gS);gz=gS}be.pop();gV.pop();be.reverse()}if(c6.on){var gU=(be.length-gV.length);if(gU==0){c6.log("Using server side image levels only.")}else{c6.log("Using "+gU+" additional virtual image levels.")}}}else{c6.log("No image level information from server. Using virtual image levels.");var gy=aq.width;var gY=aq.height;if(gM>0){while(gy>gM&&gY>0){be.push(gy);gy=Math.round(gy/2);gY=Math.round(gY/2)}}be.reverse()}}if(c6.on){c6.log("Using image levels: "+be.join(", "))}}a5()}switch(fr){case eS:U.maxPanReferenceWidth=aZ.width*ap.scale;U.maxPanReferenceHeight=aZ.height*ap.scale;break;case ak:U.maxPanReferenceWidth=0;U.maxPanReferenceHeight=0;break;default:U.maxPanReferenceWidth=a0.imageWidth;U.maxPanReferenceHeight=a0.imageHeight;break}};var d1=function(gy){for(var gz in U){gy[gz]=U[gz]}};var am=function(){var o=fL.video.source;if(o&&o.indexOf("[static]")==0&&fL.serverBase!=b){var gy=fL.serverBase;gy=gy.split("/");gy.pop();gy=gy.join("/");o=o.replace(/\[static\]\/*/,gy+"/static/")}return o};this.start=function(){dL();if(ct){ct.destroy();ct=b}if(!fF){return}dZ()};var dZ=function(o){fL={};fz.loadConfigs()};var dx=function(){if(a.oSupportedViewers[ci.strClassName]==b){var gz=false;try{var gB=f5.getBoundingClientRect();gz=(!a.isInternetExplorer||a.versionInternetExplorer>8)}catch(gD){}a.oSupportedViewers[ci.strClassName]=gz}dz();ad();if(fz.hasPlugin("fullscreen")&&!fz.hasPlugin("resize")){fz.addPluginFromString("resize")}var gC=fL.enableZoom;h=(a.BrowserSupports.canvas());bI.enabled=false;q=false;if(gC&&a.BrowserSupports.canvas()){var gy=""+fL.inPlaceZoom;switch(gy.toLowerCase()){case"auto":bI.enabled=(!a.isMobileDevice);break;default:bI.enabled=fz.makeBool(gy,true);break}gy=""+fL.documentZoom;switch(gy.toLowerCase()){case"auto":q=(a.isTouch);break;default:q=fz.makeBool(gy,true);break}}d=false;var gy=""+fL.hideUI;gy=gy.toLowerCase();if((a.isMobileDevice&&gy=="onmobiledevices")||(!bI.enabled&&gy=="ifnoinplacezoom")||fz.makeBool(fL.hideUI)==true){d=true}a9=(!fL.noNav&&!d&&bI.enabled);if(h){el=b}else{el=a._FSITouchZoomInstance}if(h&&fz.hasPlugin("resize")){if(!f6){var o=a.addCustomEvent(f5,"FSIElementDimension",aT);a.setCustomEventListenerProperty(o,"treshold",250);f6=true}}else{if(f6){a.removeCustomEvent(f5,"FSIElementDimension",aT);f6=false}}if(fL.noCanvas){h=false}var gA=fL.skin;c6.log("Loading skin: "+gA+".css");if(fV){fV.remove()}if(a.oSupportedViewers[ci.strClassName]==true){fV=a.loadSkinCSS(gA,aY,cH);aN.name=fV.getSkinName();aN.className="fsi-skin-"+aN.name;f5.className="fsi-viewer-root "+aN.className}else{cH(false)}};var cH=function(gy,o){if(gy){c6.log("Skin loaded successfully. ")}else{c6.error("Failed to load skin.")}if(gy){cu(o)}dI()};this.getMenuHeight=function(gy){var o=bm;if(gy!=b){switch(gy){case"navWindow":if(d5.bFloatingNavWindow){o=0}break}}return o};var eR=function(o){if(typeof(o)!="string"){return o}if(o.indexOf("url(")!=0){return o}o=o.replace(/^url\(["'\s]*/,"");o=o.replace(/["'\s]*\)$/,"");if(o.indexOf("//")==-1){o=o.replace(/^\/*/,"");o=a._FSIViewerLocation+"/skins/"+o}return o};var cu=function(gA){if(aN._nameParsedLast!=aN.name){aN._nameParsedLast=aN.name;var gE="."+aN.className+" .";var gy=function(gJ,gI,gH,gG){var gF=gA.getStyle(gE+gJ,gI,gG);if(gF==b){gF=gH}return gF};d5=gy("fsi-ui-info","content",b,true);d5.bFloatingMenuBar=fz.makeBool(d5.floatingMenuBar);d5.bFloatingNavWindow=fz.makeBool(d5.floatingNavWindow);d5.hMenuBar=gy("fsi-ui-menu-bar","height");aN.cursors={};var gD=a._FSIViewerLocation+"/skins/resources/"+aN.name+"/";var gz=function(gG,gF){var gH=gy("fsi-ui-cursor-"+gG,"content");if(typeof(gH)!="string"){return gF}if(gH.indexOf(".")!=-1&&gH.indexOf("//")==-1){gH=gH.replace(/^[\/]*/,"");gH="url('"+gD+gH+"'),"+gF}return gH};aN.cursors.wait=gz("wait","progress");if(bI.enabled){aN.cursors.zoom=gz("zoom","crosshair")}else{aN.cursors.zoom="default"}aN.cursors.pan=gz("pan","move");aN.cursors.rotate=gz("rotate","ew-resize");aN.cursors.rotate3d=gz("rotate-3d","move");aN.navFrameBorderColor=gy("fsi-ui-nav-frame","border-color","red");aN.navFrameBackgroundColor=gy("fsi-ui-nav-frame","background-color","rgba(255,255,255,0.5)");an=gy("fsi-ui-select-frame","border-color","red");a8=gy("fsi-ui-select-frame","background-color","rgba(255,255,255,0.25)");aN.oProgressBarStyle={};aN.oProgressBarStyle.color=gy("fsi-ui-progressbar","color","#CCC");aN.oProgressBarStyle.background=gy("fsi-ui-progressbar","background-color","#FFF");aN.oProgressBarStyle.border=gy("fsi-ui-progressbar","border-color","#CCC");aN.oProgressBarStyle.text=gy("fsi-ui-progressbar-text","color","#555");aN.urlLogo=eR(gy("fsi-ui-logo-url","background-image"));var gC=16;var o=8;if(d5){if(!isNaN(d5.baseSize)&&d5.baseSize>0){gC=d5.baseSize}if(!isNaN(d5.baseEnlargement)&&d5.baseEnlargement>0){o=d5.baseEnlargement}}else{d5={}}var gB=1;if(fL.adaptiveUISize==true){gB=a.getDevicePixelRatio()}Z=Math.round(gC+o*gB);d5._baseSkinSize=Z}f5.style.fontSize=Z+"px"};var dI=function(){if(typeof(d5.hMenuBar)!="string"||d5.hMenuBar.length<1||isNaN(parseFloat(d5.hMenuBar))){cq=false}else{cq=(a.oSupportedViewers[ci.strClassName]==true&&d!=true)}if(cq){i()}else{bm=cb=0;dy()}};var dy=function(){if(ct){bm=ct.getHeight()}if(d5&&d5.bFloatingMenuBar){cb=0}else{cb=bm}ad();bb()};var i=function(){if(fb==b){if(a._FSIViewerLocation!=b){fb=new a.ToolTip(f5)}}e4();if(ct){ct.destroy()}ct=new a.MenuBar(f3,aN,dy)};var e4=function(){if(fb!=b){var gy=fL.language;var gz=gy+".xml";var o=a._FSIViewerLocation+"/languages/"+gz;if(o!=f0){b0=o;c6.log("Loading language file: "+o);fz.loadFile(o,e9,"application/xml")}}};var ef=function(){if(!ct){return}var gA;var gy=[];gy.push({cmd:"Reset"});if(bI.enabled==true){gy.push({cmd:"ZoomOut",enabled:false});gy.push({cmd:"ZoomIn"})}if(fz.hasPlugin("mousemodes")||fz.hasPlugin("mousemodeselect")){var gD=fz.getPluginParameter("mousemodes","sequence","0,1,3,2");gD=gD.split(",");var gB=[];for(var gz=0;gz<4;gz++){gB[gz]=fz.getPluginParameter("mousemodes","mode"+gz,true,true)}if(!bI.enabled){gB[0]=gB[1]=false}var gC=function(gE){if(isNaN(gE)||gE<0||gE>2){return}if(!gB[gE]){return}if(gE==2&&gd.length<2){return}var gF=true;if(gE==1){gF=(fr>et)}gy.push({cmd:"MouseMode_"+gE,groupID:"MouseMode",enabled:gF})};for(var gz=0;gz<gD.length;gz++){gC(parseInt(gD[gz]))}}if(fz.hasPlugin("maxzoom")&&bI.enabled){gy.push({cmd:"MaxZoom"})}if(d9){if(!fz.hasPlugin("hotspots")){fz.addPluginFromString("hotspots")}if(fz.getPluginParameter("hotspots","button","true",true)){gy.push({cmd:"Hotspots",bCheckButton:true})}cT=fz.getPluginParameter("hotspots","visible","true",true)}if(a.FullScreen.getAvailable(f5)&&fz.hasPlugin("fullscreen")){if(a.bFullScreenFSIViewerCSSAdded!=true){a.bFullScreenFSIViewerCSSAdded=true;var o=".fsi-viewer-root"+a.FullScreen.getFullscreenPseudoClass();a.addCSSRule(o,"position:absolute!important;left:0px!important;top:0px!important;width:100%!important;height:100%!important;",0)}gy.push({cmd:"FullScreen",bCheckButton:1})}ct.addButtons(gy);if(d9&&cT){ct.setButtonPressed("Hotspots",true)}};var e0=function(){var o;if(!q){o=Math.round(Math.max(1,gx)*Math.max(aZ.width,aZ.height))}else{o=Math.round(Math.max(1,gx)*Math.max(screen.width,screen.height))}eX=Math.min(1024,Math.max(2,Math.ceil(o/3/128))*128)};var bb=function(){var gA=fz.parsePositionParameter(fL.virtualSpace.position);if(gA!=b){fL.virtualSpace.shiftX=gA.x;fL.virtualSpace.shiftY=gA.y;fL.virtualSpace.shiftZ=gA.z}if(fz.cfg.cameraarmanglestart!=b){fL.virtualSpace.baseRotationX=fL.camera.armAngleStart;if(fz.cfg.cameraarmangleend!=b){fL.virtualSpace.rotationXRange=fL.camera.armAngleEnd-fL.camera.armAngleStart}}if(fL.useDevicePixelRatio){gx=a.getDevicePixelRatio()}else{gx=1}e0();eN=new a.CroppedImage();eN.setCropFromConfig(fz.cfg);switch(fL.panLimits){case"loose":fr=ak;break;case"medium":fr=et;break;default:fr=eS;break}m();ez=true;if(fL.noSceneLoop){gq=aR}else{gq=er}E=fL.virtualSpace.rotationYRange*-Math.PI/180;aP.rotXRange=fL.virtualSpace.rotationXRange;aP.rotXGradPerSet=(aP.rotXRange/(aP.nSceneSets-1))*Math.PI/180;if(e1!=b){var gz=e1;e1=b;aY.changeImage.apply(aY,gz);return}var gy=fL.dir;if(!gy||gy.length==0){var o=fz.getImageList();if(o){bu(o.arImages,o.oXML,o)}else{return cL()}}else{var o=fz.loadImageList(gy,bu,bV);if(c6.on&&typeof(o._url)=="string"){c6.log("Loading image list: "+o._url)}}};var bu=function(o,gz){if(!o||o.length<1){c6.error("Failed to load image list.");return cL()}dw();gd=o;bk=ab=o.length;aP=fz.parseSceneSets(gd.length,false);c6.log("Image list ready ("+gd.length+" images)");if(gd.length>0){var gy=fz.getImageInfoURL(gd[0]);fz.loadFile(gy,bx)}else{bf()}};var en=function(){if(!dA||aP.nSceneSets<1){return}if(aP.bSetCameraPosition){return}aP.bSetCameraPosition=true;var gE=new THREE.Vector3();var gy=new THREE.Vector3();var gJ=new THREE.Vector3();var gH=new THREE.Object3D();var gz=new THREE.Object3D();gH.add(gz);var gK=new THREE.Object3D();gz.add(gK);var gD=180/Math.PI;var gN;var gO;var gP=dj.targetObj.position;gz.rotation.set(0,0,0);gJ.set(0,gP.y,gP.z);if(fz.cfg.cameraarmlength==b){gO=dj.camera.position.distanceTo(gP)}else{gO=fL.camera.armLength}var gG=fz.parsePositionParameter(fL.camera.armJointPosition);if(gG==b){gz.position.set(gP.x,gP.y,gP.z)}else{gz.position.set(gG.x,gG.y,gG.z)}gz.rotation.x=fL.camera.armAngleMeasureSetup/gD;gH.rotation.set(0,0,0);gK.rotation.set(0,0,0);gK.position.set(0,0,gO);gH.updateMatrixWorld();gy.getPositionFromMatrix(gK.matrixWorld);var gM=fL.virtualSpace.baseRotationX;var gF=fL.virtualSpace.rotationXRange/(aP.nSceneSets-1);if(fL.reverseSceneSets){gM+=fL.virtualSpace.rotationXRange;gF=-gF}c6.log("Calculated Camera Positions:");c6.log("----------------------------");var o=180/Math.PI;for(var gI=0;gI<aP.nSceneSets;gI++){var gA=aP.arSets[gI];gA.cameraArmAngle=gM;gz.rotation.x=gM/gD;gH.updateMatrixWorld();gE.getPositionFromMatrix(gK.matrixWorld);gA.posCamera=new THREE.Vector3(dj.camera.position.x+gE.x-gy.x,dj.camera.position.y+gE.y-gy.y,dj.camera.position.z+gE.z-gy.z);gE.x=0;gA.xAngleToTarget=gJ.angleTo(gE)-Math.PI/2;gA.xAngleToTargetDeg=gA.xAngleToTarget*o;if(c6.on){c6.log("SceneSet "+(gI+1)+", arm angle "+gM+"°, angle to target: "+gA.xAngleToTargetDeg+"°, position (x,y,z): "+gA.posCamera.x+", "+gA.posCamera.y+", "+gA.posCamera.z)}if(d9){gA.visibleHotSpots={};for(var gL=0;gL<fL.hotspots.points.length;gL++){var gB=fL.hotspots.points[gL];var gC=1;if(gB.perimeterAngleX!=b){var gQ=Math.abs(gB.perimeterAngleX-gA.xAngleToTargetDeg);if(gQ>180){gQ=Math.abs(360-gQ)}if(gQ<gB.perimeterAngleXRange){if(gQ>gB.perimeterAngleXRange-gB.perimeterAngleXFadeOut){gC=(gB.perimeterAngleXRange-gQ)/gB.perimeterAngleXFadeOut}}else{gC=0}gA.visibleHotSpots[gB.FSIHotspotID]=gC}}}gM+=gF}};var dk=function(){if(aP.bDefault){return}var gB=100000000;var gG=0;var gI;if(c6.on){gI=a.cloneObject(aP.arSets)}var gH={};for(var gC=0;gC<aP.arSets.length;gC++){var gF=aP.arSets[gC].arScenes;for(var gA=0;gA<gF.length;gA++){var gD=gF[gA]=gF[gA]-1;gH[gD]=gd[gD]}}var gE=[];var gz=e.length;for(var gy in gH){gE.push(gH[gy]);gH[gy]=gz;gz++}for(var gC=0;gC<aP.arSets.length;gC++){var gF=aP.arSets[gC].arScenes;for(var gA=0;gA<gF.length;gA++){gF[gA]=gH[gF[gA]]}gB=Math.min(gB,gF.length);gG=Math.max(gG,gF.length)}if(aP.arSets[0].arScenes.length>0){aP.quantizeMin=gB;aP.quantizeMax=aP.quantizeMaxImages=gG;if(c6.on){c6.log('Using SceneSets Parameter: "'+fz.cfg.scenesets+'"');c6.log("Parsed SceneSets:");for(var gC=0;gC<gI.length;gC++){c6.log("Scene "+(gC+1)+": "+gI[gC].arScenes.join(", "))}}gd=gE;if(aP.arSets.length>1){if(gB!=gG){aP.bQuantize=true}if(db!=b&&db>0){aP.quantizeMax=Math.max(aP.quantizeMax,db);if(gG!=aP.quantizeMax){aP.bQuantize=true}}}}else{aP.bDefault=true;aP.bHasMultipleSets=false;c6.error('Invalid SecenSet definition: "'+fz.cfg.scenesets+'"')}};var aW=function(){var gA=100000000;var o=0;for(var gz=0;gz<aP.arSets.length;gz++){var gy=aP.arSets[gz].arScenes;gA=Math.min(gA,gy.length);o=Math.max(o,gy.length)}return{min:gA,max:o}};var fj=function(){var gG=aP.quantizeMax;for(var gB=0;gB<aP.arSets.length;gB++){if(gB==aP.nVideoSet){continue}var gF=aP.arSets[gB].arScenes;if(gF.length<gG){var gE=gF.length;var gy=gG-gE;var gD=aP.arSets[gB].oSpinPositions={};for(var gA=0;gA<gE;gA++){var gC=gF[gA];gD[gC]=Math.round(gA*gG/gE)}aP.arSets[gB].fQuantizeFactor=gG/gE;var o=gE-1;var gz=new Array(gG);for(var gA=0;gA<gG;gA++){var gC=(gA*o/(gG-1));gz[gA]=gF[Math.round(gC)]}aP.arSets[gB].arScenes=gz}else{aP.arSets[gB].oSpinPositions=false}}};var cL=function(){bC("default");if(ct){ct.setEnabled(false)}};var bx=function(gy,o){aq=o;aq.transparency=fz.makeBool(aq.alpha);aq.width=parseInt(aq.width);aq.height=parseInt(aq.height);if(fL.fpxservertemplate!=b){eC.renderer=fL.fpxservertemplate}if(fL.headers!=b){eC.headers=fL.headers}dl=(aq.transparency&&!fL.preventImageTransparency);if(dl){if(h){bd=fL.useMaskedJPEGs}else{var gz=fz.cfg.fpxservertemplate;if((fL.video==b||!fL.video.source.length)&&(gz==b||gz=="jpeg")){eC.renderer="png"}}}gl=(!dl||!bd);if(typeof(aq.levels)=="object"&&typeof(aq.levels.sort)=="function"){aq.levels.sort(aF)}else{aq.levels=b}eN.setSourceDimension(aq.width,aq.height);n();k(em.width,em.height);dq();bf()};var aF=function(gy,o){return o.width-gy.width};var dq=function(){if(eN.isCropped()){var gy=eN.getImageRect();var o=gy.width()/U.imageWidth;aJ.cropScaleX=aq.width/gy.width();aJ.cropScaleY=aq.height/gy.height();aJ.x=(gy.left+gy.width()/2-aq.width/2)/o;aJ.y=(gy.top+gy.height()/2-aq.height/2)/o}else{aJ.cropScaleX=1;aJ.cropScaleY=1;aJ.x=0;aJ.y=0}};var n=function(){var o;if(eN.isCropped()){o=eN.getPixelRangeRect();em.width=o.right;em.height=o.bottom}else{em.width=aq.width;em.height=aq.height;o=new a.Rect(0,0,em.width,em.height)}};var bf=function(){fR();dA=false;bp=false;var o=true;if(a.BrowserSupports.canvas()){if(fL.drawCube||fL.drawGroundPlate||fL.drawTable){bp=dA=true}if(!dA&&fL.enableHotspots){if(fL.hotspots&&fL.hotspots.points&&fL.hotspots.points.length>0){dA=true}}var gy="js/three_custom_min.js";if(a._FSIViewerLocation!=b){gy=a._FSIViewerLocation+"/applications/viewer/"+gy}o=false;if(dA){if(typeof(window.THREE)=="object"){o=true}else{if(!a.loadJavascript(gy,dn,aY,es)){o=true;dA=false}}}else{a.releaseLoadJavascript(gy,dn);o=true}}if(!dA){bp=false}if(o){c7()}};var es=function(o,gz,gy){if(typeof(window.THREE)!="object"){dA=false}if(!dA){bp=false}c7()};var c7=function(){if(fL.video.spinDirection&&fL.video.spinDirection.toLowerCase()=="left"){fL._reverseVideoDirection=true}if(fL.spinDirectionImage!=b){if(fL.spinDirectionImage.toLowerCase()=="left"){fL._reverseImageDirection=true}}else{fL._reverseImageDirection=fL._reverseVideoDirection}if(!aP.bDefault){if(fL._reverseImageDirection){for(var o=0;o<aP.arSets.length;o++){aP.arSets[o].arScenes.reverse()}fL._reverseImageDirection=false}if(fL.reverseSceneSets){aP.arSets.reverse()}}if(fL._reverseImageDirection){gd.reverse();gd.unshift(gd.pop())}f=am();cx();ef();if(d9){fq(true)}else{fq(false)}if(fw){ff()}};var e9=function(o,gA){f0=b0;if(gA){dg={};var gz=fz.findXMLNode(gA,"data");if(gz){gz=fz.findXMLNode(gz,"tip")}while(gz){if(gz.nodeType==1){var gB=gz.getAttribute("id");var gy=fz.XMLChildNodesToString(gz);dg[gB]=gy}gz=gz.nextSibling}fb.setContent(dg)}};var ce=function(){if(ct&&d6!=b){ct.setButtonPressed("MouseMode_"+d6,true)}if(a9){cz()}};var cx=function(){if(em.width){gs=Math.min(ch,em.width)}else{gs=ch}a5()};var a5=function(){bI.scaleToSourceImage=Math.max(1,em.width/a0.imageWidth);bI.maxScale=bI.maxScaleInitial=fL.maxZoom/100*bI.scaleToSourceImage;bI.defaultZoom=Math.min(fL.desktopClickZoomScale,bI.maxScale)};this.destroyOnDetach=function(){if(fL&&fL.autoDestroy!=false){fl()}};var fl=this.destroy=function(){aj.removeAttribute("x-fsi-id");a.removeClass(aj,"fsi-viewer");if(l){l.destroy()}if(fV){fV.remove();fV=b}if(bi!=b){a.removeCustomEvent(f5,"FSIMouseWheel",e3);bi=b}if(z!=b){a.removeCustomEvent(gm,"FSIDocumentZoomChange",dt);z=b}if(ep!=b){a.removeCustomEvent(ev,"FSIViewport",aX);ep=b}if(f6){a.removeCustomEvent(f5,"FSIElementDimension",aT);f6=false}if(dC){clearTimeout(dC);dC=b}M();if(fb){fb.destroy();fb=b}if(ct){ct.destroy();ct=b}dL();if(F){F.destroy();F=b}fF=false;fB();if(f5){if(fw){a.removeChild(ev,fw);a.removeChild(f5,ev);fw=b}if(f5.parentNode==aj){a.removeChild(aj,f5)}f5=b}if(T){a.removeChild(T.parentNode,T);T=b}if(gm){if(!a.isMobileDevice){a.removeEvent(gm,"keydown",cA);a.removeEvent(gm,"keyup",bW)}a.removeChild(gm.parentNode,gm);gm=b}c1=true};var m=function(){if(!aZ||aZ.width<10||aZ.height<10){return false}if(gm==b){gm=document.createElement("div");gm.className="fsi-event-overlay";var gy=";-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;";if(a.isInternetExplorer){a.setStyleAttr(gm,"position:absolute;z-index:300;background-color:rgba(0,0,0,0)"+gy)}else{a.setStyleAttr(gm,"position:absolute;z-index:300"+gy)}bC("wait");if(!a.isMobileDevice){gm.setAttribute("tabIndex","0")}f5.appendChild(gm);if(!F){var gz={};gz.detectGestures=true;gz.afterTouch={enabled:true};gz.afterTouch.modifyTarget=L;gz.afterTouch.fnGetAfterTouchEnabled=a4;gz.afterTouch.fnStartStopAfterTouch=G;if(bI.enabled){gz.detectClick=true;gz.onPinchStart=p;gz.onPinchChange=dr;gz.onPinchEnd=f2}F=new a.TouchHandler(gm,gz,dV,S,e5)}if(!a.isMobileDevice){a.addEvent(gm,"keydown",cA);a.addEvent(gm,"keyup",bW)}if(bI.enabled){bi=a.addCustomEvent(f5,"FSIMouseWheel",e3)}else{if(bi!=b){a.removeCustomEvent(f5,"FSIMouseWheel",e3);bi=b}}if(bI.enabled){if(z==b){z=a.addCustomEvent(gm,"FSIDocumentZoomChange",dt);a.triggerCustomEvent(z)}}else{if(z){a.removeCustomEvent(gm,"FSIDocumentZoomChange",dt);z=b}if(F){F.enable(true)}}}if(T==b&&d9){T=document.createElement("div");a.setStyleAttr(T,"position:absolute;z-index:4;");gm.appendChild(T)}if(T){eD(T,false)}if(fw==b||fw.FSIisCanvas!=h){if(fw!=b&&fw.FSIisCanvas!=h){a.removeChild(f5,fw);fh=fw=by=b}ev=document.createElement("div");ev.setAttribute("draggable","false");a.setStyleAttr(ev,"position:absolute;overflow:hidden;width:100%;height:100%;overflow:hidden");if(h){fw=document.createElement("canvas")}else{fw=document.createElement("div")}ev.appendChild(fw);f5.appendChild(ev);var o="z-index:1;position:absolute;transform-origin:0px 0px;	-webkit-transform-origin:0px 0px;	-ms-transform-origin:0px 0px;";o+="backface-visibility: hidden;-webkit-backface-visibility: hidden;";a.setStyleAttr(fw,o);if(h){b8=fw.getContext("2d");c8=b8.webkitBackingStorePixelRatio||b8.mozBackingStorePixelRatio||b8.msBackingStorePixelRatio||b8.oBackingStorePixelRatio||b8.backingStorePixelRatio||1;if(!d7){fw.style.width=fw.style.height=""}}else{fw.style.textAlign="left"}fw.FSIisCanvas=h}if(typeof(fL.backgroundColor)=="string"&&fL.backgroundColor.toLowerCase()=="none"){fL.backgroundColor="transparent"}f5.style.backgroundColor=fL.backgroundColor;if(!h){if(fh==b){fh=by;by=b}if(by!=b){a.removeChild(by.parentNode,by)}by=document.createElement("img");if(fh!=b){by.style.display="none"}fw.appendChild(by)}if(h){if(ep==b){ep=a.addCustomEvent(ev,"FSIViewport",aX);a.setCustomEventListenerProperty(ep,"treshold",350)}}else{if(ep!=b){a.removeCustomEvent(ev,"FSIViewport",aX);ep=b}aS.setRect(0,0,aZ.width,aZ.height)}go=fw.width=aZ.width*ap.scale;cw=fw.height=aZ.height*ap.scale;fw.lastOffsetX=fw.lastOffsetY=0;if((a.BrowserSupports.documentZoom()&&!a.isMobileDevice)||(a.isMobileDevice&&!h)){e6=true}dd(aZ.width,aZ.height);dY();return true};this.onVisibilityChanged=function(){if(ep){a.triggerCustomEvent(ep)}};var p=function(o,gA,gz){if(bI.maxScale<=1){eJ.bActive=false;return}eJ.bActive=true;eJ.lastX=gA.x;eJ.lastY=gA.y;eJ.distanceStart=o._FSI_PinchDistance;var gy=a.getElementPosition(gm);eJ.offsetX=-gy.left-aZ.width/2;eJ.offsetY=-gy.top-aZ.height/2;eJ.startZoom=bI.scale;aG(false)};var dr=function(gE,gC,gF){if(!eJ.bActive){return}var gA=gE._FSI_PinchDistance;var gz=gC.x-eJ.lastX;var o=gC.y-eJ.lastY;eJ.lastX=gC.x;eJ.lastY=gC.y;var gH=eJ.startZoom*gE._FSI_PinchScale;gH=Math.max(1,Math.min(bI.maxScale,gH));var gG=gH*100/bI.maxScale;var gD=gC.x+eJ.offsetX;var gB=gC.y+eJ.offsetY;var gy=gH/bI.scale;bI.panPos.left-=gD;bI.panPos.top-=gB;bI.panPos.left*=gy;bI.panPos.top*=gy;bI.panPos.left+=gD;bI.panPos.top+=gB;bI.panPos.left+=gz;bI.panPos.top+=o;aY.setZoom(gG,true,false)};var f2=function(o,gA,gz){if(!eJ.bActive){return}eJ.bActive=false;aG(true);var gy=bI.scale*100/bI.maxScale;aY.setZoom(gy,false,false)};var H=function(gz){var gy=gz;var o=a.getDevicePixelRatio();if(o<1||fL.useDevicePixelRatio){gz=o*gz}if(eO!=gz){eO=gz;bI.maxScale=Math.max(1,bI.maxScaleInitial/gz);df();bS=gz;if(d9){if(eg!=bS){eg=bS;di=true}if(!bN){gk()}}}};var aX=function(o){bH=o.FSI_viewport_rect;H(o.FSI_scale);if(!b1){return}r(o.FSI_after_treshold)};var dt=function(o){eA()};var eA=function(){if(fL.autoDisablePointerActions){var o=(aY.getInFullScreenMode()||(ae.width<=window.innerWidth&&ae.height<=window.innerHeight));if(o!=fM){fM=o;F.enable(o);if(fu){fu.enable(o)}}}};var aI=function(){return(cI&&(!F||!F.isAfterTouchRunning()))};var e3=function(gF){av(false);if(gF.preventDefault){gF.preventDefault()}v();bv();var gG=aI();if(bN||gG){return}if(bI.maxScale<=1){return}var gE=gF.FSI_weighted_delta;cc=F.getMousePositionClient(gF);var gD=a.getElementPosition(gm);var gz=1+Math.abs(gE)/6;if(gE<0){gz=1/gz}var gH=Math.max(1,Math.min(bI.maxScale,bI.scale*gz));var gC=cc.x*ap.scale-gD.left-aZ.width*ap.scale/2;var gB=cc.y*ap.scale-gD.top-aZ.height*ap.scale/2;var o=gH/bI.scale;var gA=bI.panPos.left-gC;var gy=bI.panPos.top-gB;gA*=o;gy*=o;gA+=gC;gy+=gB;eh(gA,gy,gH,13);if(fu&&fu.isDragging()){bI.lockPanAnimation=true}gF.cancelBubble=true};var G=function(o){fX=o;if(o){gk()}};var d8=function(){if(!fL.showProgressbar){return}if(gd.length<2){du=b;at=false;return}if(!h){return}var gy=aZ.width/3;var o=(aZ.width-gy)/2;var gz=aZ.height-26;du=new a.CanvasProgressBar(b8,o,gz,gy,14,aN.oProgressBarStyle);ck()};var ck=function(){if(!du){return}var gy=aZ.width/3*ap.scale;var o=(bS*aZ.width-gy)/2;var gz=bS*aZ.height-26;du.setPos(o,gz)};var ff=function(){cl=(typeof(aY.onProgress)=="function");cf(0);var gC=false;aA=(!a.isMobileDevice&&(a.isOpera||a.isInternetExplorer));d8();bC("wait");var gE="";if(f.indexOf("//")==-1){gE=fL.video.base}if(!h||a.isMobileDevice||!f){c6.log("Using image sequence w/o video.");return cP()}var gI=fL.video.captureOffsetStart;if(gI==b||isNaN(gI)){gI=0}var gA=fL.video.captureOffsetEnd;if(gA==b||isNaN(gA)){gA=0}var gD;var gK=fL.video.captureFrames;if(gK==b||isNaN(gK)){fL.video.captureFrames=120}if(aP.nSceneSets>1){var gF=aW();fL.video.captureFrames=Math.max(fL.video.captureFrames,gF.max)}else{fL.video.captureFrames-=fL.video.captureFrames%gd.length;fL.video.captureFrames=Math.max(fL.video.captureFrames,gd.length)}var gJ=document.createElement("canvas");gJ.setAttribute("webkit-playsinline","");var gG=gJ.getContext("2d");if(!c3){c3=document.createElement("canvas");gr=c3.getContext("2d")}var gK=gE+f;if(a.isInternetExplorer&&a.versionInternetExplorer<10&&a.isCrossDomain(gK)){c6.error("CROSS DOMAIN VIDEO ACCESS not possible with this browser.");c6.log("Falling back to using image sequence.");return cP()}c6.log("Capture "+fL.video.captureFrames+" video frames");dm=document.createElement("video");dm.setAttribute("muted","muted");dm.setAttribute("preload","auto");dm.setAttribute("webkit-playsinline","");dm.setAttribute("crossorigin","anonymous");a.setStyleAttr(dm,"position:absolute;z-index:10000;width:1px;height:1px");dm.style.marginLeft=aZ.width/2+"px";dm.style.marginTop=aZ.height/2+"px";if(!a.isSafari&&!a.isInternetExplorer){var gz=document.createElement("source");gz.setAttribute("src",gE+f+".webm");dm.appendChild(gz)}var gy=document.createElement("source");gy.setAttribute("src",gE+f+".mp4");dm.appendChild(gy);if(!a.isSafari&&!a.isInternetExplorer){var o=document.createElement("source");o.setAttribute("src",gE+f+".ogv");dm.appendChild(gy)}f5.appendChild(dm);dm.FSIEvents={};var gH=function(gM,gN,gL){dm.FSIEvents[gM]={fn:gN,phase:gL};a.addEvent(dm,gM,gN,gL)};gH("error",function(gL){if(dm.networkState==dm.NETWORK_NO_SOURCE){c6.error('Failed loading the video: "'+f+'"');c6.log("Falling back to using image sequence w/o video.");cP()}},true);gH("loadedmetadata",function(gM){bN=true;dR("video");var gN=dm.videoWidth;var gL=dm.videoHeight;dm.setAttribute("width",gN);dm.setAttribute("height",gL);gD=(dm.duration-gI-gA)/fL.video.captureFrames;fT(gN,gL);gJ.setAttribute("width",cv.croppedWidth);gJ.setAttribute("height",cv.croppedHeight);c3.setAttribute("width",cv.croppedWidth);c3.setAttribute("height",cv.croppedHeight);ce();ga()},true);gH("canplaythrough",function(gL){if(!gC){gC=true;this.currentTime=Math.max(0,gI)}},true);var gB=0;gH("seeked",function(gL){if(!bN){return}var gM=dm.duration;if(a.isInternetExplorer){gM-=0.3}if(e.length<fL.video.captureFrames){try{gG.drawImage(gL.target,0,0,cv.width,cv.height,-eM.left,-eM.top,cv.width,cv.height);var gO=gG.getImageData(0,0,gJ.width,gJ.height);e.push(gO)}catch(gN){c6.error('Failed capturing the video: "'+f+'"');c6.log("REASON: "+gN.message);c6.log("Falling back to using image sequence w/o video.");bN=false;cP();return}cf(100*e.length/fL.video.captureFrames);bP(e.length-1);gk();gB=Math.min(gM,gD*e.length+gI);if(aA){dC=setTimeout(function(gP){dm.currentTime=gB},1)}else{dm.currentTime=gB}}else{cG()}},true)};var av=f3.stopAutoSpin=function(o){if(!ed){return}fA("autoSpin");clearInterval(ed);ed=0;if(o){eb()}};var fg=function(){var o=d2+gj;if(o>=dT){o-=dT}else{if(o<0){o+=dT}}bP(o);fS=true;gk()};var aK=function(o){dT=o;eP=160/dT*4/fL.fMouseSensitivity;de=dT/120};var fH=function(){var o;if(!aP.bDefault&&aP.nSceneSets>1){o=Math.max(1,Math.min(aP.nSceneSets,fL.video.sceneSet))-1;if(fL.reverseSceneSets){o=(-(o+1)+aP.nSceneSets)%aP.nSceneSets}}return o};var cG=function(){if(fL._reverseVideoDirection){e.reverse();e.unshift(e.pop())}be.unshift(t.imageWidth);if(e.length>0){aP.nVideoSet=fH()}else{aP.nVideoSet=b}if(aP.nVideoSet!=b){var o=f8;cP();f8=o}else{dk();bF()}};var bF=function(){cf(100);if(bO!=b){fp=bO}if(aP.bQuantize){fj()}bP(0);at=false;bs=dA;b7=b;if(fL._reverseImageDirection&&fu){fu.reverseImageSequence()}if(el){gk()}dP();if(du){du=b}a6();if(dT>1||aP.nSceneSets>1){u=false;if(a.isIETouch){if(aP.nSceneSets>1){gm.style.msTouchAction="pinch-zoom double-tap-zoom"}else{gm.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}}if(fL.autoSpinSpeed!=0){bE("autoSpin");if(fL.autoSpinSpeed<0){fL.autoSpinSpeed=-fL.autoSpinSpeed;gj=-1}else{gj=1}var gy=fL.autoSpinSpeed*1000/dT;if(gy==0){gy=1}while(gy<20&&Math.abs(gj)<dT/2){gy*=2;gj*=2}gy=Math.max(20,Math.ceil(gy));ed=setInterval(fg,gy)}}else{u=true;if(a.isIETouch){gm.style.msTouchAction=b}if(!bI.enabled){bC("default")}}var gy=fL.initialMouseMode;if(gy!="auto"){gy=parseInt(gy)}eB(gy);bN=false;var o=b;if(fL.video.frameOffset&&f8){o=d2+fL.video.frameOffset;o=gq(dT+o);bP(o)}bM();b1=true;if(ct){ct.setEnabled(true)}if(c!=b){f9(c,(gd.length>1));c=b}else{if(ai!=b&&fz.makeBool(fz.cfg.keepcurrentviewafterconfigchange,false)){fL.initialview=ai}if(fL){if(fL.initialview!=b&&fL.initialview.length>0){if(!f9(fL.initialview,false)){fL.initialview=b}else{fL.initialview=cj(fL.initialview)}}else{fL.initialview=b}}}ai=b;if(typeof aY.onReady=="function"){aY.onReady(aY)}bR();if(bI.enabled){bG()}if(!bI.enabled){if(u){F.setCapture(false,false)}else{F.setCapture(true,false)}}if(ep){a.triggerCustomEvent(ep);r(true)}};var cP=function(){gp();db=e.length;dR("image");ga();dk();fL.pellets=false;dP();k(em.width,em.height);ce();eK()};var c0=function(){a.removeEvent(by,"load",c0);if(fh!=b&&fh.parentNode!=b){a.removeChild(fh.parentNode,fh);fh=b}by.style.display="inline";fw.style.paddingLeft=U.imageX+"px";fw.style.paddingTop=U.imageY+"px"};var eK=function(){bN=true;gt();if(!h){by.width=U.imageWidth;by.height=U.imageHeight;a.addEvent(by,"load",c0,true);if(fh==b){try{fw.style.paddingLeft=fw.style.paddingRight="auto";fw.style.paddingTop=fw.style.paddingRight="auto"}catch(gy){}}}if(c3){c3.setAttribute("width",U.imageWidth);c3.setAttribute("height",U.imageHeight)}var o=eq=new Image();o.FSI_nImage=0;a.addEvent(o,"load",fP);fk(o,f1(o.FSI_nImage).fullURL)};var fk=function(o,gy){if(!bd){o.FSI_image_context=o;a.loadImageCors(o,gy)}else{var gA=gy;gA+=b3;o.FSI_image_context=o;o.FSI_url=gA;var gz=o._FSI_alpha_mask=new Image();gz.FSI_my_img=o;gz.crossOrigin="anonymous";a.addEvent(gz,"load",c2);gy=a.changeRendererInURL(gy,"png.alpha");gz.src=gy}};var c2=function(){a.removeEvent(this,"load",c2);var o=this.FSI_my_img;o.FSI_alpha_channel=this;a.loadImageCors(o,o.FSI_url)};var b5=function(gz){if(!gz){return}if(gz.FSI_alpha_channel){var gy=gz.width;var gB=gz.height;var gA=gz.FSI_image_context=document.createElement("canvas");gA.setAttribute("width",gy);gA.setAttribute("height",gB);gA.setAttribute("crossorigin","anonymous");var o=gA.getContext("2d");o.drawImage(gz.FSI_alpha_channel,0,0,gy,gB);o.globalCompositeOperation="xor";o.drawImage(gz,0,0,gy,gB);gz.FSI_alpha_channel=b}};var cf=function(o){W=o;if(du){at=true}if(cl){aY.onProgress(o)}};var fP=function(o){if(!eq){return}b5(eq);if(h){e.push(eq)}else{e.push(eq.src)}cf(100*(e.length-db)/gd.length);bP(e.length-1);gk();if(++eq.FSI_nImage>=gd.length){af();if(el){el.addImage(by)}bF();return}var gy=eq;if(h){a.removeEvent(eq,"load",fP);var gz=eq.FSI_nImage;gy=eq=new Image();gy.FSI_nImage=gz;a.addEvent(gy,"load",fP)}fk(gy,f1(gy.FSI_nImage).fullURL)};var af=function(){if(eq==b){return}a.removeEvent(eq,"load",fP);eq=b};var gb=function(o){var gy=gq(Math.round(o));if(gy!=gq(d2)){df();bP(gy);gk()}dH=o};var bE=function(o){if(gv){return}D=P;P=true;gv=true;M();cE=false;M();y=false};var fA=function(o){if(!gv){return}P=D;bP(gq(d2));gv=false;cE=true;y=true;if(!cU||d2!=cU.spinPos){if(cU){eL()}eG()}else{cy(50)}};var bP=function(o){d2=dH=o;if(!aL){cW=d2}else{cW=aL[d2]}};var b6=function(){dE=document.createElement("canvas");dE.setAttribute("width",cv.croppedWidth);dE.setAttribute("height",cv.croppedHeight);dQ=dE.getContext("2d");var gB=dE.width;var gy=dE.height;var gA=dQ.createImageData(gB,gy);var gC=gA.data;for(var gD=0;gD<gy;gD++){if(gD%4==0){for(var o=0;o<gB;o++){if(o%4!=0){var gz=gD*gB*4+o*4;gC[gz]=0;gC[gz+1]=0;gC[gz+2]=0;gC[gz+3]=255}}}else{if(gD%4==1||gD%4==2){for(var o=1;o<gB;o+=4){var gz=gD*gB*4+o*4;gC[gz]=0;gC[gz+1]=0;gC[gz+2]=0;gC[gz+3]=255}}}}dQ.putImageData(gA,0,0)};var gk=function(o){if(eu){return}if(a3!=b){return}a3=requestAnimationFrame(function(){ao()})};var gp=function(){if(a3==b){return}cancelAnimationFrame(a3);a3=b};var ao=function(){var o=false;a3=b;if(fX){if(F.runAfterTouch()){o=true}}if(!h){if(I!=cW){by.src=e[cW];I=cW}}else{if(O){if(eV()){o=true}}b8.globalAlpha=1;b8.clearRect(0,0,go,cw);fp();if(cE&&cU){if(gw()){o=true}}}if(bs){if(gf){var gB=ge*aZ.width;var gz=ge*aZ.height;gf=false;var gA=-ap.drawOffsetX+(gB-aZ.width*ap.scale)/2-bI.panPos.left+aJ.x*bI.scale;var gy=-ap.drawOffsetY+(gz-aZ.height*ap.scale)/2-bI.panPos.top+aJ.y*bI.scale;dj.camera.setViewOffset(gB,gz,gA,gy,ap.totalWidth,ap.totalHeight)}if(cN){var gC;if(cr.oSpinPositions){gC=cr.oSpinPositions[cW]/dT}else{gC=d2/dT}eI(0,gC*E,0)}if(bp){dj.renderer.draw(dj.scene,dj.camera)}if(cN){cN=false;if(d9&&ds){if(!bp){dj.renderer.render(dj.scene,dj.camera)}br()}}}if(fS){fS=false;if(fu){fu.update(cW,al)}}if(fi){fI();b8.fillStyle=a8;b8.fillRect(fU.left+1,fU.top+1,fU.width()-1,fU.height()-1);b8.fillStyle=an;b8.fillRect(fU.left,fU.top,fU.width(),1);b8.fillRect(fU.left,fU.bottom,fU.width(),1);b8.fillRect(fU.left,fU.top,1,fU.height());b8.fillRect(fU.right,fU.top,1,fU.height())}if(at){du.draw(W)}if(cQ){if(bK){g(fw,"translate3d("+ap.left+"px,"+ap.top+"px,0px)"+ap.strTransformScale)}else{g(fw,"translate("+ap.left+"px,"+ap.top+"px)"+ap.strTransformScale)}}if(o){gk()}};var fI=function(){fU.copyRect(aE);fU.offsetRect(-aE.clientOffset.left,-aE.clientOffset.top);fU.normalizeRect();if(ap.scale!=1){fU.scaleRect(ap.scale)}};var df=function(){cN=fS=true};var dU=function(o){return false};var J=function(o){b8.drawImage(o.img.FSI_image_context,o.x,o.y,o.width,o.height);return false};var fZ=function(gy){var o;gy.alpha+=ex;if(gy.alpha>=1){gy.fnDraw=J;gy.alpha=1;o=false}else{o=true}b8.globalAlpha=gy.alpha;J(gy);b8.globalAlpha=1;return o};var gw=function(){var o=false;if(y){f7()}if(cU.nVisibleTiles>0){var gC=ap.drawOffsetX+U.imageX+bI.panPos.left;var gB=ap.drawOffsetY+U.imageY+bI.panPos.top;var gA=U.imageWidth/cU.width;b8.save();b8.translate(gC,gB);b8.scale(gA,gA);var gy=cU.arVisibleTiles;for(var gz=0;gz<cU.nVisibleTiles;gz++){if(gy[gz].fnDraw(gy[gz])){o=true}}b8.restore()}cU.bTilesFading=o;if(P&&!o&&cU.bFilesArePreparedForLoading){if(b7.nTilesLoading==0&&cU.arTilesToLoad.length==0){P=false}}return o};var eU=function(){var o=false;if(y){f7()}if(cU.nVisibleTiles>0){var gC=ap.drawOffsetX+U.imageX+bI.panPos.left;var gB=ap.drawOffsetY+U.imageY+bI.panPos.top;var gA=U.imageWidth/cU.width;var gy=cU.arVisibleTiles;for(var gz=0;gz<cU.nVisibleTiles;gz++){if(gy[gz].fnDraw(gy[gz],gC,gB,gA)){o=true}}}cU.bTilesFading=o;if(P&&!o&&cU.bFilesArePreparedForLoading){if(b7.nTilesLoading==0&&cU.arTilesToLoad.length==0){P=false}}return o};var dR=function(o,gy){eF=(o=="video");if(eF){ee=b;c5=c3;bz=f3.getPreviewImage=ay;fp=b2}else{bz=f3.getPreviewImage=cg;fp=fK}if(!gy){f8=eF;if(fL){if(gd.length>1){if(!fL.showPreviewWhileLoading){bO=fp;fp=a.fnDoNothing}else{if(!fL.spinPreviewWhileLoading){bO=fp;if(!aw.bSetup){aw.bStillPreview=true;fp=a.fnDoNothing}else{if(aw.imgDraw){fp=fy}else{fp=a.fnDoNothing}}}else{bO=b}}}aw.bSetup=true}}};var ga=function(){if(!aw.bStillPreview||aw.bStillPreviewDone){return}fO()};var fO=function(){aw.bStillPreviewDone=true;var gA=b1;b1=true;var gB;var gC=dW(fL.initialview);var o;if(aP.bDefault){gB=gC.scene}else{var gz=aP.arSets[gC.SceneSet];gB=gz.arScenes[gC.scene]-1}bt();var gy=f1(gB).fullURL;aw.img=new Image();a.addEvent(aw.img,"load",A);fk(aw.img,gy);b1=gA;bh=b};var A=function(){b5(this);aw.imgDraw=this.FSI_image_context;fp=fy};var fy=function(){ar(aw.imgDraw,U.imageX,U.imageY,ge)};var ay=function(o){if(ee==o){return c5}ee=o;gr.putImageData(e[o],0,0);c5=c3;return c5};var cg=function(o){if(ee==o){return c5}ee=o;if(!cC){cC=t.imageWidth;if(gl){au=document.createElement("canvas");au.setAttribute("width",t.imageWidth);au.setAttribute("height",t.imageHeight);gg=au.getContext("2d")}}if(!gl){c5=e[o].FSI_image_context}else{gg.drawImage(e[o].FSI_image_context,0,0,t.imageWidth,t.imageHeight);c5=au}return c5};var b2=function(){b8.globalAlpha=1;var o=ge*t.videoWidth/cv.croppedWidth;ar(ay(cW),U.videoX,U.videoY,o);if(P&&fL.pellets&&!C){b8.globalAlpha=fL.pelletsOpacity;b8.globalCompositeOperation="xor";ar(dE,U.videoX,U.videoY,o);b8.globalAlpha=1;b8.globalCompositeOperation="source-over"}};var fK=function(){ar(cg(cW),U.imageX,U.imageY,ge)};var ar=function(gA,gH,gE,gy){var gG,gF;var gB=ap.drawOffsetX+gH+bI.panPos.left;var gz=ap.drawOffsetY+gE+bI.panPos.top;if(gB<0){gG=-gB/gy;gB=0}else{gG=0}if(gz<0){gF=-gz/gy;gz=0}else{gF=0}var gI=gA.width-gG;var gD=gA.height-gF;var gC=gI*gy;var o=gD*gy;b8.drawImage(gA,gG,gF,gI,gD,gB,gz,gC,o)};var cz=function(){if(fu!=b){dL()}if(bI.enabled&&h){fu=new a.NavigatorWindow(f3,fz,aN)}};var dL=function(){if(fu==b){return}fu.destroy();fu=b};var bQ=function(){if(!dA||!dj.targetObj){return}var gA=aZ.width*ap.scale;var gE=aZ.height*ap.scale;dj.sceneWidth=a0.imageWidth*aJ.cropScaleX;dj.sceneHeight=a0.imageHeight*aJ.cropScaleY;var gB=dj.sceneWidth;var o=gB/1.5;var gD=o/gE;var gC=fL.camera.digitalCropFactor*fL.camera.focalLength*gD;var gy=2*THREE.Math.radToDeg(Math.atan(24/gC/2));dj.camera=new THREE.PerspectiveCamera(gy,dj.sceneWidth/dj.sceneHeight,0.1,10000);var gz=fz.parsePositionParameter(fL.camera.position);if(gz!=b){aQ.x=gz.x;aQ.y=gz.y;aQ.z=gz.z}else{if(fL.camera.heightTable!=b&&fL.camera.heightCamera!=b){fL.camera.heightAboveTable=fL.camera.heightCamera-fL.camera.heightTable}if(fL.camera.shiftX==b){fL.camera.shiftX=0}aQ.x=fL.camera.shiftX;aQ.y=fL.camera.heightAboveTable;aQ.z=fL.camera.distanceToTableCenter}dj.camera.position.x=aQ.x;dj.camera.position.y=aQ.y;dj.camera.position.z=aQ.z;en();dj.camera.lookAt(dj.targetObj.position);dj.camera.rotation.z=0;eE();dj.camera.setViewOffset(gA,gE,-ap.drawOffsetX+aJ.x,-ap.drawOffsetY+aJ.y,gA,gE)};var gt=function(){if(!dA){return}var g0;g0=window.THREE;if(a.BrowserSupports.canvas()&&typeof g0!=="undefined"){if(h){dj.renderer=new g0.CanvasRenderer({canvas:fw,clearColor:0,clearAlpha:0,devicePixelRatio:1});dj.renderer.autoClear=false;dj.renderer.setSize(aZ.width*ap.scale,aZ.height*ap.scale)}else{dj.renderer=new g0.CanvasRenderer({clearColor:0,clearAlpha:0});dj.renderer.autoClear=false;dj.renderer.setSize(aZ.width,aZ.height)}dj.scene=new g0.Scene();dj.projector=new g0.Projector();dj.objects=new g0.Object3D();var gI=new g0.Object3D();var gZ=fz.parsePositionParameter(fL.camera.targetPosition);if(gZ==b){gI.position.x=fL.camera.targetWidthOffset;gI.position.y=fL.camera.targetHeightOffset;gI.position.z=0}else{gI.position.x=gZ.x;gI.position.y=gZ.y;gI.position.z=gZ.z}dj.scene.add(gI.position);dj.targetObj=gI;var gH;if(fL.virtualSpace.cubeLineWidth>0&&fL.drawCube){var gX,gz;if(fL.virtualSpace.cubeSizeX){gX=new g0.CubeGeometry(fL.virtualSpace.cubeSizeX,fL.virtualSpace.cubeSizeY,fL.virtualSpace.cubeSizeZ);gH=fL.virtualSpace.cubeSizeY/2}else{gX=new g0.CubeGeometry(fL.virtualSpace.cubeSize,fL.virtualSpace.cubeSize,fL.virtualSpace.cubeSize);gH=fL.virtualSpace.cubeSize/2}gz=new g0.MeshBasicMaterial({color:65280,wireframe:true,wireframeLinewidth:fL.virtualSpace.cubeLineWidth});var gD=new g0.Mesh(gX,gz);if(fL.virtualSpace.shiftY==b){fL.virtualSpace.shiftY=0}gD.position.x=fL.virtualSpace.shiftX;gD.position.y=gH+fL.virtualSpace.shiftY;gD.position.z=fL.virtualSpace.shiftZ;dj.cube=gD;dj.objects.add(gD)}if(fL.drawGroundPlate){var gO=new g0.PlaneGeometry(500,500,10,10);var gJ=new g0.MeshLambertMaterial({color:15626314,wireframe:true});var gA=new g0.Mesh(gO,gJ);gA.rotation.x=-Math.PI/2;gA.position.y=0;dj.objects.add(gA);dj.plane=gA}if(fL.drawTable){var o=fL.tableDiameter/2;var gT=50;var gy=new g0.Geometry();var g3;g3=Math.PI*2/360;var gP=0;var gE=function(g7,g6){var g9=0;var ha=0;var he=0;var g8=0;for(var hb=0;hb<=36;hb++,gP+=4){var g5=Math.sin(g3*hb)*g7;var hd=Math.cos(g3*hb)*g7;var g4=Math.sin(g3*hb)*g6;var hc=Math.cos(g3*hb)*g6;gy.vertices.push(new g0.Vector3(g4,hc,0));gy.vertices.push(new g0.Vector3(he,g8,0));gy.vertices.push(new g0.Vector3(g9,ha,0));gy.vertices.push(new g0.Vector3(g5,hd,0));gy.faces.push(new g0.Face4(gP,gP+1,gP+2,gP+3));g9=g5;ha=hd;he=g4;g8=hc}};var gF=0;var gC=0;for(var gY=0;gY<=4;gY++,gP+=3){var gN=Math.sin(g3*gY*90)*gT;var gM=Math.cos(g3*gY*90)*gT;gy.vertices.push(new g0.Vector3(0,0,0));gy.vertices.push(new g0.Vector3(gN,gM,0));gy.vertices.push(new g0.Vector3(gF,gC,0));gy.faces.push(new g0.Face3(gP,gP+1,gP+2));gF=gN;gC=gM}g3=Math.PI*2/36;var gS=0;var gR=gT;while(gR<o){gS+=gT;gR=gS+gT;if(gR>o){gR=o}gE(gS,gR)}var gW=new g0.Mesh(gy,new g0.MeshLambertMaterial({color:5810431,wireframe:true}));gW.rotation.x=-Math.PI/2;dj.disk=gW;dj.objects.add(gW)}var g2=new g0.Vector3(0,1,0);var gQ=new g0.Color(16755200);var gL=new g0.Face3(0,1,2,g2,gQ,0);dj.objects.add(gL);if(fL.hotspots&&fL.hotspots.points){aM();fE=fL.hotspotCallbackFunction;if(typeof(fE)=="string"){try{fE=window[fE]}catch(gV){}}else{if(typeof(fE)!="function"){fE=b}}for(var gU=0;gU<fL.hotspots.points.length;gU++){var gG=fL.hotspots.points[gU];gG.FSIHotspotID=gU;if(gG.perimeterAngle!=b&&gG.perimeterAngleY==b){gG.perimeterAngleY=gG.perimeterAngle;gG.perimeterAngleYRange=gG.perimeterAngleRange;gG.perimeterAngleYFadeOut=gG.perimeterAngleFadeOut}if(gG.perimeterAngleY&&gG.perimeterAngleY<0){gG.perimeterAngleY=360+gG.perimeterAngleY}gG.perimeterAngleYFadeOut=Math.min(gG.perimeterAngleYRange,gG.perimeterAngleYFadeOut);if(gG.perimeterAngleX&&gG.perimeterAngleX<0){gG.perimeterAngleX=360+gG.perimeterAngleX}gG.perimeterAngleXFadeOut=Math.min(gG.perimeterAngleXRange,gG.perimeterAngleXFadeOut);var gK=new g0.Object3D();gK.position.x=gG.x+fL.virtualSpace.shiftX;gK.position.y=gG.y+fL.virtualSpace.shiftY;gK.position.z=gG.z+fL.virtualSpace.shiftZ;gG.object=gK;dj.objects.add(gK);if(fL.hotspots.visible){var g1=new g0.Mesh(new g0.SphereGeometry(5,8,4),new g0.MeshLambertMaterial({color:255,wireframe:false}));g1.position.x=gG.x;g1.position.y=gG.y;g1.position.z=gG.z;dj.objects.add(g1)}if(fL.hotspots.defaults){for(var gB in fL.hotspots.defaults){if(gG[gB]==b){gG[gB]=fL.hotspots.defaults[gB]}}}cY(gG)}c6.log(gU+" HotSpots created.")}dj.scene.add(dj.objects);bQ()}};var eH=function(o){var gy=o.type;fe(gy,this)};var fe=function(gA,o){var gz=o.FSIHotspot;if(!gz||!gA){return}switch(gA){case"mouseover":a.addClass(o,gz.hoverClass);break;case"mousedown":a.addClass(o,gz.activeClass);break;case"mouseout":a.removeClass(o,gz.hoverClass);break;default:a.removeClass(o,gz.activeClass)}if(gA=="click"&&gz.url!=b){window.open(gz.url,gz.urlTarget)}if(!fE){return}var gB=gz.FSIHotspotID;var gy=gz.tooltip;var gC=gz.actionParameter;fE(gA,aY,K,gB,gy,gC,gz.perimeterAngleY,gz.perimeterAngleX)};var dG=function(){if(!dA){return}dj.objects.remove(dj.cube);dj.objects.remove(dj.plane);dj.objects.remove(dj.disk)};var eI=function(gz,gy,o){dj.objects.rotation.x=gz;dj.objects.rotation.y=gy+fL.virtualSpace.baseRotationYRad;dj.objects.rotation.z=o};var br=function(){if(di){di=false;var gA=1/eg;gi.testWidth=ge*t.imageWidth;T.style.webkitTransform="scale("+gA+")";T.style.transform="scale("+gA+","+gA+")"}var gS=eg*ap.left;var gR=eg*ap.top;var gT=eg*aZ.width/2;var gC=eg*aZ.height/2;var gH,gJ;var gP=false;var gI,gW;var gV=aZ.width*eg;var gU=aZ.height*eg;if(gi.spinFrame!=cW){gi.spinFrame=cW;if(gi.arSpotsAtFrame==b){gi.arSpotsAtFrame=new Array(dT)}var gN=gi.hotSpotsAtThisFrame;gi.hotSpotsAtThisFrame=gi.arSpotsAtFrame[cW];if(gi.hotSpotsAtThisFrame==b){var gF=fL.virtualSpace.rotationYRange*gq(d2)/dT;gi.hotSpotsAtThisFrame=gi.arSpotsAtFrame[cW]=new Array();for(var gQ=0;gQ<fL.hotspots.points.length;gQ++){gI=fL.hotspots.points[gQ];gJ=1;if(gI.perimeterAngleY!=b){var gX=Math.abs(gI.perimeterAngleY-gF);if(gX>180){gX=Math.abs(360-gX)}if(gX<gI.perimeterAngleYRange){if(gX>gI.perimeterAngleYRange-gI.perimeterAngleYFadeOut){gJ=(gI.perimeterAngleYRange-gX)/gI.perimeterAngleYFadeOut}}else{gJ=0}}if(gJ!=0){var gM={};gM.index=gQ;gM.hotspot=gI;gM.op=gJ;gi.hotSpotsAtThisFrame.push(gM);gH=gI.object.matrixWorld.getPosition();gM.zIndex=Math.round(gH.z)}}}if(gN&&gN.length>0){var gL={};for(var gO=0;gO<gi.hotSpotsAtThisFrame.length;gO++){var gz=gi.hotSpotsAtThisFrame[gO];gI=gz.hotspot;gI.marker.style.zIndex=gI.tooltip.style.zIndex=gz.zIndex;gL[gz.index]=gI.bVisible}for(var gO=0;gO<gN.length;gO++){if(!gL[gN[gO].index]){bo(gN[gO].hotspot,false)}}}}if(gi.scale!=eg){gi.scale=eg;gP=true}var gG=cr.xAngleToTargetDeg;for(var gQ=0;gQ<gi.hotSpotsAtThisFrame.length;gQ++){var gB=gi.hotSpotsAtThisFrame[gQ];gI=gB.hotspot;gJ=1;if(cr.visibleHotSpots){gJ=cr.visibleHotSpots[gI.FSIHotspotID]}gJ=gJ*gB.op;if(!gP&&gI._opScale!=b){if(gI._opScale==0){gJ=0}}else{gI._opScale=1;if(fL.enableZoom&&gI.perimeterZoom!=b){if(ge<gI.perimeterZoom){gJ=gI._opScale=0}}if(gJ!=0&&gI.perimeterImageWidth!=b){if(gi.testWidth<gI.perimeterImageWidth){gJ=gI._opScale=0}}}if(gJ!=0){gH=gI.object.matrixWorld.getPosition();var gy=dj.projector.projectVector(gH,dj.camera);var gE=Math.round(gS+gy.x*gT+gT);var gD=Math.round(gR+gC-gy.y*gC);if(bI.enabled){if(gE<0||gD<0||gE>gV||gD>gU){gJ=0}}}if(gJ!=0){bo(gI,true);if(gI._opacity!=gJ){gI._opacity=gJ;gI.marker.style.opacity=gI.tooltip.style.opacity=gJ}var gK=gI.oSvg;gI.tooltip.style.left=gE+gK.endX+(gI.tooltip.offsetWidth*gK.xAlign)+"px";gI.tooltip.style.top=gD+gK.endY+(gI.tooltip.offsetHeight*gK.yAlign)+"px";gI.marker.style.left=gE+gK.startX+"px";gI.marker.style.top=gD+gK.startY+"px"}else{bo(gI,false)}}};var aH=function(gA,gF,gy,gE,o,gD,gB,gz,gC){if(gz==b){gz=bg}if(gC==b){gC=1}var gG=document.createElementNS(c9,"polyline");gG.setAttribute("points",gA+","+gF+" "+gy+","+gE+" "+o+" , "+gD+" "+gy+","+gE+" "+gA+","+gF);gG.setAttribute("stroke",gB);gG.setAttribute("stroke-width",gz);gG.setAttribute("stroke-opacity",gC);gG.setAttribute("stroke-linecap","square");return gG};var aM=function(){var gB=aC=document.createElementNS(c9,"svg");try{if(!gB.style){aC=b;c6.log("ERROR: SVG Gradient not supported");return false}}catch(gD){aC=b;c6.log("ERROR: SVG Gradient not supported");return false}var gI=a.getSVGID();var gC=fL.hotspotDotRadius;var gz=0,gK=0;var gy=1,gH=1;var o=2,gF=2;gB.setAttribute("xmlns",c9);gB.setAttribute("version",fd);gB.setAttribute("baseProfile","tiny");var gA=gB.cloneNode(true);try{var gL=document.createElementNS(c9,"radialGradient");gL.setAttribute("id",gI);gL.setAttribute("cx","0.5");gL.setAttribute("cy","0.5");gL.setAttribute("r","0.5");var gJ=document.createElementNS(c9,"stop");gJ.setAttribute("stop-color",fL.hotspotDotColor1);gJ.setAttribute("offset","0.5");var gG=document.createElementNS(c9,"stop");gG.setAttribute("stop-color",fL.hotspotDotColor2);gG.setAttribute("offset","1");gL.appendChild(gJ);gL.appendChild(gG);gA.appendChild(gL);gA.style.position="absolute";T.appendChild(gA)}catch(gD){c6.log("ERROR: SVG Gradient not supported")}var gE=document.createElementNS(c9,"circle");gE.setAttribute("r",gC);gE.setAttribute("stroke",fL.hotspotLineColor2);gE.setAttribute("stroke-width","1px");gE.setAttribute("stroke-opacity","0.85");gE.setAttribute("fill","url(#"+gI+")");gE.setAttribute("fill-opacity","0.5");gB.appendChild(gE);return true};var aU=function(gD){var gI=gD.horizontalMarkerSize;var gN=Math.abs(gD.verticalMarkerSize);var gR;if(!aC){return{width:0,height:0,startX:0,startY:0,endX:0,endY:0,xAlign:0,yAlign:0}}var gF=gD.markerAngle*Math.PI/180;var gO,gB,gM,gA,gK,gz;var gT={};var gC=gT.radius=fL.hotspotDotRadius+1;gR=Math.max(0,Math.min(1,gD.horizontalMarkerPosition));if(gR>0.5){gI=-gI}gT.xAlign=-gR;gR=Math.max(0,Math.min(1,gD.verticalMarkerPosition));gT.yAlign=-gR;gO=0;gB=0;gM=gO+Math.sin(gF)*gN;gA=gB-Math.cos(gF)*gN;gK=gM+gI;var gP=Math.min(gO-gC,gM);var o=Math.min(gB-gC,gA);gP=Math.min(gP,gK);var gH=Math.sin(gF);var gJ=Math.cos(gF);gO-=gP;gM-=gP;gK-=gP;gB-=o;gA-=o;gz=gA;gT.startX=-gO;gT.startY=-gB;gT.endX=gT.startX+gK;gT.endY=gT.startY+gz;var gS=Math.max(gO+gC,gM);gS=Math.max(gS,gK);var gy=Math.max(gB+gC,gA);var gG=gT.svg=aC.cloneNode(true);var gE=gT.width=gS;var gL=gT.height=gy;gG.setAttribute("width",gE);gG.setAttribute("height",gL);gG.setAttribute("viewBox","0 0 "+gE+" "+gL);gG.setAttribute("class","fsi-ui-hotspot-line");var gQ=gG.firstChild;gQ.setAttribute("cx",gO);gQ.setAttribute("cy",gB);gO+=Math.sin(gF)*gC;gB-=Math.cos(gF)*gC;gG.appendChild(aH(gO,gB,gM,gA,gK,gz,fL.hotspotLineColor1,"5px","0.25"));gG.appendChild(aH(gO,gB,gM,gA,gK,gz,fL.hotspotLineColor2,"1px"));return gT};var bo=function(gy,o){if(gy.bVisible==o){return}gy.bVisible=o;if(o){gy._opacity=b;gy.marker.style.display=gy.tooltip.style.display="block"}else{gy.marker.style.display=gy.tooltip.style.display="none";gy._opacity=0;gy.marker.style.opacity=gy.tooltip.style.opacity=0}};var cY=function(gC){var gy=document.createElement("div");var gz="fsi-ui-hotspot";if(bJ){gz+=" "+bJ}if(gC.cssClass!=b&&gC.cssClass.length>0){gz+=" "+gC.cssClass}if(gC.normalClass.length>0){gC.normalClass=gz+" "+gC.normalClass}else{gC.normalClass=gz}if(gC.hoverClass.length>0){gC.hoverClass="fsi-ui-hotspot-hover "+gC.hoverClass}else{gC.hoverClass="fsi-ui-hotspot-hover"}if(gC.activeClass.length>0){gC.activeClass="fsi-ui-hotspot-active "+gC.activeClass}else{gC.activeClass="fsi-ui-hotspot-active"}gy.className=gC.normalClass;var gA="position:absolute;left:0px;top:0px;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;"+gC.cssStyle;a.setStyleAttr(gy,gA);gy.innerHTML=gC.text;if(fL.decodeHTMLEntitiesInHotSpotTexts){gy.innerHTML=gy.innerText}var gB=aU(gC);var o;if(gB&&gB.svg){o=gB.svg;o.style.position="absolute";T.appendChild(o)}else{o={style:{}}}if(gC.interactive){gy.FSIHotspot=gC;T.appendChild(gy);a.addEvent(gy,"mouseover",eH);a.addEvent(gy,"mouseout",eH)}else{gy.style.zIndex="1";T.appendChild(gy)}gC.bVisible=false;gC.tooltip=gy;gC.marker=o;gC.oSvg=gB;gy.style.display="none";o.style.display="none"};var cA=function(o){av();var gy=true;var gz=(dT&&!cI);eQ=o.shiftKey;switch(o.keyCode){case 37:if(gz){bw();dc=1;gb(dH+de)}gy=false;break;case 39:if(gz){bw();dc=-1;gb(dH-de)}gy=false;break;case 32:gy=false;break}if(!gy&&o.preventDefault){o.preventDefault()}return gy};var dX=function(gy){var gz=Math.round(100*gy);var o=""+gz/100;if(gz%100==0){o+=".0"}if(gz%10==0){o+="0"}return o};var bW=function(o){eQ=o.shiftKey;if(c6&&c6.on){if(!eQ){bC(bD)}}var gy=true;var gz=(dT&&!cI);switch(o.keyCode){case 37:if(gz){eb(d2,true)}gy=false;break;case 39:if(gz){eb(d2,true)}gy=false;break;case 32:aY.resetView();gy=false;break}if(!gy){o.cancelBubble=true;if(o.stopPropagation){o.stopPropagation()}if(o.preventDefault){o.preventDefault()}}return gy};this.resetView=function(){av(false);d0();if(fL.initialview&&fL.initialViewPersistent){f9(fL.initialview,true)}else{f9("1,1,0,0,1,1",true)}};this.spinToDegree=function(o){if(!b1){return}var gy=gq(Math.round(o/360*dT));aY.spinToTarget(gy)};this.spinToTarget=function(gA,gD,gB){if(!b1){return}gA=cR(gA);var gG=gq(d2);var gC=gA-gG;var o=(gD!=b&&!isNaN(gD)&&gD!=aP.nCurrent);if(gC==0&&!o){dK(gA,gA,0,0);return true}var gF;if(gC!=0){dc=(gC>0)?1:-1;gF=gG;if(!fL.noSceneLoop){if(Math.abs(gC)>dT/2){if(dc>0){gA-=dT}else{gF-=dT}dc=-dc;gC=Math.abs(gA-gF)}}}else{gF=gA}var gy=aP.nCurrent;if(o&&!fL.noSetLoop&&aP.nSceneSets>1){var gE=gD-aP.nCurrent;if(Math.abs(gE)>aP.nSceneSets/2){if(gE>0){gD-=aP.nSceneSets}else{gy-=aP.nSceneSets}}}bw();if(gB==b||isNaN(gB)){gB=4;if(gC!=0){gB=Math.ceil(0.2*360/dT*Math.abs(gC))}if(o){var gE=Math.abs(gD-gy);var gz=Math.ceil(0.1*360/aP.nSceneSets*gE);gB=Math.max(gB,gz)}}dK(gF,gA,0,gB,gy,gD);return true};var V=function(o){if(aP.nSceneSets<2){return 0}if(fL.noSetLoop){o=Math.max(0,Math.min(aP.nSceneSets-1,o))}else{o=o%aP.nSceneSets;if(o<0){o=aP.nSceneSets+o}}return o};var dw=function(){cr={};aP.bSetCameraPosition=false;aP.initialScene=aP.initialSceneSet=aP.nCurrent=0;aP.arCurrentSetIndex=false;bk=ab=gd.length;co=(e.length>0)?e.length:bk;aK(co);aL=false};var a6=function(){if(aP.bHasMultipleSets){aK(aP.quantizeMax);ab=aP.quantizeMax;aP.nCurrent=b;fa(0)}else{dw()}};var fa=function(gz){gz=V(gz);if(gz==aP.nCurrent){return}aP.nCurrent=gz;cr=aP.arSets[gz];var gy=aP.arCurrentSetIndex=aP.arSets[gz].arScenes;aL=gy;bk=aP.quantizeMaxImages;co=bk;if(aP.nVideoSet!=b){if(aP.nVideoSet==gz){ab=bk=gy.length;co=db;if(fu){fu.setPreviewImageSize(cv.croppedWidth,cv.croppedHeight)}if(!eF){dR("video",true)}aL=b}else{if(fu){fu.setPreviewImageSize()}ab=aP.quantizeMax;if(eF){dR("image",true)}}}eE();df();var o=d2;ee=d2=b;if(cU){cU.spinPos=b}bP(o);gk();return gz};var eE=function(){if(!aP.bSetCameraPosition||!cr.posCamera){return}var o=cr.posCamera;dj.camera.position.set(o.x,o.y,o.z);dj.camera.lookAt(dj.targetObj.position);dj.camera.rotation.z=0};var aR=function(o){o=Math.max(0,Math.min(dT-1,o));return o};var er=function(o){o%=dT;if(o<0){o=dT+o}return o};var cR=function(gy,gB){if(!f8){return gy}var gA;var o=dT/bk;var gz=Math.round(gy/o)*o;if(!gB||gy==gz){gA=gz}else{if(dc==1){gA=Math.round(gz+o)}else{gA=Math.round(gz-o)}}gA=gq(gA);return gA};var eb=function(o,gA){var gy=(o!=b)?o:d2;var gz=cR(gy,gA);aY.spinToTarget(gz)};var dK=function(o,gB,gC,gA,gz,gy){o=Math.round(o);gB=Math.round(gB);bw();if(gy!=b&&!isNaN(gy)&&gy!=aP.nCurrent){if(gz==b){gz=aP.nCurrent}}else{gz=b}if(o!=gB||gz!=gy){if(a7(o,gB,gC,gA,gz,gy)){bE("spinToFrame")}else{fA("doSpinToFrame")}}else{fA("doSpinToFrame")}};var bw=function(){if(eY==b){return}cancelAnimationFrame(eY);eY=b;fA("cancelSpinToFrame")};var a7=function(gB,gH,gG,gC,gy,gE){var gF=gH-gB;var gD;if(gF==0){gD=gH}else{gD=aB(gG,gC,gB,gF)}var gA;if(gy!=b){var gz=gE-gy;gA=Math.round(aB(gG,gC,gy,gz))}if(gG!=gC){if(el){el.lockImageSourceDimension(by,true);el.lockImage(by,true)}var o=Math.round(gD);if(o<0){o=dT+o}else{if(o==dT){o=0}}eY=requestAnimationFrame(function(){if(gy!=b){fa(gA)}if(o!=d2){df();bP(o);gk()}a7(gB,gH,++gG,gC,gy,gE)});return true}else{eY=b;if(el){el.lockImage(by,false)}bP(gq(gH));if(gE!=b){fa(gE)}bM();bR();fA("doSpinToFrame")}};var bM=function(){bP(gq(d2));gk();if(h){eG()}};var f1=function(gy){var o={};o.baseURL=fz.getImageURL(gd[gy],eC);o.fullURL=o.baseURL+f4;return o};var eL=function(){if(!cU){return}bU=b;cU=b;a1=b;P=true;M()};var bt=function(){if(bh==bq){return}bh=bq;var o=eN.getPixelRangeRect(bq);f4=eN.getPixelRangeParametersByCalculatedResult(o)};var ax=function(o){if(o==b){o=Math.round(d2/(dT/ab))}if(isNaN(o)||o<0||o>=ab){c6.error("invalid image index in loadHDImage "+o);return}if(aP.arCurrentSetIndex){o=aP.arCurrentSetIndex[o]}o-=db;return o};var eG=function(gL){if(h&&!eF&&ge<=1){eL();return}if(eu||bU==bq){return}bU=bq;gL=ax(gL);bt();var gy=f1(gL);if(a1==gy.fullURL){return}if(cU&&gy.fullURL==cU.src){return}b7={};b7.img=new Image();b7.nImage=gL;b7.renderScale=ge;var gz=dT/bk;b7.spinPos=cR(gL*gz);b7.img.crossOrigin="anonymous";b7.img.FSI_ImageObject=b7;a1=b7.src=gy.fullURL;if(h){P=true;b7.bTilesFading=false;b7.bFillsViewport=false;var gG=em.width;var gF=em.height;var gE=bq;var gC=Math.round(gE/gG*gF);b7.width=gE;b7.height=gC;var o="&referenceWidth="+gE+"&referenceHeight="+gC;var gM=eX;b7.tiles=[];var gJ=0;var gH=0;var gK=gM;var gI=gM;gK=Math.min(gK,gE);gI=Math.min(gI,gC);var gB;var gA=false;while(gH<gC){gB={};gB.fnDraw=dU;gB.FSI_ImageObject=b7;gB.x=gJ;gB.y=gH;if(gJ+gK>=gE){gB.width=gE-gJ;gK=Math.min(gM,gE-gJ);gA=true}gB.width=gK;gB.height=gI;var gD=eN.getPixelRangeParameters(gE,gC,gJ,gH,gK,gI);gB.url=gy.baseURL+gD;if(gA){gA=false;gH+=gM;gJ=0;gK=gM;if(gH+gM>gC){gI=Math.min(gM,gC-gH)}}else{gJ+=gM}b7.tiles.push(gB)}b7.nTiles=b7.tiles.length;b7.arVisibleTiles=new Array(b7.nTiles);b7.nVisibleTiles=0;b7.nTilesLoading=0;b7.nTilesLoaded=0;b7.nTilesRequested=0;b7.nTileColumns=Math.ceil(gE/gM);b7.nTileRows=Math.ceil(gC/gM);y=true;N(null,b7)}};var dJ=function(o){o.bLoading=true;o.img=new Image();o.img.oTile=o;a.addEvent(o.img,"load",aV);fk(o.img,o.url)};var aV=function(){a.removeEvent(this,"load",aV);var gy=this.oTile;gy.bLoaded=true;var o=gy.FSI_ImageObject;if(o.nTilesLoaded==o.nTiles){o.bComplete=true;o.bFillsViewport=true}if(o.src!=a1){return}gy.alpha=0;gy.fnDraw=fZ;o.nTilesLoading--;o.nTilesLoaded++;N(null,o);b5(this);gk();cy(25)};var bL=function(gy,o){return o.distance-gy.distance};var f7=function(){y=false;if(!cU){return}var gE=cU;var gO,gN,gz,o;var gD;if(bI.enabled){eT.setRect(0,0,aZ.width,aZ.height);eT.scaleRect(1/bI.scale);eT.offsetRect(-bI.panPos.left/ge,-bI.panPos.top/ge);eT.offsetRect((aZ.width-eT.width())/2,(aZ.height-eT.height())/2);dh.copyRect(aS);dh.scaleRect(1/bI.scale);dh.offsetRect(eT.left,eT.top);gD=dh}else{gD=aS}bX(gD);gO=e8.left;gN=e8.top;gz=e8.right;o=e8.bottom;var gL=Math.max(0,Math.floor(gO/eX));var gA=Math.min(gE.nTileColumns-1,Math.floor(gz/eX));var gK=Math.max(0,Math.floor(gN/eX));var gy=Math.min(gE.nTileRows-1,Math.floor(o/eX));var gB=gA-gL+1;var gG=gy-gK+1;var gH=Math.max(0,gG)*gB;if(gE.nFirstTileXLastGetVisible==gL&&gE.nFirstTileYLastGetVisible==gK&&gE.nTilesLastGetVisible==gH){return}gE.nFirstTileXLastGetVisible=gL;gE.nFirstTileYLastGetVisible=gK;gE.nTilesLastGetVisible=gH;var gQ=gE.tiles;var gP=gE.arVisibleTiles;var gI=gK*gE.nTileColumns;var gC=gL;var gJ;var gF=P;P=false;for(var gM=0;gM<gH;gM++){gJ=gP[gM]=gQ[gI+gC];if(!P&&gJ.alpha!=1){P=true}if(++gC>gA){gC=gL;gI+=gE.nTileColumns}}gE.nVisibleTiles=gH;gE.bFilesArePreparedForLoading=false;if(P&&!gF){b8.globalAlpha=1;fp()}cy(50)};var M=function(){if(fN){clearTimeout(fN);fN=b}};var cy=function(o){if(fN!=b){return}if(!cU||cU.bRequestsComplete){return}fN=setTimeout(fW,o)};var fW=function(){M();B()};var B=function(){if(O){return}var gB=cU;if(gB.nTilesLoading>=ei){return}var gE,gz,gy;if(!gB.bFilesArePreparedForLoading){gB.bFilesArePreparedForLoading=true;if(!gB.arTilesToLoad||gB.arTilesToLoad.length!=0){gB.arTilesToLoad=[]}gE=gB.arTilesToLoad;var gC=gB.arVisibleTiles;for(var gA=0;gA<gB.nVisibleTiles;gA++){if(!gC[gA].bLoading){gE.push(gC[gA])}}if(gE.length>1){bI.centerX=e8.left+e8.width()/2;bI.centerY=e8.top+e8.height()/2;for(var gA=0;gA<gE.length;gA++){var gD=gE[gA];gz=gD.x-bI.centerX+gD.width/2;gy=gD.y-bI.centerY+gD.height/2;gD.distance=Math.abs(gz)+Math.abs(gy)}gE.sort(bL)}}var o=0;gE=gB.arTilesToLoad;while(gB.nTilesLoading<ei&&gE.length>0){var gD=gE.pop();dJ(gD);o++;gB.nTilesLoading++}gB.nTilesRequested+=o;if(gB.nTilesRequested==gB.nTiles){gB.bRequestsComplete=true}};var N=function(o,gy){if(gy==b){a.removeEvent(this,"load",N);gy=this.FSI_ImageObject;gy.width=this.width;gy.height=this.height}if(gy.src!=a1){return}b5(this);cU=gy;if(gv){return}gk()};this.onMenuButtonPress=function(gy){av();d0();bv();var o,gz;if(gy.indexOf("_")!=-1){o=gy.split("_");gy=o[0];gz=o[1]}switch(gy){case"Reset":aY.resetView();break;case"ZoomOut":case"ZoomIn":Y(gy,150,10);break;case"MouseMode":eB(parseInt(gz));break;case"MaxZoom":e2(b,b,bI.scaleToSourceImage-ge,false,30);break}};var cd=function(gz,gy){var o=false;if(ct){o=ct.enableButton(gz,gy);if(o){if(typeof(aY.onEnableMenuButton)=="function"){aY.onEnableMenuButton(gz,gy)}}}else{if(typeof(aY.onEnableMenuButton)=="function"){aY.onEnableMenuButton(gz,gy)}}return o};this.onMenuButtonRelease=function(gy){bv();var o,gz;if(typeof(gy)=="string"&&gy.indexOf("_")!=-1){o=gy.split("_");gy=o[0];gz=o[1]}switch(gy){case"FullScreen":if(a.FullScreen.getEnabled()){c4();a.FullScreen.quit()}else{a.FullScreen.start(f5);c4()}break;case"Hotspots":cT=ct.getButtonPressed("Hotspots");fq(cT);break}};var ac=function(gy){if(!bI.enabled){return}var o=ge;fo(gy);bI.panPos.left*=ge/o;bI.panPos.top*=ge/o;bG(true)};var eW=function(gy){if(gy==b){gy=bn.cmd;bn.nRepeatCount++}switch(gy){case"ZoomOut":var o=(bn.nRepeatCount<1)?1.01:1.035;ac(bI.scale/o);break;case"ZoomIn":var o=(bn.nRepeatCount<1)?1.01:1.035;ac(bI.scale*o);break}if(bn.nRepeatCount==1){if(bn.intervalTimeFirst!=bn.intervalTimeRepeat){clearInterval(bn.interval);bn.interval=setInterval(eW,bn.intervalTimeRepeat)}}};var Y=function(gz,o,gy){aG(false);bv();bn={};bn.bRunning=true;if(o==b){o=500}bn.intervalTimeFirst=o;if(gy==b){bn.intervalTimeRepeat=o}else{bn.intervalTimeRepeat=gy}bn.nRepeatCount=0;bn.cmd=gz;eW(gz);bn.interval=setInterval(eW,bn.intervalTimeFirst)};var bv=function(){if(!bn.bRunning){return}aG(true);clearInterval(bn.interval);switch(bn.cmd){case"ZoomOut":case"ZoomIn":ek();break}bn={}};var ej=function(o){if(Q!=b){if(Q.width!=a0.imageWidth){bl()}else{return}}if(f8){return}Q={};Q.previewImageCanvasWidthBeforeResize=o;Q.uniqueInstanceID=ah;Q.nTimeout=setTimeout(dB,50)};var dB=function(){if(!b1){Q.nTimeout=setTimeout(dB,250);return}if(!fL.loadExactPreviewImagesAfterResize){var gy=Q.previewImageCanvasWidthBeforeResize/a0.imageWidth;if(Math.abs(1-gy)<0.05){bl();return}}Q.nTimeout=b;Q.img=new Image();a.addEvent(Q.img,"load",ag);Q.pos=0;Q.arIndex=new Array(e.length);Q.arIndex[0]=cW;for(var o=0,gz=1;o<e.length;o++){if(o!=cW){Q.arIndex[gz++]=o}}ag()};var ag=function(o){if(o!=b){if(!Q||Q.uniqueInstanceID!=ah){return}a.removeEvent(Q.img,"load",ag);b5(Q.img);e[Q.indexCurrent]=Q.img;if(Q.pos==1){au=b;cC=b;ee=b;bz(Q.indexCurrent)}if(Q.indexCurrent==cW){ee=b;gk()}Q.img=new Image();a.addEvent(Q.img,"load",ag)}Q.indexCurrent=Q.arIndex[Q.pos];Q.pos++;if(Q.pos>e.length){bl()}else{var gy=bq;bq=az;bt();Q.url=f1(Q.indexCurrent).fullURL;bq=gy;bt();Q.nTimeout=setTimeout(cO,50)}};var cO=function(){fk(Q.img,Q.url)};var bl=function(){if(Q==b){return}if(Q.nTimeout){clearTimeout(Q.nTimeout);Q.nTimeout=b}a.removeEvent(Q.img,"load",ag);Q=b};var cs=function(){c4()};var aO=function(){c6.error("ERROR entering FullScreen")};var c4=function(){var o=a.FullScreen.getEnabled();if(ct){ct.setButtonPressed("FullScreen",o)}if(o==dD){return}dD=o;if(o==true){a.FullScreen.addChangeEvents(window,cs,aO)}else{a.FullScreen.removeChangeEvents(window,cs,aO)}};this.getInFullScreenMode=function(){return dD};this.getSpinFrames=function(){return dT};this.getImageIsTransparent=function(){return dl};this.getSrcDim=function(){return em};var fv=f3;fv.iViewer=aY;fv.getToolTipObject=function(){return fb};fv.getElementSpace=function(){return ae};fv.getDrawRatio=function(){return U};fv.getdrawRatioUnZoomed=function(){return a0};fv.getdrawRatioUnResized=function(){return t};fv.getinPlaceZoom=function(){return bI};fv.getRootContainer=function(){return f5};if(typeof(dO)!="object"||a.makeBool(dO.autoInit,true)){aY.init(fD,dO)}};(function(){var d="fsi-viewer";var e="display:block;width:300px;height:300px;";var g=a.customTags[d];if(g){return}var c=function(i){var h=a.attributes2parameters(i);if(h.src!=b&&h.imagesrc==b){h.imagesrc=h.src}return h};var f={};f.registerElement=function(){a.addViewerClassCSSRule(d,e);var h=Object.create(HTMLDivElement.prototype);h.createdCallback=function(){a.customTagDimFromAttributes(this);a.Viewer.prototype.constructor.call(this,this,{autoInit:false})};h.attachedCallback=function(){if(this.getInitDone()){return}this.init(this,c(this));this.start()};h.detachedCallback=function(){this.destroyOnDetach()};document.registerElement(d,{prototype:h})};f.replaceTagInit=function(h){a.addViewerClassCSSRule(d,e)};f.replaceTag=function(h){if(!h||(typeof(h.getInitDone)=="function"&&h.getInitDone())){return}a.customTagDimFromAttributes(h);a.Viewer.prototype.constructor.call(h,h,c(h));h.start()};g=a.registerCustomTag(d,f)}())}(window.$FSI=window.$FSI||{}));