<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Add Permission Set" />

  <#if show_form?? >

    <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="addpermissionset">
      <input type="hidden" name="save" value="1">
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
        <td class="pad1" colspan="2">
         <#if message??>
          <span style="color: red">${message}</span>
         <#else>
          Enter the permission set properties in the form below and press the save button at the end of the page. 
          The permission sets will then be re-read for the changes to take effect.
         </#if>
        </td>
      </tr>
	  <tr>
	    <td class="sectionheader" colspan="2">Name</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1">Name</td>
        <td class="pad1" align="right"><input type="text" class="inwhite" name="name" <#if name?? >value="${name}"</#if> help="<@appID/>:permissionsets_name" /> 
        </td>
      </tr>
      
      <#-- General Permissions -->
      
      <tr>
	    <td class="sectionheader" colspan="2">General Permissions</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1">Change Password</td>
        <td class="pad1" align="right"><@formgfxselect objid="general_changePassword" itemlist=valueList preselect=permissionset.general_changePassword?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Read Licence</td>
        <td class="pad1" align="right"><@formgfxselect objid="general_readLicence" itemlist=valueList preselect=permissionset.general_readLicence?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Save Licence</td>
        <td class="pad1" align="right"><@formgfxselect objid="general_writeLicence" itemlist=valueList preselect=permissionset.general_writeLicence?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Switch User</td>
        <td class="pad1" align="right"><@formgfxselect objid="general_switchUser" itemlist=valueList preselect=permissionset.general_switchUser?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Write Preferences</td>
        <td class="pad1" align="right"><@formgfxselect objid="general_writePreferences" itemlist=valueList preselect=permissionset.general_writePreferences?string helpid="renderer_format" />
        </td>
      </tr>

      <#-- Read Permissions -->
	  
	  <tr>
	    <td class="sectionheader" colspan="2">Read Permissions</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="pad1">Basic Metadata</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_basicMetadata" itemlist=valueList preselect=permissionset.read_basicMetadata?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Extended Metadata</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_extendedMetadata" itemlist=valueList preselect=permissionset.read_extendedMetadata?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Rendered Images</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_renderedImages" itemlist=valueList preselect=permissionset.read_renderedImages?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Files</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_files" itemlist=valueList preselect=permissionset.read_files?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Copy</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_copy" itemlist=valueList preselect=permissionset.read_copy?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">ICC Profile</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_iccProfiles" itemlist=valueList preselect=permissionset.read_iccProfiles?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Storage Status</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_storageStatus" itemlist=valueList preselect=permissionset.read_storageStatus?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Download Source</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_downloadSource" itemlist=valueList preselect=permissionset.read_downloadSource?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Total Asset Count</td>
        <td class="pad1" align="right"><@formgfxselect objid="read_totalAssetCount" itemlist=valueList preselect=permissionset.read_totalAssetCount?string helpid="renderer_format" />
        </td>
      </tr>
      
      
      <#-- List Permissions -->
	  
	  <tr>
	    <td class="sectionheader" colspan="2">List Permissions</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="pad1">Files</td>
        <td class="pad1" align="right"><@formgfxselect objid="list_files" itemlist=valueList preselect=permissionset.list_files?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Directories</td>
        <td class="pad1" align="right"><@formgfxselect objid="list_directories" itemlist=valueList preselect=permissionset.list_directories?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Search Results</td>
        <td class="pad1" align="right"><@formgfxselect objid="list_searchResults" itemlist=valueList preselect=permissionset.list_searchResults?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Connector</td>
        <td class="pad1" align="right"><@formgfxselect objid="list_connector" itemlist=valueList preselect=permissionset.list_connector?string helpid="renderer_format" />
        </td>
      </tr>

      <#-- Write Permissions -->
	  
	  <tr>
	    <td class="sectionheader" colspan="2">Write Permissions</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="pad1">Upload</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_upload" itemlist=valueList preselect=permissionset.write_upload?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Create Directory</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_createDirectory" itemlist=valueList preselect=permissionset.write_createDirectory?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Overwrite</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_overwrite" itemlist=valueList preselect=permissionset.write_overwrite?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Delete</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_delete" itemlist=valueList preselect=permissionset.write_delete?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Rename</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_rename" itemlist=valueList preselect=permissionset.write_rename?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Extended Metadata</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_extendedMetadata" itemlist=valueList preselect=permissionset.write_extendedMetadata?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Paste</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_paste" itemlist=valueList preselect=permissionset.write_paste?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Move to Trash</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_moveToTrash" itemlist=valueList preselect=permissionset.write_moveToTrash?string helpid="renderer_format" />
        </td>
      </tr>                                    
      <tr>
        <td class="pad1">Move within Connector</td>
        <td class="pad1" align="right"><@formgfxselect objid="write_moveWithinConnector" itemlist=valueList preselect=permissionset.write_moveWithinConnector?string helpid="renderer_format" />
        </td>
      </tr>      
      
      <#-- Tasks Permissions -->
	  
	  <tr>
	    <td class="sectionheader" colspan="2">Tasks Permissions</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="pad1">Batch Processing</td>
        <td class="pad1" align="right"><@formgfxselect objid="tasks_batchRendering" itemlist=valueList preselect=permissionset.tasks_batchRendering?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Create Archive</td>
        <td class="pad1" align="right"><@formgfxselect objid="tasks_createArchive" itemlist=valueList preselect=permissionset.tasks_createArchive?string helpid="renderer_format" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Reimport Images</td>
        <td class="pad1" align="right"><@formgfxselect objid="tasks_reimportFiles" itemlist=valueList preselect=permissionset.tasks_reimportFiles?string helpid="renderer_format" />
        </td>
      </tr>
      
      <tr>
        <td class="pad1" style="padding-top: 20px;" colspan="2" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listpermissionsets" />
          <@formsubmit value="Save" helpid="permissionsets_save" />	
        </td>
      </tr>
      </table>
    </form>

  <#elseif show_confirmation?? >
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
	    <td class="sectionheader">Permission set saved</td>
	  </tr>
	  <tr><td><hr size="1" class="hr1"/></td></tr>
	  <tr>
	   <td class="pad1">
    	Please wait while the permission sets are re-read for the changes to take effect.
       </td>
      </tr>
    </table>
    <#assign timeout="5" />
    <#assign postprogresslocation="action=listpermissionsets">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">