<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Add Source Connector" />

  <#if show_form?? >

   <form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="addsourceconnector">
      
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
       <td class="pad1" colspan="3">
        <#if message??>
        <span style="color: red">${message}</span>
        <#else>
        Enter the new source connector settings below and press the save button at the end of the form. 
        After saving the FSI Server will re-read the source connectors and restart for the new source connector to be activated.
        </#if>
       </td>
      </tr>
      <tr>
       <td class="sectionheader" colspan="3">General Source Connector Settings</td>
	  </tr>
	  <tr>
       <td colspan="3"><hr size="1" class="hr1"/></td>
      </tr>
      <tr>
        <td class="pad1">Enabled</td>
        <td class="pad1" colspan="2">
        	<@formcheckbox objid="enabled" preselect=enabled helpid="sourceconnector_enabled" />
        </td>
      </tr>
	  <tr>
        <td class="pad1">Source Connector Name</td>
        <td class="pad1" colspan="2">
      	  <input type="text" class="inwhite" id="connectorname" name="connectorname" <#if connectorname??>value="${connectorname}"</#if> help="<@appID/>:sourceconnector_name">
        </td>
      </tr>
      <tr>
        <td class="pad1">Location</td>
        <td class="pad1" colspan="2">
      	  <input type="text" class="inwhite" id="location" name="location"  <#if location??>value="${location}"</#if> help="<@appID/>:sourceconnector_location">
        </td>
      </tr>
      <tr>
        <td class="pad1">Comment</td>
        <td class="pad1" colspan="2">
      	  <input type="text" class="inwhite" id="comment" name="comment"  <#if comment??>value="${comment}"</#if> help="<@appID/>:sourceconnector_comment">
        </td>
      </tr>
      <tr>
        <td class="pad1">Type</td>
        <td class="pad1" colspan="2"><@formgfxselect objid="type" itemlist=available_types preselect=type helpid="sourceconnector_type" /></td>
      </tr>
      <tr>
        <td class="pad1">Create Directory</td>
        <td class="pad1" colspan="2">
      	  <@formcheckbox objid="mkdir" preselect=mkdir />
        </td>
      </tr>
      <tr>
        <td class="pad1">Copyright Notice</td>
        <td class="pad1" colspan="2">
      	  <input type="text" class="inwhite" id="copyrightnotice" name="copyrightnotice"  <#if copyrightnotice??>value="${copyrightnotice}"</#if> help="<@appID/>:sourceconnector_copyrightnotice">
        </td>
      </tr>
      <tr>
       <td class="sectionheader" colspan="3">Format Settings</td>
	  </tr>
      <tr>
        <td class="pad1">Format:</td>
        <td class="pad1" colspan="2"><@formgfxselect objid="format" itemlist=available_formats preselect=format helpid="sourceconnector_format" /></td>
      </tr>
      <tr>
        <td class="pad1">Image Quality</td>
        <td class="pad1" colspan="2">
      	  <input type="text" class="inwhite" style="width:190" maxlength="3" id="quality" name="quality" <#if quality??>value="${quality}"</#if> help="<@appID/>:sourceconnector_quality">
        </td>
      </tr>
      <tr>
       <td class="sectionheader" colspan="3">Access Control</td>
	  </tr>
	  <tr>
        <td class="pad1" colspan="3">Select a group that is allowed to access this source connector. Further groups can be assigned to this source connector once it has been saved.
        </td>
      <tr>
        <td class="pad1">Access:</td>
        <td class="pad1"><@formgfxselect objid="group" itemlist=available_groups preselect=default_group helpid="sourceconnector_group" /></td>
        <td class="pad1"><@formgfxselect objid="permissionset" itemlist=available_permissionsets preselect=default_permissionset helpid="sourceconnector_permissionset" /></td>
      </tr>
      <tr>
        <td class="pad1" style="padding-top: 20px;" colspan="3" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listsourceconnectors" helpid="sourceconnector_cancel" />
          <@formsubmit value="Save" helpid="sourceconnector_save" />
        </td>
      </tr>
      </table>
    </form>

  <#elseif show_confirmation?? >
        
    <table cellspacing="0" cellpadding="0" style="border:0px;width:500px;">
     <tr>
      <td class="sectionheader">New source connector saved</td>
	 </tr>
	 <tr>
      <td><hr size="1" class="hr1"/></td>
     </tr>
     <tr>
      <td class="pad1">
      Please wait while the source connectors are re-read for the changes to take effect.
      </td>
     </tr>
    </table>
    <#assign timeout="8" />
	<#assign postprogresslocation="action=listsourceconnectors">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">